/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Redshift storage properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftStorageProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftStorageProperties.Builder, RedshiftStorageProperties> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(RedshiftStorageProperties::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RedshiftStorageProperties::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            WORKGROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String workgroupName;

    private final Type type;

    private RedshiftStorageProperties(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.workgroupName = builder.workgroupName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The cluster name in the Amazon Redshift storage properties.
     * </p>
     * 
     * @return The cluster name in the Amazon Redshift storage properties.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The workgroup name in the Amazon Redshift storage properties.
     * </p>
     * 
     * @return The workgroup name in the Amazon Redshift storage properties.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftStorageProperties)) {
            return false;
        }
        RedshiftStorageProperties other = (RedshiftStorageProperties) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftStorageProperties").add("ClusterName", clusterName())
                .add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #clusterName()} initialized to the given value.
     *
     * <p>
     * The cluster name in the Amazon Redshift storage properties.
     * </p>
     * 
     * @param clusterName
     *        The cluster name in the Amazon Redshift storage properties.
     */
    public static RedshiftStorageProperties fromClusterName(String clusterName) {
        return builder().clusterName(clusterName).build();
    }

    /**
     * Create an instance of this class with {@link #workgroupName()} initialized to the given value.
     *
     * <p>
     * The workgroup name in the Amazon Redshift storage properties.
     * </p>
     * 
     * @param workgroupName
     *        The workgroup name in the Amazon Redshift storage properties.
     */
    public static RedshiftStorageProperties fromWorkgroupName(String workgroupName) {
        return builder().workgroupName(workgroupName).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftStorageProperties, T> g) {
        return obj -> g.apply((RedshiftStorageProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftStorageProperties> {
        /**
         * <p>
         * The cluster name in the Amazon Redshift storage properties.
         * </p>
         * 
         * @param clusterName
         *        The cluster name in the Amazon Redshift storage properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The workgroup name in the Amazon Redshift storage properties.
         * </p>
         * 
         * @param workgroupName
         *        The workgroup name in the Amazon Redshift storage properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private String workgroupName;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftStorageProperties model) {
            clusterName(model.clusterName);
            workgroupName(model.workgroupName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            Object oldValue = this.clusterName;
            this.clusterName = clusterName;
            handleUnionValueChange(Type.CLUSTER_NAME, oldValue, this.clusterName);
        }

        @Override
        public final Builder clusterName(String clusterName) {
            Object oldValue = this.clusterName;
            this.clusterName = clusterName;
            handleUnionValueChange(Type.CLUSTER_NAME, oldValue, this.clusterName);
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            Object oldValue = this.workgroupName;
            this.workgroupName = workgroupName;
            handleUnionValueChange(Type.WORKGROUP_NAME, oldValue, this.workgroupName);
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            Object oldValue = this.workgroupName;
            this.workgroupName = workgroupName;
            handleUnionValueChange(Type.WORKGROUP_NAME, oldValue, this.workgroupName);
            return this;
        }

        @Override
        public RedshiftStorageProperties build() {
            return new RedshiftStorageProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RedshiftStorageProperties#type()
     */
    public enum Type {
        CLUSTER_NAME,

        WORKGROUP_NAME,

        UNKNOWN_TO_SDK_VERSION
    }
}
