/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Region implements SdkPojo, Serializable, ToCopyableBuilder<Region.Builder, Region> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionName").getter(getter(Region::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<String> REGION_NAME_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionNamePath").getter(getter(Region::regionNamePath)).setter(setter(Builder::regionNamePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNamePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REGION_NAME_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String regionNamePath;

    private final Type type;

    private Region(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.regionNamePath = builder.regionNamePath;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Web Services Region name.
     * </p>
     * 
     * @return The Amazon Web Services Region name.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The region name path.
     * </p>
     * 
     * @return The region name path.
     */
    public final String regionNamePath() {
        return regionNamePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(regionNamePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        return Objects.equals(regionName(), other.regionName()) && Objects.equals(regionNamePath(), other.regionNamePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Region").add("RegionName", regionName()).add("RegionNamePath", regionNamePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "regionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "regionNamePath":
            return Optional.ofNullable(clazz.cast(regionNamePath()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #regionName()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Region name.
     * </p>
     * 
     * @param regionName
     *        The Amazon Web Services Region name.
     */
    public static Region fromRegionName(String regionName) {
        return builder().regionName(regionName).build();
    }

    /**
     * Create an instance of this class with {@link #regionNamePath()} initialized to the given value.
     *
     * <p>
     * The region name path.
     * </p>
     * 
     * @param regionNamePath
     *        The region name path.
     */
    public static Region fromRegionNamePath(String regionNamePath) {
        return builder().regionNamePath(regionNamePath).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regionName", REGION_NAME_FIELD);
        map.put("regionNamePath", REGION_NAME_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The Amazon Web Services Region name.
         * </p>
         * 
         * @param regionName
         *        The Amazon Web Services Region name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The region name path.
         * </p>
         * 
         * @param regionNamePath
         *        The region name path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNamePath(String regionNamePath);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String regionNamePath;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            regionName(model.regionName);
            regionNamePath(model.regionNamePath);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            Object oldValue = this.regionName;
            this.regionName = regionName;
            handleUnionValueChange(Type.REGION_NAME, oldValue, this.regionName);
        }

        @Override
        public final Builder regionName(String regionName) {
            Object oldValue = this.regionName;
            this.regionName = regionName;
            handleUnionValueChange(Type.REGION_NAME, oldValue, this.regionName);
            return this;
        }

        public final String getRegionNamePath() {
            return regionNamePath;
        }

        public final void setRegionNamePath(String regionNamePath) {
            Object oldValue = this.regionNamePath;
            this.regionNamePath = regionNamePath;
            handleUnionValueChange(Type.REGION_NAME_PATH, oldValue, this.regionNamePath);
        }

        @Override
        public final Builder regionNamePath(String regionNamePath) {
            Object oldValue = this.regionNamePath;
            this.regionNamePath = regionNamePath;
            handleUnionValueChange(Type.REGION_NAME_PATH, oldValue, this.regionNamePath);
            return this;
        }

        @Override
        public Region build() {
            return new Region(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Region#type()
     */
    public enum Type {
        REGION_NAME,

        REGION_NAME_PATH,

        UNKNOWN_TO_SDK_VERSION
    }
}
