/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleDetail implements SdkPojo, Serializable, ToCopyableBuilder<RuleDetail.Builder, RuleDetail> {
    private static final SdkField<MetadataFormEnforcementDetail> METADATA_FORM_ENFORCEMENT_DETAIL_FIELD = SdkField
            .<MetadataFormEnforcementDetail> builder(MarshallingType.SDK_POJO)
            .memberName("metadataFormEnforcementDetail")
            .getter(getter(RuleDetail::metadataFormEnforcementDetail))
            .setter(setter(Builder::metadataFormEnforcementDetail))
            .constructor(MetadataFormEnforcementDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataFormEnforcementDetail")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(METADATA_FORM_ENFORCEMENT_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MetadataFormEnforcementDetail metadataFormEnforcementDetail;

    private final Type type;

    private RuleDetail(BuilderImpl builder) {
        this.metadataFormEnforcementDetail = builder.metadataFormEnforcementDetail;
        this.type = builder.type;
    }

    /**
     * <p>
     * The enforcement detail of the metadata form.
     * </p>
     * 
     * @return The enforcement detail of the metadata form.
     */
    public final MetadataFormEnforcementDetail metadataFormEnforcementDetail() {
        return metadataFormEnforcementDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataFormEnforcementDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDetail)) {
            return false;
        }
        RuleDetail other = (RuleDetail) obj;
        return Objects.equals(metadataFormEnforcementDetail(), other.metadataFormEnforcementDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleDetail").add("MetadataFormEnforcementDetail", metadataFormEnforcementDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataFormEnforcementDetail":
            return Optional.ofNullable(clazz.cast(metadataFormEnforcementDetail()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #metadataFormEnforcementDetail()} initialized to the given value.
     *
     * <p>
     * The enforcement detail of the metadata form.
     * </p>
     * 
     * @param metadataFormEnforcementDetail
     *        The enforcement detail of the metadata form.
     */
    public static RuleDetail fromMetadataFormEnforcementDetail(MetadataFormEnforcementDetail metadataFormEnforcementDetail) {
        return builder().metadataFormEnforcementDetail(metadataFormEnforcementDetail).build();
    }

    /**
     * Create an instance of this class with {@link #metadataFormEnforcementDetail()} initialized to the given value.
     *
     * <p>
     * The enforcement detail of the metadata form.
     * </p>
     * 
     * @param metadataFormEnforcementDetail
     *        The enforcement detail of the metadata form.
     */
    public static RuleDetail fromMetadataFormEnforcementDetail(
            Consumer<MetadataFormEnforcementDetail.Builder> metadataFormEnforcementDetail) {
        MetadataFormEnforcementDetail.Builder builder = MetadataFormEnforcementDetail.builder();
        metadataFormEnforcementDetail.accept(builder);
        return fromMetadataFormEnforcementDetail(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataFormEnforcementDetail", METADATA_FORM_ENFORCEMENT_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleDetail, T> g) {
        return obj -> g.apply((RuleDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleDetail> {
        /**
         * <p>
         * The enforcement detail of the metadata form.
         * </p>
         * 
         * @param metadataFormEnforcementDetail
         *        The enforcement detail of the metadata form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataFormEnforcementDetail(MetadataFormEnforcementDetail metadataFormEnforcementDetail);

        /**
         * <p>
         * The enforcement detail of the metadata form.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataFormEnforcementDetail.Builder}
         * avoiding the need to create one manually via {@link MetadataFormEnforcementDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataFormEnforcementDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataFormEnforcementDetail(MetadataFormEnforcementDetail)}.
         * 
         * @param metadataFormEnforcementDetail
         *        a consumer that will call methods on {@link MetadataFormEnforcementDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataFormEnforcementDetail(MetadataFormEnforcementDetail)
         */
        default Builder metadataFormEnforcementDetail(
                Consumer<MetadataFormEnforcementDetail.Builder> metadataFormEnforcementDetail) {
            return metadataFormEnforcementDetail(MetadataFormEnforcementDetail.builder()
                    .applyMutation(metadataFormEnforcementDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetadataFormEnforcementDetail metadataFormEnforcementDetail;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDetail model) {
            metadataFormEnforcementDetail(model.metadataFormEnforcementDetail);
        }

        public final MetadataFormEnforcementDetail.Builder getMetadataFormEnforcementDetail() {
            return metadataFormEnforcementDetail != null ? metadataFormEnforcementDetail.toBuilder() : null;
        }

        public final void setMetadataFormEnforcementDetail(MetadataFormEnforcementDetail.BuilderImpl metadataFormEnforcementDetail) {
            Object oldValue = this.metadataFormEnforcementDetail;
            this.metadataFormEnforcementDetail = metadataFormEnforcementDetail != null ? metadataFormEnforcementDetail.build()
                    : null;
            handleUnionValueChange(Type.METADATA_FORM_ENFORCEMENT_DETAIL, oldValue, this.metadataFormEnforcementDetail);
        }

        @Override
        public final Builder metadataFormEnforcementDetail(MetadataFormEnforcementDetail metadataFormEnforcementDetail) {
            Object oldValue = this.metadataFormEnforcementDetail;
            this.metadataFormEnforcementDetail = metadataFormEnforcementDetail;
            handleUnionValueChange(Type.METADATA_FORM_ENFORCEMENT_DETAIL, oldValue, this.metadataFormEnforcementDetail);
            return this;
        }

        @Override
        public RuleDetail build() {
            return new RuleDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleDetail#type()
     */
    public enum Type {
        METADATA_FORM_ENFORCEMENT_DETAIL,

        UNKNOWN_TO_SDK_VERSION
    }
}
