/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scope of a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleScope implements SdkPojo, Serializable, ToCopyableBuilder<RuleScope.Builder, RuleScope> {
    private static final SdkField<AssetTypesForRule> ASSET_TYPE_FIELD = SdkField
            .<AssetTypesForRule> builder(MarshallingType.SDK_POJO).memberName("assetType").getter(getter(RuleScope::assetType))
            .setter(setter(Builder::assetType)).constructor(AssetTypesForRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()).build();

    private static final SdkField<Boolean> DATA_PRODUCT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dataProduct").getter(getter(RuleScope::dataProduct)).setter(setter(Builder::dataProduct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProduct").build()).build();

    private static final SdkField<ProjectsForRule> PROJECT_FIELD = SdkField.<ProjectsForRule> builder(MarshallingType.SDK_POJO)
            .memberName("project").getter(getter(RuleScope::project)).setter(setter(Builder::project))
            .constructor(ProjectsForRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TYPE_FIELD,
            DATA_PRODUCT_FIELD, PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetTypesForRule assetType;

    private final Boolean dataProduct;

    private final ProjectsForRule project;

    private RuleScope(BuilderImpl builder) {
        this.assetType = builder.assetType;
        this.dataProduct = builder.dataProduct;
        this.project = builder.project;
    }

    /**
     * <p>
     * The asset type included in the rule scope.
     * </p>
     * 
     * @return The asset type included in the rule scope.
     */
    public final AssetTypesForRule assetType() {
        return assetType;
    }

    /**
     * <p>
     * The data product included in the rule scope.
     * </p>
     * 
     * @return The data product included in the rule scope.
     */
    public final Boolean dataProduct() {
        return dataProduct;
    }

    /**
     * <p>
     * The project included in the rule scope.
     * </p>
     * 
     * @return The project included in the rule scope.
     */
    public final ProjectsForRule project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetType());
        hashCode = 31 * hashCode + Objects.hashCode(dataProduct());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleScope)) {
            return false;
        }
        RuleScope other = (RuleScope) obj;
        return Objects.equals(assetType(), other.assetType()) && Objects.equals(dataProduct(), other.dataProduct())
                && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleScope").add("AssetType", assetType()).add("DataProduct", dataProduct())
                .add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetType":
            return Optional.ofNullable(clazz.cast(assetType()));
        case "dataProduct":
            return Optional.ofNullable(clazz.cast(dataProduct()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetType", ASSET_TYPE_FIELD);
        map.put("dataProduct", DATA_PRODUCT_FIELD);
        map.put("project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleScope, T> g) {
        return obj -> g.apply((RuleScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleScope> {
        /**
         * <p>
         * The asset type included in the rule scope.
         * </p>
         * 
         * @param assetType
         *        The asset type included in the rule scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetType(AssetTypesForRule assetType);

        /**
         * <p>
         * The asset type included in the rule scope.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetTypesForRule.Builder} avoiding the
         * need to create one manually via {@link AssetTypesForRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetTypesForRule.Builder#build()} is called immediately and its
         * result is passed to {@link #assetType(AssetTypesForRule)}.
         * 
         * @param assetType
         *        a consumer that will call methods on {@link AssetTypesForRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetType(AssetTypesForRule)
         */
        default Builder assetType(Consumer<AssetTypesForRule.Builder> assetType) {
            return assetType(AssetTypesForRule.builder().applyMutation(assetType).build());
        }

        /**
         * <p>
         * The data product included in the rule scope.
         * </p>
         * 
         * @param dataProduct
         *        The data product included in the rule scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProduct(Boolean dataProduct);

        /**
         * <p>
         * The project included in the rule scope.
         * </p>
         * 
         * @param project
         *        The project included in the rule scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectsForRule project);

        /**
         * <p>
         * The project included in the rule scope.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectsForRule.Builder} avoiding the
         * need to create one manually via {@link ProjectsForRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectsForRule.Builder#build()} is called immediately and its
         * result is passed to {@link #project(ProjectsForRule)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectsForRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectsForRule)
         */
        default Builder project(Consumer<ProjectsForRule.Builder> project) {
            return project(ProjectsForRule.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetTypesForRule assetType;

        private Boolean dataProduct;

        private ProjectsForRule project;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleScope model) {
            assetType(model.assetType);
            dataProduct(model.dataProduct);
            project(model.project);
        }

        public final AssetTypesForRule.Builder getAssetType() {
            return assetType != null ? assetType.toBuilder() : null;
        }

        public final void setAssetType(AssetTypesForRule.BuilderImpl assetType) {
            this.assetType = assetType != null ? assetType.build() : null;
        }

        @Override
        public final Builder assetType(AssetTypesForRule assetType) {
            this.assetType = assetType;
            return this;
        }

        public final Boolean getDataProduct() {
            return dataProduct;
        }

        public final void setDataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
        }

        @Override
        public final Builder dataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
            return this;
        }

        public final ProjectsForRule.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectsForRule.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectsForRule project) {
            this.project = project;
            return this;
        }

        @Override
        public RuleScope build() {
            return new RuleScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
