/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the self granting status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfGrantStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfGrantStatusDetail.Builder, SelfGrantStatusDetail> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(SelfGrantStatusDetail::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> FAILURE_CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCause").getter(getter(SelfGrantStatusDetail::failureCause)).setter(setter(Builder::failureCause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(SelfGrantStatusDetail::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SelfGrantStatusDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            FAILURE_CAUSE_FIELD, SCHEMA_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String failureCause;

    private final String schemaName;

    private final String status;

    private SelfGrantStatusDetail(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.failureCause = builder.failureCause;
        this.schemaName = builder.schemaName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the database used for the data source.
     * </p>
     * 
     * @return The name of the database used for the data source.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The reason for why the operation failed.
     * </p>
     * 
     * @return The reason for why the operation failed.
     */
    public final String failureCause() {
        return failureCause;
    }

    /**
     * <p>
     * The name of the schema used in the data source.
     * </p>
     * 
     * @return The name of the schema used in the data source.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The self granting status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SelfGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The self granting status of the data source.
     * @see SelfGrantStatus
     */
    public final SelfGrantStatus status() {
        return SelfGrantStatus.fromValue(status);
    }

    /**
     * <p>
     * The self granting status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SelfGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The self granting status of the data source.
     * @see SelfGrantStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfGrantStatusDetail)) {
            return false;
        }
        SelfGrantStatusDetail other = (SelfGrantStatusDetail) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(failureCause(), other.failureCause())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfGrantStatusDetail").add("DatabaseName", databaseName()).add("FailureCause", failureCause())
                .add("SchemaName", schemaName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "failureCause":
            return Optional.ofNullable(clazz.cast(failureCause()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("failureCause", FAILURE_CAUSE_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfGrantStatusDetail, T> g) {
        return obj -> g.apply((SelfGrantStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfGrantStatusDetail> {
        /**
         * <p>
         * The name of the database used for the data source.
         * </p>
         * 
         * @param databaseName
         *        The name of the database used for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The reason for why the operation failed.
         * </p>
         * 
         * @param failureCause
         *        The reason for why the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCause(String failureCause);

        /**
         * <p>
         * The name of the schema used in the data source.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema used in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The self granting status of the data source.
         * </p>
         * 
         * @param status
         *        The self granting status of the data source.
         * @see SelfGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfGrantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The self granting status of the data source.
         * </p>
         * 
         * @param status
         *        The self granting status of the data source.
         * @see SelfGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfGrantStatus
         */
        Builder status(SelfGrantStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String failureCause;

        private String schemaName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfGrantStatusDetail model) {
            databaseName(model.databaseName);
            failureCause(model.failureCause);
            schemaName(model.schemaName);
            status(model.status);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getFailureCause() {
            return failureCause;
        }

        public final void setFailureCause(String failureCause) {
            this.failureCause = failureCause;
        }

        @Override
        public final Builder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SelfGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public SelfGrantStatusDetail build() {
            return new SelfGrantStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
