/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Spark Amazon Web Services Glue properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkGluePropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SparkGluePropertiesOutput.Builder, SparkGluePropertiesOutput> {
    private static final SdkField<SparkGlueArgs> ADDITIONAL_ARGS_FIELD = SdkField
            .<SparkGlueArgs> builder(MarshallingType.SDK_POJO).memberName("additionalArgs")
            .getter(getter(SparkGluePropertiesOutput::additionalArgs)).setter(setter(Builder::additionalArgs))
            .constructor(SparkGlueArgs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalArgs").build()).build();

    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueConnectionName").getter(getter(SparkGluePropertiesOutput::glueConnectionName))
            .setter(setter(Builder::glueConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionName").build())
            .build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueVersion").getter(getter(SparkGluePropertiesOutput::glueVersion))
            .setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueVersion").build()).build();

    private static final SdkField<Integer> IDLE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("idleTimeout").getter(getter(SparkGluePropertiesOutput::idleTimeout))
            .setter(setter(Builder::idleTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleTimeout").build()).build();

    private static final SdkField<String> JAVA_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("javaVirtualEnv").getter(getter(SparkGluePropertiesOutput::javaVirtualEnv))
            .setter(setter(Builder::javaVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("javaVirtualEnv").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfWorkers").getter(getter(SparkGluePropertiesOutput::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfWorkers").build()).build();

    private static final SdkField<String> PYTHON_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pythonVirtualEnv").getter(getter(SparkGluePropertiesOutput::pythonVirtualEnv))
            .setter(setter(Builder::pythonVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonVirtualEnv").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerType").getter(getter(SparkGluePropertiesOutput::workerType)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ARGS_FIELD,
            GLUE_CONNECTION_NAME_FIELD, GLUE_VERSION_FIELD, IDLE_TIMEOUT_FIELD, JAVA_VIRTUAL_ENV_FIELD, NUMBER_OF_WORKERS_FIELD,
            PYTHON_VIRTUAL_ENV_FIELD, WORKER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SparkGlueArgs additionalArgs;

    private final String glueConnectionName;

    private final String glueVersion;

    private final Integer idleTimeout;

    private final String javaVirtualEnv;

    private final Integer numberOfWorkers;

    private final String pythonVirtualEnv;

    private final String workerType;

    private SparkGluePropertiesOutput(BuilderImpl builder) {
        this.additionalArgs = builder.additionalArgs;
        this.glueConnectionName = builder.glueConnectionName;
        this.glueVersion = builder.glueVersion;
        this.idleTimeout = builder.idleTimeout;
        this.javaVirtualEnv = builder.javaVirtualEnv;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.pythonVirtualEnv = builder.pythonVirtualEnv;
        this.workerType = builder.workerType;
    }

    /**
     * <p>
     * The additional args in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The additional args in the Spark Amazon Web Services Glue properties.
     */
    public final SparkGlueArgs additionalArgs() {
        return additionalArgs;
    }

    /**
     * <p>
     * The Amazon Web Services Glue connection name in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The Amazon Web Services Glue connection name in the Spark Amazon Web Services Glue properties.
     */
    public final String glueConnectionName() {
        return glueConnectionName;
    }

    /**
     * <p>
     * The Amazon Web Services Glue version in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The Amazon Web Services Glue version in the Spark Amazon Web Services Glue properties.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The idle timeout in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The idle timeout in the Spark Amazon Web Services Glue properties.
     */
    public final Integer idleTimeout() {
        return idleTimeout;
    }

    /**
     * <p>
     * The Java virtual env in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The Java virtual env in the Spark Amazon Web Services Glue properties.
     */
    public final String javaVirtualEnv() {
        return javaVirtualEnv;
    }

    /**
     * <p>
     * The number of workers in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The number of workers in the Spark Amazon Web Services Glue properties.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The Python virtual env in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The Python virtual env in the Spark Amazon Web Services Glue properties.
     */
    public final String pythonVirtualEnv() {
        return pythonVirtualEnv;
    }

    /**
     * <p>
     * The worker type in the Spark Amazon Web Services Glue properties.
     * </p>
     * 
     * @return The worker type in the Spark Amazon Web Services Glue properties.
     */
    public final String workerType() {
        return workerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalArgs());
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(javaVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(pythonVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(workerType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkGluePropertiesOutput)) {
            return false;
        }
        SparkGluePropertiesOutput other = (SparkGluePropertiesOutput) obj;
        return Objects.equals(additionalArgs(), other.additionalArgs())
                && Objects.equals(glueConnectionName(), other.glueConnectionName())
                && Objects.equals(glueVersion(), other.glueVersion()) && Objects.equals(idleTimeout(), other.idleTimeout())
                && Objects.equals(javaVirtualEnv(), other.javaVirtualEnv())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(pythonVirtualEnv(), other.pythonVirtualEnv())
                && Objects.equals(workerType(), other.workerType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparkGluePropertiesOutput").add("AdditionalArgs", additionalArgs())
                .add("GlueConnectionName", glueConnectionName()).add("GlueVersion", glueVersion())
                .add("IdleTimeout", idleTimeout()).add("JavaVirtualEnv", javaVirtualEnv())
                .add("NumberOfWorkers", numberOfWorkers()).add("PythonVirtualEnv", pythonVirtualEnv())
                .add("WorkerType", workerType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalArgs":
            return Optional.ofNullable(clazz.cast(additionalArgs()));
        case "glueConnectionName":
            return Optional.ofNullable(clazz.cast(glueConnectionName()));
        case "glueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "idleTimeout":
            return Optional.ofNullable(clazz.cast(idleTimeout()));
        case "javaVirtualEnv":
            return Optional.ofNullable(clazz.cast(javaVirtualEnv()));
        case "numberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "pythonVirtualEnv":
            return Optional.ofNullable(clazz.cast(pythonVirtualEnv()));
        case "workerType":
            return Optional.ofNullable(clazz.cast(workerType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalArgs", ADDITIONAL_ARGS_FIELD);
        map.put("glueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        map.put("glueVersion", GLUE_VERSION_FIELD);
        map.put("idleTimeout", IDLE_TIMEOUT_FIELD);
        map.put("javaVirtualEnv", JAVA_VIRTUAL_ENV_FIELD);
        map.put("numberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("pythonVirtualEnv", PYTHON_VIRTUAL_ENV_FIELD);
        map.put("workerType", WORKER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkGluePropertiesOutput, T> g) {
        return obj -> g.apply((SparkGluePropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkGluePropertiesOutput> {
        /**
         * <p>
         * The additional args in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param additionalArgs
         *        The additional args in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArgs(SparkGlueArgs additionalArgs);

        /**
         * <p>
         * The additional args in the Spark Amazon Web Services Glue properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkGlueArgs.Builder} avoiding the need
         * to create one manually via {@link SparkGlueArgs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkGlueArgs.Builder#build()} is called immediately and its
         * result is passed to {@link #additionalArgs(SparkGlueArgs)}.
         * 
         * @param additionalArgs
         *        a consumer that will call methods on {@link SparkGlueArgs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalArgs(SparkGlueArgs)
         */
        default Builder additionalArgs(Consumer<SparkGlueArgs.Builder> additionalArgs) {
            return additionalArgs(SparkGlueArgs.builder().applyMutation(additionalArgs).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue connection name in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param glueConnectionName
         *        The Amazon Web Services Glue connection name in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionName(String glueConnectionName);

        /**
         * <p>
         * The Amazon Web Services Glue version in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param glueVersion
         *        The Amazon Web Services Glue version in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The idle timeout in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param idleTimeout
         *        The idle timeout in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeout(Integer idleTimeout);

        /**
         * <p>
         * The Java virtual env in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param javaVirtualEnv
         *        The Java virtual env in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder javaVirtualEnv(String javaVirtualEnv);

        /**
         * <p>
         * The number of workers in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The Python virtual env in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param pythonVirtualEnv
         *        The Python virtual env in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonVirtualEnv(String pythonVirtualEnv);

        /**
         * <p>
         * The worker type in the Spark Amazon Web Services Glue properties.
         * </p>
         * 
         * @param workerType
         *        The worker type in the Spark Amazon Web Services Glue properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerType(String workerType);
    }

    static final class BuilderImpl implements Builder {
        private SparkGlueArgs additionalArgs;

        private String glueConnectionName;

        private String glueVersion;

        private Integer idleTimeout;

        private String javaVirtualEnv;

        private Integer numberOfWorkers;

        private String pythonVirtualEnv;

        private String workerType;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkGluePropertiesOutput model) {
            additionalArgs(model.additionalArgs);
            glueConnectionName(model.glueConnectionName);
            glueVersion(model.glueVersion);
            idleTimeout(model.idleTimeout);
            javaVirtualEnv(model.javaVirtualEnv);
            numberOfWorkers(model.numberOfWorkers);
            pythonVirtualEnv(model.pythonVirtualEnv);
            workerType(model.workerType);
        }

        public final SparkGlueArgs.Builder getAdditionalArgs() {
            return additionalArgs != null ? additionalArgs.toBuilder() : null;
        }

        public final void setAdditionalArgs(SparkGlueArgs.BuilderImpl additionalArgs) {
            this.additionalArgs = additionalArgs != null ? additionalArgs.build() : null;
        }

        @Override
        public final Builder additionalArgs(SparkGlueArgs additionalArgs) {
            this.additionalArgs = additionalArgs;
            return this;
        }

        public final String getGlueConnectionName() {
            return glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Integer getIdleTimeout() {
            return idleTimeout;
        }

        public final void setIdleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        @Override
        public final Builder idleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public final String getJavaVirtualEnv() {
            return javaVirtualEnv;
        }

        public final void setJavaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
        }

        @Override
        public final Builder javaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getPythonVirtualEnv() {
            return pythonVirtualEnv;
        }

        public final void setPythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
        }

        @Override
        public final Builder pythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public SparkGluePropertiesOutput build() {
            return new SparkGluePropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
