/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateConnectionRequest.Builder, UpdateConnectionRequest> {
    private static final SdkField<AwsLocation> AWS_LOCATION_FIELD = SdkField.<AwsLocation> builder(MarshallingType.SDK_POJO)
            .memberName("awsLocation").getter(getter(UpdateConnectionRequest::awsLocation)).setter(setter(Builder::awsLocation))
            .constructor(AwsLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLocation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateConnectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateConnectionRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateConnectionRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<ConnectionPropertiesPatch> PROPS_FIELD = SdkField
            .<ConnectionPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("props")
            .getter(getter(UpdateConnectionRequest::props)).setter(setter(Builder::props))
            .constructor(ConnectionPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOCATION_FIELD,
            DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, PROPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AwsLocation awsLocation;

    private final String description;

    private final String domainIdentifier;

    private final String identifier;

    private final ConnectionPropertiesPatch props;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.awsLocation = builder.awsLocation;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.props = builder.props;
    }

    /**
     * <p>
     * The location where a connection is to be updated.
     * </p>
     * 
     * @return The location where a connection is to be updated.
     */
    public final AwsLocation awsLocation() {
        return awsLocation;
    }

    /**
     * <p>
     * The description of a connection.
     * </p>
     * 
     * @return The description of a connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where a connection is to be updated.
     * </p>
     * 
     * @return The ID of the domain where a connection is to be updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the connection to be updated.
     * </p>
     * 
     * @return The ID of the connection to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The connection props.
     * </p>
     * 
     * @return The connection props.
     */
    public final ConnectionPropertiesPatch props() {
        return props;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(props());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest) obj;
        return Objects.equals(awsLocation(), other.awsLocation()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(props(), other.props());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionRequest").add("AwsLocation", awsLocation())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier()).add("Props", props()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsLocation":
            return Optional.ofNullable(clazz.cast(awsLocation()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "props":
            return Optional.ofNullable(clazz.cast(props()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsLocation", AWS_LOCATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("props", PROPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectionRequest> {
        /**
         * <p>
         * The location where a connection is to be updated.
         * </p>
         * 
         * @param awsLocation
         *        The location where a connection is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLocation(AwsLocation awsLocation);

        /**
         * <p>
         * The location where a connection is to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLocation.Builder} avoiding the need to
         * create one manually via {@link AwsLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #awsLocation(AwsLocation)}.
         * 
         * @param awsLocation
         *        a consumer that will call methods on {@link AwsLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLocation(AwsLocation)
         */
        default Builder awsLocation(Consumer<AwsLocation.Builder> awsLocation) {
            return awsLocation(AwsLocation.builder().applyMutation(awsLocation).build());
        }

        /**
         * <p>
         * The description of a connection.
         * </p>
         * 
         * @param description
         *        The description of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where a connection is to be updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where a connection is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the connection to be updated.
         * </p>
         * 
         * @param identifier
         *        The ID of the connection to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The connection props.
         * </p>
         * 
         * @param props
         *        The connection props.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder props(ConnectionPropertiesPatch props);

        /**
         * <p>
         * The connection props.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPropertiesPatch.Builder}
         * avoiding the need to create one manually via {@link ConnectionPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPropertiesPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #props(ConnectionPropertiesPatch)}.
         * 
         * @param props
         *        a consumer that will call methods on {@link ConnectionPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #props(ConnectionPropertiesPatch)
         */
        default Builder props(Consumer<ConnectionPropertiesPatch.Builder> props) {
            return props(ConnectionPropertiesPatch.builder().applyMutation(props).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private AwsLocation awsLocation;

        private String description;

        private String domainIdentifier;

        private String identifier;

        private ConnectionPropertiesPatch props;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            super(model);
            awsLocation(model.awsLocation);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            props(model.props);
        }

        public final AwsLocation.Builder getAwsLocation() {
            return awsLocation != null ? awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AwsLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AwsLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final ConnectionPropertiesPatch.Builder getProps() {
            return props != null ? props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesPatch.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesPatch props) {
            this.props = props;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
