/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriptionTargetRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateSubscriptionTargetRequest.Builder, UpdateSubscriptionTargetRequest> {
    private static final SdkField<List<String>> APPLICABLE_ASSET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicableAssetTypes")
            .getter(getter(UpdateSubscriptionTargetRequest::applicableAssetTypes))
            .setter(setter(Builder::applicableAssetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableAssetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHORIZED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authorizedPrincipals")
            .getter(getter(UpdateSubscriptionTargetRequest::authorizedPrincipals))
            .setter(setter(Builder::authorizedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateSubscriptionTargetRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(UpdateSubscriptionTargetRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateSubscriptionTargetRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> MANAGE_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manageAccessRole").getter(getter(UpdateSubscriptionTargetRequest::manageAccessRole))
            .setter(setter(Builder::manageAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRole").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateSubscriptionTargetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(UpdateSubscriptionTargetRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<List<SubscriptionTargetForm>> SUBSCRIPTION_TARGET_CONFIG_FIELD = SdkField
            .<List<SubscriptionTargetForm>> builder(MarshallingType.LIST)
            .memberName("subscriptionTargetConfig")
            .getter(getter(UpdateSubscriptionTargetRequest::subscriptionTargetConfig))
            .setter(setter(Builder::subscriptionTargetConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscriptionTargetForm> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscriptionTargetForm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_ASSET_TYPES_FIELD,
            AUTHORIZED_PRINCIPALS_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, IDENTIFIER_FIELD,
            MANAGE_ACCESS_ROLE_FIELD, NAME_FIELD, PROVIDER_FIELD, SUBSCRIPTION_TARGET_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> applicableAssetTypes;

    private final List<String> authorizedPrincipals;

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final String identifier;

    private final String manageAccessRole;

    private final String name;

    private final String provider;

    private final List<SubscriptionTargetForm> subscriptionTargetConfig;

    private UpdateSubscriptionTargetRequest(BuilderImpl builder) {
        super(builder);
        this.applicableAssetTypes = builder.applicableAssetTypes;
        this.authorizedPrincipals = builder.authorizedPrincipals;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.identifier = builder.identifier;
        this.manageAccessRole = builder.manageAccessRole;
        this.name = builder.name;
        this.provider = builder.provider;
        this.subscriptionTargetConfig = builder.subscriptionTargetConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicableAssetTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicableAssetTypes() {
        return applicableAssetTypes != null && !(applicableAssetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicableAssetTypes} method.
     * </p>
     * 
     * @return The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final List<String> applicableAssetTypes() {
        return applicableAssetTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedPrincipals() {
        return authorizedPrincipals != null && !(authorizedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedPrincipals} method.
     * </p>
     * 
     * @return The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final List<String> authorizedPrincipals() {
        return authorizedPrincipals;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a subscription target is to be updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a subscription target is to be updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the environment in which a subscription target is to be updated.
     * </p>
     * 
     * @return The identifier of the environment in which a subscription target is to be updated.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * Identifier of the subscription target that is to be updated.
     * </p>
     * 
     * @return Identifier of the subscription target that is to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * 
     * @return The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final String manageAccessRole() {
        return manageAccessRole;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * 
     * @return The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final String provider() {
        return provider;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscriptionTargetConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubscriptionTargetConfig() {
        return subscriptionTargetConfig != null && !(subscriptionTargetConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptionTargetConfig} method.
     * </p>
     * 
     * @return The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
     */
    public final List<SubscriptionTargetForm> subscriptionTargetConfig() {
        return subscriptionTargetConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicableAssetTypes() ? applicableAssetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedPrincipals() ? authorizedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(manageAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriptionTargetRequest)) {
            return false;
        }
        UpdateSubscriptionTargetRequest other = (UpdateSubscriptionTargetRequest) obj;
        return hasApplicableAssetTypes() == other.hasApplicableAssetTypes()
                && Objects.equals(applicableAssetTypes(), other.applicableAssetTypes())
                && hasAuthorizedPrincipals() == other.hasAuthorizedPrincipals()
                && Objects.equals(authorizedPrincipals(), other.authorizedPrincipals())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(manageAccessRole(), other.manageAccessRole()) && Objects.equals(name(), other.name())
                && Objects.equals(provider(), other.provider())
                && hasSubscriptionTargetConfig() == other.hasSubscriptionTargetConfig()
                && Objects.equals(subscriptionTargetConfig(), other.subscriptionTargetConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriptionTargetRequest")
                .add("ApplicableAssetTypes", hasApplicableAssetTypes() ? applicableAssetTypes() : null)
                .add("AuthorizedPrincipals", hasAuthorizedPrincipals() ? authorizedPrincipals() : null)
                .add("DomainIdentifier", domainIdentifier()).add("EnvironmentIdentifier", environmentIdentifier())
                .add("Identifier", identifier()).add("ManageAccessRole", manageAccessRole())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Provider", provider())
                .add("SubscriptionTargetConfig", hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicableAssetTypes":
            return Optional.ofNullable(clazz.cast(applicableAssetTypes()));
        case "authorizedPrincipals":
            return Optional.ofNullable(clazz.cast(authorizedPrincipals()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "manageAccessRole":
            return Optional.ofNullable(clazz.cast(manageAccessRole()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "subscriptionTargetConfig":
            return Optional.ofNullable(clazz.cast(subscriptionTargetConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicableAssetTypes", APPLICABLE_ASSET_TYPES_FIELD);
        map.put("authorizedPrincipals", AUTHORIZED_PRINCIPALS_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("manageAccessRole", MANAGE_ACCESS_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("subscriptionTargetConfig", SUBSCRIPTION_TARGET_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriptionTargetRequest, T> g) {
        return obj -> g.apply((UpdateSubscriptionTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSubscriptionTargetRequest> {
        /**
         * <p>
         * The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(Collection<String> applicableAssetTypes);

        /**
         * <p>
         * The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(String... applicableAssetTypes);

        /**
         * <p>
         * The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(Collection<String> authorizedPrincipals);

        /**
         * <p>
         * The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(String... authorizedPrincipals);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a subscription target is to be updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which a subscription target is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the environment in which a subscription target is to be updated.
         * </p>
         * 
         * @param environmentIdentifier
         *        The identifier of the environment in which a subscription target is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * Identifier of the subscription target that is to be updated.
         * </p>
         * 
         * @param identifier
         *        Identifier of the subscription target that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param manageAccessRole
         *        The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageAccessRole(String manageAccessRole);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param provider
         *        The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig);

        /**
         * <p>
         * The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig);

        /**
         * <p>
         * The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptionTargetConfig(List<SubscriptionTargetForm>)}.
         * 
         * @param subscriptionTargetConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionTargetConfig(java.util.Collection<SubscriptionTargetForm>)
         */
        Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<String> applicableAssetTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorizedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private String domainIdentifier;

        private String environmentIdentifier;

        private String identifier;

        private String manageAccessRole;

        private String name;

        private String provider;

        private List<SubscriptionTargetForm> subscriptionTargetConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriptionTargetRequest model) {
            super(model);
            applicableAssetTypes(model.applicableAssetTypes);
            authorizedPrincipals(model.authorizedPrincipals);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            identifier(model.identifier);
            manageAccessRole(model.manageAccessRole);
            name(model.name);
            provider(model.provider);
            subscriptionTargetConfig(model.subscriptionTargetConfig);
        }

        public final Collection<String> getApplicableAssetTypes() {
            if (applicableAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return applicableAssetTypes;
        }

        public final void setApplicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
        }

        @Override
        public final Builder applicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableAssetTypes(String... applicableAssetTypes) {
            applicableAssetTypes(Arrays.asList(applicableAssetTypes));
            return this;
        }

        public final Collection<String> getAuthorizedPrincipals() {
            if (authorizedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedPrincipals;
        }

        public final void setAuthorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
        }

        @Override
        public final Builder authorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipals(String... authorizedPrincipals) {
            authorizedPrincipals(Arrays.asList(authorizedPrincipals));
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getManageAccessRole() {
            return manageAccessRole;
        }

        public final void setManageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
        }

        @Override
        public final Builder manageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<SubscriptionTargetForm.Builder> getSubscriptionTargetConfig() {
            List<SubscriptionTargetForm.Builder> result = SubscriptionTargetFormsCopier
                    .copyToBuilder(this.subscriptionTargetConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionTargetConfig(Collection<SubscriptionTargetForm.BuilderImpl> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copyFromBuilder(subscriptionTargetConfig);
        }

        @Override
        public final Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copy(subscriptionTargetConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig) {
            subscriptionTargetConfig(Arrays.asList(subscriptionTargetConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig) {
            subscriptionTargetConfig(Stream.of(subscriptionTargetConfig)
                    .map(c -> SubscriptionTargetForm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriptionTargetRequest build() {
            return new UpdateSubscriptionTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
