/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.AddEntityOwnerRequest;
import software.amazon.awssdk.services.datazone.model.AddEntityOwnerResponse;
import software.amazon.awssdk.services.datazone.model.AddPolicyGrantRequest;
import software.amazon.awssdk.services.datazone.model.AddPolicyGrantResponse;
import software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleRequest;
import software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleResponse;
import software.amazon.awssdk.services.datazone.model.AssociateGovernedTermsRequest;
import software.amazon.awssdk.services.datazone.model.AssociateGovernedTermsResponse;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.CreateAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.CreateAccountPoolResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateConnectionRequest;
import software.amazon.awssdk.services.datazone.model.CreateConnectionResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataProductResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.CreateDomainRequest;
import software.amazon.awssdk.services.datazone.model.CreateDomainResponse;
import software.amazon.awssdk.services.datazone.model.CreateDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.CreateDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectResponse;
import software.amazon.awssdk.services.datazone.model.CreateRuleRequest;
import software.amazon.awssdk.services.datazone.model.CreateRuleResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAccountPoolResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.datazone.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDataProductRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDataProductResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDomainRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDomainResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.DeleteListingRequest;
import software.amazon.awssdk.services.datazone.model.DeleteListingResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectResponse;
import software.amazon.awssdk.services.datazone.model.DeleteRuleRequest;
import software.amazon.awssdk.services.datazone.model.DeleteRuleResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleRequest;
import software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleResponse;
import software.amazon.awssdk.services.datazone.model.DisassociateGovernedTermsRequest;
import software.amazon.awssdk.services.datazone.model.DisassociateGovernedTermsResponse;
import software.amazon.awssdk.services.datazone.model.GetAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.GetAccountPoolResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetConnectionRequest;
import software.amazon.awssdk.services.datazone.model.GetConnectionResponse;
import software.amazon.awssdk.services.datazone.model.GetDataProductRequest;
import software.amazon.awssdk.services.datazone.model.GetDataProductResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.GetDomainRequest;
import software.amazon.awssdk.services.datazone.model.GetDomainResponse;
import software.amazon.awssdk.services.datazone.model.GetDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.GetDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.GetFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse;
import software.amazon.awssdk.services.datazone.model.GetJobRunRequest;
import software.amazon.awssdk.services.datazone.model.GetJobRunResponse;
import software.amazon.awssdk.services.datazone.model.GetLineageEventRequest;
import software.amazon.awssdk.services.datazone.model.GetLineageEventResponse;
import software.amazon.awssdk.services.datazone.model.GetLineageNodeRequest;
import software.amazon.awssdk.services.datazone.model.GetLineageNodeResponse;
import software.amazon.awssdk.services.datazone.model.GetListingRequest;
import software.amazon.awssdk.services.datazone.model.GetListingResponse;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.GetProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetProjectRequest;
import software.amazon.awssdk.services.datazone.model.GetProjectResponse;
import software.amazon.awssdk.services.datazone.model.GetRuleRequest;
import software.amazon.awssdk.services.datazone.model.GetRuleResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointResponse;
import software.amazon.awssdk.services.datazone.model.GetUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse;
import software.amazon.awssdk.services.datazone.model.ListConnectionsRequest;
import software.amazon.awssdk.services.datazone.model.ListConnectionsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse;
import software.amazon.awssdk.services.datazone.model.ListDomainsRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainsResponse;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.datazone.model.ListJobRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListJobRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListNotificationsRequest;
import software.amazon.awssdk.services.datazone.model.ListNotificationsResponse;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectsResponse;
import software.amazon.awssdk.services.datazone.model.ListRulesRequest;
import software.amazon.awssdk.services.datazone.model.ListRulesResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PostLineageEventRequest;
import software.amazon.awssdk.services.datazone.model.PostLineageEventResponse;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.RemoveEntityOwnerRequest;
import software.amazon.awssdk.services.datazone.model.RemoveEntityOwnerResponse;
import software.amazon.awssdk.services.datazone.model.RemovePolicyGrantRequest;
import software.amazon.awssdk.services.datazone.model.RemovePolicyGrantResponse;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse;
import software.amazon.awssdk.services.datazone.model.SearchListingsRequest;
import software.amazon.awssdk.services.datazone.model.SearchListingsResponse;
import software.amazon.awssdk.services.datazone.model.SearchRequest;
import software.amazon.awssdk.services.datazone.model.SearchResponse;
import software.amazon.awssdk.services.datazone.model.SearchTypesRequest;
import software.amazon.awssdk.services.datazone.model.SearchTypesResponse;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.TagResourceRequest;
import software.amazon.awssdk.services.datazone.model.TagResourceResponse;
import software.amazon.awssdk.services.datazone.model.UntagResourceRequest;
import software.amazon.awssdk.services.datazone.model.UntagResourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.UpdateAccountPoolResponse;
import software.amazon.awssdk.services.datazone.model.UpdateAssetFilterRequest;
import software.amazon.awssdk.services.datazone.model.UpdateAssetFilterResponse;
import software.amazon.awssdk.services.datazone.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.datazone.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDomainRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDomainResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDomainUnitRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDomainUnitResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentActionRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentActionResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateProjectProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateProjectProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateProjectRequest;
import software.amazon.awssdk.services.datazone.model.UpdateProjectResponse;
import software.amazon.awssdk.services.datazone.model.UpdateRuleRequest;
import software.amazon.awssdk.services.datazone.model.UpdateRuleResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.datazone.paginators.ListAccountPoolsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListAccountsInAccountPoolPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListConnectionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListJobRunsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListLineageEventsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListRulesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher;

/**
 * Service client for accessing Amazon DataZone asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your
 * data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone
 * simplifies your experience across Amazon Web Services services, including, but not limited to, Amazon Redshift,
 * Amazon Athena, Amazon Web Services Glue, and Amazon Web Services Lake Formation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataZoneAsyncClient extends AwsClient {
    String SERVICE_NAME = "datazone";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datazone";

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     *
     * @param acceptPredictionsRequest
     * @return A Java Future containing the result of the AcceptPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptPredictionsResponse> acceptPredictions(AcceptPredictionsRequest acceptPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPredictionsRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptPredictionsRequest#builder()}
     * </p>
     *
     * @param acceptPredictionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptPredictionsResponse> acceptPredictions(
            Consumer<AcceptPredictionsRequest.Builder> acceptPredictionsRequest) {
        return acceptPredictions(AcceptPredictionsRequest.builder().applyMutation(acceptPredictionsRequest).build());
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     * @return A Java Future containing the result of the AcceptSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptSubscriptionRequestResponse> acceptSubscriptionRequest(
            AcceptSubscriptionRequestRequest acceptSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AcceptSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptSubscriptionRequestResponse> acceptSubscriptionRequest(
            Consumer<AcceptSubscriptionRequestRequest.Builder> acceptSubscriptionRequestRequest) {
        return acceptSubscriptionRequest(AcceptSubscriptionRequestRequest.builder()
                .applyMutation(acceptSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Adds the owner of an entity (a domain unit).
     * </p>
     *
     * @param addEntityOwnerRequest
     * @return A Java Future containing the result of the AddEntityOwner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AddEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddEntityOwner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddEntityOwnerResponse> addEntityOwner(AddEntityOwnerRequest addEntityOwnerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the owner of an entity (a domain unit).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddEntityOwnerRequest.Builder} avoiding the need to
     * create one manually via {@link AddEntityOwnerRequest#builder()}
     * </p>
     *
     * @param addEntityOwnerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AddEntityOwnerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddEntityOwner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AddEntityOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddEntityOwner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddEntityOwnerResponse> addEntityOwner(Consumer<AddEntityOwnerRequest.Builder> addEntityOwnerRequest) {
        return addEntityOwner(AddEntityOwnerRequest.builder().applyMutation(addEntityOwnerRequest).build());
    }

    /**
     * <p>
     * Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment
     * blueprint configurations, or environment profiles.
     * </p>
     *
     * @param addPolicyGrantRequest
     * @return A Java Future containing the result of the AddPolicyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AddPolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddPolicyGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPolicyGrantResponse> addPolicyGrant(AddPolicyGrantRequest addPolicyGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment
     * blueprint configurations, or environment profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPolicyGrantRequest.Builder} avoiding the need to
     * create one manually via {@link AddPolicyGrantRequest#builder()}
     * </p>
     *
     * @param addPolicyGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AddPolicyGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddPolicyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AddPolicyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AddPolicyGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPolicyGrantResponse> addPolicyGrant(Consumer<AddPolicyGrantRequest.Builder> addPolicyGrantRequest) {
        return addPolicyGrant(AddPolicyGrantRequest.builder().applyMutation(addPolicyGrantRequest).build());
    }

    /**
     * <p>
     * Associates the environment role in Amazon DataZone.
     * </p>
     *
     * @param associateEnvironmentRoleRequest
     * @return A Java Future containing the result of the AssociateEnvironmentRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AssociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnvironmentRoleResponse> associateEnvironmentRole(
            AssociateEnvironmentRoleRequest associateEnvironmentRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the environment role in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnvironmentRoleRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateEnvironmentRoleRequest#builder()}
     * </p>
     *
     * @param associateEnvironmentRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AssociateEnvironmentRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateEnvironmentRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AssociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnvironmentRoleResponse> associateEnvironmentRole(
            Consumer<AssociateEnvironmentRoleRequest.Builder> associateEnvironmentRoleRequest) {
        return associateEnvironmentRole(AssociateEnvironmentRoleRequest.builder().applyMutation(associateEnvironmentRoleRequest)
                .build());
    }

    /**
     * <p>
     * Associates governed terms with an asset.
     * </p>
     *
     * @param associateGovernedTermsRequest
     * @return A Java Future containing the result of the AssociateGovernedTerms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AssociateGovernedTerms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateGovernedTerms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateGovernedTermsResponse> associateGovernedTerms(
            AssociateGovernedTermsRequest associateGovernedTermsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates governed terms with an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateGovernedTermsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateGovernedTermsRequest#builder()}
     * </p>
     *
     * @param associateGovernedTermsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AssociateGovernedTermsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateGovernedTerms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AssociateGovernedTerms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateGovernedTerms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateGovernedTermsResponse> associateGovernedTerms(
            Consumer<AssociateGovernedTermsRequest.Builder> associateGovernedTermsRequest) {
        return associateGovernedTerms(AssociateGovernedTermsRequest.builder().applyMutation(associateGovernedTermsRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The run must exist and be in a cancelable status (e.g., SUBMITTED, IN_PROGRESS).
     * </p>
     * </li>
     * <li>
     * <p>
     * Runs in SUCCEEDED status cannot be cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have access to the run and cancel permissions.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelMetadataGenerationRunRequest
     * @return A Java Future containing the result of the CancelMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataGenerationRunResponse> cancelMetadataGenerationRun(
            CancelMetadataGenerationRunRequest cancelMetadataGenerationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The run must exist and be in a cancelable status (e.g., SUBMITTED, IN_PROGRESS).
     * </p>
     * </li>
     * <li>
     * <p>
     * Runs in SUCCEEDED status cannot be cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have access to the run and cancel permissions.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMetadataGenerationRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param cancelMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataGenerationRunResponse> cancelMetadataGenerationRun(
            Consumer<CancelMetadataGenerationRunRequest.Builder> cancelMetadataGenerationRunRequest) {
        return cancelMetadataGenerationRun(CancelMetadataGenerationRunRequest.builder()
                .applyMutation(cancelMetadataGenerationRunRequest).build());
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     *
     * @param cancelSubscriptionRequest
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(CancelSubscriptionRequest cancelSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSubscriptionRequest#builder()}
     * </p>
     *
     * @param cancelSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(
            Consumer<CancelSubscriptionRequest.Builder> cancelSubscriptionRequest) {
        return cancelSubscription(CancelSubscriptionRequest.builder().applyMutation(cancelSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates an account pool.
     * </p>
     *
     * @param createAccountPoolRequest
     * @return A Java Future containing the result of the CreateAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAccountPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAccountPoolResponse> createAccountPool(CreateAccountPoolRequest createAccountPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an account pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountPoolRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccountPoolRequest#builder()}
     * </p>
     *
     * @param createAccountPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAccountPoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAccountPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAccountPoolResponse> createAccountPool(
            Consumer<CreateAccountPoolRequest.Builder> createAccountPoolRequest) {
        return createAccountPool(CreateAccountPoolRequest.builder().applyMutation(createAccountPoolRequest).build());
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     * <p>
     * Before creating assets, make sure that the following requirements are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>--domain-identifier</code> must refer to an existing domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>--owning-project-identifier</code> must be a valid project within the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset type must be created beforehand using <code>create-asset-type</code>, or be a supported system-defined
     * type. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/datazone/create-asset-type.html">create-asset-type</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>--type-revision</code> (if used) must match a valid revision of the asset type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Form type must exist and be associated with the asset type. Use <code>create-form-type</code> to define. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/datazone/create-form-type.html">create-form-type</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Form content must include all required fields as per the form schema (e.g., <code>bucketArn</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must invoke the following pre-requisite commands before invoking this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datazone/latest/APIReference/API_CreateFormType.html">CreateFormType</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datazone/latest/APIReference/API_CreateAssetType.html">CreateAssetType</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createAssetRequest
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(CreateAssetRequest createAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     * <p>
     * Before creating assets, make sure that the following requirements are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>--domain-identifier</code> must refer to an existing domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>--owning-project-identifier</code> must be a valid project within the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset type must be created beforehand using <code>create-asset-type</code>, or be a supported system-defined
     * type. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/datazone/create-asset-type.html">create-asset-type</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>--type-revision</code> (if used) must match a valid revision of the asset type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Form type must exist and be associated with the asset type. Use <code>create-form-type</code> to define. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/datazone/create-form-type.html">create-form-type</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Form content must include all required fields as per the form schema (e.g., <code>bucketArn</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must invoke the following pre-requisite commands before invoking this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datazone/latest/APIReference/API_CreateFormType.html">CreateFormType</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datazone/latest/APIReference/API_CreateAssetType.html">CreateAssetType</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest) {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * <p>
     * Creates a data asset filter.
     * </p>
     * <p>
     * Asset filters provide a sophisticated way to create controlled views of data assets by selecting specific columns
     * or applying row-level filters. This capability is crucial for organizations that need to share data while
     * maintaining security and privacy controls. For example, your database might be filtered to show only non-PII
     * fields to certain users, or sales data might be filtered by region for different regional teams. Asset filters
     * enable fine-grained access control while maintaining a single source of truth.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A valid domain (<code>--domain-identifier</code>) must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * A data asset (<code>--asset-identifier</code>) must already be created under that domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must have the referenced columns available in its schema for column-based filtering.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot specify both (<code>columnConfiguration</code>, <code>rowConfiguration</code>)at the same time.
     * </p>
     * </li>
     * </ul>
     *
     * @param createAssetFilterRequest
     * @return A Java Future containing the result of the CreateAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetFilterResponse> createAssetFilter(CreateAssetFilterRequest createAssetFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data asset filter.
     * </p>
     * <p>
     * Asset filters provide a sophisticated way to create controlled views of data assets by selecting specific columns
     * or applying row-level filters. This capability is crucial for organizations that need to share data while
     * maintaining security and privacy controls. For example, your database might be filtered to show only non-PII
     * fields to certain users, or sales data might be filtered by region for different regional teams. Asset filters
     * enable fine-grained access control while maintaining a single source of truth.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A valid domain (<code>--domain-identifier</code>) must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * A data asset (<code>--asset-identifier</code>) must already be created under that domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must have the referenced columns available in its schema for column-based filtering.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot specify both (<code>columnConfiguration</code>, <code>rowConfiguration</code>)at the same time.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetFilterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetFilterRequest#builder()}
     * </p>
     *
     * @param createAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetFilterResponse> createAssetFilter(
            Consumer<CreateAssetFilterRequest.Builder> createAssetFilterRequest) {
        return createAssetFilter(CreateAssetFilterRequest.builder().applyMutation(createAssetFilterRequest).build());
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     * <p>
     * Asset revisions represent new versions of existing assets, capturing changes to either the underlying data or its
     * metadata. They maintain a historical record of how assets evolve over time, who made changes, and when those
     * changes occurred. This versioning capability is crucial for governance and compliance, allowing organizations to
     * track changes, understand their impact, and roll back if necessary.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Asset must already exist in the domain with identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type with correct revision must be registered in the same domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form content must include all required fields (e.g., <code>bucketArn</code> for
     * <code>S3ObjectCollectionForm</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project of the original asset must still exist and be active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have write access to the project and domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param createAssetRevisionRequest
     * @return A Java Future containing the result of the CreateAssetRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetRevisionResponse> createAssetRevision(
            CreateAssetRevisionRequest createAssetRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     * <p>
     * Asset revisions represent new versions of existing assets, capturing changes to either the underlying data or its
     * metadata. They maintain a historical record of how assets evolve over time, who made changes, and when those
     * changes occurred. This versioning capability is crucial for governance and compliance, allowing organizations to
     * track changes, understand their impact, and roll back if necessary.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Asset must already exist in the domain with identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type with correct revision must be registered in the same domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form content must include all required fields (e.g., <code>bucketArn</code> for
     * <code>S3ObjectCollectionForm</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project of the original asset must still exist and be active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have write access to the project and domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRevisionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssetRevisionRequest#builder()}
     * </p>
     *
     * @param createAssetRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssetRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetRevisionResponse> createAssetRevision(
            Consumer<CreateAssetRevisionRequest.Builder> createAssetRevisionRequest) {
        return createAssetRevision(CreateAssetRevisionRequest.builder().applyMutation(createAssetRevisionRequest).build());
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type with <code>typeIdentifier</code> and <code>typeRevision</code> must exist and be published.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have <code>CreateAssetType</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain-identifier and owning-project-identifier must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the asset type must be unique within the domain — duplicate names will cause failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * JSON input must be valid — incorrect formatting causes Invalid JSON errors.
     * </p>
     * </li>
     * </ul>
     *
     * @param createAssetTypeRequest
     * @return A Java Future containing the result of the CreateAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetTypeResponse> createAssetType(CreateAssetTypeRequest createAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type with <code>typeIdentifier</code> and <code>typeRevision</code> must exist and be published.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have <code>CreateAssetType</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain-identifier and owning-project-identifier must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the asset type must be unique within the domain — duplicate names will cause failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * JSON input must be valid — incorrect formatting causes Invalid JSON errors.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetTypeRequest#builder()}
     * </p>
     *
     * @param createAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetTypeResponse> createAssetType(
            Consumer<CreateAssetTypeRequest.Builder> createAssetTypeRequest) {
        return createAssetType(CreateAssetTypeRequest.builder().applyMutation(createAssetTypeRequest).build());
    }

    /**
     * <p>
     * Creates a new connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(
            Consumer<CreateConnectionRequest.Builder> createConnectionRequest) {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a data product.
     * </p>
     * <p>
     * A data product is a comprehensive package that combines data assets with their associated metadata,
     * documentation, and access controls. It's designed to serve specific business needs or use cases, making it easier
     * for users to find and consume data appropriately. Data products include important information about data quality,
     * freshness, and usage guidelines, effectively bridging the gap between data producers and consumers while ensuring
     * proper governance.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The domain must exist and be accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must be unique within the domain (no existing data product with the same name).
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have create permissions for data products in the project.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must have Amazon DataZone publishing enabled.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDataProductRequest
     * @return A Java Future containing the result of the CreateDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataProductResponse> createDataProduct(CreateDataProductRequest createDataProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data product.
     * </p>
     * <p>
     * A data product is a comprehensive package that combines data assets with their associated metadata,
     * documentation, and access controls. It's designed to serve specific business needs or use cases, making it easier
     * for users to find and consume data appropriately. Data products include important information about data quality,
     * freshness, and usage guidelines, effectively bridging the gap between data producers and consumers while ensuring
     * proper governance.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The domain must exist and be accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must be unique within the domain (no existing data product with the same name).
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have create permissions for data products in the project.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must have Amazon DataZone publishing enabled.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProductRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataProductRequest#builder()}
     * </p>
     *
     * @param createDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataProductResponse> createDataProduct(
            Consumer<CreateDataProductRequest.Builder> createDataProductRequest) {
        return createDataProduct(CreateDataProductRequest.builder().applyMutation(createDataProductRequest).build());
    }

    /**
     * <p>
     * Creates a data product revision.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The original data product must exist in the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permissions on the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new revision name must comply with naming constraints (if required).
     * </p>
     * </li>
     * </ul>
     *
     * @param createDataProductRevisionRequest
     * @return A Java Future containing the result of the CreateDataProductRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataProductRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProductRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataProductRevisionResponse> createDataProductRevision(
            CreateDataProductRevisionRequest createDataProductRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data product revision.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The original data product must exist in the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permissions on the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new revision name must comply with naming constraints (if required).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProductRevisionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataProductRevisionRequest#builder()}
     * </p>
     *
     * @param createDataProductRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataProductRevisionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateDataProductRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataProductRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataProductRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataProductRevisionResponse> createDataProductRevision(
            Consumer<CreateDataProductRevisionRequest.Builder> createDataProductRevisionRequest) {
        return createDataProductRevision(CreateDataProductRevisionRequest.builder()
                .applyMutation(createDataProductRevisionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a domain unit in Amazon DataZone.
     * </p>
     *
     * @param createDomainUnitRequest
     * @return A Java Future containing the result of the CreateDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainUnitResponse> createDomainUnit(CreateDomainUnitRequest createDomainUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain unit in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainUnitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainUnitRequest#builder()}
     * </p>
     *
     * @param createDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDomainUnitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainUnitResponse> createDomainUnit(
            Consumer<CreateDomainUnitRequest.Builder> createDomainUnitRequest) {
        return createDomainUnit(CreateDomainUnitRequest.builder().applyMutation(createDomainUnitRequest).build());
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates an action for the environment, for example, creates a console link for an analytics tool that is
     * available in this environment.
     * </p>
     *
     * @param createEnvironmentActionRequest
     * @return A Java Future containing the result of the CreateEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentActionResponse> createEnvironmentAction(
            CreateEnvironmentActionRequest createEnvironmentActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an action for the environment, for example, creates a console link for an analytics tool that is
     * available in this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentActionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param createEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentActionResponse> createEnvironmentAction(
            Consumer<CreateEnvironmentActionRequest.Builder> createEnvironmentActionRequest) {
        return createEnvironmentAction(CreateEnvironmentActionRequest.builder().applyMutation(createEnvironmentActionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Amazon DataZone blueprint.
     * </p>
     *
     * @param createEnvironmentBlueprintRequest
     * @return A Java Future containing the result of the CreateEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentBlueprintResponse> createEnvironmentBlueprint(
            CreateEnvironmentBlueprintRequest createEnvironmentBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Amazon DataZone blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentBlueprintRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentBlueprintRequest#builder()}
     * </p>
     *
     * @param createEnvironmentBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentBlueprintRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentBlueprintResponse> createEnvironmentBlueprint(
            Consumer<CreateEnvironmentBlueprintRequest.Builder> createEnvironmentBlueprintRequest) {
        return createEnvironmentBlueprint(CreateEnvironmentBlueprintRequest.builder()
                .applyMutation(createEnvironmentBlueprintRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     *
     * @param createEnvironmentProfileRequest
     * @return A Java Future containing the result of the CreateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentProfileResponse> createEnvironmentProfile(
            CreateEnvironmentProfileRequest createEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param createEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentProfileResponse> createEnvironmentProfile(
            Consumer<CreateEnvironmentProfileRequest.Builder> createEnvironmentProfileRequest) {
        return createEnvironmentProfile(CreateEnvironmentProfileRequest.builder().applyMutation(createEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The domain must exist and be in an <code>ENABLED</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project must exist and be accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must be unique within the domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param createFormTypeRequest
     * @return A Java Future containing the result of the CreateFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFormTypeResponse> createFormType(CreateFormTypeRequest createFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The domain must exist and be in an <code>ENABLED</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The owning project must exist and be accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must be unique within the domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFormTypeRequest#builder()}
     * </p>
     *
     * @param createFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFormTypeResponse> createFormType(Consumer<CreateFormTypeRequest.Builder> createFormTypeRequest) {
        return createFormType(CreateFormTypeRequest.builder().applyMutation(createFormTypeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     * <p>
     * Specifies that this is a create glossary policy.
     * </p>
     * <p>
     * A glossary serves as the central repository for business terminology and definitions within an organization. It
     * helps establish and maintain a common language across different departments and teams, reducing miscommunication
     * and ensuring consistent interpretation of business concepts. Glossaries can include hierarchical relationships
     * between terms, cross-references, and links to actual data assets, making them invaluable for both business users
     * and technical teams trying to understand and use data correctly.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain must exist and be in an active state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Owning project must exist and be accessible by the caller.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary name must be unique within the domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param createGlossaryRequest
     * @return A Java Future containing the result of the CreateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlossaryResponse> createGlossary(CreateGlossaryRequest createGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     * <p>
     * Specifies that this is a create glossary policy.
     * </p>
     * <p>
     * A glossary serves as the central repository for business terminology and definitions within an organization. It
     * helps establish and maintain a common language across different departments and teams, reducing miscommunication
     * and ensuring consistent interpretation of business concepts. Glossaries can include hierarchical relationships
     * between terms, cross-references, and links to actual data assets, making them invaluable for both business users
     * and technical teams trying to understand and use data correctly.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain must exist and be in an active state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Owning project must exist and be accessible by the caller.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary name must be unique within the domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGlossaryRequest#builder()}
     * </p>
     *
     * @param createGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlossaryResponse> createGlossary(Consumer<CreateGlossaryRequest.Builder> createGlossaryRequest) {
        return createGlossary(CreateGlossaryRequest.builder().applyMutation(createGlossaryRequest).build());
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     * <p>
     * A glossary term represents an individual entry within the Amazon DataZone glossary, serving as a standardized
     * definition for a specific business concept or data element. Each term can include rich metadata such as detailed
     * definitions, synonyms, related terms, and usage examples. Glossary terms can be linked directly to data assets,
     * providing business context to technical data elements. This linking capability helps users understand the
     * business meaning of data fields and ensures consistent interpretation across different systems and teams. Terms
     * can also have relationships with other terms, creating a semantic network that reflects the complexity of
     * business concepts.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * Glossary must exist and be in an ENABLED state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The term name must be unique within the glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure term does not conflict with existing terms in hierarchy.
     * </p>
     * </li>
     * </ul>
     *
     * @param createGlossaryTermRequest
     * @return A Java Future containing the result of the CreateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlossaryTermResponse> createGlossaryTerm(CreateGlossaryTermRequest createGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     * <p>
     * A glossary term represents an individual entry within the Amazon DataZone glossary, serving as a standardized
     * definition for a specific business concept or data element. Each term can include rich metadata such as detailed
     * definitions, synonyms, related terms, and usage examples. Glossary terms can be linked directly to data assets,
     * providing business context to technical data elements. This linking capability helps users understand the
     * business meaning of data fields and ensures consistent interpretation across different systems and teams. Terms
     * can also have relationships with other terms, creating a semantic network that reflects the complexity of
     * business concepts.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * Glossary must exist and be in an ENABLED state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The term name must be unique within the glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure term does not conflict with existing terms in hierarchy.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlossaryTermRequest#builder()}
     * </p>
     *
     * @param createGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlossaryTermResponse> createGlossaryTerm(
            Consumer<CreateGlossaryTermRequest.Builder> createGlossaryTermRequest) {
        return createGlossaryTerm(CreateGlossaryTermRequest.builder().applyMutation(createGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     *
     * @param createGroupProfileRequest
     * @return A Java Future containing the result of the CreateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupProfileResponse> createGroupProfile(CreateGroupProfileRequest createGroupProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupProfileRequest#builder()}
     * </p>
     *
     * @param createGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupProfileResponse> createGroupProfile(
            Consumer<CreateGroupProfileRequest.Builder> createGroupProfileRequest) {
        return createGroupProfile(CreateGroupProfileRequest.builder().applyMutation(createGroupProfileRequest).build());
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     *
     * @param createListingChangeSetRequest
     * @return A Java Future containing the result of the CreateListingChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListingChangeSetResponse> createListingChangeSet(
            CreateListingChangeSetRequest createListingChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListingChangeSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateListingChangeSetRequest#builder()}
     * </p>
     *
     * @param createListingChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateListingChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListingChangeSetResponse> createListingChangeSet(
            Consumer<CreateListingChangeSetRequest.Builder> createListingChangeSetRequest) {
        return createListingChangeSet(CreateListingChangeSetRequest.builder().applyMutation(createListingChangeSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     *
     * @param createProjectMembershipRequest
     * @return A Java Future containing the result of the CreateProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProjectMembershipResponse> createProjectMembership(
            CreateProjectMembershipRequest createProjectMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProjectMembershipRequest#builder()}
     * </p>
     *
     * @param createProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProjectMembershipResponse> createProjectMembership(
            Consumer<CreateProjectMembershipRequest.Builder> createProjectMembershipRequest) {
        return createProjectMembership(CreateProjectMembershipRequest.builder().applyMutation(createProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Creates a project profile.
     * </p>
     *
     * @param createProjectProfileRequest
     * @return A Java Future containing the result of the CreateProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProjectProfileResponse> createProjectProfile(
            CreateProjectProfileRequest createProjectProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProjectProfileRequest#builder()}
     * </p>
     *
     * @param createProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProjectProfileResponse> createProjectProfile(
            Consumer<CreateProjectProfileRequest.Builder> createProjectProfileRequest) {
        return createProjectProfile(CreateProjectProfileRequest.builder().applyMutation(createProjectProfileRequest).build());
    }

    /**
     * <p>
     * Creates a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionGrantRequest
     * @return A Java Future containing the result of the CreateSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionGrantResponse> createSubscriptionGrant(
            CreateSubscriptionGrantRequest createSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param createSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionGrantResponse> createSubscriptionGrant(
            Consumer<CreateSubscriptionGrantRequest.Builder> createSubscriptionGrantRequest) {
        return createSubscriptionGrant(CreateSubscriptionGrantRequest.builder().applyMutation(createSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionRequestRequest
     * @return A Java Future containing the result of the CreateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionRequestResponse> createSubscriptionRequest(
            CreateSubscriptionRequestRequest createSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionRequestResponse> createSubscriptionRequest(
            Consumer<CreateSubscriptionRequestRequest.Builder> createSubscriptionRequestRequest) {
        return createSubscriptionRequest(CreateSubscriptionRequestRequest.builder()
                .applyMutation(createSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionTargetRequest
     * @return A Java Future containing the result of the CreateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionTargetResponse> createSubscriptionTarget(
            CreateSubscriptionTargetRequest createSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param createSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionTargetResponse> createSubscriptionTarget(
            Consumer<CreateSubscriptionTargetRequest.Builder> createSubscriptionTargetRequest) {
        return createSubscriptionTarget(CreateSubscriptionTargetRequest.builder().applyMutation(createSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserProfileRequest#builder()}
     * </p>
     *
     * @param createUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(
            Consumer<CreateUserProfileRequest.Builder> createUserProfileRequest) {
        return createUserProfile(CreateUserProfileRequest.builder().applyMutation(createUserProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an account pool.
     * </p>
     *
     * @param deleteAccountPoolRequest
     * @return A Java Future containing the result of the DeleteAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAccountPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAccountPoolResponse> deleteAccountPool(DeleteAccountPoolRequest deleteAccountPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccountPoolRequest#builder()}
     * </p>
     *
     * @param deleteAccountPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAccountPoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAccountPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAccountPoolResponse> deleteAccountPool(
            Consumer<DeleteAccountPoolRequest.Builder> deleteAccountPoolRequest) {
        return deleteAccountPool(DeleteAccountPoolRequest.builder().applyMutation(deleteAccountPoolRequest).build());
    }

    /**
     * <p>
     * Deletes an asset in Amazon DataZone.
     * </p>
     * <ul>
     * <li>
     * <p>
     * --domain-identifier must refer to a valid and existing domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * --identifier must refer to an existing asset in the specified domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset must not be referenced in any existing asset filters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset must not be linked to any draft or published data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have delete permissions for the domain and project.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAssetRequest
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(DeleteAssetRequest deleteAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset in Amazon DataZone.
     * </p>
     * <ul>
     * <li>
     * <p>
     * --domain-identifier must refer to a valid and existing domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * --identifier must refer to an existing asset in the specified domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset must not be referenced in any existing asset filters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset must not be linked to any draft or published data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have delete permissions for the domain and project.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest) {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * Deletes an asset filter.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset filter must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain and asset must not have been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure the --identifier refers to a valid filter ID.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAssetFilterRequest
     * @return A Java Future containing the result of the DeleteAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetFilterResponse> deleteAssetFilter(DeleteAssetFilterRequest deleteAssetFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset filter.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset filter must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain and asset must not have been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure the --identifier refers to a valid filter ID.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetFilterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetFilterRequest#builder()}
     * </p>
     *
     * @param deleteAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetFilterResponse> deleteAssetFilter(
            Consumer<DeleteAssetFilterRequest.Builder> deleteAssetFilterRequest) {
        return deleteAssetFilter(DeleteAssetFilterRequest.builder().applyMutation(deleteAssetFilterRequest).build());
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset type must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have DeleteAssetType permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset type must not be in use (e.g., assigned to any asset). If used, deletion will fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * You should retrieve the asset type using get-asset-type to confirm its presence before deletion.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAssetTypeRequest
     * @return A Java Future containing the result of the DeleteAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetTypeResponse> deleteAssetType(DeleteAssetTypeRequest deleteAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset type must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have DeleteAssetType permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset type must not be in use (e.g., assigned to any asset). If used, deletion will fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * You should retrieve the asset type using get-asset-type to confirm its presence before deletion.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetTypeRequest#builder()}
     * </p>
     *
     * @param deleteAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetTypeResponse> deleteAssetType(
            Consumer<DeleteAssetTypeRequest.Builder> deleteAssetTypeRequest) {
        return deleteAssetType(DeleteAssetTypeRequest.builder().applyMutation(deleteAssetTypeRequest).build());
    }

    /**
     * <p>
     * Deletes and connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and connection. In Amazon DataZone, a connection enables you to connect your resources (domains,
     * projects, and environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes a data product in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product must exist and not be deleted or archived.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user must have delete permissions for the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure there are no active dependencies (e.g., published links, assets using the product).
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain and project must be active.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteDataProductRequest
     * @return A Java Future containing the result of the DeleteDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataProductResponse> deleteDataProduct(DeleteDataProductRequest deleteDataProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data product in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product must exist and not be deleted or archived.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user must have delete permissions for the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure there are no active dependencies (e.g., published links, assets using the product).
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain and project must be active.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProductRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataProductRequest#builder()}
     * </p>
     *
     * @param deleteDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDataProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataProductResponse> deleteDataProduct(
            Consumer<DeleteDataProductRequest.Builder> deleteDataProductRequest) {
        return deleteDataProduct(DeleteDataProductRequest.builder().applyMutation(deleteDataProductRequest).build());
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a domain unit.
     * </p>
     *
     * @param deleteDomainUnitRequest
     * @return A Java Future containing the result of the DeleteDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainUnitResponse> deleteDomainUnit(DeleteDomainUnitRequest deleteDomainUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainUnitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainUnitRequest#builder()}
     * </p>
     *
     * @param deleteDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDomainUnitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainUnitResponse> deleteDomainUnit(
            Consumer<DeleteDomainUnitRequest.Builder> deleteDomainUnitRequest) {
        return deleteDomainUnit(DeleteDomainUnitRequest.builder().applyMutation(deleteDomainUnitRequest).build());
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes an action for the environment, for example, deletes a console link for an analytics tool that is
     * available in this environment.
     * </p>
     *
     * @param deleteEnvironmentActionRequest
     * @return A Java Future containing the result of the DeleteEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentActionResponse> deleteEnvironmentAction(
            DeleteEnvironmentActionRequest deleteEnvironmentActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an action for the environment, for example, deletes a console link for an analytics tool that is
     * available in this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentActionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentActionResponse> deleteEnvironmentAction(
            Consumer<DeleteEnvironmentActionRequest.Builder> deleteEnvironmentActionRequest) {
        return deleteEnvironmentAction(DeleteEnvironmentActionRequest.builder().applyMutation(deleteEnvironmentActionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a blueprint in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentBlueprintRequest
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintResponse> deleteEnvironmentBlueprint(
            DeleteEnvironmentBlueprintRequest deleteEnvironmentBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a blueprint in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentBlueprintRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentBlueprintRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintResponse> deleteEnvironmentBlueprint(
            Consumer<DeleteEnvironmentBlueprintRequest.Builder> deleteEnvironmentBlueprintRequest) {
        return deleteEnvironmentBlueprint(DeleteEnvironmentBlueprintRequest.builder()
                .applyMutation(deleteEnvironmentBlueprintRequest).build());
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprintConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintConfigurationResponse> deleteEnvironmentBlueprintConfiguration(
            DeleteEnvironmentBlueprintConfigurationRequest deleteEnvironmentBlueprintConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprintConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintConfigurationResponse> deleteEnvironmentBlueprintConfiguration(
            Consumer<DeleteEnvironmentBlueprintConfigurationRequest.Builder> deleteEnvironmentBlueprintConfigurationRequest) {
        return deleteEnvironmentBlueprintConfiguration(DeleteEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(deleteEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     * @return A Java Future containing the result of the DeleteEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentProfileResponse> deleteEnvironmentProfile(
            DeleteEnvironmentProfileRequest deleteEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentProfileResponse> deleteEnvironmentProfile(
            Consumer<DeleteEnvironmentProfileRequest.Builder> deleteEnvironmentProfileRequest) {
        return deleteEnvironmentProfile(DeleteEnvironmentProfileRequest.builder().applyMutation(deleteEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Deletes and metadata form type in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type must not be in use by any asset types or assets.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have delete permissions on the form type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any dependencies (such as linked asset types) must be removed first.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteFormTypeRequest
     * @return A Java Future containing the result of the DeleteFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFormTypeResponse> deleteFormType(DeleteFormTypeRequest deleteFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and metadata form type in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type must not be in use by any asset types or assets.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have delete permissions on the form type.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any dependencies (such as linked asset types) must be removed first.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFormTypeRequest#builder()}
     * </p>
     *
     * @param deleteFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFormTypeResponse> deleteFormType(Consumer<DeleteFormTypeRequest.Builder> deleteFormTypeRequest) {
        return deleteFormType(DeleteFormTypeRequest.builder().applyMutation(deleteFormTypeRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The glossary must be in DISABLED state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary must not have any glossary terms associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary must exist in the specified domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The caller must have the <code>datazone:DeleteGlossary</code> permission in the domain and glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * There should be no active assets or metadata linked to the glossary.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteGlossaryRequest
     * @return A Java Future containing the result of the DeleteGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryResponse> deleteGlossary(DeleteGlossaryRequest deleteGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The glossary must be in DISABLED state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary must not have any glossary terms associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * The glossary must exist in the specified domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The caller must have the <code>datazone:DeleteGlossary</code> permission in the domain and glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * There should be no active assets or metadata linked to the glossary.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGlossaryRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryResponse> deleteGlossary(Consumer<DeleteGlossaryRequest.Builder> deleteGlossaryRequest) {
        return deleteGlossary(DeleteGlossaryRequest.builder().applyMutation(deleteGlossaryRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Glossary term must exist and be active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The term must not be linked to other assets or child terms.
     * </p>
     * </li>
     * <li>
     * <p>
     * Caller must have delete permissions in the domain/glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure all associations (such as to assets or parent terms) are removed before deletion.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteGlossaryTermRequest
     * @return A Java Future containing the result of the DeleteGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryTermResponse> deleteGlossaryTerm(DeleteGlossaryTermRequest deleteGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Glossary term must exist and be active.
     * </p>
     * </li>
     * <li>
     * <p>
     * The term must not be linked to other assets or child terms.
     * </p>
     * </li>
     * <li>
     * <p>
     * Caller must have delete permissions in the domain/glossary.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure all associations (such as to assets or parent terms) are removed before deletion.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlossaryTermRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryTermResponse> deleteGlossaryTerm(
            Consumer<DeleteGlossaryTermRequest.Builder> deleteGlossaryTermRequest) {
        return deleteGlossaryTerm(DeleteGlossaryTermRequest.builder().applyMutation(deleteGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     *
     * @param deleteListingRequest
     * @return A Java Future containing the result of the DeleteListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteListingResponse> deleteListing(DeleteListingRequest deleteListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListingRequest#builder()}
     * </p>
     *
     * @param deleteListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteListingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteListingResponse> deleteListing(Consumer<DeleteListingRequest.Builder> deleteListingRequest) {
        return deleteListing(DeleteListingRequest.builder().applyMutation(deleteListingRequest).build());
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectMembershipRequest
     * @return A Java Future containing the result of the DeleteProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProjectMembershipResponse> deleteProjectMembership(
            DeleteProjectMembershipRequest deleteProjectMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProjectMembershipRequest#builder()}
     * </p>
     *
     * @param deleteProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProjectMembershipResponse> deleteProjectMembership(
            Consumer<DeleteProjectMembershipRequest.Builder> deleteProjectMembershipRequest) {
        return deleteProjectMembership(DeleteProjectMembershipRequest.builder().applyMutation(deleteProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a project profile.
     * </p>
     *
     * @param deleteProjectProfileRequest
     * @return A Java Future containing the result of the DeleteProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProjectProfileResponse> deleteProjectProfile(
            DeleteProjectProfileRequest deleteProjectProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProjectProfileRequest#builder()}
     * </p>
     *
     * @param deleteProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProjectProfileResponse> deleteProjectProfile(
            Consumer<DeleteProjectProfileRequest.Builder> deleteProjectProfileRequest) {
        return deleteProjectProfile(DeleteProjectProfileRequest.builder().applyMutation(deleteProjectProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements across user
     * workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon
     * DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards
     * in data management processes. For instance, a metadata enforcement rule can specify the required information for
     * creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational
     * standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     * @return A Java Future containing the result of the DeleteSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionGrantResponse> deleteSubscriptionGrant(
            DeleteSubscriptionGrantRequest deleteSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionGrantResponse> deleteSubscriptionGrant(
            Consumer<DeleteSubscriptionGrantRequest.Builder> deleteSubscriptionGrantRequest) {
        return deleteSubscriptionGrant(DeleteSubscriptionGrantRequest.builder().applyMutation(deleteSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     * @return A Java Future containing the result of the DeleteSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionRequestResponse> deleteSubscriptionRequest(
            DeleteSubscriptionRequestRequest deleteSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionRequestResponse> deleteSubscriptionRequest(
            Consumer<DeleteSubscriptionRequestRequest.Builder> deleteSubscriptionRequestRequest) {
        return deleteSubscriptionRequest(DeleteSubscriptionRequestRequest.builder()
                .applyMutation(deleteSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     * @return A Java Future containing the result of the DeleteSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionTargetResponse> deleteSubscriptionTarget(
            DeleteSubscriptionTargetRequest deleteSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionTargetResponse> deleteSubscriptionTarget(
            Consumer<DeleteSubscriptionTargetRequest.Builder> deleteSubscriptionTargetRequest) {
        return deleteSubscriptionTarget(DeleteSubscriptionTargetRequest.builder().applyMutation(deleteSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     * @return A Java Future containing the result of the DeleteTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesDataPointsResponse> deleteTimeSeriesDataPoints(
            DeleteTimeSeriesDataPointsRequest deleteTimeSeriesDataPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesDataPointsResponse> deleteTimeSeriesDataPoints(
            Consumer<DeleteTimeSeriesDataPointsRequest.Builder> deleteTimeSeriesDataPointsRequest) {
        return deleteTimeSeriesDataPoints(DeleteTimeSeriesDataPointsRequest.builder()
                .applyMutation(deleteTimeSeriesDataPointsRequest).build());
    }

    /**
     * <p>
     * Disassociates the environment role in Amazon DataZone.
     * </p>
     *
     * @param disassociateEnvironmentRoleRequest
     * @return A Java Future containing the result of the DisassociateEnvironmentRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DisassociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEnvironmentRoleResponse> disassociateEnvironmentRole(
            DisassociateEnvironmentRoleRequest disassociateEnvironmentRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the environment role in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateEnvironmentRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateEnvironmentRoleRequest#builder()}
     * </p>
     *
     * @param disassociateEnvironmentRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DisassociateEnvironmentRoleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateEnvironmentRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DisassociateEnvironmentRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEnvironmentRoleResponse> disassociateEnvironmentRole(
            Consumer<DisassociateEnvironmentRoleRequest.Builder> disassociateEnvironmentRoleRequest) {
        return disassociateEnvironmentRole(DisassociateEnvironmentRoleRequest.builder()
                .applyMutation(disassociateEnvironmentRoleRequest).build());
    }

    /**
     * <p>
     * Disassociates restricted terms from an asset.
     * </p>
     *
     * @param disassociateGovernedTermsRequest
     * @return A Java Future containing the result of the DisassociateGovernedTerms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DisassociateGovernedTerms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateGovernedTerms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGovernedTermsResponse> disassociateGovernedTerms(
            DisassociateGovernedTermsRequest disassociateGovernedTermsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates restricted terms from an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateGovernedTermsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateGovernedTermsRequest#builder()}
     * </p>
     *
     * @param disassociateGovernedTermsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DisassociateGovernedTermsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateGovernedTerms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DisassociateGovernedTerms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateGovernedTerms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGovernedTermsResponse> disassociateGovernedTerms(
            Consumer<DisassociateGovernedTermsRequest.Builder> disassociateGovernedTermsRequest) {
        return disassociateGovernedTerms(DisassociateGovernedTermsRequest.builder()
                .applyMutation(disassociateGovernedTermsRequest).build());
    }

    /**
     * <p>
     * Gets the details of the account pool.
     * </p>
     *
     * @param getAccountPoolRequest
     * @return A Java Future containing the result of the GetAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAccountPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountPoolResponse> getAccountPool(GetAccountPoolRequest getAccountPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the account pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPoolRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountPoolRequest#builder()}
     * </p>
     *
     * @param getAccountPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAccountPoolRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAccountPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountPoolResponse> getAccountPool(Consumer<GetAccountPoolRequest.Builder> getAccountPoolRequest) {
        return getAccountPool(GetAccountPoolRequest.builder().applyMutation(getAccountPoolRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     * <p>
     * An asset is the fundamental building block in Amazon DataZone, representing any data resource that needs to be
     * cataloged and managed. It can take many forms, from Amazon S3 buckets and database tables to dashboards and
     * machine learning models. Each asset contains comprehensive metadata about the resource, including its location,
     * schema, ownership, and lineage information. Assets are essential for organizing and managing data resources
     * across an organization, making them discoverable and usable while maintaining proper governance.
     * </p>
     * <p>
     * Before using the Amazon DataZone GetAsset command, ensure the following prerequisites are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain identifier must exist and be valid
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset identifier must exist
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have the required permissions to perform the action
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetRequest
     * @return A Java Future containing the result of the GetAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetResponse> getAsset(GetAssetRequest getAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     * <p>
     * An asset is the fundamental building block in Amazon DataZone, representing any data resource that needs to be
     * cataloged and managed. It can take many forms, from Amazon S3 buckets and database tables to dashboards and
     * machine learning models. Each asset contains comprehensive metadata about the resource, including its location,
     * schema, ownership, and lineage information. Assets are essential for organizing and managing data resources
     * across an organization, making them discoverable and usable while maintaining proper governance.
     * </p>
     * <p>
     * Before using the Amazon DataZone GetAsset command, ensure the following prerequisites are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain identifier must exist and be valid
     * </p>
     * </li>
     * <li>
     * <p>
     * Asset identifier must exist
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have the required permissions to perform the action
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetRequest#builder()}
     * </p>
     *
     * @param getAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetResponse> getAsset(Consumer<GetAssetRequest.Builder> getAssetRequest) {
        return getAsset(GetAssetRequest.builder().applyMutation(getAssetRequest).build());
    }

    /**
     * <p>
     * Gets an asset filter.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain (<code>--domain-identifier</code>), asset (<code>--asset-identifier</code>), and filter (
     * <code>--identifier</code>) must all exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset filter should not have been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must still exist (since the filter is linked to it).
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetFilterRequest
     * @return A Java Future containing the result of the GetAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetFilterResponse> getAssetFilter(GetAssetFilterRequest getAssetFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an asset filter.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Domain (<code>--domain-identifier</code>), asset (<code>--asset-identifier</code>), and filter (
     * <code>--identifier</code>) must all exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset filter should not have been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must still exist (since the filter is linked to it).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetFilterRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetFilterRequest#builder()}
     * </p>
     *
     * @param getAssetFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetFilterResponse> getAssetFilter(Consumer<GetAssetFilterRequest.Builder> getAssetFilterRequest) {
        return getAssetFilter(GetAssetFilterRequest.builder().applyMutation(getAssetFilterRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     * <p>
     * Asset types define the categories and characteristics of different kinds of data assets within Amazon DataZone..
     * They determine what metadata fields are required, what operations are possible, and how the asset integrates with
     * other Amazon Web Services services. Asset types can range from built-in types like Amazon S3 buckets and Amazon
     * Web Services Glue tables to custom types defined for specific organizational needs. Understanding asset types is
     * crucial for properly organizing and managing different kinds of data resources.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset type with identifier must exist in the domain. ResourceNotFoundException.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have the GetAssetType permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure the domain-identifier value is correct and accessible.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetTypeRequest
     * @return A Java Future containing the result of the GetAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetTypeResponse> getAssetType(GetAssetTypeRequest getAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     * <p>
     * Asset types define the categories and characteristics of different kinds of data assets within Amazon DataZone..
     * They determine what metadata fields are required, what operations are possible, and how the asset integrates with
     * other Amazon Web Services services. Asset types can range from built-in types like Amazon S3 buckets and Amazon
     * Web Services Glue tables to custom types defined for specific organizational needs. Understanding asset types is
     * crucial for properly organizing and managing different kinds of data resources.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset type with identifier must exist in the domain. ResourceNotFoundException.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have the GetAssetType permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * Ensure the domain-identifier value is correct and accessible.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetTypeRequest#builder()}
     * </p>
     *
     * @param getAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetTypeResponse> getAssetType(Consumer<GetAssetTypeRequest.Builder> getAssetTypeRequest) {
        return getAssetType(GetAssetTypeRequest.builder().applyMutation(getAssetTypeRequest).build());
    }

    /**
     * <p>
     * Gets a connection. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     *
     * @param getConnectionRequest
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a connection. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest) {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Gets the data product.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product ID must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have read or discovery permissions for the data product.
     * </p>
     * </li>
     * </ul>
     *
     * @param getDataProductRequest
     * @return A Java Future containing the result of the GetDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataProduct" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataProductResponse> getDataProduct(GetDataProductRequest getDataProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data product.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product ID must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have read or discovery permissions for the data product.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataProductRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataProductRequest#builder()}
     * </p>
     *
     * @param getDataProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataProductRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataProduct" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataProductResponse> getDataProduct(Consumer<GetDataProductRequest.Builder> getDataProductRequest) {
        return getDataProduct(GetDataProductRequest.builder().applyMutation(getDataProductRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     *
     * @param getDataSourceRunRequest
     * @return A Java Future containing the result of the GetDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceRunResponse> getDataSourceRun(GetDataSourceRunRequest getDataSourceRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRunRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataSourceRunRequest#builder()}
     * </p>
     *
     * @param getDataSourceRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceRunResponse> getDataSourceRun(
            Consumer<GetDataSourceRunRequest.Builder> getDataSourceRunRequest) {
        return getDataSourceRun(GetDataSourceRunRequest.builder().applyMutation(getDataSourceRunRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified domain unit.
     * </p>
     *
     * @param getDomainUnitRequest
     * @return A Java Future containing the result of the GetDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainUnitResponse> getDomainUnit(GetDomainUnitRequest getDomainUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainUnitRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainUnitRequest#builder()}
     * </p>
     *
     * @param getDomainUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDomainUnitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomainUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomainUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomainUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainUnitResponse> getDomainUnit(Consumer<GetDomainUnitRequest.Builder> getDomainUnitRequest) {
        return getDomainUnit(GetDomainUnitRequest.builder().applyMutation(getDomainUnitRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Gets the specified environment action.
     * </p>
     *
     * @param getEnvironmentActionRequest
     * @return A Java Future containing the result of the GetEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentActionResponse> getEnvironmentAction(
            GetEnvironmentActionRequest getEnvironmentActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified environment action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentActionRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentActionRequest#builder()}
     * </p>
     *
     * @param getEnvironmentActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentActionResponse> getEnvironmentAction(
            Consumer<GetEnvironmentActionRequest.Builder> getEnvironmentActionRequest) {
        return getEnvironmentAction(GetEnvironmentActionRequest.builder().applyMutation(getEnvironmentActionRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     * @return A Java Future containing the result of the GetEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintResponse> getEnvironmentBlueprint(
            GetEnvironmentBlueprintRequest getEnvironmentBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentBlueprintRequest.Builder} avoiding
     * the need to create one manually via {@link GetEnvironmentBlueprintRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintResponse> getEnvironmentBlueprint(
            Consumer<GetEnvironmentBlueprintRequest.Builder> getEnvironmentBlueprintRequest) {
        return getEnvironmentBlueprint(GetEnvironmentBlueprintRequest.builder().applyMutation(getEnvironmentBlueprintRequest)
                .build());
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     * @return A Java Future containing the result of the GetEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintConfigurationResponse> getEnvironmentBlueprintConfiguration(
            GetEnvironmentBlueprintConfigurationRequest getEnvironmentBlueprintConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintConfigurationResponse> getEnvironmentBlueprintConfiguration(
            Consumer<GetEnvironmentBlueprintConfigurationRequest.Builder> getEnvironmentBlueprintConfigurationRequest) {
        return getEnvironmentBlueprintConfiguration(GetEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(getEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the credentials of an environment in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentCredentialsRequest
     * @return A Java Future containing the result of the GetEnvironmentCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentCredentialsResponse> getEnvironmentCredentials(
            GetEnvironmentCredentialsRequest getEnvironmentCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the credentials of an environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link GetEnvironmentCredentialsRequest#builder()}
     * </p>
     *
     * @param getEnvironmentCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetEnvironmentCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentCredentialsResponse> getEnvironmentCredentials(
            Consumer<GetEnvironmentCredentialsRequest.Builder> getEnvironmentCredentialsRequest) {
        return getEnvironmentCredentials(GetEnvironmentCredentialsRequest.builder()
                .applyMutation(getEnvironmentCredentialsRequest).build());
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentProfileRequest
     * @return A Java Future containing the result of the GetEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentProfileResponse> getEnvironmentProfile(
            GetEnvironmentProfileRequest getEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param getEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentProfileResponse> getEnvironmentProfile(
            Consumer<GetEnvironmentProfileRequest.Builder> getEnvironmentProfileRequest) {
        return getEnvironmentProfile(GetEnvironmentProfileRequest.builder().applyMutation(getEnvironmentProfileRequest).build());
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     * <p>
     * Form types define the structure and validation rules for collecting metadata about assets in Amazon DataZone.
     * They act as templates that ensure consistent metadata capture across similar types of assets, while allowing for
     * customization to meet specific organizational needs. Form types can include required fields, validation rules,
     * and dependencies, helping maintain high-quality metadata that makes data assets more discoverable and usable.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type with the specified identifier must exist in the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permission on the form type.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type should not be deleted or in an invalid state.
     * </p>
     * </li>
     * </ul>
     *
     * @param getFormTypeRequest
     * @return A Java Future containing the result of the GetFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormTypeResponse> getFormType(GetFormTypeRequest getFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     * <p>
     * Form types define the structure and validation rules for collecting metadata about assets in Amazon DataZone.
     * They act as templates that ensure consistent metadata capture across similar types of assets, while allowing for
     * customization to meet specific organizational needs. Form types can include required fields, validation rules,
     * and dependencies, helping maintain high-quality metadata that makes data assets more discoverable and usable.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The form type with the specified identifier must exist in the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permission on the form type.
     * </p>
     * </li>
     * <li>
     * <p>
     * The form type should not be deleted or in an invalid state.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetFormTypeRequest#builder()}
     * </p>
     *
     * @param getFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormTypeResponse> getFormType(Consumer<GetFormTypeRequest.Builder> getFormTypeRequest) {
        return getFormType(GetFormTypeRequest.builder().applyMutation(getFormTypeRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The specified glossary ID must exist and be associated with the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The caller must have the <code>datazone:GetGlossary</code> permission on the domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param getGlossaryRequest
     * @return A Java Future containing the result of the GetGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryResponse> getGlossary(GetGlossaryRequest getGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The specified glossary ID must exist and be associated with the given domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * The caller must have the <code>datazone:GetGlossary</code> permission on the domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetGlossaryRequest#builder()}
     * </p>
     *
     * @param getGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryResponse> getGlossary(Consumer<GetGlossaryRequest.Builder> getGlossaryRequest) {
        return getGlossary(GetGlossaryRequest.builder().applyMutation(getGlossaryRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Glossary term with identifier must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permission on the glossary term.
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain must be accessible and active.
     * </p>
     * </li>
     * </ul>
     *
     * @param getGlossaryTermRequest
     * @return A Java Future containing the result of the GetGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryTermResponse> getGlossaryTerm(GetGlossaryTermRequest getGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Glossary term with identifier must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permission on the glossary term.
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain must be accessible and active.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryTermRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlossaryTermRequest#builder()}
     * </p>
     *
     * @param getGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryTermResponse> getGlossaryTerm(
            Consumer<GetGlossaryTermRequest.Builder> getGlossaryTermRequest) {
        return getGlossaryTerm(GetGlossaryTermRequest.builder().applyMutation(getGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     *
     * @param getGroupProfileRequest
     * @return A Java Future containing the result of the GetGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupProfileResponse> getGroupProfile(GetGroupProfileRequest getGroupProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetGroupProfileRequest#builder()}
     * </p>
     *
     * @param getGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupProfileResponse> getGroupProfile(
            Consumer<GetGroupProfileRequest.Builder> getGroupProfileRequest) {
        return getGroupProfile(GetGroupProfileRequest.builder().applyMutation(getGroupProfileRequest).build());
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     * @return A Java Future containing the result of the GetIamPortalLoginUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIamPortalLoginUrlResponse> getIamPortalLoginUrl(
            GetIamPortalLoginUrlRequest getIamPortalLoginUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIamPortalLoginUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetIamPortalLoginUrlRequest#builder()}
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIamPortalLoginUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIamPortalLoginUrlResponse> getIamPortalLoginUrl(
            Consumer<GetIamPortalLoginUrlRequest.Builder> getIamPortalLoginUrlRequest) {
        return getIamPortalLoginUrl(GetIamPortalLoginUrlRequest.builder().applyMutation(getIamPortalLoginUrlRequest).build());
    }

    /**
     * <p>
     * The details of the job run.
     * </p>
     *
     * @param getJobRunRequest
     * @return A Java Future containing the result of the GetJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunResponse> getJobRun(GetJobRunRequest getJobRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The details of the job run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunRequest#builder()}
     * </p>
     *
     * @param getJobRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetJobRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunResponse> getJobRun(Consumer<GetJobRunRequest.Builder> getJobRunRequest) {
        return getJobRun(GetJobRunRequest.builder().applyMutation(getJobRunRequest).build());
    }

    /**
     * <p>
     * Describes the lineage event.
     * </p>
     *
     * @param getLineageEventRequest
     * @return A Java Future containing the result of the GetLineageEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLineageEventResponse> getLineageEvent(GetLineageEventRequest getLineageEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the lineage event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLineageEventRequest.Builder} avoiding the need
     * to create one manually via {@link GetLineageEventRequest#builder()}
     * </p>
     *
     * @param getLineageEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetLineageEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLineageEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetLineageEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLineageEventResponse> getLineageEvent(
            Consumer<GetLineageEventRequest.Builder> getLineageEventRequest) {
        return getLineageEvent(GetLineageEventRequest.builder().applyMutation(getLineageEventRequest).build());
    }

    /**
     * <p>
     * Gets the data lineage node.
     * </p>
     *
     * @param getLineageNodeRequest
     * @return A Java Future containing the result of the GetLineageNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetLineageNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLineageNodeResponse> getLineageNode(GetLineageNodeRequest getLineageNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data lineage node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLineageNodeRequest.Builder} avoiding the need to
     * create one manually via {@link GetLineageNodeRequest#builder()}
     * </p>
     *
     * @param getLineageNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetLineageNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLineageNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetLineageNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLineageNodeResponse> getLineageNode(Consumer<GetLineageNodeRequest.Builder> getLineageNodeRequest) {
        return getLineageNode(GetLineageNodeRequest.builder().applyMutation(getLineageNodeRequest).build());
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time). If you specify a listing version, only details that are
     * specific to that version are returned.
     * </p>
     *
     * @param getListingRequest
     * @return A Java Future containing the result of the GetListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListingResponse> getListing(GetListingRequest getListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time). If you specify a listing version, only details that are
     * specific to that version are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetListingRequest.Builder} avoiding the need to
     * create one manually via {@link GetListingRequest#builder()}
     * </p>
     *
     * @param getListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetListingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListingResponse> getListing(Consumer<GetListingRequest.Builder> getListingRequest) {
        return getListing(GetListingRequest.builder().applyMutation(getListingRequest).build());
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid domain and run identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The metadata generation run must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have read access to the metadata run.
     * </p>
     * </li>
     * </ul>
     *
     * @param getMetadataGenerationRunRequest
     * @return A Java Future containing the result of the GetMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataGenerationRunResponse> getMetadataGenerationRun(
            GetMetadataGenerationRunRequest getMetadataGenerationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid domain and run identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The metadata generation run must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have read access to the metadata run.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataGenerationRunRequest.Builder} avoiding
     * the need to create one manually via {@link GetMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param getMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataGenerationRunResponse> getMetadataGenerationRun(
            Consumer<GetMetadataGenerationRunRequest.Builder> getMetadataGenerationRunRequest) {
        return getMetadataGenerationRun(GetMetadataGenerationRunRequest.builder().applyMutation(getMetadataGenerationRunRequest)
                .build());
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     *
     * @param getProjectRequest
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(GetProjectRequest getProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * The details of the project profile.
     * </p>
     *
     * @param getProjectProfileRequest
     * @return A Java Future containing the result of the GetProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProjectProfileResponse> getProjectProfile(GetProjectProfileRequest getProjectProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The details of the project profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetProjectProfileRequest#builder()}
     * </p>
     *
     * @param getProjectProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetProjectProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetProjectProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProjectProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProjectProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProjectProfileResponse> getProjectProfile(
            Consumer<GetProjectProfileRequest.Builder> getProjectProfileRequest) {
        return getProjectProfile(GetProjectProfileRequest.builder().applyMutation(getProjectProfileRequest).build());
    }

    /**
     * <p>
     * Gets the details of a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements
     * across user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects)
     * within the Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold
     * governance standards in data management processes. For instance, a metadata enforcement rule can specify the
     * required information for creating a subscription request or publishing a data asset to the catalog, ensuring
     * alignment with organizational standards.
     * </p>
     *
     * @param getRuleRequest
     * @return A Java Future containing the result of the GetRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleResponse> getRule(GetRuleRequest getRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a rule in Amazon DataZone. A rule is a formal agreement that enforces specific requirements
     * across user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects)
     * within the Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold
     * governance standards in data management processes. For instance, a metadata enforcement rule can specify the
     * required information for creating a subscription request or publishing a data asset to the catalog, ensuring
     * alignment with organizational standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRuleRequest#builder()}
     * </p>
     *
     * @param getRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleResponse> getRule(Consumer<GetRuleRequest.Builder> getRuleRequest) {
        return getRule(GetRuleRequest.builder().applyMutation(getRuleRequest).build());
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionRequest
     * @return A Java Future containing the result of the GetSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest getSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSubscriptionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSubscriptionResponse> getSubscription(
            Consumer<GetSubscriptionRequest.Builder> getSubscriptionRequest) {
        return getSubscription(GetSubscriptionRequest.builder().applyMutation(getSubscriptionRequest).build());
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionGrantRequest
     * @return A Java Future containing the result of the GetSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionGrantResponse> getSubscriptionGrant(
            GetSubscriptionGrantRequest getSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionGrantRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param getSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionGrantResponse> getSubscriptionGrant(
            Consumer<GetSubscriptionGrantRequest.Builder> getSubscriptionGrantRequest) {
        return getSubscriptionGrant(GetSubscriptionGrantRequest.builder().applyMutation(getSubscriptionGrantRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     * @return A Java Future containing the result of the GetSubscriptionRequestDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionRequestDetailsResponse> getSubscriptionRequestDetails(
            GetSubscriptionRequestDetailsRequest getSubscriptionRequestDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequestDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSubscriptionRequestDetailsRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSubscriptionRequestDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionRequestDetailsResponse> getSubscriptionRequestDetails(
            Consumer<GetSubscriptionRequestDetailsRequest.Builder> getSubscriptionRequestDetailsRequest) {
        return getSubscriptionRequestDetails(GetSubscriptionRequestDetailsRequest.builder()
                .applyMutation(getSubscriptionRequestDetailsRequest).build());
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionTargetRequest
     * @return A Java Future containing the result of the GetSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionTargetResponse> getSubscriptionTarget(
            GetSubscriptionTargetRequest getSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param getSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionTargetResponse> getSubscriptionTarget(
            Consumer<GetSubscriptionTargetRequest.Builder> getSubscriptionTargetRequest) {
        return getSubscriptionTarget(GetSubscriptionTargetRequest.builder().applyMutation(getSubscriptionTargetRequest).build());
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     * @return A Java Future containing the result of the GetTimeSeriesDataPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTimeSeriesDataPointResponse> getTimeSeriesDataPoint(
            GetTimeSeriesDataPointRequest getTimeSeriesDataPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimeSeriesDataPointRequest.Builder} avoiding the
     * need to create one manually via {@link GetTimeSeriesDataPointRequest#builder()}
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTimeSeriesDataPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTimeSeriesDataPointResponse> getTimeSeriesDataPoint(
            Consumer<GetTimeSeriesDataPointRequest.Builder> getTimeSeriesDataPointRequest) {
        return getTimeSeriesDataPoint(GetTimeSeriesDataPointRequest.builder().applyMutation(getTimeSeriesDataPointRequest)
                .build());
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     *
     * @param getUserProfileRequest
     * @return A Java Future containing the result of the GetUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserProfileResponse> getUserProfile(GetUserProfileRequest getUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserProfileRequest#builder()}
     * </p>
     *
     * @param getUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetUserProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserProfileResponse> getUserProfile(Consumer<GetUserProfileRequest.Builder> getUserProfileRequest) {
        return getUserProfile(GetUserProfileRequest.builder().applyMutation(getUserProfileRequest).build());
    }

    /**
     * <p>
     * Lists existing account pools.
     * </p>
     *
     * @param listAccountPoolsRequest
     * @return A Java Future containing the result of the ListAccountPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountPoolsResponse> listAccountPools(ListAccountPoolsRequest listAccountPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing account pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccountPoolsRequest#builder()}
     * </p>
     *
     * @param listAccountPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccountPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountPoolsResponse> listAccountPools(
            Consumer<ListAccountPoolsRequest.Builder> listAccountPoolsRequest) {
        return listAccountPools(ListAccountPoolsRequest.builder().applyMutation(listAccountPoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPools(software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountPoolsPublisher publisher = client.listAccountPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountPoolsPublisher publisher = client.listAccountPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPools(software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest)} operation.</b>
     * </p>
     *
     * @param listAccountPoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountPoolsPublisher listAccountPoolsPaginator(ListAccountPoolsRequest listAccountPoolsRequest) {
        return new ListAccountPoolsPublisher(this, listAccountPoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPools(software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountPoolsPublisher publisher = client.listAccountPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountPoolsPublisher publisher = client.listAccountPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPools(software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccountPoolsRequest#builder()}
     * </p>
     *
     * @param listAccountPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountPoolsPublisher listAccountPoolsPaginator(Consumer<ListAccountPoolsRequest.Builder> listAccountPoolsRequest) {
        return listAccountPoolsPaginator(ListAccountPoolsRequest.builder().applyMutation(listAccountPoolsRequest).build());
    }

    /**
     * <p>
     * Lists the accounts in the specified account pool.
     * </p>
     *
     * @param listAccountsInAccountPoolRequest
     * @return A Java Future containing the result of the ListAccountsInAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountsInAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountsInAccountPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsInAccountPoolResponse> listAccountsInAccountPool(
            ListAccountsInAccountPoolRequest listAccountsInAccountPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts in the specified account pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountsInAccountPoolRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountsInAccountPoolRequest#builder()}
     * </p>
     *
     * @param listAccountsInAccountPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAccountsInAccountPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountsInAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountsInAccountPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsInAccountPoolResponse> listAccountsInAccountPool(
            Consumer<ListAccountsInAccountPoolRequest.Builder> listAccountsInAccountPoolRequest) {
        return listAccountsInAccountPool(ListAccountsInAccountPoolRequest.builder()
                .applyMutation(listAccountsInAccountPoolRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountsInAccountPool(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountsInAccountPoolPublisher publisher = client.listAccountsInAccountPoolPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountsInAccountPoolPublisher publisher = client.listAccountsInAccountPoolPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsInAccountPool(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsInAccountPoolRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountsInAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountsInAccountPool"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsInAccountPoolPublisher listAccountsInAccountPoolPaginator(
            ListAccountsInAccountPoolRequest listAccountsInAccountPoolRequest) {
        return new ListAccountsInAccountPoolPublisher(this, listAccountsInAccountPoolRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountsInAccountPool(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountsInAccountPoolPublisher publisher = client.listAccountsInAccountPoolPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAccountsInAccountPoolPublisher publisher = client.listAccountsInAccountPoolPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsInAccountPool(software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountsInAccountPoolRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountsInAccountPoolRequest#builder()}
     * </p>
     *
     * @param listAccountsInAccountPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAccountsInAccountPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAccountsInAccountPool"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsInAccountPoolPublisher listAccountsInAccountPoolPaginator(
            Consumer<ListAccountsInAccountPoolRequest.Builder> listAccountsInAccountPoolRequest) {
        return listAccountsInAccountPoolPaginator(ListAccountsInAccountPoolRequest.builder()
                .applyMutation(listAccountsInAccountPoolRequest).build());
    }

    /**
     * <p>
     * Lists asset filters.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A valid domain and asset must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must have at least one filter created to return results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssetFiltersRequest
     * @return A Java Future containing the result of the ListAssetFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetFiltersResponse> listAssetFilters(ListAssetFiltersRequest listAssetFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists asset filters.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A valid domain and asset must exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The asset must have at least one filter created to return results.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetFiltersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetFiltersRequest#builder()}
     * </p>
     *
     * @param listAssetFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssetFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetFiltersResponse> listAssetFilters(
            Consumer<ListAssetFiltersRequest.Builder> listAssetFiltersRequest) {
        return listAssetFilters(ListAssetFiltersRequest.builder().applyMutation(listAssetFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersPublisher publisher = client.listAssetFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersPublisher publisher = client.listAssetFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listAssetFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersPublisher listAssetFiltersPaginator(ListAssetFiltersRequest listAssetFiltersRequest) {
        return new ListAssetFiltersPublisher(this, listAssetFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersPublisher publisher = client.listAssetFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetFiltersPublisher publisher = client.listAssetFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetFilters(software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetFiltersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetFiltersRequest#builder()}
     * </p>
     *
     * @param listAssetFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetFiltersPublisher listAssetFiltersPaginator(Consumer<ListAssetFiltersRequest.Builder> listAssetFiltersRequest) {
        return listAssetFiltersPaginator(ListAssetFiltersRequest.builder().applyMutation(listAssetFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be at least one revision of the asset (which happens automatically after creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permissions on the asset and domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssetRevisionsRequest
     * @return A Java Future containing the result of the ListAssetRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetRevisionsResponse> listAssetRevisions(ListAssetRevisionsRequest listAssetRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The asset must exist in the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be at least one revision of the asset (which happens automatically after creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be valid and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have permissions on the asset and domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssetRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetRevisionsResponse> listAssetRevisions(
            Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest) {
        return listAssetRevisions(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsPublisher listAssetRevisionsPaginator(ListAssetRevisionsRequest listAssetRevisionsRequest) {
        return new ListAssetRevisionsPublisher(this, listAssetRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsPublisher listAssetRevisionsPaginator(
            Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest) {
        return listAssetRevisionsPaginator(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists connections. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     *
     * @param listConnectionsRequest
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(ListConnectionsRequest listConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists connections. In Amazon DataZone, a connection enables you to connect your resources (domains, projects, and
     * environments) to external resources and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListConnectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(
            Consumer<ListConnectionsRequest.Builder> listConnectionsRequest) {
        return listConnections(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsPublisher listConnectionsPaginator(ListConnectionsRequest listConnectionsRequest) {
        return new ListConnectionsPublisher(this, listConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.datazone.model.ListConnectionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListConnectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectionsPublisher listConnectionsPaginator(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest) {
        return listConnectionsPaginator(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists data product revisions.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product ID must exist within the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have view permissions on the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be in a valid and accessible state.
     * </p>
     * </li>
     * </ul>
     *
     * @param listDataProductRevisionsRequest
     * @return A Java Future containing the result of the ListDataProductRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataProductRevisionsResponse> listDataProductRevisions(
            ListDataProductRevisionsRequest listDataProductRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data product revisions.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The data product ID must exist within the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have view permissions on the data product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain must be in a valid and accessible state.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProductRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProductRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataProductRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataProductRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataProductRevisionsResponse> listDataProductRevisions(
            Consumer<ListDataProductRevisionsRequest.Builder> listDataProductRevisionsRequest) {
        return listDataProductRevisions(ListDataProductRevisionsRequest.builder().applyMutation(listDataProductRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsPublisher publisher = client.listDataProductRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsPublisher publisher = client.listDataProductRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataProductRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsPublisher listDataProductRevisionsPaginator(
            ListDataProductRevisionsRequest listDataProductRevisionsRequest) {
        return new ListDataProductRevisionsPublisher(this, listDataProductRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsPublisher publisher = client.listDataProductRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataProductRevisionsPublisher publisher = client.listDataProductRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProductRevisions(software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProductRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProductRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataProductRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataProductRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataProductRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProductRevisionsPublisher listDataProductRevisionsPaginator(
            Consumer<ListDataProductRevisionsRequest.Builder> listDataProductRevisionsRequest) {
        return listDataProductRevisionsPaginator(ListDataProductRevisionsRequest.builder()
                .applyMutation(listDataProductRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return A Java Future containing the result of the ListDataSourceRunActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunActivitiesResponse> listDataSourceRunActivities(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDataSourceRunActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunActivitiesResponse> listDataSourceRunActivities(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest) {
        return listDataSourceRunActivities(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesPublisher listDataSourceRunActivitiesPaginator(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) {
        return new ListDataSourceRunActivitiesPublisher(this, listDataSourceRunActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesPublisher listDataSourceRunActivitiesPaginator(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest) {
        return listDataSourceRunActivitiesPaginator(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return A Java Future containing the result of the ListDataSourceRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunsResponse> listDataSourceRuns(ListDataSourceRunsRequest listDataSourceRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSourceRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunsResponse> listDataSourceRuns(
            Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest) {
        return listDataSourceRuns(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsPublisher listDataSourceRunsPaginator(ListDataSourceRunsRequest listDataSourceRunsRequest) {
        return new ListDataSourceRunsPublisher(this, listDataSourceRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsPublisher listDataSourceRunsPaginator(
            Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest) {
        return listDataSourceRunsPaginator(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        return new ListDataSourcesPublisher(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists child domain units for the specified parent domain unit.
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     * @return A Java Future containing the result of the ListDomainUnitsForParent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainUnitsForParentResponse> listDomainUnitsForParent(
            ListDomainUnitsForParentRequest listDomainUnitsForParentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists child domain units for the specified parent domain unit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainUnitsForParentRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainUnitsForParentRequest#builder()}
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDomainUnitsForParent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainUnitsForParentResponse> listDomainUnitsForParent(
            Consumer<ListDomainUnitsForParentRequest.Builder> listDomainUnitsForParentRequest) {
        return listDomainUnitsForParent(ListDomainUnitsForParentRequest.builder().applyMutation(listDomainUnitsForParentRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentPublisher publisher = client.listDomainUnitsForParentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentPublisher publisher = client.listDomainUnitsForParentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentPublisher listDomainUnitsForParentPaginator(
            ListDomainUnitsForParentRequest listDomainUnitsForParentRequest) {
        return new ListDomainUnitsForParentPublisher(this, listDomainUnitsForParentRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentPublisher publisher = client.listDomainUnitsForParentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainUnitsForParentPublisher publisher = client.listDomainUnitsForParentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainUnitsForParent(software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainUnitsForParentRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainUnitsForParentRequest#builder()}
     * </p>
     *
     * @param listDomainUnitsForParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainUnitsForParentRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomainUnitsForParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomainUnitsForParent"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainUnitsForParentPublisher listDomainUnitsForParentPaginator(
            Consumer<ListDomainUnitsForParentRequest.Builder> listDomainUnitsForParentRequest) {
        return listDomainUnitsForParentPaginator(ListDomainUnitsForParentRequest.builder()
                .applyMutation(listDomainUnitsForParentRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, listDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the entity (domain units) owners.
     * </p>
     *
     * @param listEntityOwnersRequest
     * @return A Java Future containing the result of the ListEntityOwners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntityOwnersResponse> listEntityOwners(ListEntityOwnersRequest listEntityOwnersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the entity (domain units) owners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityOwnersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntityOwnersRequest#builder()}
     * </p>
     *
     * @param listEntityOwnersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntityOwners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntityOwnersResponse> listEntityOwners(
            Consumer<ListEntityOwnersRequest.Builder> listEntityOwnersRequest) {
        return listEntityOwners(ListEntityOwnersRequest.builder().applyMutation(listEntityOwnersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersPublisher publisher = client.listEntityOwnersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersPublisher publisher = client.listEntityOwnersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation.</b>
     * </p>
     *
     * @param listEntityOwnersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersPublisher listEntityOwnersPaginator(ListEntityOwnersRequest listEntityOwnersRequest) {
        return new ListEntityOwnersPublisher(this, listEntityOwnersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersPublisher publisher = client.listEntityOwnersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEntityOwnersPublisher publisher = client.listEntityOwnersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityOwners(software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntityOwnersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntityOwnersRequest#builder()}
     * </p>
     *
     * @param listEntityOwnersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEntityOwners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEntityOwners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntityOwnersPublisher listEntityOwnersPaginator(Consumer<ListEntityOwnersRequest.Builder> listEntityOwnersRequest) {
        return listEntityOwnersPaginator(ListEntityOwnersRequest.builder().applyMutation(listEntityOwnersRequest).build());
    }

    /**
     * <p>
     * Lists existing environment actions.
     * </p>
     *
     * @param listEnvironmentActionsRequest
     * @return A Java Future containing the result of the ListEnvironmentActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentActionsResponse> listEnvironmentActions(
            ListEnvironmentActionsRequest listEnvironmentActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing environment actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentActionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironmentActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentActionsResponse> listEnvironmentActions(
            Consumer<ListEnvironmentActionsRequest.Builder> listEnvironmentActionsRequest) {
        return listEnvironmentActions(ListEnvironmentActionsRequest.builder().applyMutation(listEnvironmentActionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsPublisher publisher = client.listEnvironmentActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsPublisher publisher = client.listEnvironmentActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsPublisher listEnvironmentActionsPaginator(
            ListEnvironmentActionsRequest listEnvironmentActionsRequest) {
        return new ListEnvironmentActionsPublisher(this, listEnvironmentActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsPublisher publisher = client.listEnvironmentActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentActionsPublisher publisher = client.listEnvironmentActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentActions(software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnvironmentActionsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentActionsPublisher listEnvironmentActionsPaginator(
            Consumer<ListEnvironmentActionsRequest.Builder> listEnvironmentActionsRequest) {
        return listEnvironmentActionsPaginator(ListEnvironmentActionsRequest.builder()
                .applyMutation(listEnvironmentActionsRequest).build());
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return A Java Future containing the result of the ListEnvironmentBlueprintConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintConfigurationsResponse> listEnvironmentBlueprintConfigurations(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListEnvironmentBlueprintConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintConfigurationsResponse> listEnvironmentBlueprintConfigurations(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest) {
        return listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsPublisher listEnvironmentBlueprintConfigurationsPaginator(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest) {
        return new ListEnvironmentBlueprintConfigurationsPublisher(this, listEnvironmentBlueprintConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsPublisher listEnvironmentBlueprintConfigurationsPaginator(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest) {
        return listEnvironmentBlueprintConfigurationsPaginator(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return A Java Future containing the result of the ListEnvironmentBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintsResponse> listEnvironmentBlueprints(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListEnvironmentBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintsResponse> listEnvironmentBlueprints(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) {
        return listEnvironmentBlueprints(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsPublisher listEnvironmentBlueprintsPaginator(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) {
        return new ListEnvironmentBlueprintsPublisher(this, listEnvironmentBlueprintsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsPublisher listEnvironmentBlueprintsPaginator(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) {
        return listEnvironmentBlueprintsPaginator(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return A Java Future containing the result of the ListEnvironmentProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProfilesResponse> listEnvironmentProfiles(
            ListEnvironmentProfilesRequest listEnvironmentProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironmentProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProfilesResponse> listEnvironmentProfiles(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) {
        return listEnvironmentProfiles(ListEnvironmentProfilesRequest.builder().applyMutation(listEnvironmentProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesPublisher listEnvironmentProfilesPaginator(
            ListEnvironmentProfilesRequest listEnvironmentProfilesRequest) {
        return new ListEnvironmentProfilesPublisher(this, listEnvironmentProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesPublisher listEnvironmentProfilesPaginator(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) {
        return listEnvironmentProfilesPaginator(ListEnvironmentProfilesRequest.builder()
                .applyMutation(listEnvironmentProfilesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        return new ListEnvironmentsPublisher(this, listEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists job runs.
     * </p>
     *
     * @param listJobRunsRequest
     * @return A Java Future containing the result of the ListJobRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobRunsResponse> listJobRuns(ListJobRunsRequest listJobRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists job runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListJobRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJobRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobRunsResponse> listJobRuns(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest) {
        return listJobRuns(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsPublisher publisher = client.listJobRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsPublisher publisher = client.listJobRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListJobRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListJobRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param listJobRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsPublisher listJobRunsPaginator(ListJobRunsRequest listJobRunsRequest) {
        return new ListJobRunsPublisher(this, listJobRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsPublisher publisher = client.listJobRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListJobRunsPublisher publisher = client.listJobRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListJobRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListJobRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobRuns(software.amazon.awssdk.services.datazone.model.ListJobRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobRunsRequest#builder()}
     * </p>
     *
     * @param listJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListJobRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobRunsPublisher listJobRunsPaginator(Consumer<ListJobRunsRequest.Builder> listJobRunsRequest) {
        return listJobRunsPaginator(ListJobRunsRequest.builder().applyMutation(listJobRunsRequest).build());
    }

    /**
     * <p>
     * Lists lineage events.
     * </p>
     *
     * @param listLineageEventsRequest
     * @return A Java Future containing the result of the ListLineageEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLineageEventsResponse> listLineageEvents(ListLineageEventsRequest listLineageEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists lineage events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLineageEventsRequest#builder()}
     * </p>
     *
     * @param listLineageEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLineageEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLineageEventsResponse> listLineageEvents(
            Consumer<ListLineageEventsRequest.Builder> listLineageEventsRequest) {
        return listLineageEvents(ListLineageEventsRequest.builder().applyMutation(listLineageEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsPublisher publisher = client.listLineageEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsPublisher publisher = client.listLineageEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsPublisher listLineageEventsPaginator(ListLineageEventsRequest listLineageEventsRequest) {
        return new ListLineageEventsPublisher(this, listLineageEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsPublisher publisher = client.listLineageEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageEventsPublisher publisher = client.listLineageEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageEvents(software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLineageEventsRequest#builder()}
     * </p>
     *
     * @param listLineageEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLineageEventsPublisher listLineageEventsPaginator(
            Consumer<ListLineageEventsRequest.Builder> listLineageEventsRequest) {
        return listLineageEventsPaginator(ListLineageEventsRequest.builder().applyMutation(listLineageEventsRequest).build());
    }

    /**
     * <p>
     * Lists the history of the specified data lineage node.
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     * @return A Java Future containing the result of the ListLineageNodeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLineageNodeHistoryResponse> listLineageNodeHistory(
            ListLineageNodeHistoryRequest listLineageNodeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of the specified data lineage node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageNodeHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLineageNodeHistoryRequest#builder()}
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLineageNodeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLineageNodeHistoryResponse> listLineageNodeHistory(
            Consumer<ListLineageNodeHistoryRequest.Builder> listLineageNodeHistoryRequest) {
        return listLineageNodeHistory(ListLineageNodeHistoryRequest.builder().applyMutation(listLineageNodeHistoryRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryPublisher publisher = client.listLineageNodeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryPublisher publisher = client.listLineageNodeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryPublisher listLineageNodeHistoryPaginator(
            ListLineageNodeHistoryRequest listLineageNodeHistoryRequest) {
        return new ListLineageNodeHistoryPublisher(this, listLineageNodeHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryPublisher publisher = client.listLineageNodeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListLineageNodeHistoryPublisher publisher = client.listLineageNodeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLineageNodeHistory(software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLineageNodeHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLineageNodeHistoryRequest#builder()}
     * </p>
     *
     * @param listLineageNodeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListLineageNodeHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLineageNodeHistoryPublisher listLineageNodeHistoryPaginator(
            Consumer<ListLineageNodeHistoryRequest.Builder> listLineageNodeHistoryRequest) {
        return listLineageNodeHistoryPaginator(ListLineageNodeHistoryRequest.builder()
                .applyMutation(listLineageNodeHistoryRequest).build());
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     * <p>
     * Metadata generation runs represent automated processes that leverage AI/ML capabilities to create or enhance
     * asset metadata at scale. This feature helps organizations maintain comprehensive and consistent metadata across
     * large numbers of assets without manual intervention. It can automatically generate business descriptions, tags,
     * and other metadata elements, significantly reducing the time and effort required for metadata management while
     * improving consistency and completeness.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid domain identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have access to metadata generation runs in the domain.
     * </p>
     * </li>
     * </ul>
     *
     * @param listMetadataGenerationRunsRequest
     * @return A Java Future containing the result of the ListMetadataGenerationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataGenerationRunsResponse> listMetadataGenerationRuns(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     * <p>
     * Metadata generation runs represent automated processes that leverage AI/ML capabilities to create or enhance
     * asset metadata at scale. This feature helps organizations maintain comprehensive and consistent metadata across
     * large numbers of assets without manual intervention. It can automatically generate business descriptions, tags,
     * and other metadata elements, significantly reducing the time and effort required for metadata management while
     * improving consistency and completeness.
     * </p>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid domain identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * User must have access to metadata generation runs in the domain.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMetadataGenerationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataGenerationRunsResponse> listMetadataGenerationRuns(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest) {
        return listMetadataGenerationRuns(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsPublisher listMetadataGenerationRunsPaginator(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) {
        return new ListMetadataGenerationRunsPublisher(this, listMetadataGenerationRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsPublisher listMetadataGenerationRunsPaginator(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest) {
        return listMetadataGenerationRunsPaginator(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(ListNotificationsRequest listNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) {
        return new ListNotificationsPublisher(this, listNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Lists policy grants.
     * </p>
     *
     * @param listPolicyGrantsRequest
     * @return A Java Future containing the result of the ListPolicyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyGrantsResponse> listPolicyGrants(ListPolicyGrantsRequest listPolicyGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists policy grants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGrantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPolicyGrantsRequest#builder()}
     * </p>
     *
     * @param listPolicyGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPolicyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyGrantsResponse> listPolicyGrants(
            Consumer<ListPolicyGrantsRequest.Builder> listPolicyGrantsRequest) {
        return listPolicyGrants(ListPolicyGrantsRequest.builder().applyMutation(listPolicyGrantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsPublisher publisher = client.listPolicyGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsPublisher publisher = client.listPolicyGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyGrantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsPublisher listPolicyGrantsPaginator(ListPolicyGrantsRequest listPolicyGrantsRequest) {
        return new ListPolicyGrantsPublisher(this, listPolicyGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsPublisher publisher = client.listPolicyGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListPolicyGrantsPublisher publisher = client.listPolicyGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGrants(software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGrantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPolicyGrantsRequest#builder()}
     * </p>
     *
     * @param listPolicyGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListPolicyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListPolicyGrants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyGrantsPublisher listPolicyGrantsPaginator(Consumer<ListPolicyGrantsRequest.Builder> listPolicyGrantsRequest) {
        return listPolicyGrantsPaginator(ListPolicyGrantsRequest.builder().applyMutation(listPolicyGrantsRequest).build());
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return A Java Future containing the result of the ListProjectMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProjectMembershipsResponse> listProjectMemberships(
            ListProjectMembershipsRequest listProjectMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProjectMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProjectMembershipsResponse> listProjectMemberships(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) {
        return listProjectMemberships(ListProjectMembershipsRequest.builder().applyMutation(listProjectMembershipsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsPublisher listProjectMembershipsPaginator(
            ListProjectMembershipsRequest listProjectMembershipsRequest) {
        return new ListProjectMembershipsPublisher(this, listProjectMembershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsPublisher listProjectMembershipsPaginator(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) {
        return listProjectMembershipsPaginator(ListProjectMembershipsRequest.builder()
                .applyMutation(listProjectMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists project profiles.
     * </p>
     *
     * @param listProjectProfilesRequest
     * @return A Java Future containing the result of the ListProjectProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProjectProfilesResponse> listProjectProfiles(
            ListProjectProfilesRequest listProjectProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists project profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectProfilesRequest#builder()}
     * </p>
     *
     * @param listProjectProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProjectProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProjectProfilesResponse> listProjectProfiles(
            Consumer<ListProjectProfilesRequest.Builder> listProjectProfilesRequest) {
        return listProjectProfiles(ListProjectProfilesRequest.builder().applyMutation(listProjectProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesPublisher publisher = client.listProjectProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesPublisher publisher = client.listProjectProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesPublisher listProjectProfilesPaginator(ListProjectProfilesRequest listProjectProfilesRequest) {
        return new ListProjectProfilesPublisher(this, listProjectProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesPublisher publisher = client.listProjectProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectProfilesPublisher publisher = client.listProjectProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectProfiles(software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectProfilesRequest#builder()}
     * </p>
     *
     * @param listProjectProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectProfilesPublisher listProjectProfilesPaginator(
            Consumer<ListProjectProfilesRequest.Builder> listProjectProfilesRequest) {
        return listProjectProfilesPaginator(ListProjectProfilesRequest.builder().applyMutation(listProjectProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists existing rules. In Amazon DataZone, a rule is a formal agreement that enforces specific requirements across
     * user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the
     * Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance
     * standards in data management processes. For instance, a metadata enforcement rule can specify the required
     * information for creating a subscription request or publishing a data asset to the catalog, ensuring alignment
     * with organizational standards.
     * </p>
     *
     * @param listRulesRequest
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(ListRulesRequest listRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing rules. In Amazon DataZone, a rule is a formal agreement that enforces specific requirements across
     * user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the
     * Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance
     * standards in data management processes. For instance, a metadata enforcement rule can specify the required
     * information for creating a subscription request or publishing a data asset to the catalog, ensuring alignment
     * with organizational standards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)} operation.</b>
     * </p>
     *
     * @param listRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(ListRulesRequest listRulesRequest) {
        return new ListRulesPublisher(this, listRulesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.datazone.model.ListRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRulesPaginator(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return A Java Future containing the result of the ListSubscriptionGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionGrantsResponse> listSubscriptionGrants(
            ListSubscriptionGrantsRequest listSubscriptionGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptionGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionGrantsResponse> listSubscriptionGrants(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) {
        return listSubscriptionGrants(ListSubscriptionGrantsRequest.builder().applyMutation(listSubscriptionGrantsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsPublisher listSubscriptionGrantsPaginator(
            ListSubscriptionGrantsRequest listSubscriptionGrantsRequest) {
        return new ListSubscriptionGrantsPublisher(this, listSubscriptionGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsPublisher listSubscriptionGrantsPaginator(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) {
        return listSubscriptionGrantsPaginator(ListSubscriptionGrantsRequest.builder()
                .applyMutation(listSubscriptionGrantsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return A Java Future containing the result of the ListSubscriptionRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionRequestsResponse> listSubscriptionRequests(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptionRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionRequestsResponse> listSubscriptionRequests(
            Consumer<ListSubscriptionRequestsRequest.Builder> listSubscriptionRequestsRequest) {
        return listSubscriptionRequests(ListSubscriptionRequestsRequest.builder().applyMutation(listSubscriptionRequestsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsPublisher listSubscriptionRequestsPaginator(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) {
        return new ListSubscriptionRequestsPublisher(this, listSubscriptionRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service e