/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The account information within an account pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountInfo implements SdkPojo, Serializable, ToCopyableBuilder<AccountInfo.Builder, AccountInfo> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(AccountInfo::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountName").getter(getter(AccountInfo::awsAccountName)).setter(setter(Builder::awsAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountName").build()).build();

    private static final SdkField<List<String>> SUPPORTED_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedRegions")
            .getter(getter(AccountInfo::supportedRegions))
            .setter(setter(Builder::supportedRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_NAME_FIELD, SUPPORTED_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsAccountName;

    private final List<String> supportedRegions;

    private AccountInfo(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountName = builder.awsAccountName;
        this.supportedRegions = builder.supportedRegions;
    }

    /**
     * <p>
     * The account ID.
     * </p>
     * 
     * @return The account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The account name.
     * </p>
     * 
     * @return The account name.
     */
    public final String awsAccountName() {
        return awsAccountName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedRegions() {
        return supportedRegions != null && !(supportedRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regions supported for an account within an account pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedRegions} method.
     * </p>
     * 
     * @return The regions supported for an account within an account pool.
     */
    public final List<String> supportedRegions() {
        return supportedRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedRegions() ? supportedRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountInfo)) {
            return false;
        }
        AccountInfo other = (AccountInfo) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsAccountName(), other.awsAccountName())
                && hasSupportedRegions() == other.hasSupportedRegions()
                && Objects.equals(supportedRegions(), other.supportedRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountInfo").add("AwsAccountId", awsAccountId())
                .add("AwsAccountName", awsAccountName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SupportedRegions", hasSupportedRegions() ? supportedRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountName":
            return Optional.ofNullable(clazz.cast(awsAccountName()));
        case "supportedRegions":
            return Optional.ofNullable(clazz.cast(supportedRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountName", AWS_ACCOUNT_NAME_FIELD);
        map.put("supportedRegions", SUPPORTED_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountInfo, T> g) {
        return obj -> g.apply((AccountInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountInfo> {
        /**
         * <p>
         * The account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The account name.
         * </p>
         * 
         * @param awsAccountName
         *        The account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountName(String awsAccountName);

        /**
         * <p>
         * The regions supported for an account within an account pool.
         * </p>
         * 
         * @param supportedRegions
         *        The regions supported for an account within an account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRegions(Collection<String> supportedRegions);

        /**
         * <p>
         * The regions supported for an account within an account pool.
         * </p>
         * 
         * @param supportedRegions
         *        The regions supported for an account within an account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRegions(String... supportedRegions);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountName;

        private List<String> supportedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountInfo model) {
            awsAccountId(model.awsAccountId);
            awsAccountName(model.awsAccountName);
            supportedRegions(model.supportedRegions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountName() {
            return awsAccountName;
        }

        public final void setAwsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
        }

        @Override
        public final Builder awsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
            return this;
        }

        public final Collection<String> getSupportedRegions() {
            if (supportedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedRegions;
        }

        public final void setSupportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = AwsRegionListCopier.copy(supportedRegions);
        }

        @Override
        public final Builder supportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = AwsRegionListCopier.copy(supportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRegions(String... supportedRegions) {
            supportedRegions(Arrays.asList(supportedRegions));
            return this;
        }

        @Override
        public AccountInfo build() {
            return new AccountInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
