/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateGovernedTermsRequest extends DataZoneRequest implements
        ToCopyableBuilder<AssociateGovernedTermsRequest.Builder, AssociateGovernedTermsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(AssociateGovernedTermsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(AssociateGovernedTermsRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(AssociateGovernedTermsRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<List<String>> GOVERNED_GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("governedGlossaryTerms")
            .getter(getter(AssociateGovernedTermsRequest::governedGlossaryTerms))
            .setter(setter(Builder::governedGlossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("governedGlossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, GOVERNED_GLOSSARY_TERMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final List<String> governedGlossaryTerms;

    private AssociateGovernedTermsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.governedGlossaryTerms = builder.governedGlossaryTerms;
    }

    /**
     * <p>
     * The ID of the domain where governed terms are to be associated with an asset.
     * </p>
     * 
     * @return The ID of the domain where governed terms are to be associated with an asset.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the asset with which you want to associate a governed term.
     * </p>
     * 
     * @return The ID of the asset with which you want to associate a governed term.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the asset with which you want to associate a governed term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link GovernedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset with which you want to associate a governed term.
     * @see GovernedEntityType
     */
    public final GovernedEntityType entityType() {
        return GovernedEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset with which you want to associate a governed term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link GovernedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset with which you want to associate a governed term.
     * @see GovernedEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the GovernedGlossaryTerms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGovernedGlossaryTerms() {
        return governedGlossaryTerms != null && !(governedGlossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms in a restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGovernedGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms in a restricted glossary.
     */
    public final List<String> governedGlossaryTerms() {
        return governedGlossaryTerms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGovernedGlossaryTerms() ? governedGlossaryTerms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateGovernedTermsRequest)) {
            return false;
        }
        AssociateGovernedTermsRequest other = (AssociateGovernedTermsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && hasGovernedGlossaryTerms() == other.hasGovernedGlossaryTerms()
                && Objects.equals(governedGlossaryTerms(), other.governedGlossaryTerms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateGovernedTermsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EntityIdentifier", entityIdentifier()).add("EntityType", entityTypeAsString())
                .add("GovernedGlossaryTerms", hasGovernedGlossaryTerms() ? governedGlossaryTerms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "governedGlossaryTerms":
            return Optional.ofNullable(clazz.cast(governedGlossaryTerms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("governedGlossaryTerms", GOVERNED_GLOSSARY_TERMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateGovernedTermsRequest, T> g) {
        return obj -> g.apply((AssociateGovernedTermsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateGovernedTermsRequest> {
        /**
         * <p>
         * The ID of the domain where governed terms are to be associated with an asset.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where governed terms are to be associated with an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the asset with which you want to associate a governed term.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the asset with which you want to associate a governed term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the asset with which you want to associate a governed term.
         * </p>
         * 
         * @param entityType
         *        The type of the asset with which you want to associate a governed term.
         * @see GovernedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GovernedEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset with which you want to associate a governed term.
         * </p>
         * 
         * @param entityType
         *        The type of the asset with which you want to associate a governed term.
         * @see GovernedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GovernedEntityType
         */
        Builder entityType(GovernedEntityType entityType);

        /**
         * <p>
         * The glossary terms in a restricted glossary.
         * </p>
         * 
         * @param governedGlossaryTerms
         *        The glossary terms in a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedGlossaryTerms(Collection<String> governedGlossaryTerms);

        /**
         * <p>
         * The glossary terms in a restricted glossary.
         * </p>
         * 
         * @param governedGlossaryTerms
         *        The glossary terms in a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedGlossaryTerms(String... governedGlossaryTerms);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private List<String> governedGlossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateGovernedTermsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            governedGlossaryTerms(model.governedGlossaryTerms);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(GovernedEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final Collection<String> getGovernedGlossaryTerms() {
            if (governedGlossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return governedGlossaryTerms;
        }

        public final void setGovernedGlossaryTerms(Collection<String> governedGlossaryTerms) {
            this.governedGlossaryTerms = AssociateGovernedTermsInputGovernedGlossaryTermsListCopier.copy(governedGlossaryTerms);
        }

        @Override
        public final Builder governedGlossaryTerms(Collection<String> governedGlossaryTerms) {
            this.governedGlossaryTerms = AssociateGovernedTermsInputGovernedGlossaryTermsListCopier.copy(governedGlossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder governedGlossaryTerms(String... governedGlossaryTerms) {
            governedGlossaryTerms(Arrays.asList(governedGlossaryTerms));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateGovernedTermsRequest build() {
            return new AssociateGovernedTermsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
