/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a Amazon DataZone domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSummary implements SdkPojo, Serializable, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DomainSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DomainSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DomainSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVersion").getter(getter(DomainSummary::domainVersionAsString))
            .setter(setter(Builder::domainVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DomainSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DomainSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> MANAGED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedAccountId").getter(getter(DomainSummary::managedAccountId))
            .setter(setter(Builder::managedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedAccountId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DomainSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PORTAL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalUrl").getter(getter(DomainSummary::portalUrl)).setter(setter(Builder::portalUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalUrl").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DomainSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, DOMAIN_VERSION_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, MANAGED_ACCOUNT_ID_FIELD, NAME_FIELD,
            PORTAL_URL_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String domainVersion;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String managedAccountId;

    private final String name;

    private final String portalUrl;

    private final String status;

    private DomainSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainVersion = builder.domainVersion;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.managedAccountId = builder.managedAccountId;
        this.name = builder.name;
        this.portalUrl = builder.portalUrl;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the Amazon DataZone domain.
     * </p>
     * 
     * @return The ARN of the Amazon DataZone domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A timestamp of when a Amazon DataZone domain was created.
     * </p>
     * 
     * @return A timestamp of when a Amazon DataZone domain was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of an Amazon DataZone domain.
     * </p>
     * 
     * @return A description of an Amazon DataZone domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainVersion}
     * will return {@link DomainVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainVersionAsString}.
     * </p>
     * 
     * @return The domain version.
     * @see DomainVersion
     */
    public final DomainVersion domainVersion() {
        return DomainVersion.fromValue(domainVersion);
    }

    /**
     * <p>
     * The domain version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainVersion}
     * will return {@link DomainVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainVersionAsString}.
     * </p>
     * 
     * @return The domain version.
     * @see DomainVersion
     */
    public final String domainVersionAsString() {
        return domainVersion;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A timestamp of when a Amazon DataZone domain was last updated.
     * </p>
     * 
     * @return A timestamp of when a Amazon DataZone domain was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that manages the domain.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that manages the domain.
     */
    public final String managedAccountId() {
        return managedAccountId;
    }

    /**
     * <p>
     * A name of an Amazon DataZone domain.
     * </p>
     * 
     * @return A name of an Amazon DataZone domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data portal URL for the Amazon DataZone domain.
     * </p>
     * 
     * @return The data portal URL for the Amazon DataZone domain.
     */
    public final String portalUrl() {
        return portalUrl;
    }

    /**
     * <p>
     * The status of the Amazon DataZone domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon DataZone domain.
     * @see DomainStatus
     */
    public final DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon DataZone domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon DataZone domain.
     * @see DomainStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(portalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description())
                && Objects.equals(domainVersionAsString(), other.domainVersionAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(managedAccountId(), other.managedAccountId()) && Objects.equals(name(), other.name())
                && Objects.equals(portalUrl(), other.portalUrl()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainVersion", domainVersionAsString()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ManagedAccountId", managedAccountId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("PortalUrl", portalUrl())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainVersion":
            return Optional.ofNullable(clazz.cast(domainVersionAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "managedAccountId":
            return Optional.ofNullable(clazz.cast(managedAccountId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "portalUrl":
            return Optional.ofNullable(clazz.cast(portalUrl()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainVersion", DOMAIN_VERSION_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("managedAccountId", MANAGED_ACCOUNT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("portalUrl", PORTAL_URL_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The ARN of the Amazon DataZone domain.
         * </p>
         * 
         * @param arn
         *        The ARN of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A timestamp of when a Amazon DataZone domain was created.
         * </p>
         * 
         * @param createdAt
         *        A timestamp of when a Amazon DataZone domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of an Amazon DataZone domain.
         * </p>
         * 
         * @param description
         *        A description of an Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain version.
         * </p>
         * 
         * @param domainVersion
         *        The domain version.
         * @see DomainVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainVersion
         */
        Builder domainVersion(String domainVersion);

        /**
         * <p>
         * The domain version.
         * </p>
         * 
         * @param domainVersion
         *        The domain version.
         * @see DomainVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainVersion
         */
        Builder domainVersion(DomainVersion domainVersion);

        /**
         * <p>
         * The ID of the Amazon DataZone domain.
         * </p>
         * 
         * @param id
         *        The ID of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A timestamp of when a Amazon DataZone domain was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp of when a Amazon DataZone domain was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The identifier of the Amazon Web Services account that manages the domain.
         * </p>
         * 
         * @param managedAccountId
         *        The identifier of the Amazon Web Services account that manages the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedAccountId(String managedAccountId);

        /**
         * <p>
         * A name of an Amazon DataZone domain.
         * </p>
         * 
         * @param name
         *        A name of an Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data portal URL for the Amazon DataZone domain.
         * </p>
         * 
         * @param portalUrl
         *        The data portal URL for the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalUrl(String portalUrl);

        /**
         * <p>
         * The status of the Amazon DataZone domain.
         * </p>
         * 
         * @param status
         *        The status of the Amazon DataZone domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon DataZone domain.
         * </p>
         * 
         * @param status
         *        The status of the Amazon DataZone domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String domainVersion;

        private String id;

        private Instant lastUpdatedAt;

        private String managedAccountId;

        private String name;

        private String portalUrl;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            domainVersion(model.domainVersion);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            managedAccountId(model.managedAccountId);
            name(model.name);
            portalUrl(model.portalUrl);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainVersion() {
            return domainVersion;
        }

        public final void setDomainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
        }

        @Override
        public final Builder domainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
            return this;
        }

        @Override
        public final Builder domainVersion(DomainVersion domainVersion) {
            this.domainVersion(domainVersion == null ? null : domainVersion.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getManagedAccountId() {
            return managedAccountId;
        }

        public final void setManagedAccountId(String managedAccountId) {
            this.managedAccountId = managedAccountId;
        }

        @Override
        public final Builder managedAccountId(String managedAccountId) {
            this.managedAccountId = managedAccountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPortalUrl() {
            return portalUrl;
        }

        public final void setPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
        }

        @Override
        public final Builder portalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
