/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The domain unit principal to whom the policy is granted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainUnitPolicyGrantPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainUnitPolicyGrantPrincipal.Builder, DomainUnitPolicyGrantPrincipal> {
    private static final SdkField<String> DOMAIN_UNIT_DESIGNATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitDesignation").getter(getter(DomainUnitPolicyGrantPrincipal::domainUnitDesignationAsString))
            .setter(setter(Builder::domainUnitDesignation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitDesignation").build())
            .build();

    private static final SdkField<DomainUnitGrantFilter> DOMAIN_UNIT_GRANT_FILTER_FIELD = SdkField
            .<DomainUnitGrantFilter> builder(MarshallingType.SDK_POJO).memberName("domainUnitGrantFilter")
            .getter(getter(DomainUnitPolicyGrantPrincipal::domainUnitGrantFilter)).setter(setter(Builder::domainUnitGrantFilter))
            .constructor(DomainUnitGrantFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitGrantFilter").build())
            .build();

    private static final SdkField<String> DOMAIN_UNIT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitIdentifier").getter(getter(DomainUnitPolicyGrantPrincipal::domainUnitIdentifier))
            .setter(setter(Builder::domainUnitIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_DESIGNATION_FIELD,
            DOMAIN_UNIT_GRANT_FILTER_FIELD, DOMAIN_UNIT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainUnitDesignation;

    private final DomainUnitGrantFilter domainUnitGrantFilter;

    private final String domainUnitIdentifier;

    private DomainUnitPolicyGrantPrincipal(BuilderImpl builder) {
        this.domainUnitDesignation = builder.domainUnitDesignation;
        this.domainUnitGrantFilter = builder.domainUnitGrantFilter;
        this.domainUnitIdentifier = builder.domainUnitIdentifier;
    }

    /**
     * <p>
     * Specifes the designation of the domain unit users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainUnitDesignation} will return {@link DomainUnitDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainUnitDesignationAsString}.
     * </p>
     * 
     * @return Specifes the designation of the domain unit users.
     * @see DomainUnitDesignation
     */
    public final DomainUnitDesignation domainUnitDesignation() {
        return DomainUnitDesignation.fromValue(domainUnitDesignation);
    }

    /**
     * <p>
     * Specifes the designation of the domain unit users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainUnitDesignation} will return {@link DomainUnitDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainUnitDesignationAsString}.
     * </p>
     * 
     * @return Specifes the designation of the domain unit users.
     * @see DomainUnitDesignation
     */
    public final String domainUnitDesignationAsString() {
        return domainUnitDesignation;
    }

    /**
     * <p>
     * The grant filter for the domain unit.
     * </p>
     * 
     * @return The grant filter for the domain unit.
     */
    public final DomainUnitGrantFilter domainUnitGrantFilter() {
        return domainUnitGrantFilter;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final String domainUnitIdentifier() {
        return domainUnitIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitDesignationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitGrantFilter());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitPolicyGrantPrincipal)) {
            return false;
        }
        DomainUnitPolicyGrantPrincipal other = (DomainUnitPolicyGrantPrincipal) obj;
        return Objects.equals(domainUnitDesignationAsString(), other.domainUnitDesignationAsString())
                && Objects.equals(domainUnitGrantFilter(), other.domainUnitGrantFilter())
                && Objects.equals(domainUnitIdentifier(), other.domainUnitIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainUnitPolicyGrantPrincipal").add("DomainUnitDesignation", domainUnitDesignationAsString())
                .add("DomainUnitGrantFilter", domainUnitGrantFilter()).add("DomainUnitIdentifier", domainUnitIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnitDesignation":
            return Optional.ofNullable(clazz.cast(domainUnitDesignationAsString()));
        case "domainUnitGrantFilter":
            return Optional.ofNullable(clazz.cast(domainUnitGrantFilter()));
        case "domainUnitIdentifier":
            return Optional.ofNullable(clazz.cast(domainUnitIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainUnitDesignation", DOMAIN_UNIT_DESIGNATION_FIELD);
        map.put("domainUnitGrantFilter", DOMAIN_UNIT_GRANT_FILTER_FIELD);
        map.put("domainUnitIdentifier", DOMAIN_UNIT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((DomainUnitPolicyGrantPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainUnitPolicyGrantPrincipal> {
        /**
         * <p>
         * Specifes the designation of the domain unit users.
         * </p>
         * 
         * @param domainUnitDesignation
         *        Specifes the designation of the domain unit users.
         * @see DomainUnitDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainUnitDesignation
         */
        Builder domainUnitDesignation(String domainUnitDesignation);

        /**
         * <p>
         * Specifes the designation of the domain unit users.
         * </p>
         * 
         * @param domainUnitDesignation
         *        Specifes the designation of the domain unit users.
         * @see DomainUnitDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainUnitDesignation
         */
        Builder domainUnitDesignation(DomainUnitDesignation domainUnitDesignation);

        /**
         * <p>
         * The grant filter for the domain unit.
         * </p>
         * 
         * @param domainUnitGrantFilter
         *        The grant filter for the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitGrantFilter(DomainUnitGrantFilter domainUnitGrantFilter);

        /**
         * <p>
         * The grant filter for the domain unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitGrantFilter.Builder} avoiding
         * the need to create one manually via {@link DomainUnitGrantFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitGrantFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #domainUnitGrantFilter(DomainUnitGrantFilter)}.
         * 
         * @param domainUnitGrantFilter
         *        a consumer that will call methods on {@link DomainUnitGrantFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainUnitGrantFilter(DomainUnitGrantFilter)
         */
        default Builder domainUnitGrantFilter(Consumer<DomainUnitGrantFilter.Builder> domainUnitGrantFilter) {
            return domainUnitGrantFilter(DomainUnitGrantFilter.builder().applyMutation(domainUnitGrantFilter).build());
        }

        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitIdentifier
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitIdentifier(String domainUnitIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String domainUnitDesignation;

        private DomainUnitGrantFilter domainUnitGrantFilter;

        private String domainUnitIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitPolicyGrantPrincipal model) {
            domainUnitDesignation(model.domainUnitDesignation);
            domainUnitGrantFilter(model.domainUnitGrantFilter);
            domainUnitIdentifier(model.domainUnitIdentifier);
        }

        public final String getDomainUnitDesignation() {
            return domainUnitDesignation;
        }

        public final void setDomainUnitDesignation(String domainUnitDesignation) {
            this.domainUnitDesignation = domainUnitDesignation;
        }

        @Override
        public final Builder domainUnitDesignation(String domainUnitDesignation) {
            this.domainUnitDesignation = domainUnitDesignation;
            return this;
        }

        @Override
        public final Builder domainUnitDesignation(DomainUnitDesignation domainUnitDesignation) {
            this.domainUnitDesignation(domainUnitDesignation == null ? null : domainUnitDesignation.toString());
            return this;
        }

        public final DomainUnitGrantFilter.Builder getDomainUnitGrantFilter() {
            return domainUnitGrantFilter != null ? domainUnitGrantFilter.toBuilder() : null;
        }

        public final void setDomainUnitGrantFilter(DomainUnitGrantFilter.BuilderImpl domainUnitGrantFilter) {
            this.domainUnitGrantFilter = domainUnitGrantFilter != null ? domainUnitGrantFilter.build() : null;
        }

        @Override
        public final Builder domainUnitGrantFilter(DomainUnitGrantFilter domainUnitGrantFilter) {
            this.domainUnitGrantFilter = domainUnitGrantFilter;
            return this;
        }

        public final String getDomainUnitIdentifier() {
            return domainUnitIdentifier;
        }

        public final void setDomainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
        }

        @Override
        public final Builder domainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
            return this;
        }

        @Override
        public DomainUnitPolicyGrantPrincipal build() {
            return new DomainUnitPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
