/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Glue connection patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueConnectionPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueConnectionPatch.Builder, GlueConnectionPatch> {
    private static final SdkField<AuthenticationConfigurationPatch> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfigurationPatch> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(GlueConnectionPatch::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfigurationPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("connectionProperties")
            .getter(getter(GlueConnectionPatch::connectionProperties))
            .setter(setter(Builder::connectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GlueConnectionPatch::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_PROPERTIES_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AuthenticationConfigurationPatch authenticationConfiguration;

    private final Map<String, String> connectionProperties;

    private final String description;

    private GlueConnectionPatch(BuilderImpl builder) {
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionProperties = builder.connectionProperties;
        this.description = builder.description;
    }

    /**
     * <p>
     * The authentication configuration of the Amazon Web Services Glue connection patch.
     * </p>
     * 
     * @return The authentication configuration of the Amazon Web Services Glue connection patch.
     */
    public final AuthenticationConfigurationPatch authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties of the Amazon Web Services Glue connection patch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return The properties of the Amazon Web Services Glue connection patch.
     */
    public final Map<String, String> connectionProperties() {
        return connectionProperties;
    }

    /**
     * <p>
     * The description of the Amazon Web Services Glue connection patch.
     * </p>
     * 
     * @return The description of the Amazon Web Services Glue connection patch.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnectionPatch)) {
            return false;
        }
        GlueConnectionPatch other = (GlueConnectionPatch) obj;
        return Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionProperties(), other.connectionProperties())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueConnectionPatch").add("AuthenticationConfiguration", authenticationConfiguration())
                .add("ConnectionProperties", hasConnectionProperties() ? connectionProperties() : null)
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "connectionProperties":
            return Optional.ofNullable(clazz.cast(connectionProperties()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueConnectionPatch, T> g) {
        return obj -> g.apply((GlueConnectionPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueConnectionPatch> {
        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection patch.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration of the Amazon Web Services Glue connection patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfigurationPatch authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfigurationPatch.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfigurationPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfigurationPatch.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authenticationConfiguration(AuthenticationConfigurationPatch)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfigurationPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfigurationPatch)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfigurationPatch.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfigurationPatch.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * The properties of the Amazon Web Services Glue connection patch.
         * </p>
         * 
         * @param connectionProperties
         *        The properties of the Amazon Web Services Glue connection patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<String, String> connectionProperties);

        /**
         * <p>
         * The description of the Amazon Web Services Glue connection patch.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Web Services Glue connection patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private AuthenticationConfigurationPatch authenticationConfiguration;

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnectionPatch model) {
            authenticationConfiguration(model.authenticationConfiguration);
            connectionProperties(model.connectionProperties);
            description(model.description);
        }

        public final AuthenticationConfigurationPatch.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationPatch.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationPatch authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GlueConnectionPatch build() {
            return new GlueConnectionPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
