/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListConnectionsRequest.Builder, ListConnectionsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListConnectionsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(ListConnectionsRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListConnectionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListConnectionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConnectionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(ListConnectionsRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListConnectionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListConnectionsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListConnectionsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENVIRONMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final String projectIdentifier;

    private final String sortBy;

    private final String sortOrder;

    private final String type;

    private ListConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the domain where you want to list connections.
     * </p>
     * 
     * @return The ID of the domain where you want to list connections.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment where you want to list connections.
     * </p>
     * 
     * @return The ID of the environment where you want to list connections.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The maximum number of connections to return in a single call to ListConnections. When the number of connections
     * to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in
     * a subsequent call to ListConnections to list the next set of connections.
     * </p>
     * 
     * @return The maximum number of connections to return in a single call to ListConnections. When the number of
     *         connections to be listed is greater than the value of MaxResults, the response contains a NextToken value
     *         that you can use in a subsequent call to ListConnections to list the next set of connections.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When the number of connections is greater than the default value for the MaxResults parameter, or if you
     * explicitly specify a value for MaxResults that is less than the number of connections, the response includes a
     * pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListConnections to
     * list the next set of connections.
     * </p>
     * 
     * @return When the number of connections is greater than the default value for the MaxResults parameter, or if you
     *         explicitly specify a value for MaxResults that is less than the number of connections, the response
     *         includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     *         ListConnections to list the next set of connections.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the project where you want to list connections.
     * </p>
     * 
     * @return The ID of the project where you want to list connections.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    /**
     * <p>
     * Specifies how you want to sort the listed connections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortFieldConnection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies how you want to sort the listed connections.
     * @see SortFieldConnection
     */
    public final SortFieldConnection sortBy() {
        return SortFieldConnection.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies how you want to sort the listed connections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortFieldConnection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies how you want to sort the listed connections.
     * @see SortFieldConnection
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Specifies the sort order for the listed connections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the listed connections.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies the sort order for the listed connections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the listed connections.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The type of connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of connection.
     * @see ConnectionType
     */
    public final ConnectionType type() {
        return ConnectionType.fromValue(type);
    }

    /**
     * <p>
     * The type of connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of connection.
     * @see ConnectionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionsRequest)) {
            return false;
        }
        ListConnectionsRequest other = (ListConnectionsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(projectIdentifier(), other.projectIdentifier())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("MaxResults", maxResults()).add("Name", name())
                .add("NextToken", nextToken()).add("ProjectIdentifier", projectIdentifier()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionsRequest, T> g) {
        return obj -> g.apply((ListConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectionsRequest> {
        /**
         * <p>
         * The ID of the domain where you want to list connections.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to list connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment where you want to list connections.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment where you want to list connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The maximum number of connections to return in a single call to ListConnections. When the number of
         * connections to be listed is greater than the value of MaxResults, the response contains a NextToken value
         * that you can use in a subsequent call to ListConnections to list the next set of connections.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of connections to return in a single call to ListConnections. When the number of
         *        connections to be listed is greater than the value of MaxResults, the response contains a NextToken
         *        value that you can use in a subsequent call to ListConnections to list the next set of connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param name
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the number of connections is greater than the default value for the MaxResults parameter, or if you
         * explicitly specify a value for MaxResults that is less than the number of connections, the response includes
         * a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
         * ListConnections to list the next set of connections.
         * </p>
         * 
         * @param nextToken
         *        When the number of connections is greater than the default value for the MaxResults parameter, or if
         *        you explicitly specify a value for MaxResults that is less than the number of connections, the
         *        response includes a pagination token named NextToken. You can specify this NextToken value in a
         *        subsequent call to ListConnections to list the next set of connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the project where you want to list connections.
         * </p>
         * 
         * @param projectIdentifier
         *        The ID of the project where you want to list connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        /**
         * <p>
         * Specifies how you want to sort the listed connections.
         * </p>
         * 
         * @param sortBy
         *        Specifies how you want to sort the listed connections.
         * @see SortFieldConnection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortFieldConnection
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies how you want to sort the listed connections.
         * </p>
         * 
         * @param sortBy
         *        Specifies how you want to sort the listed connections.
         * @see SortFieldConnection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortFieldConnection
         */
        Builder sortBy(SortFieldConnection sortBy);

        /**
         * <p>
         * Specifies the sort order for the listed connections.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the listed connections.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies the sort order for the listed connections.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the listed connections.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The type of connection.
         * </p>
         * 
         * @param type
         *        The type of connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of connection.
         * </p>
         * 
         * @param type
         *        The type of connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(ConnectionType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String environmentIdentifier;

        private Integer maxResults;

        private String name;

        private String nextToken;

        private String projectIdentifier;

        private String sortBy;

        private String sortOrder;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            projectIdentifier(model.projectIdentifier);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            type(model.type);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortFieldConnection sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionsRequest build() {
            return new ListConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
