/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetadataGenerationRunsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListMetadataGenerationRunsRequest.Builder, ListMetadataGenerationRunsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListMetadataGenerationRunsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMetadataGenerationRunsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetadataGenerationRunsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListMetadataGenerationRunsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListMetadataGenerationRunsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String status;

    private final String type;

    private ListMetadataGenerationRunsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where you want to list metadata generation runs.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where you want to list metadata generation runs.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns. When the
     * number of metadata generation runs to be listed is greater than the value of MaxResults, the response contains a
     * NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns to list the next set of
     * revisions.
     * </p>
     * 
     * @return The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns.
     *         When the number of metadata generation runs to be listed is greater than the value of MaxResults, the
     *         response contains a NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns
     *         to list the next set of revisions.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of metadata generation runs is greater than the default value for the MaxResults parameter, or if
     * you explicitly specify a value for MaxResults that is less than the number of metadata generation runs, the
     * response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call
     * to ListMetadataGenerationRuns to list the next set of revisions.
     * </p>
     * 
     * @return When the number of metadata generation runs is greater than the default value for the MaxResults
     *         parameter, or if you explicitly specify a value for MaxResults that is less than the number of metadata
     *         generation runs, the response includes a pagination token named NextToken. You can specify this NextToken
     *         value in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The status of the metadata generation runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation runs.
     * @see MetadataGenerationRunStatus
     */
    public final MetadataGenerationRunStatus status() {
        return MetadataGenerationRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the metadata generation runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation runs.
     * @see MetadataGenerationRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the metadata generation runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation runs.
     * @see MetadataGenerationRunType
     */
    public final MetadataGenerationRunType type() {
        return MetadataGenerationRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of the metadata generation runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation runs.
     * @see MetadataGenerationRunType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetadataGenerationRunsRequest)) {
            return false;
        }
        ListMetadataGenerationRunsRequest other = (ListMetadataGenerationRunsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetadataGenerationRunsRequest").add("DomainIdentifier", domainIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Status", statusAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetadataGenerationRunsRequest, T> g) {
        return obj -> g.apply((ListMetadataGenerationRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMetadataGenerationRunsRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain where you want to list metadata generation runs.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where you want to list metadata generation runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns. When
         * the number of metadata generation runs to be listed is greater than the value of MaxResults, the response
         * contains a NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns to list the
         * next set of revisions.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of metadata generation runs to return in a single call to
         *        ListMetadataGenerationRuns. When the number of metadata generation runs to be listed is greater than
         *        the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call
         *        to ListMetadataGenerationRuns to list the next set of revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of metadata generation runs is greater than the default value for the MaxResults parameter,
         * or if you explicitly specify a value for MaxResults that is less than the number of metadata generation runs,
         * the response includes a pagination token named NextToken. You can specify this NextToken value in a
         * subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
         * </p>
         * 
         * @param nextToken
         *        When the number of metadata generation runs is greater than the default value for the MaxResults
         *        parameter, or if you explicitly specify a value for MaxResults that is less than the number of
         *        metadata generation runs, the response includes a pagination token named NextToken. You can specify
         *        this NextToken value in a subsequent call to ListMetadataGenerationRuns to list the next set of
         *        revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The status of the metadata generation runs.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation runs.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the metadata generation runs.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation runs.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(MetadataGenerationRunStatus status);

        /**
         * <p>
         * The type of the metadata generation runs.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation runs.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the metadata generation runs.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation runs.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(MetadataGenerationRunType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetadataGenerationRunsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            status(model.status);
            type(model.type);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetadataGenerationRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataGenerationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetadataGenerationRunsRequest build() {
            return new ListMetadataGenerationRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
