/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscriptionRequestsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListSubscriptionRequestsRequest.Builder, ListSubscriptionRequestsRequest> {
    private static final SdkField<String> APPROVER_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approverProjectId").getter(getter(ListSubscriptionRequestsRequest::approverProjectId))
            .setter(setter(Builder::approverProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("approverProjectId").build())
            .build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListSubscriptionRequestsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSubscriptionRequestsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubscriptionRequestsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(ListSubscriptionRequestsRequest::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningProjectId").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListSubscriptionRequestsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListSubscriptionRequestsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListSubscriptionRequestsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> SUBSCRIBED_LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscribedListingId").getter(getter(ListSubscriptionRequestsRequest::subscribedListingId))
            .setter(setter(Builder::subscribedListingId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscribedListingId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_PROJECT_ID_FIELD,
            DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNING_PROJECT_ID_FIELD, SORT_BY_FIELD,
            SORT_ORDER_FIELD, STATUS_FIELD, SUBSCRIBED_LISTING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String approverProjectId;

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String owningProjectId;

    private final String sortBy;

    private final String sortOrder;

    private final String status;

    private final String subscribedListingId;

    private ListSubscriptionRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.approverProjectId = builder.approverProjectId;
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.owningProjectId = builder.owningProjectId;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.status = builder.status;
        this.subscribedListingId = builder.subscribedListingId;
    }

    /**
     * <p>
     * The identifier of the subscription request approver's project.
     * </p>
     * 
     * @return The identifier of the subscription request approver's project.
     */
    public final String approverProjectId() {
        return approverProjectId;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of subscription requests to return in a single call to <code>ListSubscriptionRequests</code>.
     * When the number of subscription requests to be listed is greater than the value of <code>MaxResults</code>, the
     * response contains a <code>NextToken</code> value that you can use in a subsequent call to
     * <code>ListSubscriptionRequests</code> to list the next set of subscription requests.
     * </p>
     * 
     * @return The maximum number of subscription requests to return in a single call to
     *         <code>ListSubscriptionRequests</code>. When the number of subscription requests to be listed is greater
     *         than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you
     *         can use in a subsequent call to <code>ListSubscriptionRequests</code> to list the next set of
     *         subscription requests.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of subscription requests is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * subscription requests, the response includes a pagination token named <code>NextToken</code>. You can specify
     * this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionRequests</code> to list the next
     * set of subscription requests.
     * </p>
     * 
     * @return When the number of subscription requests is greater than the default value for the
     *         <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
     *         is less than the number of subscription requests, the response includes a pagination token named
     *         <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
     *         <code>ListSubscriptionRequests</code> to list the next set of subscription requests.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the project for the subscription requests.
     * </p>
     * 
     * @return The identifier of the project for the subscription requests.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * Specifies the way to sort the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way to sort the results of this action.
     * @see SortKey
     */
    public final SortKey sortBy() {
        return SortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies the way to sort the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way to sort the results of this action.
     * @see SortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Specifies the sort order for the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the results of this action.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies the sort order for the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order for the results of this action.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * Specifies the status of the subscription requests.
     * </p>
     * <note>
     * <p>
     * This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
     * <code>PENDING</code> subscription requests.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the subscription requests.</p> <note>
     *         <p>
     *         This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
     *         <code>PENDING</code> subscription requests.
     *         </p>
     * @see SubscriptionRequestStatus
     */
    public final SubscriptionRequestStatus status() {
        return SubscriptionRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the status of the subscription requests.
     * </p>
     * <note>
     * <p>
     * This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
     * <code>PENDING</code> subscription requests.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the subscription requests.</p> <note>
     *         <p>
     *         This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
     *         <code>PENDING</code> subscription requests.
     *         </p>
     * @see SubscriptionRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier of the subscribed listing.
     * </p>
     * 
     * @return The identifier of the subscribed listing.
     */
    public final String subscribedListingId() {
        return subscribedListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approverProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedListingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionRequestsRequest)) {
            return false;
        }
        ListSubscriptionRequestsRequest other = (ListSubscriptionRequestsRequest) obj;
        return Objects.equals(approverProjectId(), other.approverProjectId())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(subscribedListingId(), other.subscribedListingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscriptionRequestsRequest").add("ApproverProjectId", approverProjectId())
                .add("DomainIdentifier", domainIdentifier()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OwningProjectId", owningProjectId()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("Status", statusAsString()).add("SubscribedListingId", subscribedListingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approverProjectId":
            return Optional.ofNullable(clazz.cast(approverProjectId()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subscribedListingId":
            return Optional.ofNullable(clazz.cast(subscribedListingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("approverProjectId", APPROVER_PROJECT_ID_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subscribedListingId", SUBSCRIBED_LISTING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionRequestsRequest, T> g) {
        return obj -> g.apply((ListSubscriptionRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscriptionRequestsRequest> {
        /**
         * <p>
         * The identifier of the subscription request approver's project.
         * </p>
         * 
         * @param approverProjectId
         *        The identifier of the subscription request approver's project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approverProjectId(String approverProjectId);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of subscription requests to return in a single call to
         * <code>ListSubscriptionRequests</code>. When the number of subscription requests to be listed is greater than
         * the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use
         * in a subsequent call to <code>ListSubscriptionRequests</code> to list the next set of subscription requests.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of subscription requests to return in a single call to
         *        <code>ListSubscriptionRequests</code>. When the number of subscription requests to be listed is
         *        greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code>
         *        value that you can use in a subsequent call to <code>ListSubscriptionRequests</code> to list the next
         *        set of subscription requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of subscription requests is greater than the default value for the <code>MaxResults</code>
         * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * subscription requests, the response includes a pagination token named <code>NextToken</code>. You can specify
         * this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionRequests</code> to list the
         * next set of subscription requests.
         * </p>
         * 
         * @param nextToken
         *        When the number of subscription requests is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of subscription requests, the response includes a pagination token named
         *        <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         *        <code>ListSubscriptionRequests</code> to list the next set of subscription requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the project for the subscription requests.
         * </p>
         * 
         * @param owningProjectId
         *        The identifier of the project for the subscription requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * Specifies the way to sort the results of this action.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way to sort the results of this action.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies the way to sort the results of this action.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way to sort the results of this action.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortBy(SortKey sortBy);

        /**
         * <p>
         * Specifies the sort order for the results of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the results of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies the sort order for the results of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order for the results of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * Specifies the status of the subscription requests.
         * </p>
         * <note>
         * <p>
         * This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
         * <code>PENDING</code> subscription requests.
         * </p>
         * </note>
         * 
         * @param status
         *        Specifies the status of the subscription requests.</p> <note>
         *        <p>
         *        This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
         *        <code>PENDING</code> subscription requests.
         *        </p>
         * @see SubscriptionRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the status of the subscription requests.
         * </p>
         * <note>
         * <p>
         * This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
         * <code>PENDING</code> subscription requests.
         * </p>
         * </note>
         * 
         * @param status
         *        Specifies the status of the subscription requests.</p> <note>
         *        <p>
         *        This is not a required parameter, but if not specified, by default, Amazon DataZone returns only
         *        <code>PENDING</code> subscription requests.
         *        </p>
         * @see SubscriptionRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionRequestStatus
         */
        Builder status(SubscriptionRequestStatus status);

        /**
         * <p>
         * The identifier of the subscribed listing.
         * </p>
         * 
         * @param subscribedListingId
         *        The identifier of the subscribed listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListingId(String subscribedListingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String approverProjectId;

        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String owningProjectId;

        private String sortBy;

        private String sortOrder;

        private String status;

        private String subscribedListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionRequestsRequest model) {
            super(model);
            approverProjectId(model.approverProjectId);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            owningProjectId(model.owningProjectId);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            status(model.status);
            subscribedListingId(model.subscribedListingId);
        }

        public final String getApproverProjectId() {
            return approverProjectId;
        }

        public final void setApproverProjectId(String approverProjectId) {
            this.approverProjectId = approverProjectId;
        }

        @Override
        public final Builder approverProjectId(String approverProjectId) {
            this.approverProjectId = approverProjectId;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubscribedListingId() {
            return subscribedListingId;
        }

        public final void setSubscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
        }

        @Override
        public final Builder subscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionRequestsRequest build() {
            return new ListSubscriptionRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
