/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMetadataGenerationRunRequest extends DataZoneRequest implements
        ToCopyableBuilder<StartMetadataGenerationRunRequest.Builder, StartMetadataGenerationRunRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartMetadataGenerationRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(StartMetadataGenerationRunRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(StartMetadataGenerationRunRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final SdkField<MetadataGenerationRunTarget> TARGET_FIELD = SdkField
            .<MetadataGenerationRunTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(StartMetadataGenerationRunRequest::target)).setter(setter(Builder::target))
            .constructor(MetadataGenerationRunTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StartMetadataGenerationRunRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, TARGET_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String domainIdentifier;

    private final String owningProjectIdentifier;

    private final MetadataGenerationRunTarget target;

    private final String type;

    private StartMetadataGenerationRunRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.target = builder.target;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *         populated if not provided.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where you want to start a metadata generation run.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where you want to start a metadata generation run.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the project that owns the asset for which you want to start a metadata generation run.
     * </p>
     * 
     * @return The ID of the project that owns the asset for which you want to start a metadata generation run.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    /**
     * <p>
     * The asset for which you want to start a metadata generation run.
     * </p>
     * 
     * @return The asset for which you want to start a metadata generation run.
     */
    public final MetadataGenerationRunTarget target() {
        return target;
    }

    /**
     * <p>
     * The type of the metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation run.
     * @see MetadataGenerationRunType
     */
    public final MetadataGenerationRunType type() {
        return MetadataGenerationRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of the metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation run.
     * @see MetadataGenerationRunType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataGenerationRunRequest)) {
            return false;
        }
        StartMetadataGenerationRunRequest other = (StartMetadataGenerationRunRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier())
                && Objects.equals(target(), other.target()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMetadataGenerationRunRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("OwningProjectIdentifier", owningProjectIdentifier())
                .add("Target", target()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataGenerationRunRequest, T> g) {
        return obj -> g.apply((StartMetadataGenerationRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMetadataGenerationRunRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         * populated if not provided.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         *        populated if not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain where you want to start a metadata generation run.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where you want to start a metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the project that owns the asset for which you want to start a metadata generation run.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The ID of the project that owns the asset for which you want to start a metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        /**
         * <p>
         * The asset for which you want to start a metadata generation run.
         * </p>
         * 
         * @param target
         *        The asset for which you want to start a metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(MetadataGenerationRunTarget target);

        /**
         * <p>
         * The asset for which you want to start a metadata generation run.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataGenerationRunTarget.Builder}
         * avoiding the need to create one manually via {@link MetadataGenerationRunTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataGenerationRunTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(MetadataGenerationRunTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link MetadataGenerationRunTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(MetadataGenerationRunTarget)
         */
        default Builder target(Consumer<MetadataGenerationRunTarget.Builder> target) {
            return target(MetadataGenerationRunTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The type of the metadata generation run.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation run.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the metadata generation run.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation run.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(MetadataGenerationRunType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String owningProjectIdentifier;

        private MetadataGenerationRunTarget target;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataGenerationRunRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            owningProjectIdentifier(model.owningProjectIdentifier);
            target(model.target);
            type(model.type);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final MetadataGenerationRunTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(MetadataGenerationRunTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(MetadataGenerationRunTarget target) {
            this.target = target;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataGenerationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataGenerationRunRequest build() {
            return new StartMetadataGenerationRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
