/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountPoolRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateAccountPoolRequest.Builder, UpdateAccountPoolRequest> {
    private static final SdkField<AccountSource> ACCOUNT_SOURCE_FIELD = SdkField
            .<AccountSource> builder(MarshallingType.SDK_POJO).memberName("accountSource")
            .getter(getter(UpdateAccountPoolRequest::accountSource)).setter(setter(Builder::accountSource))
            .constructor(AccountSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSource").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAccountPoolRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateAccountPoolRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateAccountPoolRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAccountPoolRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionStrategy").getter(getter(UpdateAccountPoolRequest::resolutionStrategyAsString))
            .setter(setter(Builder::resolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCE_FIELD,
            DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, NAME_FIELD, RESOLUTION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccountSource accountSource;

    private final String description;

    private final String domainIdentifier;

    private final String identifier;

    private final String name;

    private final String resolutionStrategy;

    private UpdateAccountPoolRequest(BuilderImpl builder) {
        super(builder);
        this.accountSource = builder.accountSource;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.resolutionStrategy = builder.resolutionStrategy;
    }

    /**
     * <p>
     * The source of accounts for the account pool. In the current release, it's either a static list of accounts
     * provided by the customer or a custom Amazon Web Services Lambda handler.
     * </p>
     * 
     * @return The source of accounts for the account pool. In the current release, it's either a static list of
     *         accounts provided by the customer or a custom Amazon Web Services Lambda handler.
     */
    public final AccountSource accountSource() {
        return accountSource;
    }

    /**
     * <p>
     * The description of the account pool that is to be udpated.
     * </p>
     * 
     * @return The description of the account pool that is to be udpated.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain ID where the account pool that is to be updated lives.
     * </p>
     * 
     * @return The domain ID where the account pool that is to be updated lives.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the account pool that is to be updated.
     * </p>
     * 
     * @return The ID of the account pool that is to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the account pool that is to be updated.
     * </p>
     * 
     * @return The name of the account pool that is to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The mechanism used to resolve the account selection from the account pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link ResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return The mechanism used to resolve the account selection from the account pool.
     * @see ResolutionStrategy
     */
    public final ResolutionStrategy resolutionStrategy() {
        return ResolutionStrategy.fromValue(resolutionStrategy);
    }

    /**
     * <p>
     * The mechanism used to resolve the account selection from the account pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link ResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return The mechanism used to resolve the account selection from the account pool.
     * @see ResolutionStrategy
     */
    public final String resolutionStrategyAsString() {
        return resolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountPoolRequest)) {
            return false;
        }
        UpdateAccountPoolRequest other = (UpdateAccountPoolRequest) obj;
        return Objects.equals(accountSource(), other.accountSource()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(resolutionStrategyAsString(), other.resolutionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountPoolRequest").add("AccountSource", accountSource())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResolutionStrategy", resolutionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountSource":
            return Optional.ofNullable(clazz.cast(accountSource()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resolutionStrategy":
            return Optional.ofNullable(clazz.cast(resolutionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountSource", ACCOUNT_SOURCE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountPoolRequest, T> g) {
        return obj -> g.apply((UpdateAccountPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountPoolRequest> {
        /**
         * <p>
         * The source of accounts for the account pool. In the current release, it's either a static list of accounts
         * provided by the customer or a custom Amazon Web Services Lambda handler.
         * </p>
         * 
         * @param accountSource
         *        The source of accounts for the account pool. In the current release, it's either a static list of
         *        accounts provided by the customer or a custom Amazon Web Services Lambda handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSource(AccountSource accountSource);

        /**
         * <p>
         * The source of accounts for the account pool. In the current release, it's either a static list of accounts
         * provided by the customer or a custom Amazon Web Services Lambda handler.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountSource.Builder} avoiding the need
         * to create one manually via {@link AccountSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountSource.Builder#build()} is called immediately and its
         * result is passed to {@link #accountSource(AccountSource)}.
         * 
         * @param accountSource
         *        a consumer that will call methods on {@link AccountSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSource(AccountSource)
         */
        default Builder accountSource(Consumer<AccountSource.Builder> accountSource) {
            return accountSource(AccountSource.builder().applyMutation(accountSource).build());
        }

        /**
         * <p>
         * The description of the account pool that is to be udpated.
         * </p>
         * 
         * @param description
         *        The description of the account pool that is to be udpated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain ID where the account pool that is to be updated lives.
         * </p>
         * 
         * @param domainIdentifier
         *        The domain ID where the account pool that is to be updated lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the account pool that is to be updated.
         * </p>
         * 
         * @param identifier
         *        The ID of the account pool that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the account pool that is to be updated.
         * </p>
         * 
         * @param name
         *        The name of the account pool that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The mechanism used to resolve the account selection from the account pool.
         * </p>
         * 
         * @param resolutionStrategy
         *        The mechanism used to resolve the account selection from the account pool.
         * @see ResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionStrategy
         */
        Builder resolutionStrategy(String resolutionStrategy);

        /**
         * <p>
         * The mechanism used to resolve the account selection from the account pool.
         * </p>
         * 
         * @param resolutionStrategy
         *        The mechanism used to resolve the account selection from the account pool.
         * @see ResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionStrategy
         */
        Builder resolutionStrategy(ResolutionStrategy resolutionStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private AccountSource accountSource;

        private String description;

        private String domainIdentifier;

        private String identifier;

        private String name;

        private String resolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountPoolRequest model) {
            super(model);
            accountSource(model.accountSource);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            name(model.name);
            resolutionStrategy(model.resolutionStrategy);
        }

        public final AccountSource.Builder getAccountSource() {
            return accountSource != null ? accountSource.toBuilder() : null;
        }

        public final void setAccountSource(AccountSource.BuilderImpl accountSource) {
            this.accountSource = accountSource != null ? accountSource.build() : null;
        }

        @Override
        public final Builder accountSource(AccountSource accountSource) {
            this.accountSource = accountSource;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionStrategy() {
            return resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountPoolRequest build() {
            return new UpdateAccountPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
