/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the user profile in Amazon DataZone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserProfileDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UserProfileDetails.Builder, UserProfileDetails> {
    private static final SdkField<IamUserProfileDetails> IAM_FIELD = SdkField
            .<IamUserProfileDetails> builder(MarshallingType.SDK_POJO).memberName("iam").getter(getter(UserProfileDetails::iam))
            .setter(setter(Builder::iam)).constructor(IamUserProfileDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()).build();

    private static final SdkField<SsoUserProfileDetails> SSO_FIELD = SdkField
            .<SsoUserProfileDetails> builder(MarshallingType.SDK_POJO).memberName("sso").getter(getter(UserProfileDetails::sso))
            .setter(setter(Builder::sso)).constructor(SsoUserProfileDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sso").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_FIELD, SSO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamUserProfileDetails iam;

    private final SsoUserProfileDetails sso;

    private final Type type;

    private UserProfileDetails(BuilderImpl builder) {
        this.iam = builder.iam;
        this.sso = builder.sso;
        this.type = builder.type;
    }

    /**
     * <p>
     * The IAM details included in the user profile details.
     * </p>
     * 
     * @return The IAM details included in the user profile details.
     */
    public final IamUserProfileDetails iam() {
        return iam;
    }

    /**
     * <p>
     * The single sign-on details included in the user profile details.
     * </p>
     * 
     * @return The single sign-on details included in the user profile details.
     */
    public final SsoUserProfileDetails sso() {
        return sso;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        hashCode = 31 * hashCode + Objects.hashCode(sso());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProfileDetails)) {
            return false;
        }
        UserProfileDetails other = (UserProfileDetails) obj;
        return Objects.equals(iam(), other.iam()) && Objects.equals(sso(), other.sso());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserProfileDetails").add("Iam", iam()).add("Sso", sso()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iam":
            return Optional.ofNullable(clazz.cast(iam()));
        case "sso":
            return Optional.ofNullable(clazz.cast(sso()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #iam()} initialized to the given value.
     *
     * <p>
     * The IAM details included in the user profile details.
     * </p>
     * 
     * @param iam
     *        The IAM details included in the user profile details.
     */
    public static UserProfileDetails fromIam(IamUserProfileDetails iam) {
        return builder().iam(iam).build();
    }

    /**
     * Create an instance of this class with {@link #iam()} initialized to the given value.
     *
     * <p>
     * The IAM details included in the user profile details.
     * </p>
     * 
     * @param iam
     *        The IAM details included in the user profile details.
     */
    public static UserProfileDetails fromIam(Consumer<IamUserProfileDetails.Builder> iam) {
        IamUserProfileDetails.Builder builder = IamUserProfileDetails.builder();
        iam.accept(builder);
        return fromIam(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sso()} initialized to the given value.
     *
     * <p>
     * The single sign-on details included in the user profile details.
     * </p>
     * 
     * @param sso
     *        The single sign-on details included in the user profile details.
     */
    public static UserProfileDetails fromSso(SsoUserProfileDetails sso) {
        return builder().sso(sso).build();
    }

    /**
     * Create an instance of this class with {@link #sso()} initialized to the given value.
     *
     * <p>
     * The single sign-on details included in the user profile details.
     * </p>
     * 
     * @param sso
     *        The single sign-on details included in the user profile details.
     */
    public static UserProfileDetails fromSso(Consumer<SsoUserProfileDetails.Builder> sso) {
        SsoUserProfileDetails.Builder builder = SsoUserProfileDetails.builder();
        sso.accept(builder);
        return fromSso(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("iam", IAM_FIELD);
        map.put("sso", SSO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserProfileDetails, T> g) {
        return obj -> g.apply((UserProfileDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserProfileDetails> {
        /**
         * <p>
         * The IAM details included in the user profile details.
         * </p>
         * 
         * @param iam
         *        The IAM details included in the user profile details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(IamUserProfileDetails iam);

        /**
         * <p>
         * The IAM details included in the user profile details.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamUserProfileDetails.Builder} avoiding
         * the need to create one manually via {@link IamUserProfileDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamUserProfileDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #iam(IamUserProfileDetails)}.
         * 
         * @param iam
         *        a consumer that will call methods on {@link IamUserProfileDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iam(IamUserProfileDetails)
         */
        default Builder iam(Consumer<IamUserProfileDetails.Builder> iam) {
            return iam(IamUserProfileDetails.builder().applyMutation(iam).build());
        }

        /**
         * <p>
         * The single sign-on details included in the user profile details.
         * </p>
         * 
         * @param sso
         *        The single sign-on details included in the user profile details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sso(SsoUserProfileDetails sso);

        /**
         * <p>
         * The single sign-on details included in the user profile details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SsoUserProfileDetails.Builder} avoiding
         * the need to create one manually via {@link SsoUserProfileDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SsoUserProfileDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #sso(SsoUserProfileDetails)}.
         * 
         * @param sso
         *        a consumer that will call methods on {@link SsoUserProfileDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sso(SsoUserProfileDetails)
         */
        default Builder sso(Consumer<SsoUserProfileDetails.Builder> sso) {
            return sso(SsoUserProfileDetails.builder().applyMutation(sso).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamUserProfileDetails iam;

        private SsoUserProfileDetails sso;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserProfileDetails model) {
            iam(model.iam);
            sso(model.sso);
        }

        public final IamUserProfileDetails.Builder getIam() {
            return iam != null ? iam.toBuilder() : null;
        }

        public final void setIam(IamUserProfileDetails.BuilderImpl iam) {
            Object oldValue = this.iam;
            this.iam = iam != null ? iam.build() : null;
            handleUnionValueChange(Type.IAM, oldValue, this.iam);
        }

        @Override
        public final Builder iam(IamUserProfileDetails iam) {
            Object oldValue = this.iam;
            this.iam = iam;
            handleUnionValueChange(Type.IAM, oldValue, this.iam);
            return this;
        }

        public final SsoUserProfileDetails.Builder getSso() {
            return sso != null ? sso.toBuilder() : null;
        }

        public final void setSso(SsoUserProfileDetails.BuilderImpl sso) {
            Object oldValue = this.sso;
            this.sso = sso != null ? sso.build() : null;
            handleUnionValueChange(Type.SSO, oldValue, this.sso);
        }

        @Override
        public final Builder sso(SsoUserProfileDetails sso) {
            Object oldValue = this.sso;
            this.sso = sso;
            handleUnionValueChange(Type.SSO, oldValue, this.sso);
            return this;
        }

        @Override
        public UserProfileDetails build() {
            return new UserProfileDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UserProfileDetails#type()
     */
    public enum Type {
        IAM,

        SSO,

        UNKNOWN_TO_SDK_VERSION
    }
}
