/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParameterGroupRequest extends DaxRequest implements
        ToCopyableBuilder<UpdateParameterGroupRequest.Builder, UpdateParameterGroupRequest> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateParameterGroupRequest::parameterGroupName)).setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<List<ParameterNameValue>> PARAMETER_NAME_VALUES_FIELD = SdkField
            .<List<ParameterNameValue>> builder(MarshallingType.LIST)
            .getter(getter(UpdateParameterGroupRequest::parameterNameValues))
            .setter(setter(Builder::parameterNameValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterNameValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterNameValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_NAME_VALUES_FIELD));

    private final String parameterGroupName;

    private final List<ParameterNameValue> parameterNameValues;

    private UpdateParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    /**
     * <p>
     * The name of the parameter group.
     * </p>
     * 
     * @return The name of the parameter group.
     */
    public String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of name-value pairs for the parameters in the group. Each element in the array represents a
     *         single parameter.
     */
    public List<ParameterNameValue> parameterNameValues() {
        return parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterNameValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParameterGroupRequest)) {
            return false;
        }
        UpdateParameterGroupRequest other = (UpdateParameterGroupRequest) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterNameValues(), other.parameterNameValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateParameterGroupRequest").add("ParameterGroupName", parameterGroupName())
                .add("ParameterNameValues", parameterNameValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterNameValues":
            return Optional.ofNullable(clazz.cast(parameterNameValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParameterGroupRequest, T> g) {
        return obj -> g.apply((UpdateParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateParameterGroupRequest> {
        /**
         * <p>
         * The name of the parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of name-value pairs for the parameters in the group. Each element in the array represents a
         *        single parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of name-value pairs for the parameters in the group. Each element in the array represents a
         *        single parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(ParameterNameValue... parameterNameValues);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterNameValue>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterNameValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterNameValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterNameValues(List<ParameterNameValue>)}.
         * 
         * @param parameterNameValues
         *        a consumer that will call methods on {@link List<ParameterNameValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterNameValues(List<ParameterNameValue>)
         */
        Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String parameterGroupName;

        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParameterGroupRequest model) {
            super(model);
            parameterGroupName(model.parameterGroupName);
            parameterNameValues(model.parameterNameValues);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return parameterNameValues != null ? parameterNameValues.stream().map(ParameterNameValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue... parameterNameValues) {
            parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues) {
            parameterNameValues(Stream.of(parameterNameValues).map(c -> ParameterNameValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParameterGroupRequest build() {
            return new UpdateParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
