/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubnetGroupsRequest extends DaxRequest implements
        ToCopyableBuilder<DescribeSubnetGroupsRequest.Builder, DescribeSubnetGroupsRequest> {
    private static final SdkField<List<String>> SUBNET_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetGroupNames")
            .getter(getter(DescribeSubnetGroupsRequest::subnetGroupNames))
            .setter(setter(Builder::subnetGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeSubnetGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSubnetGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_GROUP_NAMES_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> subnetGroupNames;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeSubnetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.subnetGroupNames = builder.subnetGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SubnetGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSubnetGroupNames() {
        return subnetGroupNames != null && !(subnetGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the subnet group.
     */
    public List<String> subnetGroupNames() {
        return subnetGroupNames;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * <p>
     * The value for <code>MaxResults</code> must be between 20 and 100.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.</p>
     *         <p>
     *         The value for <code>MaxResults</code> must be between 20 and 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * <code>MaxResults</code>.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by <code>MaxResults</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetGroupNames() ? subnetGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsRequest)) {
            return false;
        }
        DescribeSubnetGroupsRequest other = (DescribeSubnetGroupsRequest) obj;
        return hasSubnetGroupNames() == other.hasSubnetGroupNames()
                && Objects.equals(subnetGroupNames(), other.subnetGroupNames())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSubnetGroupsRequest")
                .add("SubnetGroupNames", hasSubnetGroupNames() ? subnetGroupNames() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetGroupNames":
            return Optional.ofNullable(clazz.cast(subnetGroupNames()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetGroupsRequest, T> g) {
        return obj -> g.apply((DescribeSubnetGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
        /**
         * <p>
         * The name of the subnet group.
         * </p>
         * 
         * @param subnetGroupNames
         *        The name of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupNames(Collection<String> subnetGroupNames);

        /**
         * <p>
         * The name of the subnet group.
         * </p>
         * 
         * @param subnetGroupNames
         *        The name of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupNames(String... subnetGroupNames);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * <p>
         * The value for <code>MaxResults</code> must be between 20 and 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.</p>
         *        <p>
         *        The value for <code>MaxResults</code> must be between 20 and 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by <code>MaxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private List<String> subnetGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsRequest model) {
            super(model);
            subnetGroupNames(model.subnetGroupNames);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getSubnetGroupNames() {
            if (subnetGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetGroupNames;
        }

        @Override
        public final Builder subnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroupNames(String... subnetGroupNames) {
            subnetGroupNames(Arrays.asList(subnetGroupNames));
            return this;
        }

        public final void setSubnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubnetGroupsRequest build() {
            return new DescribeSubnetGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
