/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncreaseReplicationFactorRequest extends DaxRequest implements
        ToCopyableBuilder<IncreaseReplicationFactorRequest.Builder, IncreaseReplicationFactorRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(IncreaseReplicationFactorRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<Integer> NEW_REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NewReplicationFactor").getter(getter(IncreaseReplicationFactorRequest::newReplicationFactor))
            .setter(setter(Builder::newReplicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicationFactor").build())
            .build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(IncreaseReplicationFactorRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NEW_REPLICATION_FACTOR_FIELD, AVAILABILITY_ZONES_FIELD));

    private final String clusterName;

    private final Integer newReplicationFactor;

    private final List<String> availabilityZones;

    private IncreaseReplicationFactorRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
    }

    /**
     * <p>
     * The name of the DAX cluster that will receive additional nodes.
     * </p>
     * 
     * @return The name of the DAX cluster that will receive additional nodes.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The new number of nodes for the DAX cluster.
     * </p>
     * 
     * @return The new number of nodes for the DAX cluster.
     */
    public Integer newReplicationFactor() {
        return newReplicationFactor;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster are
     * placed in these Availability Zones. Use this parameter if you want to distribute the nodes across multiple AZs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the
     *         cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes
     *         across multiple AZs.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(newReplicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicationFactorRequest)) {
            return false;
        }
        IncreaseReplicationFactorRequest other = (IncreaseReplicationFactorRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(newReplicationFactor(), other.newReplicationFactor())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IncreaseReplicationFactorRequest").add("ClusterName", clusterName())
                .add("NewReplicationFactor", newReplicationFactor())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "NewReplicationFactor":
            return Optional.ofNullable(clazz.cast(newReplicationFactor()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncreaseReplicationFactorRequest, T> g) {
        return obj -> g.apply((IncreaseReplicationFactorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
        /**
         * <p>
         * The name of the DAX cluster that will receive additional nodes.
         * </p>
         * 
         * @param clusterName
         *        The name of the DAX cluster that will receive additional nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The new number of nodes for the DAX cluster.
         * </p>
         * 
         * @param newReplicationFactor
         *        The new number of nodes for the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newReplicationFactor(Integer newReplicationFactor);

        /**
         * <p>
         * The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster
         * are placed in these Availability Zones. Use this parameter if you want to distribute the nodes across
         * multiple AZs.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the
         *        cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes
         *        across multiple AZs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster
         * are placed in these Availability Zones. Use this parameter if you want to distribute the nodes across
         * multiple AZs.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the
         *        cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes
         *        across multiple AZs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String clusterName;

        private Integer newReplicationFactor;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicationFactorRequest model) {
            super(model);
            clusterName(model.clusterName);
            newReplicationFactor(model.newReplicationFactor);
            availabilityZones(model.availabilityZones);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseReplicationFactorRequest build() {
            return new IncreaseReplicationFactorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
