/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends DaxRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(UpdateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateClusterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(UpdateClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(UpdateClusterRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicStatus").getter(getter(UpdateClusterRequest::notificationTopicStatus))
            .setter(setter(Builder::notificationTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(UpdateClusterRequest::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(UpdateClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            DESCRIPTION_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, NOTIFICATION_TOPIC_STATUS_FIELD,
            PARAMETER_GROUP_NAME_FIELD, SECURITY_GROUP_IDS_FIELD));

    private final String clusterName;

    private final String description;

    private final String preferredMaintenanceWindow;

    private final String notificationTopicArn;

    private final String notificationTopicStatus;

    private final String parameterGroupName;

    private final List<String> securityGroupIds;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.parameterGroupName = builder.parameterGroupName;
        this.securityGroupIds = builder.securityGroupIds;
    }

    /**
     * <p>
     * The name of the DAX cluster to be modified.
     * </p>
     * 
     * @return The name of the DAX cluster to be modified.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * A description of the changes being made to the cluster.
     * </p>
     * 
     * @return A description of the changes being made to the cluster.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A range of time when maintenance of DAX cluster software will be performed. For example:
     * <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed
     * automatically within the maintenance window.
     * </p>
     * 
     * @return A range of time when maintenance of DAX cluster software will be performed. For example:
     *         <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is
     *         performed automatically within the maintenance window.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the topic.
     */
    public String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * The current state of the topic.
     * </p>
     * 
     * @return The current state of the topic.
     */
    public String notificationTopicStatus() {
        return notificationTopicStatus;
    }

    /**
     * <p>
     * The name of a parameter group for this cluster.
     * </p>
     * 
     * @return The name of a parameter group for this cluster.
     */
    public String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is
     * not specified, DAX assigns the default VPC security group to each node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this
     *         parameter is not specified, DAX assigns the default VPC security group to each node.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(description(), other.description())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(notificationTopicStatus(), other.notificationTopicStatus())
                && Objects.equals(parameterGroupName(), other.parameterGroupName())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateClusterRequest").add("ClusterName", clusterName()).add("Description", description())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("NotificationTopicArn", notificationTopicArn()).add("NotificationTopicStatus", notificationTopicStatus())
                .add("ParameterGroupName", parameterGroupName())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "NotificationTopicStatus":
            return Optional.ofNullable(clazz.cast(notificationTopicStatus()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The name of the DAX cluster to be modified.
         * </p>
         * 
         * @param clusterName
         *        The name of the DAX cluster to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A description of the changes being made to the cluster.
         * </p>
         * 
         * @param description
         *        A description of the changes being made to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A range of time when maintenance of DAX cluster software will be performed. For example:
         * <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed
         * automatically within the maintenance window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        A range of time when maintenance of DAX cluster software will be performed. For example:
         *        <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is
         *        performed automatically within the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the topic.
         * </p>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) that identifies the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * The current state of the topic.
         * </p>
         * 
         * @param notificationTopicStatus
         *        The current state of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicStatus(String notificationTopicStatus);

        /**
         * <p>
         * The name of a parameter group for this cluster.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of a parameter group for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter
         * is not specified, DAX assigns the default VPC security group to each node.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this
         *        parameter is not specified, DAX assigns the default VPC security group to each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter
         * is not specified, DAX assigns the default VPC security group to each node.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this
         *        parameter is not specified, DAX assigns the default VPC security group to each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String description;

        private String preferredMaintenanceWindow;

        private String notificationTopicArn;

        private String notificationTopicStatus;

        private String parameterGroupName;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            description(model.description);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            notificationTopicArn(model.notificationTopicArn);
            notificationTopicStatus(model.notificationTopicStatus);
            parameterGroupName(model.parameterGroupName);
            securityGroupIds(model.securityGroupIds);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getNotificationTopicStatus() {
            return notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
