/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers
 * using Amazon Simple Notification Service (SNS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(NotificationConfiguration::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicStatus").getter(getter(NotificationConfiguration::topicStatus))
            .setter(setter(Builder::topicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            TOPIC_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topicArn;

    private final String topicStatus;

    private NotificationConfiguration(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.topicStatus = builder.topicStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the topic.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The current state of the topic.
     * </p>
     * 
     * @return The current state of the topic.
     */
    public final String topicStatus() {
        return topicStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(topicStatus(), other.topicStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration").add("TopicArn", topicArn()).add("TopicStatus", topicStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "TopicStatus":
            return Optional.ofNullable(clazz.cast(topicStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) that identifies the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The current state of the topic.
         * </p>
         * 
         * @param topicStatus
         *        The current state of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicStatus(String topicStatus);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String topicStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            topicArn(model.topicArn);
            topicStatus(model.topicStatus);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getTopicStatus() {
            return topicStatus;
        }

        @Override
        public final Builder topicStatus(String topicStatus) {
            this.topicStatus = topicStatus;
            return this;
        }

        public final void setTopicStatus(String topicStatus) {
            this.topicStatus = topicStatus;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
