/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends DaxRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(CreateClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateClusterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicationFactor").getter(getter(CreateClusterRequest::replicationFactor))
            .setter(setter(Builder::replicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationFactor").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateClusterRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(CreateClusterRequest::subnetGroupName))
            .setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(CreateClusterRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(CreateClusterRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(CreateClusterRequest::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).memberName("SSESpecification")
            .getter(getter(CreateClusterRequest::sseSpecification)).setter(setter(Builder::sseSpecification))
            .constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()).build();

    private static final SdkField<String> CLUSTER_ENDPOINT_ENCRYPTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClusterEndpointEncryptionType")
            .getter(getter(CreateClusterRequest::clusterEndpointEncryptionTypeAsString))
            .setter(setter(Builder::clusterEndpointEncryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpointEncryptionType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODE_TYPE_FIELD, DESCRIPTION_FIELD, REPLICATION_FACTOR_FIELD, AVAILABILITY_ZONES_FIELD, SUBNET_GROUP_NAME_FIELD,
            SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, IAM_ROLE_ARN_FIELD,
            PARAMETER_GROUP_NAME_FIELD, TAGS_FIELD, SSE_SPECIFICATION_FIELD, CLUSTER_ENDPOINT_ENCRYPTION_TYPE_FIELD));

    private final String clusterName;

    private final String nodeType;

    private final String description;

    private final Integer replicationFactor;

    private final List<String> availabilityZones;

    private final String subnetGroupName;

    private final List<String> securityGroupIds;

    private final String preferredMaintenanceWindow;

    private final String notificationTopicArn;

    private final String iamRoleArn;

    private final String parameterGroupName;

    private final List<Tag> tags;

    private final SSESpecification sseSpecification;

    private final String clusterEndpointEncryptionType;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeType = builder.nodeType;
        this.description = builder.description;
        this.replicationFactor = builder.replicationFactor;
        this.availabilityZones = builder.availabilityZones;
        this.subnetGroupName = builder.subnetGroupName;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.parameterGroupName = builder.parameterGroupName;
        this.tags = builder.tags;
        this.sseSpecification = builder.sseSpecification;
        this.clusterEndpointEncryptionType = builder.clusterEndpointEncryptionType;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * <b>Constraints:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 20 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The cluster identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         <b>Constraints:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 20 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the cluster.
     * </p>
     * 
     * @return The compute and memory capacity of the nodes in the cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * A description of the cluster.
     * </p>
     * 
     * @return A description of the cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any
     * read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read
     * replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one primary and two read
     * replicas) and 10 (one primary and nine read replicas). <code>If the AvailabilityZones</code> parameter is
     * provided, its length must equal the <code>ReplicationFactor</code>.
     * </p>
     * <note>
     * <p>
     * AWS recommends that you have at least two read replicas per cluster.
     * </p>
     * </note>
     * 
     * @return The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster,
     *         without any read replicas. For additional fault tolerance, you can create a multiple node cluster with
     *         one or more read replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one
     *         primary and two read replicas) and 10 (one primary and nine read replicas).
     *         <code>If the AvailabilityZones</code> parameter is provided, its length must equal the
     *         <code>ReplicationFactor</code>.</p> <note>
     *         <p>
     *         AWS recommends that you have at least two read replicas per cluster.
     *         </p>
     */
    public final Integer replicationFactor() {
        return replicationFactor;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or
     * updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If you
     * omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or
     *         updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If
     *         you omit this parameter, DAX will spread the nodes across Availability Zones for the highest
     *         availability.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The name of the subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group
     * must exist in the same VPC.
     * </p>
     * </important>
     * 
     * @return The name of the subnet group to be used for the replication group.</p> <important>
     *         <p>
     *         DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet
     *         group must exist in the same VPC.
     *         </p>
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is
     * system-generated.)
     * </p>
     * <p>
     * If this parameter is not specified, DAX assigns the default VPC security group to each node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group
     *         ID is system-generated.)</p>
     *         <p>
     *         If this parameter is not specified, DAX assigns the default VPC security group to each node.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a
     * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
     * period. Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:05:00-sun:09:00</code>
     * </p>
     * <note>
     * <p>
     * If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a
     * 60-minute maintenance window on a randomly selected day of the week.
     * </p>
     * </note>
     * 
     * @return Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified
     *         as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period. Valid values for <code>ddd</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:05:00-sun:09:00</code>
     *         </p>
     *         <note>
     *         <p>
     *         If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX
     *         assigns a 60-minute maintenance window on a randomly selected day of the week.
     *         </p>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be same as the DAX cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be same as the DAX cluster owner.
     *         </p>
     */
    public final String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the
     * role's permissions to access DynamoDB on your behalf.
     * </p>
     * 
     * @return A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and
     *         use the role's permissions to access DynamoDB on your behalf.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The parameter group to be associated with the DAX cluster.
     * </p>
     * 
     * @return The parameter group to be associated with the DAX cluster.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags to associate with the DAX cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of tags to associate with the DAX cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Represents the settings used to enable server-side encryption on the cluster.
     * </p>
     * 
     * @return Represents the settings used to enable server-side encryption on the cluster.
     */
    public final SSESpecification sseSpecification() {
        return sseSpecification;
    }

    /**
     * <p>
     * The type of encryption the cluster's endpoint should support. Values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> for no encryption
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code> for Transport Layer Security
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clusterEndpointEncryptionType} will return {@link ClusterEndpointEncryptionType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #clusterEndpointEncryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption the cluster's endpoint should support. Values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> for no encryption
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code> for Transport Layer Security
     *         </p>
     *         </li>
     * @see ClusterEndpointEncryptionType
     */
    public final ClusterEndpointEncryptionType clusterEndpointEncryptionType() {
        return ClusterEndpointEncryptionType.fromValue(clusterEndpointEncryptionType);
    }

    /**
     * <p>
     * The type of encryption the cluster's endpoint should support. Values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> for no encryption
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code> for Transport Layer Security
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clusterEndpointEncryptionType} will return {@link ClusterEndpointEncryptionType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #clusterEndpointEncryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption the cluster's endpoint should support. Values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> for no encryption
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code> for Transport Layer Security
     *         </p>
     *         </li>
     * @see ClusterEndpointEncryptionType
     */
    public final String clusterEndpointEncryptionTypeAsString() {
        return clusterEndpointEncryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpointEncryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(description(), other.description())
                && Objects.equals(replicationFactor(), other.replicationFactor())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(subnetGroupName(), other.subnetGroupName())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(parameterGroupName(), other.parameterGroupName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(sseSpecification(), other.sseSpecification())
                && Objects.equals(clusterEndpointEncryptionTypeAsString(), other.clusterEndpointEncryptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("ClusterName", clusterName()).add("NodeType", nodeType())
                .add("Description", description()).add("ReplicationFactor", replicationFactor())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("SubnetGroupName", subnetGroupName())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("NotificationTopicArn", notificationTopicArn()).add("IamRoleArn", iamRoleArn())
                .add("ParameterGroupName", parameterGroupName()).add("Tags", hasTags() ? tags() : null)
                .add("SSESpecification", sseSpecification())
                .add("ClusterEndpointEncryptionType", clusterEndpointEncryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ReplicationFactor":
            return Optional.ofNullable(clazz.cast(replicationFactor()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SSESpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "ClusterEndpointEncryptionType":
            return Optional.ofNullable(clazz.cast(clusterEndpointEncryptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * <b>Constraints:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A name must contain from 1 to 20 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * A name cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterName
         *        The cluster identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        <b>Constraints:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A name must contain from 1 to 20 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A name cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The compute and memory capacity of the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * A description of the cluster.
         * </p>
         * 
         * @param description
         *        A description of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without
         * any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more
         * read replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one primary and two read
         * replicas) and 10 (one primary and nine read replicas). <code>If the AvailabilityZones</code> parameter is
         * provided, its length must equal the <code>ReplicationFactor</code>.
         * </p>
         * <note>
         * <p>
         * AWS recommends that you have at least two read replicas per cluster.
         * </p>
         * </note>
         * 
         * @param replicationFactor
         *        The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster,
         *        without any read replicas. For additional fault tolerance, you can create a multiple node cluster with
         *        one or more read replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one
         *        primary and two read replicas) and 10 (one primary and nine read replicas).
         *        <code>If the AvailabilityZones</code> parameter is provided, its length must equal the
         *        <code>ReplicationFactor</code>.</p> <note>
         *        <p>
         *        AWS recommends that you have at least two read replicas per cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationFactor(Integer replicationFactor);

        /**
         * <p>
         * The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or
         * updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If you
         * omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created
         *        or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code>
         *        parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the
         *        highest availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or
         * updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If you
         * omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created
         *        or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code>
         *        parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the
         *        highest availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The name of the subnet group to be used for the replication group.
         * </p>
         * <important>
         * <p>
         * DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group
         * must exist in the same VPC.
         * </p>
         * </important>
         * 
         * @param subnetGroupName
         *        The name of the subnet group to be used for the replication group.</p> <important>
         *        <p>
         *        DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a
         *        subnet group must exist in the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID
         * is system-generated.)
         * </p>
         * <p>
         * If this parameter is not specified, DAX assigns the default VPC security group to each node.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security
         *        group ID is system-generated.)</p>
         *        <p>
         *        If this parameter is not specified, DAX assigns the default VPC security group to each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID
         * is system-generated.)
         * </p>
         * <p>
         * If this parameter is not specified, DAX assigns the default VPC security group to each node.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security
         *        group ID is system-generated.)</p>
         *        <p>
         *        If this parameter is not specified, DAX assigns the default VPC security group to each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as
         * a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period. Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:05:00-sun:09:00</code>
         * </p>
         * <note>
         * <p>
         * If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a
         * 60-minute maintenance window on a randomly selected day of the week.
         * </p>
         * </note>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is
         *        specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance
         *        window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:05:00-sun:09:00</code>
         *        </p>
         *        <note>
         *        <p>
         *        If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX
         *        assigns a 60-minute maintenance window on a randomly selected day of the week.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be same as the DAX cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be same as the DAX cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use
         * the role's permissions to access DynamoDB on your behalf.
         * </p>
         * 
         * @param iamRoleArn
         *        A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role
         *        and use the role's permissions to access DynamoDB on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The parameter group to be associated with the DAX cluster.
         * </p>
         * 
         * @param parameterGroupName
         *        The parameter group to be associated with the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * A set of tags to associate with the DAX cluster.
         * </p>
         * 
         * @param tags
         *        A set of tags to associate with the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A set of tags to associate with the DAX cluster.
         * </p>
         * 
         * @param tags
         *        A set of tags to associate with the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A set of tags to associate with the DAX cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Represents the settings used to enable server-side encryption on the cluster.
         * </p>
         * 
         * @param sseSpecification
         *        Represents the settings used to enable server-side encryption on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(SSESpecification sseSpecification);

        /**
         * <p>
         * Represents the settings used to enable server-side encryption on the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link SSESpecification.Builder} avoiding the need to
         * create one manually via {@link SSESpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecification(SSESpecification)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(SSESpecification)
         */
        default Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return sseSpecification(SSESpecification.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * The type of encryption the cluster's endpoint should support. Values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> for no encryption
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code> for Transport Layer Security
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterEndpointEncryptionType
         *        The type of encryption the cluster's endpoint should support. Values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> for no encryption
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code> for Transport Layer Security
         *        </p>
         *        </li>
         * @see ClusterEndpointEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEndpointEncryptionType
         */
        Builder clusterEndpointEncryptionType(String clusterEndpointEncryptionType);

        /**
         * <p>
         * The type of encryption the cluster's endpoint should support. Values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> for no encryption
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code> for Transport Layer Security
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterEndpointEncryptionType
         *        The type of encryption the cluster's endpoint should support. Values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> for no encryption
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code> for Transport Layer Security
         *        </p>
         *        </li>
         * @see ClusterEndpointEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEndpointEncryptionType
         */
        Builder clusterEndpointEncryptionType(ClusterEndpointEncryptionType clusterEndpointEncryptionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodeType;

        private String description;

        private Integer replicationFactor;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String subnetGroupName;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private String notificationTopicArn;

        private String iamRoleArn;

        private String parameterGroupName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SSESpecification sseSpecification;

        private String clusterEndpointEncryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodeType(model.nodeType);
            description(model.description);
            replicationFactor(model.replicationFactor);
            availabilityZones(model.availabilityZones);
            subnetGroupName(model.subnetGroupName);
            securityGroupIds(model.securityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            notificationTopicArn(model.notificationTopicArn);
            iamRoleArn(model.iamRoleArn);
            parameterGroupName(model.parameterGroupName);
            tags(model.tags);
            sseSpecification(model.sseSpecification);
            clusterEndpointEncryptionType(model.clusterEndpointEncryptionType);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getReplicationFactor() {
            return replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final SSESpecification.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        public final String getClusterEndpointEncryptionType() {
            return clusterEndpointEncryptionType;
        }

        @Override
        public final Builder clusterEndpointEncryptionType(String clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType = clusterEndpointEncryptionType;
            return this;
        }

        @Override
        public final Builder clusterEndpointEncryptionType(ClusterEndpointEncryptionType clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType(clusterEndpointEncryptionType == null ? null : clusterEndpointEncryptionType
                    .toString());
            return this;
        }

        public final void setClusterEndpointEncryptionType(String clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType = clusterEndpointEncryptionType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
