/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubnetGroupResponse extends DaxResponse implements
        ToCopyableBuilder<CreateSubnetGroupResponse.Builder, CreateSubnetGroupResponse> {
    private static final SdkField<SubnetGroup> SUBNET_GROUP_FIELD = SdkField.<SubnetGroup> builder(MarshallingType.SDK_POJO)
            .memberName("SubnetGroup").getter(getter(CreateSubnetGroupResponse::subnetGroup))
            .setter(setter(Builder::subnetGroup)).constructor(SubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_GROUP_FIELD));

    private final SubnetGroup subnetGroup;

    private CreateSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.subnetGroup = builder.subnetGroup;
    }

    /**
     * <p>
     * Represents the output of a <i>CreateSubnetGroup</i> operation.
     * </p>
     * 
     * @return Represents the output of a <i>CreateSubnetGroup</i> operation.
     */
    public final SubnetGroup subnetGroup() {
        return subnetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetGroupResponse)) {
            return false;
        }
        CreateSubnetGroupResponse other = (CreateSubnetGroupResponse) obj;
        return Objects.equals(subnetGroup(), other.subnetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubnetGroupResponse").add("SubnetGroup", subnetGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetGroup":
            return Optional.ofNullable(clazz.cast(subnetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetGroupResponse, T> g) {
        return obj -> g.apply((CreateSubnetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubnetGroupResponse> {
        /**
         * <p>
         * Represents the output of a <i>CreateSubnetGroup</i> operation.
         * </p>
         * 
         * @param subnetGroup
         *        Represents the output of a <i>CreateSubnetGroup</i> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroup(SubnetGroup subnetGroup);

        /**
         * <p>
         * Represents the output of a <i>CreateSubnetGroup</i> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubnetGroup.Builder} avoiding the need to
         * create one manually via {@link SubnetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubnetGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #subnetGroup(SubnetGroup)}.
         * 
         * @param subnetGroup
         *        a consumer that will call methods on {@link SubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetGroup(SubnetGroup)
         */
        default Builder subnetGroup(Consumer<SubnetGroup.Builder> subnetGroup) {
            return subnetGroup(SubnetGroup.builder().applyMutation(subnetGroup).build());
        }
    }

    static final class BuilderImpl extends DaxResponse.BuilderImpl implements Builder {
        private SubnetGroup subnetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetGroupResponse model) {
            super(model);
            subnetGroup(model.subnetGroup);
        }

        public final SubnetGroup.Builder getSubnetGroup() {
            return subnetGroup != null ? subnetGroup.toBuilder() : null;
        }

        public final void setSubnetGroup(SubnetGroup.BuilderImpl subnetGroup) {
            this.subnetGroup = subnetGroup != null ? subnetGroup.build() : null;
        }

        @Override
        public final Builder subnetGroup(SubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        @Override
        public CreateSubnetGroupResponse build() {
            return new CreateSubnetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
