/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of one of the following actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>CreateSubnetGroup</i>
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>ModifySubnetGroup</i>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetGroup implements SdkPojo, Serializable, ToCopyableBuilder<SubnetGroup.Builder, SubnetGroup> {
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(SubnetGroup::subnetGroupName)).setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SubnetGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(SubnetGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField
            .<List<Subnet>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(SubnetGroup::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subnet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subnet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_GROUP_NAME_FIELD,
            DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetGroupName;

    private final String description;

    private final String vpcId;

    private final List<Subnet> subnets;

    private SubnetGroup(BuilderImpl builder) {
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
    }

    /**
     * <p>
     * The name of the subnet group.
     * </p>
     * 
     * @return The name of the subnet group.
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * <p>
     * The description of the subnet group.
     * </p>
     * 
     * @return The description of the subnet group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
     * </p>
     * 
     * @return The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnets associated with the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return A list of subnets associated with the subnet group.
     */
    public final List<Subnet> subnets() {
        return subnets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetGroup)) {
            return false;
        }
        SubnetGroup other = (SubnetGroup) obj;
        return Objects.equals(subnetGroupName(), other.subnetGroupName()) && Objects.equals(description(), other.description())
                && Objects.equals(vpcId(), other.vpcId()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetGroup").add("SubnetGroupName", subnetGroupName()).add("Description", description())
                .add("VpcId", vpcId()).add("Subnets", hasSubnets() ? subnets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetGroup, T> g) {
        return obj -> g.apply((SubnetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetGroup> {
        /**
         * <p>
         * The name of the subnet group.
         * </p>
         * 
         * @param subnetGroupName
         *        The name of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * The description of the subnet group.
         * </p>
         * 
         * @param description
         *        The description of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
         * </p>
         * 
         * @param vpcId
         *        The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of subnets associated with the subnet group.
         * </p>
         * 
         * @param subnets
         *        A list of subnets associated with the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<Subnet> subnets);

        /**
         * <p>
         * A list of subnets associated with the subnet group.
         * </p>
         * 
         * @param subnets
         *        A list of subnets associated with the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Subnet... subnets);

        /**
         * <p>
         * A list of subnets associated with the subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Subnet>.Builder} avoiding the need to
         * create one manually via {@link List<Subnet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subnet>.Builder#build()} is called immediately and its
         * result is passed to {@link #subnets(List<Subnet>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on {@link List<Subnet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(List<Subnet>)
         */
        Builder subnets(Consumer<Subnet.Builder>... subnets);
    }

    static final class BuilderImpl implements Builder {
        private String subnetGroupName;

        private String description;

        private String vpcId;

        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetGroup model) {
            subnetGroupName(model.subnetGroupName);
            description(model.description);
            vpcId(model.vpcId);
            subnets(model.subnets);
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        @Transient
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(Subnet... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> Subnet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SubnetGroup build() {
            return new SubnetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
