/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;
import software.amazon.awssdk.services.dax.model.CreateClusterResponse;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dax.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DescribeClustersRequest;
import software.amazon.awssdk.services.dax.model.DescribeClustersResponse;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeEventsRequest;
import software.amazon.awssdk.services.dax.model.DescribeEventsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.ListTagsRequest;
import software.amazon.awssdk.services.dax.model.ListTagsResponse;
import software.amazon.awssdk.services.dax.model.RebootNodeRequest;
import software.amazon.awssdk.services.dax.model.RebootNodeResponse;
import software.amazon.awssdk.services.dax.model.TagResourceRequest;
import software.amazon.awssdk.services.dax.model.TagResourceResponse;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.services.dax.model.UntagResourceResponse;
import software.amazon.awssdk.services.dax.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dax.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse;

/**
 * Service client for accessing Amazon DAX asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * DAX is a managed caching service engineered for Amazon DynamoDB. DAX dramatically speeds up database reads by caching
 * frequently-accessed data from DynamoDB, so applications can access that data with sub-millisecond latency. You can
 * create a DAX cluster easily, using the AWS Management Console. With a few simple modifications to your code, your
 * application can begin taking advantage of the DAX cluster and realize significant improvements in read performance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DaxAsyncClient extends AwsClient {
    String SERVICE_NAME = "dax";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "dax";

    /**
     * <p>
     * Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException You already have a DAX cluster with the given identifier.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>InsufficientClusterCapacityException There are not enough system resources to create the cluster you
     *         requested (or to resize an already-existing cluster).</li>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ClusterQuotaForCustomerExceededException You have attempted to exceed the maximum number of DAX
     *         clusters for your AWS account.</li>
     *         <li>NodeQuotaForClusterExceededException You have attempted to exceed the maximum number of nodes for a
     *         DAX cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException You have attempted to exceed the maximum number of nodes for
     *         your AWS account.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException You have exceeded the maximum number of tags for this DAX
     *         cluster.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>ServiceQuotaExceededException You have reached the maximum number of x509 certificates that can be
     *         created for encrypted clusters in a 30 day period. Contact AWS customer support to discuss options for
     *         continuing to create encrypted clusters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException You already have a DAX cluster with the given identifier.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>InsufficientClusterCapacityException There are not enough system resources to create the cluster you
     *         requested (or to resize an already-existing cluster).</li>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ClusterQuotaForCustomerExceededException You have attempted to exceed the maximum number of DAX
     *         clusters for your AWS account.</li>
     *         <li>NodeQuotaForClusterExceededException You have attempted to exceed the maximum number of nodes for a
     *         DAX cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException You have attempted to exceed the maximum number of nodes for
     *         your AWS account.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException You have exceeded the maximum number of tags for this DAX
     *         cluster.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>ServiceQuotaExceededException You have reached the maximum number of x509 certificates that can be
     *         created for encrypted clusters in a 30 day period. Contact AWS customer support to discuss options for
     *         continuing to create encrypted clusters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes
     * in a DAX cluster.
     * </p>
     *
     * @param createParameterGroupRequest
     * @return A Java Future containing the result of the CreateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupQuotaExceededException You have attempted to exceed the maximum number of parameter
     *         groups.</li>
     *         <li>ParameterGroupAlreadyExistsException The specified parameter group already exists.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateParameterGroupResponse> createParameterGroup(
            CreateParameterGroupRequest createParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes
     * in a DAX cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParameterGroupRequest#builder()}
     * </p>
     *
     * @param createParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupQuotaExceededException You have attempted to exceed the maximum number of parameter
     *         groups.</li>
     *         <li>ParameterGroupAlreadyExistsException The specified parameter group already exists.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateParameterGroupResponse> createParameterGroup(
            Consumer<CreateParameterGroupRequest.Builder> createParameterGroupRequest) {
        return createParameterGroup(CreateParameterGroupRequest.builder().applyMutation(createParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new subnet group.
     * </p>
     *
     * @param createSubnetGroupRequest
     * @return A Java Future containing the result of the CreateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupAlreadyExistsException The specified subnet group already exists.</li>
     *         <li>SubnetGroupQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>SubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupAlreadyExistsException The specified subnet group already exists.</li>
     *         <li>SubnetGroupQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>SubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(
            Consumer<CreateSubnetGroupRequest.Builder> createSubnetGroupRequest) {
        return createSubnetGroup(CreateSubnetGroupRequest.builder().applyMutation(createSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Removes one or more nodes from a DAX cluster.
     * </p>
     * <note>
     * <p>
     * You cannot use <code>DecreaseReplicationFactor</code> to remove the last node in a DAX cluster. If you need to do
     * this, use <code>DeleteCluster</code> instead.
     * </p>
     * </note>
     *
     * @param decreaseReplicationFactorRequest
     * @return A Java Future containing the result of the DecreaseReplicationFactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>NodeNotFoundException None of the nodes in the cluster have the given node ID.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DecreaseReplicationFactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DecreaseReplicationFactor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DecreaseReplicationFactorResponse> decreaseReplicationFactor(
            DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more nodes from a DAX cluster.
     * </p>
     * <note>
     * <p>
     * You cannot use <code>DecreaseReplicationFactor</code> to remove the last node in a DAX cluster. If you need to do
     * this, use <code>DeleteCluster</code> instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DecreaseReplicationFactorRequest.Builder} avoiding
     * the need to create one manually via {@link DecreaseReplicationFactorRequest#builder()}
     * </p>
     *
     * @param decreaseReplicationFactorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DecreaseReplicationFactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>NodeNotFoundException None of the nodes in the cluster have the given node ID.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DecreaseReplicationFactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DecreaseReplicationFactor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DecreaseReplicationFactorResponse> decreaseReplicationFactor(
            Consumer<DecreaseReplicationFactorRequest.Builder> decreaseReplicationFactorRequest) {
        return decreaseReplicationFactor(DecreaseReplicationFactorRequest.builder()
                .applyMutation(decreaseReplicationFactorRequest).build());
    }

    /**
     * <p>
     * Deletes a previously provisioned DAX cluster. <i>DeleteCluster</i> deletes all associated nodes, node endpoints
     * and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins
     * deleting the cluster; you cannot cancel or revert this action.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned DAX cluster. <i>DeleteCluster</i> deletes all associated nodes, node endpoints
     * and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins
     * deleting the cluster; you cannot cancel or revert this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX
     * clusters.
     * </p>
     *
     * @param deleteParameterGroupRequest
     * @return A Java Future containing the result of the DeleteParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(
            DeleteParameterGroupRequest deleteParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX
     * clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(
            Consumer<DeleteParameterGroupRequest.Builder> deleteParameterGroupRequest) {
        return deleteParameterGroup(DeleteParameterGroupRequest.builder().applyMutation(deleteParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a subnet group if it is associated with any DAX clusters.
     * </p>
     * </note>
     *
     * @param deleteSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupInUseException The specified subnet group is currently in use.</li>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a subnet group if it is associated with any DAX clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupInUseException The specified subnet group is currently in use.</li>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(
            Consumer<DeleteSubnetGroupRequest.Builder> deleteSubnetGroupRequest) {
        return deleteSubnetGroup(DeleteSubnetGroupRequest.builder().applyMutation(deleteSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific
     * DAX cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes
     * are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     * </p>
     * <p>
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the
     * additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @param describeClustersRequest
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific
     * DAX cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes
     * are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     * </p>
     * <p>
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the
     * additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(
            Consumer<DescribeClustersRequest.Builder> describeClustersRequest) {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific
     * DAX cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes
     * are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the DELETING state, only cluster level information will be displayed.
     * </p>
     * <p>
     * If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the
     * additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters() {
        return describeClusters(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns the default system parameter information for the DAX caching software.
     * </p>
     *
     * @param describeDefaultParametersRequest
     * @return A Java Future containing the result of the DescribeDefaultParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeDefaultParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultParametersResponse> describeDefaultParameters(
            DescribeDefaultParametersRequest describeDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default system parameter information for the DAX caching software.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeDefaultParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDefaultParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeDefaultParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultParametersResponse> describeDefaultParameters(
            Consumer<DescribeDefaultParametersRequest.Builder> describeDefaultParametersRequest) {
        return describeDefaultParameters(DescribeDefaultParametersRequest.builder()
                .applyMutation(describeDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default system parameter information for the DAX caching software.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDefaultParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeDefaultParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultParametersResponse> describeDefaultParameters() {
        return describeDefaultParameters(DescribeDefaultParametersRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX
     * cluster or parameter group by providing the name as a parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14
     * days' worth of events if necessary.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX
     * cluster or parameter group by providing the name as a parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14
     * days' worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX
     * cluster or parameter group by providing the name as a parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14
     * days' worth of events if necessary.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain
     * only the descriptions for that group.
     * </p>
     *
     * @param describeParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(
            DescribeParameterGroupsRequest describeParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain
     * only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(
            Consumer<DescribeParameterGroupsRequest.Builder> describeParameterGroupsRequest) {
        return describeParameterGroups(DescribeParameterGroupsRequest.builder().applyMutation(describeParameterGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain
     * only the descriptions for that group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups() {
        return describeParameterGroups(DescribeParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     *
     * @param describeParametersRequest
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeParametersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) {
        return describeParameters(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the
     * description of that group.
     * </p>
     *
     * @param describeSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(
            DescribeSubnetGroupsRequest describeSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the
     * description of that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(
            Consumer<DescribeSubnetGroupsRequest.Builder> describeSubnetGroupsRequest) {
        return describeSubnetGroups(DescribeSubnetGroupsRequest.builder().applyMutation(describeSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the
     * description of that group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups() {
        return describeSubnetGroups(DescribeSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Adds one or more nodes to a DAX cluster.
     * </p>
     *
     * @param increaseReplicationFactorRequest
     * @return A Java Future containing the result of the IncreaseReplicationFactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>InsufficientClusterCapacityException There are not enough system resources to create the cluster you
     *         requested (or to resize an already-existing cluster).</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>NodeQuotaForClusterExceededException You have attempted to exceed the maximum number of nodes for a
     *         DAX cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException You have attempted to exceed the maximum number of nodes for
     *         your AWS account.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.IncreaseReplicationFactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IncreaseReplicationFactorResponse> increaseReplicationFactor(
            IncreaseReplicationFactorRequest increaseReplicationFactorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more nodes to a DAX cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IncreaseReplicationFactorRequest.Builder} avoiding
     * the need to create one manually via {@link IncreaseReplicationFactorRequest#builder()}
     * </p>
     *
     * @param increaseReplicationFactorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the IncreaseReplicationFactor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>InsufficientClusterCapacityException There are not enough system resources to create the cluster you
     *         requested (or to resize an already-existing cluster).</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>NodeQuotaForClusterExceededException You have attempted to exceed the maximum number of nodes for a
     *         DAX cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException You have attempted to exceed the maximum number of nodes for
     *         your AWS account.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.IncreaseReplicationFactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IncreaseReplicationFactorResponse> increaseReplicationFactor(
            Consumer<IncreaseReplicationFactorRequest.Builder> increaseReplicationFactorRequest) {
        return increaseReplicationFactor(IncreaseReplicationFactorRequest.builder()
                .applyMutation(increaseReplicationFactorRequest).build());
    }

    /**
     * <p>
     * List all of the tags for a DAX cluster. You can call <code>ListTags</code> up to 10 times per second, per
     * account.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the tags for a DAX cluster. You can call <code>ListTags</code> up to 10 times per second, per
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the
     * node status is set to REBOOTING.
     * </p>
     * <note>
     * <p>
     * <code>RebootNode</code> restarts the DAX engine process and does not remove the contents of the cache.
     * </p>
     * </note>
     *
     * @param rebootNodeRequest
     * @return A Java Future containing the result of the RebootNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>NodeNotFoundException None of the nodes in the cluster have the given node ID.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.RebootNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/RebootNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootNodeResponse> rebootNode(RebootNodeRequest rebootNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the
     * node status is set to REBOOTING.
     * </p>
     * <note>
     * <p>
     * <code>RebootNode</code> restarts the DAX engine process and does not remove the contents of the cache.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootNodeRequest.Builder} avoiding the need to
     * create one manually via {@link RebootNodeRequest#builder()}
     * </p>
     *
     * @param rebootNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.RebootNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RebootNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>NodeNotFoundException None of the nodes in the cluster have the given node ID.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.RebootNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/RebootNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootNodeResponse> rebootNode(Consumer<RebootNodeRequest.Builder> rebootNodeRequest) {
        return rebootNode(RebootNodeRequest.builder().applyMutation(rebootNodeRequest).build());
    }

    /**
     * <p>
     * Associates a set of tags with a DAX resource. You can call <code>TagResource</code> up to 5 times per second, per
     * account.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>TagQuotaPerResourceExceededException You have exceeded the maximum number of tags for this DAX
     *         cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of tags with a DAX resource. You can call <code>TagResource</code> up to 5 times per second, per
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>TagQuotaPerResourceExceededException You have exceeded the maximum number of tags for this DAX
     *         cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the association of tags from a DAX resource. You can call <code>UntagResource</code> up to 5 times per
     * second, per account.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>TagNotFoundException The tag does not exist.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of tags from a DAX resource. You can call <code>UntagResource</code> up to 5 times per
     * second, per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidArnException The Amazon Resource Name (ARN) supplied in the request is not valid.</li>
     *         <li>TagNotFoundException The tag does not exist.</li>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     *
     * @param updateClusterRequest
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.UpdateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The requested DAX cluster is not in the <i>available</i> state.</li>
     *         <li>ClusterNotFoundException The requested cluster ID does not refer to an existing DAX cluster.</li>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     *
     * @param updateParameterGroupRequest
     * @return A Java Future containing the result of the UpdateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(
            UpdateParameterGroupRequest updateParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateParameterGroupRequest#builder()}
     * </p>
     *
     * @param updateParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException One or more parameters in a parameter group are in an invalid
     *         state.</li>
     *         <li>ParameterGroupNotFoundException The specified parameter group does not exist.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(
            Consumer<UpdateParameterGroupRequest.Builder> updateParameterGroupRequest) {
        return updateParameterGroup(UpdateParameterGroupRequest.builder().applyMutation(updateParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies an existing subnet group.
     * </p>
     *
     * @param updateSubnetGroupRequest
     * @return A Java Future containing the result of the UpdateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>SubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>SubnetInUseException The requested subnet is being used by another subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param updateSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException The requested subnet group name does not refer to an existing subnet
     *         group.</li>
     *         <li>SubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a subnet group.</li>
     *         <li>SubnetInUseException The requested subnet is being used by another subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DaxException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample DaxAsyncClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(
            Consumer<UpdateSubnetGroupRequest.Builder> updateSubnetGroupRequest) {
        return updateSubnetGroup(UpdateSubnetGroupRequest.builder().applyMutation(updateSubnetGroupRequest).build());
    }

    @Override
    default DaxServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DaxAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DaxAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DaxAsyncClient}.
     */
    static DaxAsyncClientBuilder builder() {
        return new DefaultDaxAsyncClientBuilder();
    }
}
