/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeParameterGroupsResponse extends DaxResponse implements
        ToCopyableBuilder<DescribeParameterGroupsResponse.Builder, DescribeParameterGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeParameterGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ParameterGroup>> PARAMETER_GROUPS_FIELD = SdkField
            .<List<ParameterGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeParameterGroupsResponse::parameterGroups))
            .setter(setter(Builder::parameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PARAMETER_GROUPS_FIELD));

    private final String nextToken;

    private final List<ParameterGroup> parameterGroups;

    private DescribeParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.parameterGroups = builder.parameterGroups;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An array of parameter groups. Each element in the array represents one parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of parameter groups. Each element in the array represents one parameter group.
     */
    public List<ParameterGroup> parameterGroups() {
        return parameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsResponse)) {
            return false;
        }
        DescribeParameterGroupsResponse other = (DescribeParameterGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(parameterGroups(), other.parameterGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeParameterGroupsResponse").add("NextToken", nextToken())
                .add("ParameterGroups", parameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ParameterGroups":
            return Optional.ofNullable(clazz.cast(parameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeParameterGroupsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param nextToken
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of parameter groups. Each element in the array represents one parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        An array of parameter groups. Each element in the array represents one parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(Collection<ParameterGroup> parameterGroups);

        /**
         * <p>
         * An array of parameter groups. Each element in the array represents one parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        An array of parameter groups. Each element in the array represents one parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(ParameterGroup... parameterGroups);

        /**
         * <p>
         * An array of parameter groups. Each element in the array represents one parameter group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterGroup>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterGroups(List<ParameterGroup>)}.
         * 
         * @param parameterGroups
         *        a consumer that will call methods on {@link List<ParameterGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterGroups(List<ParameterGroup>)
         */
        Builder parameterGroups(Consumer<ParameterGroup.Builder>... parameterGroups);
    }

    static final class BuilderImpl extends DaxResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ParameterGroup> parameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            parameterGroups(model.parameterGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ParameterGroup.Builder> getParameterGroups() {
            return parameterGroups != null ? parameterGroups.stream().map(ParameterGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder parameterGroups(Collection<ParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ParameterGroup... parameterGroups) {
            parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ParameterGroup.Builder>... parameterGroups) {
            parameterGroups(Stream.of(parameterGroups).map(c -> ParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterGroups(Collection<ParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public DescribeParameterGroupsResponse build() {
            return new DescribeParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
