/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an individual setting that controls some aspect of DAX behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements SdkPojo, Serializable, ToCopyableBuilder<Parameter.Builder, Parameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::parameterTypeAsString)).setter(setter(Builder::parameterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterType").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::parameterValue)).setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final SdkField<List<NodeTypeSpecificValue>> NODE_TYPE_SPECIFIC_VALUES_FIELD = SdkField
            .<List<NodeTypeSpecificValue>> builder(MarshallingType.LIST)
            .getter(getter(Parameter::nodeTypeSpecificValues))
            .setter(setter(Builder::nodeTypeSpecificValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeTypeSpecificValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeTypeSpecificValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeTypeSpecificValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::allowedValues)).setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final SdkField<String> IS_MODIFIABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::isModifiableAsString)).setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Parameter::changeTypeAsString)).setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_TYPE_FIELD, PARAMETER_VALUE_FIELD, NODE_TYPE_SPECIFIC_VALUES_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD,
            DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD, CHANGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterType;

    private final String parameterValue;

    private final List<NodeTypeSpecificValue> nodeTypeSpecificValues;

    private final String description;

    private final String source;

    private final String dataType;

    private final String allowedValues;

    private final String isModifiable;

    private final String changeType;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
        this.nodeTypeSpecificValues = builder.nodeTypeSpecificValues;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.changeType = builder.changeType;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterType}
     * will return {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parameterTypeAsString}.
     * </p>
     * 
     * @return Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
     * @see ParameterType
     */
    public ParameterType parameterType() {
        return ParameterType.fromValue(parameterType);
    }

    /**
     * <p>
     * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterType}
     * will return {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parameterTypeAsString}.
     * </p>
     * 
     * @return Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
     * @see ParameterType
     */
    public String parameterTypeAsString() {
        return parameterType;
    }

    /**
     * <p>
     * The value for the parameter.
     * </p>
     * 
     * @return The value for the parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    /**
     * <p>
     * A list of node types, and specific parameter values for each node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of node types, and specific parameter values for each node.
     */
    public List<NodeTypeSpecificValue> nodeTypeSpecificValues() {
        return nodeTypeSpecificValues;
    }

    /**
     * <p>
     * A description of the parameter
     * </p>
     * 
     * @return A description of the parameter
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.
     * </p>
     * 
     * @return How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.
     */
    public String source() {
        return source;
    }

    /**
     * <p>
     * The data type of the parameter. For example, <code>integer</code>:
     * </p>
     * 
     * @return The data type of the parameter. For example, <code>integer</code>:
     */
    public String dataType() {
        return dataType;
    }

    /**
     * <p>
     * A range of values within which the parameter can be set.
     * </p>
     * 
     * @return A range of values within which the parameter can be set.
     */
    public String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Whether the customer is allowed to modify the parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isModifiable} will
     * return {@link IsModifiable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #isModifiableAsString}.
     * </p>
     * 
     * @return Whether the customer is allowed to modify the parameter.
     * @see IsModifiable
     */
    public IsModifiable isModifiable() {
        return IsModifiable.fromValue(isModifiable);
    }

    /**
     * <p>
     * Whether the customer is allowed to modify the parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isModifiable} will
     * return {@link IsModifiable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #isModifiableAsString}.
     * </p>
     * 
     * @return Whether the customer is allowed to modify the parameter.
     * @see IsModifiable
     */
    public String isModifiableAsString() {
        return isModifiable;
    }

    /**
     * <p>
     * The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code>
     * indicates that a new value for this parameter will only take effect if a node is rebooted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return The conditions under which changes to this parameter can be applied. For example,
     *         <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a
     *         node is rebooted.
     * @see ChangeType
     */
    public ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code>
     * indicates that a new value for this parameter will only take effect if a node is rebooted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return The conditions under which changes to this parameter can be applied. For example,
     *         <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a
     *         node is rebooted.
     * @see ChangeType
     */
    public String changeTypeAsString() {
        return changeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeSpecificValues());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(parameterTypeAsString(), other.parameterTypeAsString())
                && Objects.equals(parameterValue(), other.parameterValue())
                && Objects.equals(nodeTypeSpecificValues(), other.nodeTypeSpecificValues())
                && Objects.equals(description(), other.description()) && Objects.equals(source(), other.source())
                && Objects.equals(dataType(), other.dataType()) && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(isModifiableAsString(), other.isModifiableAsString())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Parameter").add("ParameterName", parameterName()).add("ParameterType", parameterTypeAsString())
                .add("ParameterValue", parameterValue()).add("NodeTypeSpecificValues", nodeTypeSpecificValues())
                .add("Description", description()).add("Source", source()).add("DataType", dataType())
                .add("AllowedValues", allowedValues()).add("IsModifiable", isModifiableAsString())
                .add("ChangeType", changeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "ParameterType":
            return Optional.ofNullable(clazz.cast(parameterTypeAsString()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        case "NodeTypeSpecificValues":
            return Optional.ofNullable(clazz.cast(nodeTypeSpecificValues()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "IsModifiable":
            return Optional.ofNullable(clazz.cast(isModifiableAsString()));
        case "ChangeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
         * </p>
         * 
         * @param parameterType
         *        Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder parameterType(String parameterType);

        /**
         * <p>
         * Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
         * </p>
         * 
         * @param parameterType
         *        Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder parameterType(ParameterType parameterType);

        /**
         * <p>
         * The value for the parameter.
         * </p>
         * 
         * @param parameterValue
         *        The value for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);

        /**
         * <p>
         * A list of node types, and specific parameter values for each node.
         * </p>
         * 
         * @param nodeTypeSpecificValues
         *        A list of node types, and specific parameter values for each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues);

        /**
         * <p>
         * A list of node types, and specific parameter values for each node.
         * </p>
         * 
         * @param nodeTypeSpecificValues
         *        A list of node types, and specific parameter values for each node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeTypeSpecificValues(NodeTypeSpecificValue... nodeTypeSpecificValues);

        /**
         * <p>
         * A list of node types, and specific parameter values for each node.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeTypeSpecificValue>.Builder} avoiding
         * the need to create one manually via {@link List<NodeTypeSpecificValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeTypeSpecificValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeTypeSpecificValues(List<NodeTypeSpecificValue>)}.
         * 
         * @param nodeTypeSpecificValues
         *        a consumer that will call methods on {@link List<NodeTypeSpecificValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeTypeSpecificValues(List<NodeTypeSpecificValue>)
         */
        Builder nodeTypeSpecificValues(Consumer<NodeTypeSpecificValue.Builder>... nodeTypeSpecificValues);

        /**
         * <p>
         * A description of the parameter
         * </p>
         * 
         * @param description
         *        A description of the parameter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.
         * </p>
         * 
         * @param source
         *        How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The data type of the parameter. For example, <code>integer</code>:
         * </p>
         * 
         * @param dataType
         *        The data type of the parameter. For example, <code>integer</code>:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * A range of values within which the parameter can be set.
         * </p>
         * 
         * @param allowedValues
         *        A range of values within which the parameter can be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * Whether the customer is allowed to modify the parameter.
         * </p>
         * 
         * @param isModifiable
         *        Whether the customer is allowed to modify the parameter.
         * @see IsModifiable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsModifiable
         */
        Builder isModifiable(String isModifiable);

        /**
         * <p>
         * Whether the customer is allowed to modify the parameter.
         * </p>
         * 
         * @param isModifiable
         *        Whether the customer is allowed to modify the parameter.
         * @see IsModifiable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsModifiable
         */
        Builder isModifiable(IsModifiable isModifiable);

        /**
         * <p>
         * The conditions under which changes to this parameter can be applied. For example,
         * <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is
         * rebooted.
         * </p>
         * 
         * @param changeType
         *        The conditions under which changes to this parameter can be applied. For example,
         *        <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a
         *        node is rebooted.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * The conditions under which changes to this parameter can be applied. For example,
         * <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is
         * rebooted.
         * </p>
         * 
         * @param changeType
         *        The conditions under which changes to this parameter can be applied. For example,
         *        <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a
         *        node is rebooted.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterType;

        private String parameterValue;

        private List<NodeTypeSpecificValue> nodeTypeSpecificValues = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String source;

        private String dataType;

        private String allowedValues;

        private String isModifiable;

        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            parameterName(model.parameterName);
            parameterType(model.parameterType);
            parameterValue(model.parameterValue);
            nodeTypeSpecificValues(model.nodeTypeSpecificValues);
            description(model.description);
            source(model.source);
            dataType(model.dataType);
            allowedValues(model.allowedValues);
            isModifiable(model.isModifiable);
            changeType(model.changeType);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterTypeAsString() {
            return parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        @Override
        public final Builder parameterType(ParameterType parameterType) {
            this.parameterType(parameterType.toString());
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Collection<NodeTypeSpecificValue.Builder> getNodeTypeSpecificValues() {
            return nodeTypeSpecificValues != null ? nodeTypeSpecificValues.stream().map(NodeTypeSpecificValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copy(nodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(NodeTypeSpecificValue... nodeTypeSpecificValues) {
            nodeTypeSpecificValues(Arrays.asList(nodeTypeSpecificValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(Consumer<NodeTypeSpecificValue.Builder>... nodeTypeSpecificValues) {
            nodeTypeSpecificValues(Stream.of(nodeTypeSpecificValues)
                    .map(c -> NodeTypeSpecificValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeTypeSpecificValues(Collection<NodeTypeSpecificValue.BuilderImpl> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copyFromBuilder(nodeTypeSpecificValues);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getIsModifiableAsString() {
            return isModifiable;
        }

        @Override
        public final Builder isModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        @Override
        public final Builder isModifiable(IsModifiable isModifiable) {
            this.isModifiable(isModifiable.toString());
            return this;
        }

        public final void setIsModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getChangeTypeAsString() {
            return changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
