/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dax.DaxClient;
import software.amazon.awssdk.services.dax.DaxServiceClientConfiguration;
import software.amazon.awssdk.services.dax.internal.DaxServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.dax.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ClusterNotFoundException;
import software.amazon.awssdk.services.dax.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;
import software.amazon.awssdk.services.dax.model.CreateClusterResponse;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DaxException;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dax.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DescribeClustersRequest;
import software.amazon.awssdk.services.dax.model.DescribeClustersResponse;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeEventsRequest;
import software.amazon.awssdk.services.dax.model.DescribeEventsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.dax.model.InvalidArnException;
import software.amazon.awssdk.services.dax.model.InvalidClusterStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.dax.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterValueException;
import software.amazon.awssdk.services.dax.model.InvalidSubnetException;
import software.amazon.awssdk.services.dax.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.dax.model.ListTagsRequest;
import software.amazon.awssdk.services.dax.model.ListTagsResponse;
import software.amazon.awssdk.services.dax.model.NodeNotFoundException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.RebootNodeRequest;
import software.amazon.awssdk.services.dax.model.RebootNodeResponse;
import software.amazon.awssdk.services.dax.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.dax.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.dax.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetInUseException;
import software.amazon.awssdk.services.dax.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.dax.model.TagNotFoundException;
import software.amazon.awssdk.services.dax.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.dax.model.TagResourceRequest;
import software.amazon.awssdk.services.dax.model.TagResourceResponse;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.services.dax.model.UntagResourceResponse;
import software.amazon.awssdk.services.dax.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dax.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDaxClient
implements DaxClient {
    private static final Logger log = Logger.loggerFor(DefaultDaxClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDaxClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"DAX#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException, InvalidClusterStateException, InsufficientClusterCapacityException, SubnetGroupNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, InvalidVpcNetworkStateException, TagQuotaPerResourceExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$createCluster$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException, InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, createParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParameterGroup");
            CreateParameterGroupResponse createParameterGroupResponse = (CreateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$createParameterGroup$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException, InvalidSubnetException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, createSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubnetGroup");
            CreateSubnetGroupResponse createSubnetGroupResponse = (CreateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$createSubnetGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecreaseReplicationFactorResponse decreaseReplicationFactor(DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseReplicationFactorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decreaseReplicationFactorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, decreaseReplicationFactorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DecreaseReplicationFactor");
            DecreaseReplicationFactorResponse decreaseReplicationFactorResponse = (DecreaseReplicationFactorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseReplicationFactor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)decreaseReplicationFactorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DecreaseReplicationFactorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return decreaseReplicationFactorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$decreaseReplicationFactor$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$deleteCluster$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, deleteParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteParameterGroup");
            DeleteParameterGroupResponse deleteParameterGroupResponse = (DeleteParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$deleteParameterGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) throws SubnetGroupInUseException, SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, deleteSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubnetGroup");
            DeleteSubnetGroupResponse deleteSubnetGroupResponse = (DeleteSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$deleteSubnetGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            DescribeClustersResponse describeClustersResponse = (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeClusters$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDefaultParametersResponse describeDefaultParameters(DescribeDefaultParametersRequest describeDefaultParametersRequest) throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDefaultParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDefaultParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeDefaultParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDefaultParameters");
            DescribeDefaultParametersResponse describeDefaultParametersResponse = (DescribeDefaultParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDefaultParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDefaultParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDefaultParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDefaultParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeDefaultParameters$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeEvents$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParameterGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameterGroups");
            DescribeParameterGroupsResponse describeParameterGroupsResponse = (DescribeParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeParameterGroups$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest) throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameters");
            DescribeParametersResponse describeParametersResponse = (DescribeParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeParameters$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) throws SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubnetGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, describeSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubnetGroups");
            DescribeSubnetGroupsResponse describeSubnetGroupsResponse = (DescribeSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$describeSubnetGroups$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncreaseReplicationFactorResponse increaseReplicationFactor(IncreaseReplicationFactorRequest increaseReplicationFactorRequest) throws ClusterNotFoundException, InvalidClusterStateException, InsufficientClusterCapacityException, InvalidVpcNetworkStateException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseReplicationFactorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)increaseReplicationFactorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, increaseReplicationFactorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IncreaseReplicationFactor");
            IncreaseReplicationFactorResponse increaseReplicationFactorResponse = (IncreaseReplicationFactorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseReplicationFactor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)increaseReplicationFactorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IncreaseReplicationFactorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return increaseReplicationFactorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$increaseReplicationFactor$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException, InvalidArnException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$listTags$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootNodeResponse rebootNode(RebootNodeRequest rebootNodeRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, rebootNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootNode");
            RebootNodeResponse rebootNodeResponse = (RebootNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rebootNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$rebootNode$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException, TagQuotaPerResourceExceededException, InvalidArnException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$tagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException, InvalidArnException, TagNotFoundException, InvalidClusterStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$untagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidClusterStateException, ClusterNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$updateCluster$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, updateParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateParameterGroup");
            UpdateParameterGroupResponse updateParameterGroupResponse = (UpdateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$updateParameterGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxClient.resolveMetricPublishers(clientConfiguration, updateSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetGroup");
            UpdateSubnetGroupResponse updateSubnetGroupResponse = (UpdateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDaxClient.lambda$updateSubnetGroup$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "dax";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DaxServiceClientConfigurationBuilder serviceConfigBuilder = new DaxServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DaxException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final DaxServiceClientConfiguration serviceClientConfiguration() {
        return new DaxServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateParameterGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootNode$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$increaseReplicationFactor$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameters$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameterGroups$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDefaultParameters$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decreaseReplicationFactor$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubnetGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParameterGroup$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

