/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dax.DaxAsyncClient;
import software.amazon.awssdk.services.dax.DaxServiceClientConfiguration;
import software.amazon.awssdk.services.dax.internal.DaxServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.dax.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ClusterNotFoundException;
import software.amazon.awssdk.services.dax.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;
import software.amazon.awssdk.services.dax.model.CreateClusterResponse;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DaxException;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dax.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DescribeClustersRequest;
import software.amazon.awssdk.services.dax.model.DescribeClustersResponse;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeEventsRequest;
import software.amazon.awssdk.services.dax.model.DescribeEventsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.dax.model.InvalidArnException;
import software.amazon.awssdk.services.dax.model.InvalidClusterStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.dax.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterValueException;
import software.amazon.awssdk.services.dax.model.InvalidSubnetException;
import software.amazon.awssdk.services.dax.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.dax.model.ListTagsRequest;
import software.amazon.awssdk.services.dax.model.ListTagsResponse;
import software.amazon.awssdk.services.dax.model.NodeNotFoundException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.RebootNodeRequest;
import software.amazon.awssdk.services.dax.model.RebootNodeResponse;
import software.amazon.awssdk.services.dax.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.dax.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.dax.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetInUseException;
import software.amazon.awssdk.services.dax.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.dax.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.dax.model.TagNotFoundException;
import software.amazon.awssdk.services.dax.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.dax.model.TagResourceRequest;
import software.amazon.awssdk.services.dax.model.TagResourceResponse;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.services.dax.model.UntagResourceResponse;
import software.amazon.awssdk.services.dax.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dax.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDaxAsyncClient
implements DaxAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDaxAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDaxAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"DAX#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$createCluster$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$createCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateParameterGroupResponse> createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, createParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$createParameterGroup$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$createParameterGroup$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, createSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$createSubnetGroup$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$createSubnetGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DecreaseReplicationFactorResponse> decreaseReplicationFactor(DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decreaseReplicationFactorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, decreaseReplicationFactorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DecreaseReplicationFactor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseReplicationFactorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseReplicationFactor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DecreaseReplicationFactorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)decreaseReplicationFactorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$decreaseReplicationFactor$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$decreaseReplicationFactor$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$deleteCluster$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$deleteCluster$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$deleteParameterGroup$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$deleteParameterGroup$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$deleteSubnetGroup$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$deleteSubnetGroup$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeClusters$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeClusters$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDefaultParametersResponse> describeDefaultParameters(DescribeDefaultParametersRequest describeDefaultParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDefaultParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeDefaultParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDefaultParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDefaultParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDefaultParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDefaultParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDefaultParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeDefaultParameters$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeDefaultParameters$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeEvents$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeEvents$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameterGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParameterGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeParameterGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeParameterGroups$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeParameterGroups$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeParameters$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeParameters$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, describeSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubnetGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubnetGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSubnetGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$describeSubnetGroups$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$describeSubnetGroups$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<IncreaseReplicationFactorResponse> increaseReplicationFactor(IncreaseReplicationFactorRequest increaseReplicationFactorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)increaseReplicationFactorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, increaseReplicationFactorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IncreaseReplicationFactor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseReplicationFactorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseReplicationFactor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new IncreaseReplicationFactorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)increaseReplicationFactorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$increaseReplicationFactor$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$increaseReplicationFactor$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$listTags$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$listTags$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootNodeResponse> rebootNode(RebootNodeRequest rebootNodeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, rebootNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootNodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RebootNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootNodeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$rebootNode$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$rebootNode$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$tagResource$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$tagResource$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$untagResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$untagResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$updateCluster$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$updateCluster$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, updateParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$updateParameterGroup$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$updateParameterGroup$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDaxAsyncClient.resolveMetricPublishers(clientConfiguration, updateSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DAX");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "NodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeNotFoundException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDaxAsyncClient.lambda$updateSubnetGroup$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDaxAsyncClient.lambda$updateSubnetGroup$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final DaxServiceClientConfiguration serviceClientConfiguration() {
        return new DaxServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "dax";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DaxException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DaxServiceClientConfigurationBuilder serviceConfigBuilder = new DaxServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$82(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateParameterGroup$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateParameterGroup$78(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCluster$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$74(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$66(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootNode$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootNode$62(List metricPublishers, MetricCollector apiCallMetricCollector, RebootNodeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTags$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$increaseReplicationFactor$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$increaseReplicationFactor$54(List metricPublishers, MetricCollector apiCallMetricCollector, IncreaseReplicationFactorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSubnetGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeParameters$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameters$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeParameterGroups$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameterGroups$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeParameterGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEvents$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDefaultParameters$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDefaultParameters$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDefaultParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusters$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCluster$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$decreaseReplicationFactor$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decreaseReplicationFactor$14(List metricPublishers, MetricCollector apiCallMetricCollector, DecreaseReplicationFactorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSubnetGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubnetGroup$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createParameterGroup$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParameterGroup$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

