/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecreaseReplicationFactorRequest extends DaxRequest implements
        ToCopyableBuilder<DecreaseReplicationFactorRequest.Builder, DecreaseReplicationFactorRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DecreaseReplicationFactorRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<Integer> NEW_REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DecreaseReplicationFactorRequest::newReplicationFactor)).setter(setter(Builder::newReplicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicationFactor").build())
            .build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DecreaseReplicationFactorRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NODE_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DecreaseReplicationFactorRequest::nodeIdsToRemove))
            .setter(setter(Builder::nodeIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NEW_REPLICATION_FACTOR_FIELD, AVAILABILITY_ZONES_FIELD, NODE_IDS_TO_REMOVE_FIELD));

    private final String clusterName;

    private final Integer newReplicationFactor;

    private final List<String> availabilityZones;

    private final List<String> nodeIdsToRemove;

    private DecreaseReplicationFactorRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
    }

    /**
     * <p>
     * The name of the DAX cluster from which you want to remove nodes.
     * </p>
     * 
     * @return The name of the DAX cluster from which you want to remove nodes.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The new number of nodes for the DAX cluster.
     * </p>
     * 
     * @return The new number of nodes for the DAX cluster.
     */
    public Integer newReplicationFactor() {
        return newReplicationFactor;
    }

    /**
     * <p>
     * The Availability Zone(s) from which to remove nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zone(s) from which to remove nodes.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The unique identifiers of the nodes to be removed from the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The unique identifiers of the nodes to be removed from the cluster.
     */
    public List<String> nodeIdsToRemove() {
        return nodeIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(newReplicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(nodeIdsToRemove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseReplicationFactorRequest)) {
            return false;
        }
        DecreaseReplicationFactorRequest other = (DecreaseReplicationFactorRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(newReplicationFactor(), other.newReplicationFactor())
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(nodeIdsToRemove(), other.nodeIdsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DecreaseReplicationFactorRequest").add("ClusterName", clusterName())
                .add("NewReplicationFactor", newReplicationFactor()).add("AvailabilityZones", availabilityZones())
                .add("NodeIdsToRemove", nodeIdsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "NewReplicationFactor":
            return Optional.ofNullable(clazz.cast(newReplicationFactor()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "NodeIdsToRemove":
            return Optional.ofNullable(clazz.cast(nodeIdsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecreaseReplicationFactorRequest, T> g) {
        return obj -> g.apply((DecreaseReplicationFactorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DecreaseReplicationFactorRequest> {
        /**
         * <p>
         * The name of the DAX cluster from which you want to remove nodes.
         * </p>
         * 
         * @param clusterName
         *        The name of the DAX cluster from which you want to remove nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The new number of nodes for the DAX cluster.
         * </p>
         * 
         * @param newReplicationFactor
         *        The new number of nodes for the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newReplicationFactor(Integer newReplicationFactor);

        /**
         * <p>
         * The Availability Zone(s) from which to remove nodes.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zone(s) from which to remove nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zone(s) from which to remove nodes.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zone(s) from which to remove nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The unique identifiers of the nodes to be removed from the cluster.
         * </p>
         * 
         * @param nodeIdsToRemove
         *        The unique identifiers of the nodes to be removed from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove);

        /**
         * <p>
         * The unique identifiers of the nodes to be removed from the cluster.
         * </p>
         * 
         * @param nodeIdsToRemove
         *        The unique identifiers of the nodes to be removed from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToRemove(String... nodeIdsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String clusterName;

        private Integer newReplicationFactor;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseReplicationFactorRequest model) {
            super(model);
            clusterName(model.clusterName);
            newReplicationFactor(model.newReplicationFactor);
            availabilityZones(model.availabilityZones);
            nodeIdsToRemove(model.nodeIdsToRemove);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        public final Collection<String> getNodeIdsToRemove() {
            return nodeIdsToRemove;
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String... nodeIdsToRemove) {
            nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseReplicationFactorRequest build() {
            return new DecreaseReplicationFactorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
