/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an individual node within a DAX cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .getter(getter(Node::endpoint)).setter(setter(Builder::endpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Instant> NODE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Node::nodeCreateTime)).setter(setter(Builder::nodeCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCreateTime").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> NODE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::nodeStatus)).setter(setter(Builder::nodeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeStatus").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::parameterGroupStatus)).setter(setter(Builder::parameterGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, ENDPOINT_FIELD,
            NODE_CREATE_TIME_FIELD, AVAILABILITY_ZONE_FIELD, NODE_STATUS_FIELD, PARAMETER_GROUP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeId;

    private final Endpoint endpoint;

    private final Instant nodeCreateTime;

    private final String availabilityZone;

    private final String nodeStatus;

    private final String parameterGroupStatus;

    private Node(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.endpoint = builder.endpoint;
        this.nodeCreateTime = builder.nodeCreateTime;
        this.availabilityZone = builder.availabilityZone;
        this.nodeStatus = builder.nodeStatus;
        this.parameterGroupStatus = builder.parameterGroupStatus;
    }

    /**
     * <p>
     * A system-generated identifier for the node.
     * </p>
     * 
     * @return A system-generated identifier for the node.
     */
    public String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly
     * to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests
     * and responses to nodes in the DAX cluster.
     * </p>
     * 
     * @return The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect
     *         directly to a node endpoint, if desired (as an alternative to allowing DAX client software to
     *         intelligently route requests and responses to nodes in the DAX cluster.
     */
    public Endpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The date and time (in UNIX epoch format) when the node was launched.
     * </p>
     * 
     * @return The date and time (in UNIX epoch format) when the node was launched.
     */
    public Instant nodeCreateTime() {
        return nodeCreateTime;
    }

    /**
     * <p>
     * The Availability Zone (AZ) in which the node has been deployed.
     * </p>
     * 
     * @return The Availability Zone (AZ) in which the node has been deployed.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The current status of the node. For example: <code>available</code>.
     * </p>
     * 
     * @return The current status of the node. For example: <code>available</code>.
     */
    public String nodeStatus() {
        return nodeStatus;
    }

    /**
     * <p>
     * The status of the parameter group associated with this node. For example, <code>in-sync</code>.
     * </p>
     * 
     * @return The status of the parameter group associated with this node. For example, <code>in-sync</code>.
     */
    public String parameterGroupStatus() {
        return parameterGroupStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(nodeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(nodeId(), other.nodeId()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(nodeCreateTime(), other.nodeCreateTime())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(nodeStatus(), other.nodeStatus())
                && Objects.equals(parameterGroupStatus(), other.parameterGroupStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Node").add("NodeId", nodeId()).add("Endpoint", endpoint())
                .add("NodeCreateTime", nodeCreateTime()).add("AvailabilityZone", availabilityZone())
                .add("NodeStatus", nodeStatus()).add("ParameterGroupStatus", parameterGroupStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "NodeCreateTime":
            return Optional.ofNullable(clazz.cast(nodeCreateTime()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "NodeStatus":
            return Optional.ofNullable(clazz.cast(nodeStatus()));
        case "ParameterGroupStatus":
            return Optional.ofNullable(clazz.cast(parameterGroupStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * A system-generated identifier for the node.
         * </p>
         * 
         * @param nodeId
         *        A system-generated identifier for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect
         * directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently
         * route requests and responses to nodes in the DAX cluster.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect
         *        directly to a node endpoint, if desired (as an alternative to allowing DAX client software to
         *        intelligently route requests and responses to nodes in the DAX cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect
         * directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently
         * route requests and responses to nodes in the DAX cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * The date and time (in UNIX epoch format) when the node was launched.
         * </p>
         * 
         * @param nodeCreateTime
         *        The date and time (in UNIX epoch format) when the node was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCreateTime(Instant nodeCreateTime);

        /**
         * <p>
         * The Availability Zone (AZ) in which the node has been deployed.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone (AZ) in which the node has been deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The current status of the node. For example: <code>available</code>.
         * </p>
         * 
         * @param nodeStatus
         *        The current status of the node. For example: <code>available</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeStatus(String nodeStatus);

        /**
         * <p>
         * The status of the parameter group associated with this node. For example, <code>in-sync</code>.
         * </p>
         * 
         * @param parameterGroupStatus
         *        The status of the parameter group associated with this node. For example, <code>in-sync</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupStatus(String parameterGroupStatus);
    }

    static final class BuilderImpl implements Builder {
        private String nodeId;

        private Endpoint endpoint;

        private Instant nodeCreateTime;

        private String availabilityZone;

        private String nodeStatus;

        private String parameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            nodeId(model.nodeId);
            endpoint(model.endpoint);
            nodeCreateTime(model.nodeCreateTime);
            availabilityZone(model.availabilityZone);
            nodeStatus(model.nodeStatus);
            parameterGroupStatus(model.parameterGroupStatus);
        }

        public final String getNodeId() {
            return nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Instant getNodeCreateTime() {
            return nodeCreateTime;
        }

        @Override
        public final Builder nodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
            return this;
        }

        public final void setNodeCreateTime(Instant nodeCreateTime) {
            this.nodeCreateTime = nodeCreateTime;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getNodeStatus() {
            return nodeStatus;
        }

        @Override
        public final Builder nodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
            return this;
        }

        public final void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public final String getParameterGroupStatus() {
            return parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
