/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<Attachments> ATTACHMENTS_FIELD = SdkField.<Attachments> builder(MarshallingType.SDK_POJO)
            .memberName("attachments").getter(getter(CreateJobRequest::attachments)).setter(setter(Builder::attachments))
            .constructor(Attachments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateJobRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFailedTasksCount").getter(getter(CreateJobRequest::maxFailedTasksCount))
            .setter(setter(Builder::maxFailedTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build())
            .build();

    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRetriesPerTask").getter(getter(CreateJobRequest::maxRetriesPerTask))
            .setter(setter(Builder::maxRetriesPerTask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()).build();

    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, JobParameter>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(CreateJobRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<JobParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(CreateJobRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(CreateJobRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(CreateJobRequest::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(CreateJobRequest::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(CreateJobRequest::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(CreateJobRequest::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD,
            CLIENT_TOKEN_FIELD, FARM_ID_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, PARAMETERS_FIELD,
            PRIORITY_FIELD, QUEUE_ID_FIELD, STORAGE_PROFILE_ID_FIELD, TARGET_TASK_RUN_STATUS_FIELD, TEMPLATE_FIELD,
            TEMPLATE_TYPE_FIELD));

    private final Attachments attachments;

    private final String clientToken;

    private final String farmId;

    private final Integer maxFailedTasksCount;

    private final Integer maxRetriesPerTask;

    private final Map<String, JobParameter> parameters;

    private final Integer priority;

    private final String queueId;

    private final String storageProfileId;

    private final String targetTaskRunStatus;

    private final String template;

    private final String templateType;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.attachments = builder.attachments;
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.parameters = builder.parameters;
        this.priority = builder.priority;
        this.queueId = builder.queueId;
        this.storageProfileId = builder.storageProfileId;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.template = builder.template;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * The attachments for the job. Attach files required for the job to run to a render job.
     * </p>
     * 
     * @return The attachments for the job. Attach files required for the job to run to a render job.
     */
    public final Attachments attachments() {
        return attachments;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the farm to connect to the job.
     * </p>
     * 
     * @return The farm ID of the farm to connect to the job.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     * </p>
     * 
     * @return The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     */
    public final Integer maxFailedTasksCount() {
        return maxFailedTasksCount;
    }

    /**
     * <p>
     * The maximum number of retries for a job.
     * </p>
     * 
     * @return The maximum number of retries for a job.
     */
    public final Integer maxRetriesPerTask() {
        return maxRetriesPerTask;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the job.
     */
    public final Map<String, JobParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The priority of the job on a scale of 1 to 100. The highest priority is 1.
     * </p>
     * 
     * @return The priority of the job on a scale of 1 to 100. The highest priority is 1.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ID of the queue that the job is submitted to.
     * </p>
     * 
     * @return The ID of the queue that the job is submitted to.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The storage profile ID for the storage profile to connect to the job.
     * </p>
     * 
     * @return The storage profile ID for the storage profile to connect to the job.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    /**
     * <p>
     * The initial status of the job's tasks when they are created. Tasks that are created with a <code>SUSPENDED</code>
     * status will not run until you update their status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link CreateJobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The initial status of the job's tasks when they are created. Tasks that are created with a
     *         <code>SUSPENDED</code> status will not run until you update their status.
     * @see CreateJobTargetTaskRunStatus
     */
    public final CreateJobTargetTaskRunStatus targetTaskRunStatus() {
        return CreateJobTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The initial status of the job's tasks when they are created. Tasks that are created with a <code>SUSPENDED</code>
     * status will not run until you update their status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link CreateJobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The initial status of the job's tasks when they are created. Tasks that are created with a
     *         <code>SUSPENDED</code> status will not run until you update their status.
     * @see CreateJobTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The job template to use for this job.
     * </p>
     * 
     * @return The job template to use for this job.
     */
    public final String template() {
        return template;
    }

    /**
     * <p>
     * The file type for the job template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link JobTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The file type for the job template.
     * @see JobTemplateType
     */
    public final JobTemplateType templateType() {
        return JobTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The file type for the job template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link JobTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The file type for the job template.
     * @see JobTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(attachments(), other.attachments()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(farmId(), other.farmId()) && Objects.equals(maxFailedTasksCount(), other.maxFailedTasksCount())
                && Objects.equals(maxRetriesPerTask(), other.maxRetriesPerTask()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(priority(), other.priority())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(storageProfileId(), other.storageProfileId())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && Objects.equals(template(), other.template())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("Attachments", attachments()).add("ClientToken", clientToken())
                .add("FarmId", farmId()).add("MaxFailedTasksCount", maxFailedTasksCount())
                .add("MaxRetriesPerTask", maxRetriesPerTask())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").add("Priority", priority())
                .add("QueueId", queueId()).add("StorageProfileId", storageProfileId())
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString())
                .add("Template", template() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateType", templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "maxFailedTasksCount":
            return Optional.ofNullable(clazz.cast(maxFailedTasksCount()));
        case "maxRetriesPerTask":
            return Optional.ofNullable(clazz.cast(maxRetriesPerTask()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * The attachments for the job. Attach files required for the job to run to a render job.
         * </p>
         * 
         * @param attachments
         *        The attachments for the job. Attach files required for the job to run to a render job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachments attachments);

        /**
         * <p>
         * The attachments for the job. Attach files required for the job to run to a render job.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachments.Builder} avoiding the need to
         * create one manually via {@link Attachments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachments.Builder#build()} is called immediately and its result
         * is passed to {@link #attachments(Attachments)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link Attachments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(Attachments)
         */
        default Builder attachments(Consumer<Attachments.Builder> attachments) {
            return attachments(Attachments.builder().applyMutation(attachments).build());
        }

        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the farm to connect to the job.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm to connect to the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * </p>
         * 
         * @param maxFailedTasksCount
         *        The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFailedTasksCount(Integer maxFailedTasksCount);

        /**
         * <p>
         * The maximum number of retries for a job.
         * </p>
         * 
         * @param maxRetriesPerTask
         *        The maximum number of retries for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetriesPerTask(Integer maxRetriesPerTask);

        /**
         * <p>
         * The parameters for the job.
         * </p>
         * 
         * @param parameters
         *        The parameters for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, JobParameter> parameters);

        /**
         * <p>
         * The priority of the job on a scale of 1 to 100. The highest priority is 1.
         * </p>
         * 
         * @param priority
         *        The priority of the job on a scale of 1 to 100. The highest priority is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ID of the queue that the job is submitted to.
         * </p>
         * 
         * @param queueId
         *        The ID of the queue that the job is submitted to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The storage profile ID for the storage profile to connect to the job.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID for the storage profile to connect to the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);

        /**
         * <p>
         * The initial status of the job's tasks when they are created. Tasks that are created with a
         * <code>SUSPENDED</code> status will not run until you update their status.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The initial status of the job's tasks when they are created. Tasks that are created with a
         *        <code>SUSPENDED</code> status will not run until you update their status.
         * @see CreateJobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreateJobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The initial status of the job's tasks when they are created. Tasks that are created with a
         * <code>SUSPENDED</code> status will not run until you update their status.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The initial status of the job's tasks when they are created. Tasks that are created with a
         *        <code>SUSPENDED</code> status will not run until you update their status.
         * @see CreateJobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreateJobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(CreateJobTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The job template to use for this job.
         * </p>
         * 
         * @param template
         *        The job template to use for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * The file type for the job template.
         * </p>
         * 
         * @param templateType
         *        The file type for the job template.
         * @see JobTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The file type for the job template.
         * </p>
         * 
         * @param templateType
         *        The file type for the job template.
         * @see JobTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateType
         */
        Builder templateType(JobTemplateType templateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private Attachments attachments;

        private String clientToken;

        private String farmId;

        private Integer maxFailedTasksCount;

        private Integer maxRetriesPerTask;

        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Integer priority;

        private String queueId;

        private String storageProfileId;

        private String targetTaskRunStatus;

        private String template;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            attachments(model.attachments);
            clientToken(model.clientToken);
            farmId(model.farmId);
            maxFailedTasksCount(model.maxFailedTasksCount);
            maxRetriesPerTask(model.maxRetriesPerTask);
            parameters(model.parameters);
            priority(model.priority);
            queueId(model.queueId);
            storageProfileId(model.storageProfileId);
            targetTaskRunStatus(model.targetTaskRunStatus);
            template(model.template);
            templateType(model.templateType);
        }

        public final Attachments.Builder getAttachments() {
            return attachments != null ? attachments.toBuilder() : null;
        }

        public final void setAttachments(Attachments.BuilderImpl attachments) {
            this.attachments = attachments != null ? attachments.build() : null;
        }

        @Override
        public final Builder attachments(Attachments attachments) {
            this.attachments = attachments;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(CreateJobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(JobTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
