/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.deadline.internal.DeadlineServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.deadline.model.AccessDeniedException;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse;
import software.amazon.awssdk.services.deadline.model.ConflictException;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse;
import software.amazon.awssdk.services.deadline.model.CreateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.CreateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.CreateFarmRequest;
import software.amazon.awssdk.services.deadline.model.CreateFarmResponse;
import software.amazon.awssdk.services.deadline.model.CreateFleetRequest;
import software.amazon.awssdk.services.deadline.model.CreateFleetResponse;
import software.amazon.awssdk.services.deadline.model.CreateJobRequest;
import software.amazon.awssdk.services.deadline.model.CreateJobResponse;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.CreateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.CreateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueResponse;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.CreateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.CreateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DeadlineException;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFarmRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFarmResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFleetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFleetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueResponse;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetBudgetRequest;
import software.amazon.awssdk.services.deadline.model.GetBudgetResponse;
import software.amazon.awssdk.services.deadline.model.GetFarmRequest;
import software.amazon.awssdk.services.deadline.model.GetFarmResponse;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetMonitorRequest;
import software.amazon.awssdk.services.deadline.model.GetMonitorResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionActionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionActionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.GetStepRequest;
import software.amazon.awssdk.services.deadline.model.GetStepResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.GetTaskRequest;
import software.amazon.awssdk.services.deadline.model.GetTaskResponse;
import software.amazon.awssdk.services.deadline.model.GetWorkerRequest;
import software.amazon.awssdk.services.deadline.model.GetWorkerResponse;
import software.amazon.awssdk.services.deadline.model.InternalServerErrorException;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetsRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetsResponse;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListJobsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobsResponse;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListMonitorsRequest;
import software.amazon.awssdk.services.deadline.model.ListMonitorsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListQueuesRequest;
import software.amazon.awssdk.services.deadline.model.ListQueuesResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsResponse;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.ListStepsRequest;
import software.amazon.awssdk.services.deadline.model.ListStepsResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.deadline.model.ListTasksRequest;
import software.amazon.awssdk.services.deadline.model.ListTasksResponse;
import software.amazon.awssdk.services.deadline.model.ListWorkersRequest;
import software.amazon.awssdk.services.deadline.model.ListWorkersResponse;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.deadline.model.SearchJobsRequest;
import software.amazon.awssdk.services.deadline.model.SearchJobsResponse;
import software.amazon.awssdk.services.deadline.model.SearchStepsRequest;
import software.amazon.awssdk.services.deadline.model.SearchStepsResponse;
import software.amazon.awssdk.services.deadline.model.SearchTasksRequest;
import software.amazon.awssdk.services.deadline.model.SearchTasksResponse;
import software.amazon.awssdk.services.deadline.model.SearchWorkersRequest;
import software.amazon.awssdk.services.deadline.model.SearchWorkersResponse;
import software.amazon.awssdk.services.deadline.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.TagResourceRequest;
import software.amazon.awssdk.services.deadline.model.TagResourceResponse;
import software.amazon.awssdk.services.deadline.model.ThrottlingException;
import software.amazon.awssdk.services.deadline.model.UntagResourceRequest;
import software.amazon.awssdk.services.deadline.model.UntagResourceResponse;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFarmRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFarmResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFleetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFleetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateJobRequest;
import software.amazon.awssdk.services.deadline.model.UpdateJobResponse;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueResponse;
import software.amazon.awssdk.services.deadline.model.UpdateSessionRequest;
import software.amazon.awssdk.services.deadline.model.UpdateSessionResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStepRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStepResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.UpdateTaskRequest;
import software.amazon.awssdk.services.deadline.model.UpdateTaskResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse;
import software.amazon.awssdk.services.deadline.model.ValidationException;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssociateMemberToQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeFleetRoleForReadRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeFleetRoleForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForReadRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForUserRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.AssumeQueueRoleForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.BatchGetJobEntityRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CopyJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.CreateWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteMeteredProductRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DeleteWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.DisassociateMemberFromQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetLicenseEndpointRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionActionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetSessionsStatisticsAggregationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStepRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStorageProfileForQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetTaskRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.GetWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListAvailableMeteredProductsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListBudgetsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFarmMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFarmsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFleetMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListJobMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListLicenseEndpointsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListMeteredProductsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListMonitorsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueFleetAssociationsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueueMembersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionActionsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionsForWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepConsumersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepDependenciesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStepsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStorageProfilesForQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListStorageProfilesRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListTasksRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.ListWorkersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.PutMeteredProductRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchJobsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchStepsRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchTasksRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.SearchWorkersRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.StartSessionsStatisticsAggregationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateBudgetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateFarmRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateMonitorRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueFleetAssociationRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateQueueRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateSessionRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateStepRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateStorageProfileRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateTaskRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateWorkerRequestMarshaller;
import software.amazon.awssdk.services.deadline.transform.UpdateWorkerScheduleRequestMarshaller;
import software.amazon.awssdk.services.deadline.waiters.DeadlineAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DeadlineAsyncClient}.
 *
 * @see DeadlineAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDeadlineAsyncClient implements DeadlineAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeadlineAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultDeadlineAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     *
     * @param associateMemberToFarmRequest
     * @return A Java Future containing the result of the AssociateMemberToFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToFarmResponse> associateMemberToFarm(
            AssociateMemberToFarmRequest associateMemberToFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToFarmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToFarmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssociateMemberToFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToFarmRequest, AssociateMemberToFarmResponse>()
                            .withOperationName("AssociateMemberToFarm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMemberToFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateMemberToFarmRequest));
            CompletableFuture<AssociateMemberToFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     *
     * @param associateMemberToFleetRequest
     * @return A Java Future containing the result of the AssociateMemberToFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToFleetResponse> associateMemberToFleet(
            AssociateMemberToFleetRequest associateMemberToFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssociateMemberToFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToFleetRequest, AssociateMemberToFleetResponse>()
                            .withOperationName("AssociateMemberToFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMemberToFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateMemberToFleetRequest));
            CompletableFuture<AssociateMemberToFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     *
     * @param associateMemberToJobRequest
     * @return A Java Future containing the result of the AssociateMemberToJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToJobResponse> associateMemberToJob(
            AssociateMemberToJobRequest associateMemberToJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssociateMemberToJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToJobRequest, AssociateMemberToJobResponse>()
                            .withOperationName("AssociateMemberToJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMemberToJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateMemberToJobRequest));
            CompletableFuture<AssociateMemberToJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     *
     * @param associateMemberToQueueRequest
     * @return A Java Future containing the result of the AssociateMemberToQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToQueueResponse> associateMemberToQueue(
            AssociateMemberToQueueRequest associateMemberToQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssociateMemberToQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToQueueRequest, AssociateMemberToQueueResponse>()
                            .withOperationName("AssociateMemberToQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMemberToQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateMemberToQueueRequest));
            CompletableFuture<AssociateMemberToQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     * @return A Java Future containing the result of the AssumeFleetRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeFleetRoleForReadResponse> assumeFleetRoleForRead(
            AssumeFleetRoleForReadRequest assumeFleetRoleForReadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeFleetRoleForReadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeFleetRoleForReadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeFleetRoleForRead");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeFleetRoleForReadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeFleetRoleForReadResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssumeFleetRoleForReadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeFleetRoleForReadRequest, AssumeFleetRoleForReadResponse>()
                            .withOperationName("AssumeFleetRoleForRead").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeFleetRoleForReadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(assumeFleetRoleForReadRequest));
            CompletableFuture<AssumeFleetRoleForReadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     * @return A Java Future containing the result of the AssumeFleetRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeFleetRoleForWorkerResponse> assumeFleetRoleForWorker(
            AssumeFleetRoleForWorkerRequest assumeFleetRoleForWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeFleetRoleForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeFleetRoleForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeFleetRoleForWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeFleetRoleForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeFleetRoleForWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<AssumeFleetRoleForWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeFleetRoleForWorkerRequest, AssumeFleetRoleForWorkerResponse>()
                            .withOperationName("AssumeFleetRoleForWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeFleetRoleForWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(assumeFleetRoleForWorkerRequest));
            CompletableFuture<AssumeFleetRoleForWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeQueueRoleForReadResponse> assumeQueueRoleForRead(
            AssumeQueueRoleForReadRequest assumeQueueRoleForReadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForReadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForReadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForRead");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeQueueRoleForReadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeQueueRoleForReadResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssumeQueueRoleForReadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForReadRequest, AssumeQueueRoleForReadResponse>()
                            .withOperationName("AssumeQueueRoleForRead").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeQueueRoleForReadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(assumeQueueRoleForReadRequest));
            CompletableFuture<AssumeQueueRoleForReadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeQueueRoleForUserResponse> assumeQueueRoleForUser(
            AssumeQueueRoleForUserRequest assumeQueueRoleForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeQueueRoleForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeQueueRoleForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<AssumeQueueRoleForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForUserRequest, AssumeQueueRoleForUserResponse>()
                            .withOperationName("AssumeQueueRoleForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeQueueRoleForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(assumeQueueRoleForUserRequest));
            CompletableFuture<AssumeQueueRoleForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeQueueRoleForWorkerResponse> assumeQueueRoleForWorker(
            AssumeQueueRoleForWorkerRequest assumeQueueRoleForWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeQueueRoleForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeQueueRoleForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeQueueRoleForWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeQueueRoleForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeQueueRoleForWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<AssumeQueueRoleForWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeQueueRoleForWorkerRequest, AssumeQueueRoleForWorkerResponse>()
                            .withOperationName("AssumeQueueRoleForWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeQueueRoleForWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(assumeQueueRoleForWorkerRequest));
            CompletableFuture<AssumeQueueRoleForWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     *
     * @param batchGetJobEntityRequest
     * @return A Java Future containing the result of the BatchGetJobEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetJobEntityResponse> batchGetJobEntity(BatchGetJobEntityRequest batchGetJobEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetJobEntityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetJobEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetJobEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetJobEntityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetJobEntityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<BatchGetJobEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetJobEntityRequest, BatchGetJobEntityResponse>()
                            .withOperationName("BatchGetJobEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetJobEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchGetJobEntityRequest));
            CompletableFuture<BatchGetJobEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     *
     * @param copyJobTemplateRequest
     * @return A Java Future containing the result of the CopyJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyJobTemplateResponse> copyJobTemplate(CopyJobTemplateRequest copyJobTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyJobTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CopyJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CopyJobTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CopyJobTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyJobTemplateRequest, CopyJobTemplateResponse>()
                            .withOperationName("CopyJobTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopyJobTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(copyJobTemplateRequest));
            CompletableFuture<CopyJobTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     *
     * @param createBudgetRequest
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBudgetResponse> createBudget(CreateBudgetRequest createBudgetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBudget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBudgetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateBudgetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBudgetRequest, CreateBudgetResponse>()
                            .withOperationName("CreateBudget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBudgetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createBudgetRequest));
            CompletableFuture<CreateBudgetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     *
     * @param createFarmRequest
     * @return A Java Future containing the result of the CreateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFarmResponse> createFarm(CreateFarmRequest createFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFarmRequest, CreateFarmResponse>().withOperationName("CreateFarm")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createFarmRequest));
            CompletableFuture<CreateFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job. A job is a render submission submitted by a user. It contains specific job properties outlined as
     * steps and tasks.
     * </p>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>().withOperationName("CreateJob")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(createJobRequest));
            CompletableFuture<CreateJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     *
     * @param createLicenseEndpointRequest
     * @return A Java Future containing the result of the CreateLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLicenseEndpointResponse> createLicenseEndpoint(
            CreateLicenseEndpointRequest createLicenseEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLicenseEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLicenseEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateLicenseEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLicenseEndpointRequest, CreateLicenseEndpointResponse>()
                            .withOperationName("CreateLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLicenseEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createLicenseEndpointRequest));
            CompletableFuture<CreateLicenseEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     *
     * @param createMonitorRequest
     * @return A Java Future containing the result of the CreateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMonitorResponse> createMonitor(CreateMonitorRequest createMonitorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateMonitorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateMonitorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMonitorRequest, CreateMonitorResponse>()
                            .withOperationName("CreateMonitor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMonitorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createMonitorRequest));
            CompletableFuture<CreateMonitorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     *
     * @param createQueueRequest
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateQueueRequest, CreateQueueResponse>()
                            .withOperationName("CreateQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createQueueRequest));
            CompletableFuture<CreateQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     *
     * @param createQueueEnvironmentRequest
     * @return A Java Future containing the result of the CreateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQueueEnvironmentResponse> createQueueEnvironment(
            CreateQueueEnvironmentRequest createQueueEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueueEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateQueueEnvironmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateQueueEnvironmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateQueueEnvironmentRequest, CreateQueueEnvironmentResponse>()
                            .withOperationName("CreateQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateQueueEnvironmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createQueueEnvironmentRequest));
            CompletableFuture<CreateQueueEnvironmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     * @return A Java Future containing the result of the CreateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQueueFleetAssociationResponse> createQueueFleetAssociation(
            CreateQueueFleetAssociationRequest createQueueFleetAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueueFleetAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateQueueFleetAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateQueueFleetAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateQueueFleetAssociationRequest, CreateQueueFleetAssociationResponse>()
                            .withOperationName("CreateQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateQueueFleetAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createQueueFleetAssociationRequest));
            CompletableFuture<CreateQueueFleetAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     *
     * @param createStorageProfileRequest
     * @return A Java Future containing the result of the CreateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStorageProfileResponse> createStorageProfile(
            CreateStorageProfileRequest createStorageProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStorageProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStorageProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<CreateStorageProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStorageProfileRequest, CreateStorageProfileResponse>()
                            .withOperationName("CreateStorageProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStorageProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createStorageProfileRequest));
            CompletableFuture<CreateStorageProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     *
     * @param createWorkerRequest
     * @return A Java Future containing the result of the CreateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkerResponse> createWorker(CreateWorkerRequest createWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<CreateWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkerRequest, CreateWorkerResponse>()
                            .withOperationName("CreateWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createWorkerRequest));
            CompletableFuture<CreateWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     *
     * @param deleteBudgetRequest
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBudget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBudgetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteBudgetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBudgetRequest, DeleteBudgetResponse>()
                            .withOperationName("DeleteBudget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBudgetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteBudgetRequest));
            CompletableFuture<DeleteBudgetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     *
     * @param deleteFarmRequest
     * @return A Java Future containing the result of the DeleteFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFarmResponse> deleteFarm(DeleteFarmRequest deleteFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFarmRequest, DeleteFarmResponse>().withOperationName("DeleteFarm")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteFarmRequest));
            CompletableFuture<DeleteFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                            .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteFleetRequest));
            CompletableFuture<DeleteFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     * @return A Java Future containing the result of the DeleteLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLicenseEndpointResponse> deleteLicenseEndpoint(
            DeleteLicenseEndpointRequest deleteLicenseEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLicenseEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLicenseEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteLicenseEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLicenseEndpointRequest, DeleteLicenseEndpointResponse>()
                            .withOperationName("DeleteLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLicenseEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteLicenseEndpointRequest));
            CompletableFuture<DeleteLicenseEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     *
     * @param deleteMeteredProductRequest
     * @return A Java Future containing the result of the DeleteMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMeteredProductResponse> deleteMeteredProduct(
            DeleteMeteredProductRequest deleteMeteredProductRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMeteredProductRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMeteredProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMeteredProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMeteredProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMeteredProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteMeteredProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMeteredProductRequest, DeleteMeteredProductResponse>()
                            .withOperationName("DeleteMeteredProduct").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMeteredProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteMeteredProductRequest));
            CompletableFuture<DeleteMeteredProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return A Java Future containing the result of the DeleteMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMonitorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteMonitorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitorRequest, DeleteMonitorResponse>()
                            .withOperationName("DeleteMonitor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMonitorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteMonitorRequest));
            CompletableFuture<DeleteMonitorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     *
     * @param deleteQueueRequest
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueueRequest, DeleteQueueResponse>()
                            .withOperationName("DeleteQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteQueueRequest));
            CompletableFuture<DeleteQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     * @return A Java Future containing the result of the DeleteQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueueEnvironmentResponse> deleteQueueEnvironment(
            DeleteQueueEnvironmentRequest deleteQueueEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueueEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteQueueEnvironmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteQueueEnvironmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueueEnvironmentRequest, DeleteQueueEnvironmentResponse>()
                            .withOperationName("DeleteQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQueueEnvironmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteQueueEnvironmentRequest));
            CompletableFuture<DeleteQueueEnvironmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     * @return A Java Future containing the result of the DeleteQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueueFleetAssociationResponse> deleteQueueFleetAssociation(
            DeleteQueueFleetAssociationRequest deleteQueueFleetAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueueFleetAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteQueueFleetAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteQueueFleetAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueueFleetAssociationRequest, DeleteQueueFleetAssociationResponse>()
                            .withOperationName("DeleteQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteQueueFleetAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteQueueFleetAssociationRequest));
            CompletableFuture<DeleteQueueFleetAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     *
     * @param deleteStorageProfileRequest
     * @return A Java Future containing the result of the DeleteStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStorageProfileResponse> deleteStorageProfile(
            DeleteStorageProfileRequest deleteStorageProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStorageProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStorageProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteStorageProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStorageProfileRequest, DeleteStorageProfileResponse>()
                            .withOperationName("DeleteStorageProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStorageProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteStorageProfileRequest));
            CompletableFuture<DeleteStorageProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     *
     * @param deleteWorkerRequest
     * @return A Java Future containing the result of the DeleteWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkerResponse> deleteWorker(DeleteWorkerRequest deleteWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DeleteWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkerRequest, DeleteWorkerResponse>()
                            .withOperationName("DeleteWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteWorkerRequest));
            CompletableFuture<DeleteWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     * @return A Java Future containing the result of the DisassociateMemberFromFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromFarmResponse> disassociateMemberFromFarm(
            DisassociateMemberFromFarmRequest disassociateMemberFromFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromFarmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromFarmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DisassociateMemberFromFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromFarmRequest, DisassociateMemberFromFarmResponse>()
                            .withOperationName("DisassociateMemberFromFarm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMemberFromFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(disassociateMemberFromFarmRequest));
            CompletableFuture<DisassociateMemberFromFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     * @return A Java Future containing the result of the DisassociateMemberFromFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromFleetResponse> disassociateMemberFromFleet(
            DisassociateMemberFromFleetRequest disassociateMemberFromFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DisassociateMemberFromFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromFleetRequest, DisassociateMemberFromFleetResponse>()
                            .withOperationName("DisassociateMemberFromFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMemberFromFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(disassociateMemberFromFleetRequest));
            CompletableFuture<DisassociateMemberFromFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     * @return A Java Future containing the result of the DisassociateMemberFromJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromJobResponse> disassociateMemberFromJob(
            DisassociateMemberFromJobRequest disassociateMemberFromJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DisassociateMemberFromJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromJobRequest, DisassociateMemberFromJobResponse>()
                            .withOperationName("DisassociateMemberFromJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMemberFromJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(disassociateMemberFromJobRequest));
            CompletableFuture<DisassociateMemberFromJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     * @return A Java Future containing the result of the DisassociateMemberFromQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromQueueResponse> disassociateMemberFromQueue(
            DisassociateMemberFromQueueRequest disassociateMemberFromQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<DisassociateMemberFromQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromQueueRequest, DisassociateMemberFromQueueResponse>()
                            .withOperationName("DisassociateMemberFromQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMemberFromQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(disassociateMemberFromQueueRequest));
            CompletableFuture<DisassociateMemberFromQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     *
     * @param getBudgetRequest
     * @return A Java Future containing the result of the GetBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBudgetResponse> getBudget(GetBudgetRequest getBudgetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBudget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBudgetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetBudgetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBudgetRequest, GetBudgetResponse>().withOperationName("GetBudget")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBudgetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getBudgetRequest));
            CompletableFuture<GetBudgetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     *
     * @param getFarmRequest
     * @return A Java Future containing the result of the GetFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFarmResponse> getFarm(GetFarmRequest getFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFarmRequest, GetFarmResponse>().withOperationName("GetFarm")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getFarmRequest));
            CompletableFuture<GetFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFleetResponse> getFleet(GetFleetRequest getFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFleetRequest, GetFleetResponse>().withOperationName("GetFleet")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getFleetRequest));
            CompletableFuture<GetFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     *
     * @param getJobRequest
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJobRequest, GetJobResponse>().withOperationName("GetJob")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getJobRequest));
            CompletableFuture<GetJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     *
     * @param getLicenseEndpointRequest
     * @return A Java Future containing the result of the GetLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLicenseEndpointResponse> getLicenseEndpoint(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLicenseEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLicenseEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLicenseEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLicenseEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLicenseEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetLicenseEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLicenseEndpointRequest, GetLicenseEndpointResponse>()
                            .withOperationName("GetLicenseEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLicenseEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getLicenseEndpointRequest));
            CompletableFuture<GetLicenseEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     *
     * @param getMonitorRequest
     * @return A Java Future containing the result of the GetMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMonitorResponse> getMonitor(GetMonitorRequest getMonitorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMonitorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetMonitorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMonitorRequest, GetMonitorResponse>().withOperationName("GetMonitor")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMonitorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getMonitorRequest));
            CompletableFuture<GetMonitorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     *
     * @param getQueueRequest
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueueResponse> getQueue(GetQueueRequest getQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueueRequest, GetQueueResponse>().withOperationName("GetQueue")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueueRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getQueueRequest));
            CompletableFuture<GetQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     *
     * @param getQueueEnvironmentRequest
     * @return A Java Future containing the result of the GetQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueueEnvironmentResponse> getQueueEnvironment(
            GetQueueEnvironmentRequest getQueueEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueueEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueueEnvironmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetQueueEnvironmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueueEnvironmentRequest, GetQueueEnvironmentResponse>()
                            .withOperationName("GetQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueueEnvironmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getQueueEnvironmentRequest));
            CompletableFuture<GetQueueEnvironmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     * @return A Java Future containing the result of the GetQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueueFleetAssociationResponse> getQueueFleetAssociation(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueueFleetAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueueFleetAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetQueueFleetAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueueFleetAssociationRequest, GetQueueFleetAssociationResponse>()
                            .withOperationName("GetQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueueFleetAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getQueueFleetAssociationRequest));
            CompletableFuture<GetQueueFleetAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>().withOperationName("GetSession")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getSessionRequest));
            CompletableFuture<GetSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     *
     * @param getSessionActionRequest
     * @return A Java Future containing the result of the GetSessionAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionActionResponse> getSessionAction(GetSessionActionRequest getSessionActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSessionActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetSessionActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionActionRequest, GetSessionActionResponse>()
                            .withOperationName("GetSessionAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getSessionActionRequest));
            CompletableFuture<GetSessionActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return A Java Future containing the result of the GetSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionsStatisticsAggregationResponse> getSessionsStatisticsAggregation(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionsStatisticsAggregationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSessionsStatisticsAggregationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionsStatisticsAggregation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionsStatisticsAggregationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSessionsStatisticsAggregationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetSessionsStatisticsAggregationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionsStatisticsAggregationRequest, GetSessionsStatisticsAggregationResponse>()
                            .withOperationName("GetSessionsStatisticsAggregation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSessionsStatisticsAggregationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getSessionsStatisticsAggregationRequest));
            CompletableFuture<GetSessionsStatisticsAggregationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     *
     * @param getStepRequest
     * @return A Java Future containing the result of the GetStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStepResponse> getStep(GetStepRequest getStepRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStepRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStepRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStep");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStepResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStepResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetStepResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStepRequest, GetStepResponse>().withOperationName("GetStep")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetStepRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getStepRequest));
            CompletableFuture<GetStepResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     *
     * @param getStorageProfileRequest
     * @return A Java Future containing the result of the GetStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStorageProfileResponse> getStorageProfile(GetStorageProfileRequest getStorageProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStorageProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetStorageProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStorageProfileRequest, GetStorageProfileResponse>()
                            .withOperationName("GetStorageProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStorageProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getStorageProfileRequest));
            CompletableFuture<GetStorageProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     * @return A Java Future containing the result of the GetStorageProfileForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStorageProfileForQueueResponse> getStorageProfileForQueue(
            GetStorageProfileForQueueRequest getStorageProfileForQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageProfileForQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageProfileForQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageProfileForQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStorageProfileForQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStorageProfileForQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetStorageProfileForQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStorageProfileForQueueRequest, GetStorageProfileForQueueResponse>()
                            .withOperationName("GetStorageProfileForQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStorageProfileForQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getStorageProfileForQueueRequest));
            CompletableFuture<GetStorageProfileForQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     *
     * @param getTaskRequest
     * @return A Java Future containing the result of the GetTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTaskResponse> getTask(GetTaskRequest getTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTaskRequest, GetTaskResponse>().withOperationName("GetTask")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getTaskRequest));
            CompletableFuture<GetTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     *
     * @param getWorkerRequest
     * @return A Java Future containing the result of the GetWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkerResponse> getWorker(GetWorkerRequest getWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<GetWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkerRequest, GetWorkerResponse>().withOperationName("GetWorker")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkerRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getWorkerRequest));
            CompletableFuture<GetWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return A Java Future containing the result of the ListAvailableMeteredProducts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAvailableMeteredProductsResponse> listAvailableMeteredProducts(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailableMeteredProductsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAvailableMeteredProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableMeteredProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAvailableMeteredProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAvailableMeteredProductsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListAvailableMeteredProductsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAvailableMeteredProductsRequest, ListAvailableMeteredProductsResponse>()
                            .withOperationName("ListAvailableMeteredProducts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAvailableMeteredProductsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAvailableMeteredProductsRequest));
            CompletableFuture<ListAvailableMeteredProductsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     *
     * @param listBudgetsRequest
     * @return A Java Future containing the result of the ListBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBudgetsResponse> listBudgets(ListBudgetsRequest listBudgetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBudgetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBudgetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBudgets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBudgetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBudgetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListBudgetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBudgetsRequest, ListBudgetsResponse>()
                            .withOperationName("ListBudgets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBudgetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listBudgetsRequest));
            CompletableFuture<ListBudgetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     *
     * @param listFarmMembersRequest
     * @return A Java Future containing the result of the ListFarmMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFarmMembersResponse> listFarmMembers(ListFarmMembersRequest listFarmMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFarmMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFarmMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFarmMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFarmMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFarmMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListFarmMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFarmMembersRequest, ListFarmMembersResponse>()
                            .withOperationName("ListFarmMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFarmMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listFarmMembersRequest));
            CompletableFuture<ListFarmMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     *
     * @param listFarmsRequest
     * @return A Java Future containing the result of the ListFarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFarmsResponse> listFarms(ListFarmsRequest listFarmsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFarmsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFarms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFarmsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFarmsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListFarmsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFarmsRequest, ListFarmsResponse>().withOperationName("ListFarms")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFarmsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listFarmsRequest));
            CompletableFuture<ListFarmsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     *
     * @param listFleetMembersRequest
     * @return A Java Future containing the result of the ListFleetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetMembersResponse> listFleetMembers(ListFleetMembersRequest listFleetMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFleetMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListFleetMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetMembersRequest, ListFleetMembersResponse>()
                            .withOperationName("ListFleetMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listFleetMembersRequest));
            CompletableFuture<ListFleetMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listFleetsRequest));
            CompletableFuture<ListFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     *
     * @param listJobMembersRequest
     * @return A Java Future containing the result of the ListJobMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJobMembersResponse> listJobMembers(ListJobMembersRequest listJobMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJobMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListJobMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListJobMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobMembersRequest, ListJobMembersResponse>()
                            .withOperationName("ListJobMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListJobMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listJobMembersRequest));
            CompletableFuture<ListJobMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>().withOperationName("ListJobs")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListJobsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listJobsRequest));
            CompletableFuture<ListJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return A Java Future containing the result of the ListLicenseEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLicenseEndpointsResponse> listLicenseEndpoints(
            ListLicenseEndpointsRequest listLicenseEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLicenseEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLicenseEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLicenseEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLicenseEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLicenseEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListLicenseEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLicenseEndpointsRequest, ListLicenseEndpointsResponse>()
                            .withOperationName("ListLicenseEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLicenseEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listLicenseEndpointsRequest));
            CompletableFuture<ListLicenseEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return A Java Future containing the result of the ListMeteredProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMeteredProductsResponse> listMeteredProducts(
            ListMeteredProductsRequest listMeteredProductsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMeteredProductsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMeteredProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMeteredProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMeteredProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMeteredProductsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListMeteredProductsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMeteredProductsRequest, ListMeteredProductsResponse>()
                            .withOperationName("ListMeteredProducts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMeteredProductsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listMeteredProductsRequest));
            CompletableFuture<ListMeteredProductsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     *
     * @param listMonitorsRequest
     * @return A Java Future containing the result of the ListMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMonitorsResponse> listMonitors(ListMonitorsRequest listMonitorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMonitorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMonitorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMonitors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMonitorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMonitorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListMonitorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMonitorsRequest, ListMonitorsResponse>()
                            .withOperationName("ListMonitors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMonitorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listMonitorsRequest));
            CompletableFuture<ListMonitorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return A Java Future containing the result of the ListQueueEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueueEnvironmentsResponse> listQueueEnvironments(
            ListQueueEnvironmentsRequest listQueueEnvironmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueEnvironmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueEnvironmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueEnvironments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueueEnvironmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQueueEnvironmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListQueueEnvironmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueueEnvironmentsRequest, ListQueueEnvironmentsResponse>()
                            .withOperationName("ListQueueEnvironments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueueEnvironmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listQueueEnvironmentsRequest));
            CompletableFuture<ListQueueEnvironmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return A Java Future containing the result of the ListQueueFleetAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueueFleetAssociationsResponse> listQueueFleetAssociations(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueFleetAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueFleetAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueFleetAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueueFleetAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQueueFleetAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListQueueFleetAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueueFleetAssociationsRequest, ListQueueFleetAssociationsResponse>()
                            .withOperationName("ListQueueFleetAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueueFleetAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listQueueFleetAssociationsRequest));
            CompletableFuture<ListQueueFleetAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     *
     * @param listQueueMembersRequest
     * @return A Java Future containing the result of the ListQueueMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueueMembersResponse> listQueueMembers(ListQueueMembersRequest listQueueMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueueMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueueMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueueMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueueMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListQueueMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListQueueMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueueMembersRequest, ListQueueMembersResponse>()
                            .withOperationName("ListQueueMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueueMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listQueueMembersRequest));
            CompletableFuture<ListQueueMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     *
     * @param listQueuesRequest
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueuesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListQueuesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListQueuesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueuesRequest, ListQueuesResponse>().withOperationName("ListQueues")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueuesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listQueuesRequest));
            CompletableFuture<ListQueuesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     *
     * @param listSessionActionsRequest
     * @return A Java Future containing the result of the ListSessionActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionActionsResponse> listSessionActions(ListSessionActionsRequest listSessionActionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSessionActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListSessionActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionActionsRequest, ListSessionActionsResponse>()
                            .withOperationName("ListSessionActions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSessionActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSessionActionsRequest));
            CompletableFuture<ListSessionActionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionsRequest, ListSessionsResponse>()
                            .withOperationName("ListSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSessionsRequest));
            CompletableFuture<ListSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return A Java Future containing the result of the ListSessionsForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionsForWorkerResponse> listSessionsForWorker(
            ListSessionsForWorkerRequest listSessionsForWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsForWorkerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsForWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionsForWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionsForWorkerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSessionsForWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListSessionsForWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionsForWorkerRequest, ListSessionsForWorkerResponse>()
                            .withOperationName("ListSessionsForWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSessionsForWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSessionsForWorkerRequest));
            CompletableFuture<ListSessionsForWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     *
     * @param listStepConsumersRequest
     * @return A Java Future containing the result of the ListStepConsumers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStepConsumersResponse> listStepConsumers(ListStepConsumersRequest listStepConsumersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepConsumersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepConsumersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStepConsumers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStepConsumersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStepConsumersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListStepConsumersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStepConsumersRequest, ListStepConsumersResponse>()
                            .withOperationName("ListStepConsumers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStepConsumersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listStepConsumersRequest));
            CompletableFuture<ListStepConsumersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return A Java Future containing the result of the ListStepDependencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStepDependenciesResponse> listStepDependencies(
            ListStepDependenciesRequest listStepDependenciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepDependenciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepDependenciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStepDependencies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStepDependenciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStepDependenciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListStepDependenciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStepDependenciesRequest, ListStepDependenciesResponse>()
                            .withOperationName("ListStepDependencies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStepDependenciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listStepDependenciesRequest));
            CompletableFuture<ListStepDependenciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     *
     * @param listStepsRequest
     * @return A Java Future containing the result of the ListSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListStepsResponse> listSteps(ListStepsRequest listStepsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStepsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSteps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStepsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListStepsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListStepsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStepsRequest, ListStepsResponse>().withOperationName("ListSteps")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStepsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listStepsRequest));
            CompletableFuture<ListStepsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return A Java Future containing the result of the ListStorageProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStorageProfilesResponse> listStorageProfiles(
            ListStorageProfilesRequest listStorageProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStorageProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStorageProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStorageProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListStorageProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStorageProfilesRequest, ListStorageProfilesResponse>()
                            .withOperationName("ListStorageProfiles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStorageProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listStorageProfilesRequest));
            CompletableFuture<ListStorageProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return A Java Future containing the result of the ListStorageProfilesForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStorageProfilesForQueueResponse> listStorageProfilesForQueue(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageProfilesForQueueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStorageProfilesForQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageProfilesForQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStorageProfilesForQueueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStorageProfilesForQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListStorageProfilesForQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStorageProfilesForQueueRequest, ListStorageProfilesForQueueResponse>()
                            .withOperationName("ListStorageProfilesForQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStorageProfilesForQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listStorageProfilesForQueueRequest));
            CompletableFuture<ListStorageProfilesForQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     *
     * @param listTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTasksRequest, ListTasksResponse>().withOperationName("ListTasks")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTasksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listTasksRequest));
            CompletableFuture<ListTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     *
     * @param listWorkersRequest
     * @return A Java Future containing the result of the ListWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkersResponse> listWorkers(ListWorkersRequest listWorkersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListWorkersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<ListWorkersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkersRequest, ListWorkersResponse>()
                            .withOperationName("ListWorkers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listWorkersRequest));
            CompletableFuture<ListWorkersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     *
     * @param putMeteredProductRequest
     * @return A Java Future containing the result of the PutMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMeteredProductResponse> putMeteredProduct(PutMeteredProductRequest putMeteredProductRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMeteredProductRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMeteredProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMeteredProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMeteredProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMeteredProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<PutMeteredProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMeteredProductRequest, PutMeteredProductResponse>()
                            .withOperationName("PutMeteredProduct").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMeteredProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(putMeteredProductRequest));
            CompletableFuture<PutMeteredProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     *
     * @param searchJobsRequest
     * @return A Java Future containing the result of the SearchJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchJobsResponse> searchJobs(SearchJobsRequest searchJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<SearchJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchJobsRequest, SearchJobsResponse>().withOperationName("SearchJobs")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(searchJobsRequest));
            CompletableFuture<SearchJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     *
     * @param searchStepsRequest
     * @return A Java Future containing the result of the SearchSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchStepsResponse> searchSteps(SearchStepsRequest searchStepsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchStepsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSteps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchStepsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchStepsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<SearchStepsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchStepsRequest, SearchStepsResponse>()
                            .withOperationName("SearchSteps").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchStepsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(searchStepsRequest));
            CompletableFuture<SearchStepsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     *
     * @param searchTasksRequest
     * @return A Java Future containing the result of the SearchTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchTasksResponse> searchTasks(SearchTasksRequest searchTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<SearchTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchTasksRequest, SearchTasksResponse>()
                            .withOperationName("SearchTasks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(searchTasksRequest));
            CompletableFuture<SearchTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     *
     * @param searchWorkersRequest
     * @return A Java Future containing the result of the SearchWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchWorkersResponse> searchWorkers(SearchWorkersRequest searchWorkersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchWorkersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchWorkersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchWorkers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchWorkersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchWorkersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<SearchWorkersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchWorkersRequest, SearchWorkersResponse>()
                            .withOperationName("SearchWorkers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchWorkersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(searchWorkersRequest));
            CompletableFuture<SearchWorkersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     * @return A Java Future containing the result of the StartSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSessionsStatisticsAggregationResponse> startSessionsStatisticsAggregation(
            StartSessionsStatisticsAggregationRequest startSessionsStatisticsAggregationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSessionsStatisticsAggregationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startSessionsStatisticsAggregationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSessionsStatisticsAggregation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSessionsStatisticsAggregationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartSessionsStatisticsAggregationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<StartSessionsStatisticsAggregationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSessionsStatisticsAggregationRequest, StartSessionsStatisticsAggregationResponse>()
                            .withOperationName("StartSessionsStatisticsAggregation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSessionsStatisticsAggregationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startSessionsStatisticsAggregationRequest));
            CompletableFuture<StartSessionsStatisticsAggregationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     *
     * @param updateBudgetRequest
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBudgetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBudgetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBudget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBudgetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateBudgetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateBudgetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBudgetRequest, UpdateBudgetResponse>()
                            .withOperationName("UpdateBudget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBudgetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateBudgetRequest));
            CompletableFuture<UpdateBudgetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     *
     * @param updateFarmRequest
     * @return A Java Future containing the result of the UpdateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFarmResponse> updateFarm(UpdateFarmRequest updateFarmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateFarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFarmRequest, UpdateFarmResponse>().withOperationName("UpdateFarm")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateFarmRequest));
            CompletableFuture<UpdateFarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                            .withOperationName("UpdateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateFleetRequest));
            CompletableFuture<UpdateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     *
     * @param updateJobRequest
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJobRequest, UpdateJobResponse>().withOperationName("UpdateJob")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(updateJobRequest));
            CompletableFuture<UpdateJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     *
     * @param updateMonitorRequest
     * @return A Java Future containing the result of the UpdateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest updateMonitorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMonitorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMonitorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateMonitorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateMonitorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMonitorRequest, UpdateMonitorResponse>()
                            .withOperationName("UpdateMonitor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMonitorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateMonitorRequest));
            CompletableFuture<UpdateMonitorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     *
     * @param updateQueueRequest
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQueueResponse> updateQueue(UpdateQueueRequest updateQueueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateQueueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateQueueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQueueRequest, UpdateQueueResponse>()
                            .withOperationName("UpdateQueue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQueueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateQueueRequest));
            CompletableFuture<UpdateQueueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     * @return A Java Future containing the result of the UpdateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQueueEnvironmentResponse> updateQueueEnvironment(
            UpdateQueueEnvironmentRequest updateQueueEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueEnvironmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueEnvironmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueueEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQueueEnvironmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateQueueEnvironmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateQueueEnvironmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQueueEnvironmentRequest, UpdateQueueEnvironmentResponse>()
                            .withOperationName("UpdateQueueEnvironment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQueueEnvironmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateQueueEnvironmentRequest));
            CompletableFuture<UpdateQueueEnvironmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     * @return A Java Future containing the result of the UpdateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateQueueFleetAssociationResponse> updateQueueFleetAssociation(
            UpdateQueueFleetAssociationRequest updateQueueFleetAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateQueueFleetAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateQueueFleetAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateQueueFleetAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateQueueFleetAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateQueueFleetAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateQueueFleetAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateQueueFleetAssociationRequest, UpdateQueueFleetAssociationResponse>()
                            .withOperationName("UpdateQueueFleetAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateQueueFleetAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateQueueFleetAssociationRequest));
            CompletableFuture<UpdateQueueFleetAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     *
     * @param updateSessionRequest
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSessionResponse> updateSession(UpdateSessionRequest updateSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSessionRequest, UpdateSessionResponse>()
                            .withOperationName("UpdateSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateSessionRequest));
            CompletableFuture<UpdateSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     *
     * @param updateStepRequest
     * @return A Java Future containing the result of the UpdateStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStepResponse> updateStep(UpdateStepRequest updateStepRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStepRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStepRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStep");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStepResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateStepResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateStepResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStepRequest, UpdateStepResponse>().withOperationName("UpdateStep")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateStepRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateStepRequest));
            CompletableFuture<UpdateStepResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     *
     * @param updateStorageProfileRequest
     * @return A Java Future containing the result of the UpdateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStorageProfileResponse> updateStorageProfile(
            UpdateStorageProfileRequest updateStorageProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStorageProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStorageProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStorageProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStorageProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateStorageProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateStorageProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStorageProfileRequest, UpdateStorageProfileResponse>()
                            .withOperationName("UpdateStorageProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateStorageProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateStorageProfileRequest));
            CompletableFuture<UpdateStorageProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     *
     * @param updateTaskRequest
     * @return A Java Future containing the result of the UpdateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTaskResponse> updateTask(UpdateTaskRequest updateTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "management.";
            String resolvedHostExpression = "management.";

            CompletableFuture<UpdateTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTaskRequest, UpdateTaskResponse>().withOperationName("UpdateTask")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateTaskRequest));
            CompletableFuture<UpdateTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     *
     * @param updateWorkerRequest
     * @return A Java Future containing the result of the UpdateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkerResponse> updateWorker(UpdateWorkerRequest updateWorkerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateWorkerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<UpdateWorkerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkerRequest, UpdateWorkerResponse>()
                            .withOperationName("UpdateWorker").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateWorkerRequest));
            CompletableFuture<UpdateWorkerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     *
     * @param updateWorkerScheduleRequest
     * @return A Java Future containing the result of the UpdateWorkerSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkerScheduleResponse> updateWorkerSchedule(
            UpdateWorkerScheduleRequest updateWorkerScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkerScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkerScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "deadline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkerSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkerScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkerScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "scheduling.";
            String resolvedHostExpression = "scheduling.";

            CompletableFuture<UpdateWorkerScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkerScheduleRequest, UpdateWorkerScheduleResponse>()
                            .withOperationName("UpdateWorkerSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkerScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateWorkerScheduleRequest));
            CompletableFuture<UpdateWorkerScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public DeadlineAsyncWaiter waiter() {
        return DeadlineAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final DeadlineServiceClientConfiguration serviceClientConfiguration() {
        return new DeadlineServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DeadlineException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        DeadlineServiceClientConfigurationBuilder serviceConfigBuilder = new DeadlineServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
