/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a session action definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionActionDefinitionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionActionDefinitionSummary.Builder, SessionActionDefinitionSummary> {
    private static final SdkField<EnvironmentEnterSessionActionDefinitionSummary> ENV_ENTER_FIELD = SdkField
            .<EnvironmentEnterSessionActionDefinitionSummary> builder(MarshallingType.SDK_POJO).memberName("envEnter")
            .getter(getter(SessionActionDefinitionSummary::envEnter)).setter(setter(Builder::envEnter))
            .constructor(EnvironmentEnterSessionActionDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envEnter").build()).build();

    private static final SdkField<EnvironmentExitSessionActionDefinitionSummary> ENV_EXIT_FIELD = SdkField
            .<EnvironmentExitSessionActionDefinitionSummary> builder(MarshallingType.SDK_POJO).memberName("envExit")
            .getter(getter(SessionActionDefinitionSummary::envExit)).setter(setter(Builder::envExit))
            .constructor(EnvironmentExitSessionActionDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envExit").build()).build();

    private static final SdkField<SyncInputJobAttachmentsSessionActionDefinitionSummary> SYNC_INPUT_JOB_ATTACHMENTS_FIELD = SdkField
            .<SyncInputJobAttachmentsSessionActionDefinitionSummary> builder(MarshallingType.SDK_POJO)
            .memberName("syncInputJobAttachments").getter(getter(SessionActionDefinitionSummary::syncInputJobAttachments))
            .setter(setter(Builder::syncInputJobAttachments))
            .constructor(SyncInputJobAttachmentsSessionActionDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncInputJobAttachments").build())
            .build();

    private static final SdkField<TaskRunSessionActionDefinitionSummary> TASK_RUN_FIELD = SdkField
            .<TaskRunSessionActionDefinitionSummary> builder(MarshallingType.SDK_POJO).memberName("taskRun")
            .getter(getter(SessionActionDefinitionSummary::taskRun)).setter(setter(Builder::taskRun))
            .constructor(TaskRunSessionActionDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENV_ENTER_FIELD,
            ENV_EXIT_FIELD, SYNC_INPUT_JOB_ATTACHMENTS_FIELD, TASK_RUN_FIELD));

    private static final long serialVersionUID = 1L;

    private final EnvironmentEnterSessionActionDefinitionSummary envEnter;

    private final EnvironmentExitSessionActionDefinitionSummary envExit;

    private final SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments;

    private final TaskRunSessionActionDefinitionSummary taskRun;

    private final Type type;

    private SessionActionDefinitionSummary(BuilderImpl builder) {
        this.envEnter = builder.envEnter;
        this.envExit = builder.envExit;
        this.syncInputJobAttachments = builder.syncInputJobAttachments;
        this.taskRun = builder.taskRun;
        this.type = builder.type;
    }

    /**
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @return The environment to enter into.
     */
    public final EnvironmentEnterSessionActionDefinitionSummary envEnter() {
        return envEnter;
    }

    /**
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @return The environment to exit from.
     */
    public final EnvironmentExitSessionActionDefinitionSummary envExit() {
        return envExit;
    }

    /**
     * <p>
     * The job attachments to sync with the session action definition.
     * </p>
     * 
     * @return The job attachments to sync with the session action definition.
     */
    public final SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments() {
        return syncInputJobAttachments;
    }

    /**
     * <p>
     * The task run.
     * </p>
     * 
     * @return The task run.
     */
    public final TaskRunSessionActionDefinitionSummary taskRun() {
        return taskRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(envEnter());
        hashCode = 31 * hashCode + Objects.hashCode(envExit());
        hashCode = 31 * hashCode + Objects.hashCode(syncInputJobAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(taskRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionDefinitionSummary)) {
            return false;
        }
        SessionActionDefinitionSummary other = (SessionActionDefinitionSummary) obj;
        return Objects.equals(envEnter(), other.envEnter()) && Objects.equals(envExit(), other.envExit())
                && Objects.equals(syncInputJobAttachments(), other.syncInputJobAttachments())
                && Objects.equals(taskRun(), other.taskRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionActionDefinitionSummary").add("EnvEnter", envEnter()).add("EnvExit", envExit())
                .add("SyncInputJobAttachments", syncInputJobAttachments()).add("TaskRun", taskRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "envEnter":
            return Optional.ofNullable(clazz.cast(envEnter()));
        case "envExit":
            return Optional.ofNullable(clazz.cast(envExit()));
        case "syncInputJobAttachments":
            return Optional.ofNullable(clazz.cast(syncInputJobAttachments()));
        case "taskRun":
            return Optional.ofNullable(clazz.cast(taskRun()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @param envEnter
     *        The environment to enter into.
     */
    public static SessionActionDefinitionSummary fromEnvEnter(EnvironmentEnterSessionActionDefinitionSummary envEnter) {
        return builder().envEnter(envEnter).build();
    }

    /**
     * Create an instance of this class with {@link #envEnter()} initialized to the given value.
     *
     * <p>
     * The environment to enter into.
     * </p>
     * 
     * @param envEnter
     *        The environment to enter into.
     */
    public static SessionActionDefinitionSummary fromEnvEnter(
            Consumer<EnvironmentEnterSessionActionDefinitionSummary.Builder> envEnter) {
        EnvironmentEnterSessionActionDefinitionSummary.Builder builder = EnvironmentEnterSessionActionDefinitionSummary.builder();
        envEnter.accept(builder);
        return fromEnvEnter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @param envExit
     *        The environment to exit from.
     */
    public static SessionActionDefinitionSummary fromEnvExit(EnvironmentExitSessionActionDefinitionSummary envExit) {
        return builder().envExit(envExit).build();
    }

    /**
     * Create an instance of this class with {@link #envExit()} initialized to the given value.
     *
     * <p>
     * The environment to exit from.
     * </p>
     * 
     * @param envExit
     *        The environment to exit from.
     */
    public static SessionActionDefinitionSummary fromEnvExit(
            Consumer<EnvironmentExitSessionActionDefinitionSummary.Builder> envExit) {
        EnvironmentExitSessionActionDefinitionSummary.Builder builder = EnvironmentExitSessionActionDefinitionSummary.builder();
        envExit.accept(builder);
        return fromEnvExit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachments to sync with the session action definition.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachments to sync with the session action definition.
     */
    public static SessionActionDefinitionSummary fromSyncInputJobAttachments(
            SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments) {
        return builder().syncInputJobAttachments(syncInputJobAttachments).build();
    }

    /**
     * Create an instance of this class with {@link #syncInputJobAttachments()} initialized to the given value.
     *
     * <p>
     * The job attachments to sync with the session action definition.
     * </p>
     * 
     * @param syncInputJobAttachments
     *        The job attachments to sync with the session action definition.
     */
    public static SessionActionDefinitionSummary fromSyncInputJobAttachments(
            Consumer<SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder> syncInputJobAttachments) {
        SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder builder = SyncInputJobAttachmentsSessionActionDefinitionSummary
                .builder();
        syncInputJobAttachments.accept(builder);
        return fromSyncInputJobAttachments(builder.build());
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run.
     * </p>
     * 
     * @param taskRun
     *        The task run.
     */
    public static SessionActionDefinitionSummary fromTaskRun(TaskRunSessionActionDefinitionSummary taskRun) {
        return builder().taskRun(taskRun).build();
    }

    /**
     * Create an instance of this class with {@link #taskRun()} initialized to the given value.
     *
     * <p>
     * The task run.
     * </p>
     * 
     * @param taskRun
     *        The task run.
     */
    public static SessionActionDefinitionSummary fromTaskRun(Consumer<TaskRunSessionActionDefinitionSummary.Builder> taskRun) {
        TaskRunSessionActionDefinitionSummary.Builder builder = TaskRunSessionActionDefinitionSummary.builder();
        taskRun.accept(builder);
        return fromTaskRun(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionActionDefinitionSummary, T> g) {
        return obj -> g.apply((SessionActionDefinitionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionActionDefinitionSummary> {
        /**
         * <p>
         * The environment to enter into.
         * </p>
         * 
         * @param envEnter
         *        The environment to enter into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envEnter(EnvironmentEnterSessionActionDefinitionSummary envEnter);

        /**
         * <p>
         * The environment to enter into.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnvironmentEnterSessionActionDefinitionSummary.Builder} avoiding the need to create one manually via
         * {@link EnvironmentEnterSessionActionDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentEnterSessionActionDefinitionSummary.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #envEnter(EnvironmentEnterSessionActionDefinitionSummary)}.
         * 
         * @param envEnter
         *        a consumer that will call methods on {@link EnvironmentEnterSessionActionDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envEnter(EnvironmentEnterSessionActionDefinitionSummary)
         */
        default Builder envEnter(Consumer<EnvironmentEnterSessionActionDefinitionSummary.Builder> envEnter) {
            return envEnter(EnvironmentEnterSessionActionDefinitionSummary.builder().applyMutation(envEnter).build());
        }

        /**
         * <p>
         * The environment to exit from.
         * </p>
         * 
         * @param envExit
         *        The environment to exit from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envExit(EnvironmentExitSessionActionDefinitionSummary envExit);

        /**
         * <p>
         * The environment to exit from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnvironmentExitSessionActionDefinitionSummary.Builder} avoiding the need to create one manually via
         * {@link EnvironmentExitSessionActionDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentExitSessionActionDefinitionSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #envExit(EnvironmentExitSessionActionDefinitionSummary)}.
         * 
         * @param envExit
         *        a consumer that will call methods on {@link EnvironmentExitSessionActionDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envExit(EnvironmentExitSessionActionDefinitionSummary)
         */
        default Builder envExit(Consumer<EnvironmentExitSessionActionDefinitionSummary.Builder> envExit) {
            return envExit(EnvironmentExitSessionActionDefinitionSummary.builder().applyMutation(envExit).build());
        }

        /**
         * <p>
         * The job attachments to sync with the session action definition.
         * </p>
         * 
         * @param syncInputJobAttachments
         *        The job attachments to sync with the session action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments);

        /**
         * <p>
         * The job attachments to sync with the session action definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder} avoiding the need to create one
         * manually via {@link SyncInputJobAttachmentsSessionActionDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary)}.
         * 
         * @param syncInputJobAttachments
         *        a consumer that will call methods on
         *        {@link SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary)
         */
        default Builder syncInputJobAttachments(
                Consumer<SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder> syncInputJobAttachments) {
            return syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary.builder()
                    .applyMutation(syncInputJobAttachments).build());
        }

        /**
         * <p>
         * The task run.
         * </p>
         * 
         * @param taskRun
         *        The task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRun(TaskRunSessionActionDefinitionSummary taskRun);

        /**
         * <p>
         * The task run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TaskRunSessionActionDefinitionSummary.Builder} avoiding the need to create one manually via
         * {@link TaskRunSessionActionDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskRunSessionActionDefinitionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #taskRun(TaskRunSessionActionDefinitionSummary)}.
         * 
         * @param taskRun
         *        a consumer that will call methods on {@link TaskRunSessionActionDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskRun(TaskRunSessionActionDefinitionSummary)
         */
        default Builder taskRun(Consumer<TaskRunSessionActionDefinitionSummary.Builder> taskRun) {
            return taskRun(TaskRunSessionActionDefinitionSummary.builder().applyMutation(taskRun).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EnvironmentEnterSessionActionDefinitionSummary envEnter;

        private EnvironmentExitSessionActionDefinitionSummary envExit;

        private SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments;

        private TaskRunSessionActionDefinitionSummary taskRun;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionDefinitionSummary model) {
            envEnter(model.envEnter);
            envExit(model.envExit);
            syncInputJobAttachments(model.syncInputJobAttachments);
            taskRun(model.taskRun);
        }

        public final EnvironmentEnterSessionActionDefinitionSummary.Builder getEnvEnter() {
            return envEnter != null ? envEnter.toBuilder() : null;
        }

        public final void setEnvEnter(EnvironmentEnterSessionActionDefinitionSummary.BuilderImpl envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter != null ? envEnter.build() : null;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
        }

        @Override
        public final Builder envEnter(EnvironmentEnterSessionActionDefinitionSummary envEnter) {
            Object oldValue = this.envEnter;
            this.envEnter = envEnter;
            handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
            return this;
        }

        public final EnvironmentExitSessionActionDefinitionSummary.Builder getEnvExit() {
            return envExit != null ? envExit.toBuilder() : null;
        }

        public final void setEnvExit(EnvironmentExitSessionActionDefinitionSummary.BuilderImpl envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit != null ? envExit.build() : null;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
        }

        @Override
        public final Builder envExit(EnvironmentExitSessionActionDefinitionSummary envExit) {
            Object oldValue = this.envExit;
            this.envExit = envExit;
            handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
            return this;
        }

        public final SyncInputJobAttachmentsSessionActionDefinitionSummary.Builder getSyncInputJobAttachments() {
            return syncInputJobAttachments != null ? syncInputJobAttachments.toBuilder() : null;
        }

        public final void setSyncInputJobAttachments(
                SyncInputJobAttachmentsSessionActionDefinitionSummary.BuilderImpl syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments != null ? syncInputJobAttachments.build() : null;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
        }

        @Override
        public final Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinitionSummary syncInputJobAttachments) {
            Object oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments;
            handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
            return this;
        }

        public final TaskRunSessionActionDefinitionSummary.Builder getTaskRun() {
            return taskRun != null ? taskRun.toBuilder() : null;
        }

        public final void setTaskRun(TaskRunSessionActionDefinitionSummary.BuilderImpl taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun != null ? taskRun.build() : null;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
        }

        @Override
        public final Builder taskRun(TaskRunSessionActionDefinitionSummary taskRun) {
            Object oldValue = this.taskRun;
            this.taskRun = taskRun;
            handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
            return this;
        }

        @Override
        public SessionActionDefinitionSummary build() {
            return new SessionActionDefinitionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SessionActionDefinitionSummary#type()
     */
    public enum Type {
        ENV_ENTER,

        ENV_EXIT,

        SYNC_INPUT_JOB_ATTACHMENTS,

        TASK_RUN,

        UNKNOWN_TO_SDK_VERSION
    }
}
