/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToJobResponse;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest;
import software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserResponse;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest;
import software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest;
import software.amazon.awssdk.services.deadline.model.CopyJobTemplateResponse;
import software.amazon.awssdk.services.deadline.model.CreateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.CreateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.CreateFarmRequest;
import software.amazon.awssdk.services.deadline.model.CreateFarmResponse;
import software.amazon.awssdk.services.deadline.model.CreateFleetRequest;
import software.amazon.awssdk.services.deadline.model.CreateFleetResponse;
import software.amazon.awssdk.services.deadline.model.CreateJobRequest;
import software.amazon.awssdk.services.deadline.model.CreateJobResponse;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.CreateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.CreateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.CreateQueueRequest;
import software.amazon.awssdk.services.deadline.model.CreateQueueResponse;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.CreateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.CreateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.CreateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFarmRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFarmResponse;
import software.amazon.awssdk.services.deadline.model.DeleteFleetRequest;
import software.amazon.awssdk.services.deadline.model.DeleteFleetResponse;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.deadline.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.DeleteQueueRequest;
import software.amazon.awssdk.services.deadline.model.DeleteQueueResponse;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.DeleteStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest;
import software.amazon.awssdk.services.deadline.model.DeleteWorkerResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobResponse;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest;
import software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetBudgetRequest;
import software.amazon.awssdk.services.deadline.model.GetBudgetResponse;
import software.amazon.awssdk.services.deadline.model.GetFarmRequest;
import software.amazon.awssdk.services.deadline.model.GetFarmResponse;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetMonitorRequest;
import software.amazon.awssdk.services.deadline.model.GetMonitorResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionActionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionActionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionResponse;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.GetStepRequest;
import software.amazon.awssdk.services.deadline.model.GetStepResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueResponse;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.GetStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.GetTaskRequest;
import software.amazon.awssdk.services.deadline.model.GetTaskResponse;
import software.amazon.awssdk.services.deadline.model.GetWorkerRequest;
import software.amazon.awssdk.services.deadline.model.GetWorkerResponse;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFarmsRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmsResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListFleetsRequest;
import software.amazon.awssdk.services.deadline.model.ListFleetsResponse;
import software.amazon.awssdk.services.deadline.model.ListJobMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListJobMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListJobsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobsResponse;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.ListMonitorsRequest;
import software.amazon.awssdk.services.deadline.model.ListMonitorsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.ListQueuesRequest;
import software.amazon.awssdk.services.deadline.model.ListQueuesResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse;
import software.amazon.awssdk.services.deadline.model.ListSessionsRequest;
import software.amazon.awssdk.services.deadline.model.ListSessionsResponse;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest;
import software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse;
import software.amazon.awssdk.services.deadline.model.ListStepsRequest;
import software.amazon.awssdk.services.deadline.model.ListStepsResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.deadline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.deadline.model.ListTasksRequest;
import software.amazon.awssdk.services.deadline.model.ListTasksResponse;
import software.amazon.awssdk.services.deadline.model.ListWorkersRequest;
import software.amazon.awssdk.services.deadline.model.ListWorkersResponse;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest;
import software.amazon.awssdk.services.deadline.model.PutMeteredProductResponse;
import software.amazon.awssdk.services.deadline.model.SearchJobsRequest;
import software.amazon.awssdk.services.deadline.model.SearchJobsResponse;
import software.amazon.awssdk.services.deadline.model.SearchStepsRequest;
import software.amazon.awssdk.services.deadline.model.SearchStepsResponse;
import software.amazon.awssdk.services.deadline.model.SearchTasksRequest;
import software.amazon.awssdk.services.deadline.model.SearchTasksResponse;
import software.amazon.awssdk.services.deadline.model.SearchWorkersRequest;
import software.amazon.awssdk.services.deadline.model.SearchWorkersResponse;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.TagResourceRequest;
import software.amazon.awssdk.services.deadline.model.TagResourceResponse;
import software.amazon.awssdk.services.deadline.model.UntagResourceRequest;
import software.amazon.awssdk.services.deadline.model.UntagResourceResponse;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFarmRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFarmResponse;
import software.amazon.awssdk.services.deadline.model.UpdateFleetRequest;
import software.amazon.awssdk.services.deadline.model.UpdateFleetResponse;
import software.amazon.awssdk.services.deadline.model.UpdateJobRequest;
import software.amazon.awssdk.services.deadline.model.UpdateJobResponse;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.deadline.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.UpdateQueueRequest;
import software.amazon.awssdk.services.deadline.model.UpdateQueueResponse;
import software.amazon.awssdk.services.deadline.model.UpdateSessionRequest;
import software.amazon.awssdk.services.deadline.model.UpdateSessionResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStepRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStepResponse;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest;
import software.amazon.awssdk.services.deadline.model.UpdateStorageProfileResponse;
import software.amazon.awssdk.services.deadline.model.UpdateTaskRequest;
import software.amazon.awssdk.services.deadline.model.UpdateTaskResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest;
import software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse;
import software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListBudgetsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListFarmMembersPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListFarmsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListFleetMembersPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListJobMembersPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListMonitorsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListQueueMembersPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListQueuesPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListSessionActionsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListSessionsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListStepConsumersPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListStepsPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueuePublisher;
import software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListTasksPublisher;
import software.amazon.awssdk.services.deadline.paginators.ListWorkersPublisher;
import software.amazon.awssdk.services.deadline.waiters.DeadlineAsyncWaiter;

/**
 * Service client for accessing AWSDeadlineCloud asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * The Amazon Web Services Deadline Cloud API provides infrastructure and centralized management for your projects. Use
 * the Deadline Cloud API to onboard users, assign projects, and attach permissions specific to their job function.
 * </p>
 * <p>
 * With Deadline Cloud, content production teams can deploy resources for their workforce securely in the cloud,
 * reducing the costs of added physical infrastructure. Keep your content production operations secure, while allowing
 * your contributors to access the tools they need, such as scalable high-speed storage, licenses, and cost management
 * services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DeadlineAsyncClient extends AwsClient {
    String SERVICE_NAME = "deadline";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "deadline";

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     *
     * @param associateMemberToFarmRequest
     * @return A Java Future containing the result of the AssociateMemberToFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToFarmResponse> associateMemberToFarm(
            AssociateMemberToFarmRequest associateMemberToFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a farm membership level to a member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToFarmRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToFarmRequest#builder()}
     * </p>
     *
     * @param associateMemberToFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToFarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberToFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToFarmResponse> associateMemberToFarm(
            Consumer<AssociateMemberToFarmRequest.Builder> associateMemberToFarmRequest) {
        return associateMemberToFarm(AssociateMemberToFarmRequest.builder().applyMutation(associateMemberToFarmRequest).build());
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     *
     * @param associateMemberToFleetRequest
     * @return A Java Future containing the result of the AssociateMemberToFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToFleetResponse> associateMemberToFleet(
            AssociateMemberToFleetRequest associateMemberToFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a fleet membership level to a member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToFleetRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToFleetRequest#builder()}
     * </p>
     *
     * @param associateMemberToFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberToFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToFleetResponse> associateMemberToFleet(
            Consumer<AssociateMemberToFleetRequest.Builder> associateMemberToFleetRequest) {
        return associateMemberToFleet(AssociateMemberToFleetRequest.builder().applyMutation(associateMemberToFleetRequest)
                .build());
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     *
     * @param associateMemberToJobRequest
     * @return A Java Future containing the result of the AssociateMemberToJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToJobResponse> associateMemberToJob(
            AssociateMemberToJobRequest associateMemberToJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a job membership level to a member
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToJobRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToJobRequest#builder()}
     * </p>
     *
     * @param associateMemberToJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberToJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToJobResponse> associateMemberToJob(
            Consumer<AssociateMemberToJobRequest.Builder> associateMemberToJobRequest) {
        return associateMemberToJob(AssociateMemberToJobRequest.builder().applyMutation(associateMemberToJobRequest).build());
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     *
     * @param associateMemberToQueueRequest
     * @return A Java Future containing the result of the AssociateMemberToQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToQueueResponse> associateMemberToQueue(
            AssociateMemberToQueueRequest associateMemberToQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a queue membership level to a member
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToQueueRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToQueueRequest#builder()}
     * </p>
     *
     * @param associateMemberToQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssociateMemberToQueueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberToQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssociateMemberToQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToQueueResponse> associateMemberToQueue(
            Consumer<AssociateMemberToQueueRequest.Builder> associateMemberToQueueRequest) {
        return associateMemberToQueue(AssociateMemberToQueueRequest.builder().applyMutation(associateMemberToQueueRequest)
                .build());
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     * @return A Java Future containing the result of the AssumeFleetRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeFleetRoleForReadResponse> assumeFleetRoleForRead(
            AssumeFleetRoleForReadRequest assumeFleetRoleForReadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get Amazon Web Services credentials from the fleet role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeFleetRoleForReadRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeFleetRoleForReadRequest#builder()}
     * </p>
     *
     * @param assumeFleetRoleForReadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeFleetRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeFleetRoleForReadResponse> assumeFleetRoleForRead(
            Consumer<AssumeFleetRoleForReadRequest.Builder> assumeFleetRoleForReadRequest) {
        return assumeFleetRoleForRead(AssumeFleetRoleForReadRequest.builder().applyMutation(assumeFleetRoleForReadRequest)
                .build());
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     * @return A Java Future containing the result of the AssumeFleetRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeFleetRoleForWorkerResponse> assumeFleetRoleForWorker(
            AssumeFleetRoleForWorkerRequest assumeFleetRoleForWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get credentials from the fleet role for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeFleetRoleForWorkerRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeFleetRoleForWorkerRequest#builder()}
     * </p>
     *
     * @param assumeFleetRoleForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeFleetRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeFleetRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeFleetRoleForWorkerResponse> assumeFleetRoleForWorker(
            Consumer<AssumeFleetRoleForWorkerRequest.Builder> assumeFleetRoleForWorkerRequest) {
        return assumeFleetRoleForWorker(AssumeFleetRoleForWorkerRequest.builder().applyMutation(assumeFleetRoleForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForReadResponse> assumeQueueRoleForRead(
            AssumeQueueRoleForReadRequest assumeQueueRoleForReadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets Amazon Web Services credentials from the queue role. The IAM permissions of the credentials are scoped down
     * to have read-only access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForReadRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeQueueRoleForReadRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForReadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeQueueRoleForRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForReadResponse> assumeQueueRoleForRead(
            Consumer<AssumeQueueRoleForReadRequest.Builder> assumeQueueRoleForReadRequest) {
        return assumeQueueRoleForRead(AssumeQueueRoleForReadRequest.builder().applyMutation(assumeQueueRoleForReadRequest)
                .build());
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForUserResponse> assumeQueueRoleForUser(
            AssumeQueueRoleForUserRequest assumeQueueRoleForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to assume a role for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AssumeQueueRoleForUserRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeQueueRoleForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForUserResponse> assumeQueueRoleForUser(
            Consumer<AssumeQueueRoleForUserRequest.Builder> assumeQueueRoleForUserRequest) {
        return assumeQueueRoleForUser(AssumeQueueRoleForUserRequest.builder().applyMutation(assumeQueueRoleForUserRequest)
                .build());
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     * @return A Java Future containing the result of the AssumeQueueRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForWorkerResponse> assumeQueueRoleForWorker(
            AssumeQueueRoleForWorkerRequest assumeQueueRoleForWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a worker to assume a queue role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeQueueRoleForWorkerRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeQueueRoleForWorkerRequest#builder()}
     * </p>
     *
     * @param assumeQueueRoleForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeQueueRoleForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.AssumeQueueRoleForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeQueueRoleForWorkerResponse> assumeQueueRoleForWorker(
            Consumer<AssumeQueueRoleForWorkerRequest.Builder> assumeQueueRoleForWorkerRequest) {
        return assumeQueueRoleForWorker(AssumeQueueRoleForWorkerRequest.builder().applyMutation(assumeQueueRoleForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     *
     * @param batchGetJobEntityRequest
     * @return A Java Future containing the result of the BatchGetJobEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetJobEntityResponse> batchGetJobEntity(BatchGetJobEntityRequest batchGetJobEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get batched job details for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetJobEntityRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetJobEntityRequest#builder()}
     * </p>
     *
     * @param batchGetJobEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetJobEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.BatchGetJobEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetJobEntityResponse> batchGetJobEntity(
            Consumer<BatchGetJobEntityRequest.Builder> batchGetJobEntityRequest) {
        return batchGetJobEntity(BatchGetJobEntityRequest.builder().applyMutation(batchGetJobEntityRequest).build());
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     *
     * @param copyJobTemplateRequest
     * @return A Java Future containing the result of the CopyJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyJobTemplateResponse> copyJobTemplate(CopyJobTemplateRequest copyJobTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a job template to an Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CopyJobTemplateRequest#builder()}
     * </p>
     *
     * @param copyJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CopyJobTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CopyJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyJobTemplateResponse> copyJobTemplate(
            Consumer<CopyJobTemplateRequest.Builder> copyJobTemplateRequest) {
        return copyJobTemplate(CopyJobTemplateRequest.builder().applyMutation(copyJobTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     *
     * @param createBudgetRequest
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(CreateBudgetRequest createBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a budget to set spending thresholds for your rendering activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBudgetRequest#builder()}
     * </p>
     *
     * @param createBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateBudgetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(Consumer<CreateBudgetRequest.Builder> createBudgetRequest) {
        return createBudget(CreateBudgetRequest.builder().applyMutation(createBudgetRequest).build());
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     *
     * @param createFarmRequest
     * @return A Java Future containing the result of the CreateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFarmResponse> createFarm(CreateFarmRequest createFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a farm to allow space for queues and fleets. Farms are the space where the components of your renders
     * gather and are pieced together in the cloud. Farms contain budgets and allow you to enforce permissions. Deadline
     * Cloud farms are a useful container for large projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFarmRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFarmRequest#builder()}
     * </p>
     *
     * @param createFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateFarmRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFarmResponse> createFarm(Consumer<CreateFarmRequest.Builder> createFarmRequest) {
        return createFarm(CreateFarmRequest.builder().applyMutation(createFarmRequest).build());
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet. Fleets gather information relating to compute, or capacity, for renders within your farms. You
     * can choose to manage your own capacity or opt to have fleets fully managed by Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a job. A job is a render submission submitted by a user. It contains specific job properties outlined as
     * steps and tasks.
     * </p>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job. A job is a render submission submitted by a user. It contains specific job properties outlined as
     * steps and tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     *
     * @param createLicenseEndpointRequest
     * @return A Java Future containing the result of the CreateLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseEndpointResponse> createLicenseEndpoint(
            CreateLicenseEndpointRequest createLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license endpoint to integrate your various licensed software used for rendering on Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param createLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseEndpointResponse> createLicenseEndpoint(
            Consumer<CreateLicenseEndpointRequest.Builder> createLicenseEndpointRequest) {
        return createLicenseEndpoint(CreateLicenseEndpointRequest.builder().applyMutation(createLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     *
     * @param createMonitorRequest
     * @return A Java Future containing the result of the CreateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMonitorResponse> createMonitor(CreateMonitorRequest createMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services Deadline Cloud monitor that you can use to view your farms, queues, and fleets.
     * After you submit a job, you can track the progress of the tasks and steps that make up the job, and then download
     * the job's results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMonitorRequest#builder()}
     * </p>
     *
     * @param createMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateMonitorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMonitorResponse> createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest) {
        return createMonitor(CreateMonitorRequest.builder().applyMutation(createMonitorRequest).build());
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     *
     * @param createQueueRequest
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a queue to coordinate the order in which jobs run on a farm. A queue can also specify where to pull
     * resources and indicate where to output completed jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest) {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     *
     * @param createQueueEnvironmentRequest
     * @return A Java Future containing the result of the CreateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueueEnvironmentResponse> createQueueEnvironment(
            CreateQueueEnvironmentRequest createQueueEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an environment for a queue that defines how jobs in the queue run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param createQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueueEnvironmentResponse> createQueueEnvironment(
            Consumer<CreateQueueEnvironmentRequest.Builder> createQueueEnvironmentRequest) {
        return createQueueEnvironment(CreateQueueEnvironmentRequest.builder().applyMutation(createQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     * @return A Java Future containing the result of the CreateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueueFleetAssociationResponse> createQueueFleetAssociation(
            CreateQueueFleetAssociationRequest createQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a queue and a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param createQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueueFleetAssociationResponse> createQueueFleetAssociation(
            Consumer<CreateQueueFleetAssociationRequest.Builder> createQueueFleetAssociationRequest) {
        return createQueueFleetAssociation(CreateQueueFleetAssociationRequest.builder()
                .applyMutation(createQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     *
     * @param createStorageProfileRequest
     * @return A Java Future containing the result of the CreateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStorageProfileResponse> createStorageProfile(
            CreateStorageProfileRequest createStorageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a storage profile that specifies the operating system, file type, and file location of resources used on
     * a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStorageProfileRequest#builder()}
     * </p>
     *
     * @param createStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateStorageProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStorageProfileResponse> createStorageProfile(
            Consumer<CreateStorageProfileRequest.Builder> createStorageProfileRequest) {
        return createStorageProfile(CreateStorageProfileRequest.builder().applyMutation(createStorageProfileRequest).build());
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     *
     * @param createWorkerRequest
     * @return A Java Future containing the result of the CreateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkerResponse> createWorker(CreateWorkerRequest createWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a worker. A worker tells your instance how much processing power (vCPU), and memory (GiB) you’ll need to
     * assemble the digital assets held within a particular instance. You can specify certain instance types to use, or
     * let the worker know which instances types to exclude.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkerRequest#builder()}
     * </p>
     *
     * @param createWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.CreateWorkerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkerResponse> createWorker(Consumer<CreateWorkerRequest.Builder> createWorkerRequest) {
        return createWorker(CreateWorkerRequest.builder().applyMutation(createWorkerRequest).build());
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     *
     * @param deleteBudgetRequest
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBudgetRequest#builder()}
     * </p>
     *
     * @param deleteBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteBudgetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(Consumer<DeleteBudgetRequest.Builder> deleteBudgetRequest) {
        return deleteBudget(DeleteBudgetRequest.builder().applyMutation(deleteBudgetRequest).build());
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     *
     * @param deleteFarmRequest
     * @return A Java Future containing the result of the DeleteFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFarmResponse> deleteFarm(DeleteFarmRequest deleteFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFarmRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFarmRequest#builder()}
     * </p>
     *
     * @param deleteFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteFarmRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFarmResponse> deleteFarm(Consumer<DeleteFarmRequest.Builder> deleteFarmRequest) {
        return deleteFarm(DeleteFarmRequest.builder().applyMutation(deleteFarmRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     * @return A Java Future containing the result of the DeleteLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseEndpointResponse> deleteLicenseEndpoint(
            DeleteLicenseEndpointRequest deleteLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a license endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param deleteLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseEndpointResponse> deleteLicenseEndpoint(
            Consumer<DeleteLicenseEndpointRequest.Builder> deleteLicenseEndpointRequest) {
        return deleteLicenseEndpoint(DeleteLicenseEndpointRequest.builder().applyMutation(deleteLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     *
     * @param deleteMeteredProductRequest
     * @return A Java Future containing the result of the DeleteMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMeteredProductResponse> deleteMeteredProduct(
            DeleteMeteredProductRequest deleteMeteredProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a metered product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMeteredProductRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMeteredProductRequest#builder()}
     * </p>
     *
     * @param deleteMeteredProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteMeteredProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMeteredProductResponse> deleteMeteredProduct(
            Consumer<DeleteMeteredProductRequest.Builder> deleteMeteredProductRequest) {
        return deleteMeteredProduct(DeleteMeteredProductRequest.builder().applyMutation(deleteMeteredProductRequest).build());
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return A Java Future containing the result of the DeleteMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a Deadline Cloud monitor. After you delete a monitor, you can create a new one and attach farms to the
     * monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMonitorRequest#builder()}
     * </p>
     *
     * @param deleteMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteMonitorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMonitorResponse> deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest) {
        return deleteMonitor(DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     *
     * @param deleteQueueRequest
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest) {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     * @return A Java Future containing the result of the DeleteQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueueEnvironmentResponse> deleteQueueEnvironment(
            DeleteQueueEnvironmentRequest deleteQueueEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueueEnvironmentResponse> deleteQueueEnvironment(
            Consumer<DeleteQueueEnvironmentRequest.Builder> deleteQueueEnvironmentRequest) {
        return deleteQueueEnvironment(DeleteQueueEnvironmentRequest.builder().applyMutation(deleteQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     * @return A Java Future containing the result of the DeleteQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueueFleetAssociationResponse> deleteQueueFleetAssociation(
            DeleteQueueFleetAssociationRequest deleteQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param deleteQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueueFleetAssociationResponse> deleteQueueFleetAssociation(
            Consumer<DeleteQueueFleetAssociationRequest.Builder> deleteQueueFleetAssociationRequest) {
        return deleteQueueFleetAssociation(DeleteQueueFleetAssociationRequest.builder()
                .applyMutation(deleteQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     *
     * @param deleteStorageProfileRequest
     * @return A Java Future containing the result of the DeleteStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStorageProfileResponse> deleteStorageProfile(
            DeleteStorageProfileRequest deleteStorageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStorageProfileRequest#builder()}
     * </p>
     *
     * @param deleteStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteStorageProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStorageProfileResponse> deleteStorageProfile(
            Consumer<DeleteStorageProfileRequest.Builder> deleteStorageProfileRequest) {
        return deleteStorageProfile(DeleteStorageProfileRequest.builder().applyMutation(deleteStorageProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     *
     * @param deleteWorkerRequest
     * @return A Java Future containing the result of the DeleteWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkerResponse> deleteWorker(DeleteWorkerRequest deleteWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkerRequest#builder()}
     * </p>
     *
     * @param deleteWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DeleteWorkerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkerResponse> deleteWorker(Consumer<DeleteWorkerRequest.Builder> deleteWorkerRequest) {
        return deleteWorker(DeleteWorkerRequest.builder().applyMutation(deleteWorkerRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     * @return A Java Future containing the result of the DisassociateMemberFromFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromFarmResponse> disassociateMemberFromFarm(
            DisassociateMemberFromFarmRequest disassociateMemberFromFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromFarmRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateMemberFromFarmRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFarmRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateMemberFromFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromFarmResponse> disassociateMemberFromFarm(
            Consumer<DisassociateMemberFromFarmRequest.Builder> disassociateMemberFromFarmRequest) {
        return disassociateMemberFromFarm(DisassociateMemberFromFarmRequest.builder()
                .applyMutation(disassociateMemberFromFarmRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     * @return A Java Future containing the result of the DisassociateMemberFromFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromFleetResponse> disassociateMemberFromFleet(
            DisassociateMemberFromFleetRequest disassociateMemberFromFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromFleetRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromFleetRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromFleetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateMemberFromFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromFleetResponse> disassociateMemberFromFleet(
            Consumer<DisassociateMemberFromFleetRequest.Builder> disassociateMemberFromFleetRequest) {
        return disassociateMemberFromFleet(DisassociateMemberFromFleetRequest.builder()
                .applyMutation(disassociateMemberFromFleetRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     * @return A Java Future containing the result of the DisassociateMemberFromJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromJobResponse> disassociateMemberFromJob(
            DisassociateMemberFromJobRequest disassociateMemberFromJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromJobRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateMemberFromJobRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateMemberFromJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromJobResponse> disassociateMemberFromJob(
            Consumer<DisassociateMemberFromJobRequest.Builder> disassociateMemberFromJobRequest) {
        return disassociateMemberFromJob(DisassociateMemberFromJobRequest.builder()
                .applyMutation(disassociateMemberFromJobRequest).build());
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     * @return A Java Future containing the result of the DisassociateMemberFromQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromQueueResponse> disassociateMemberFromQueue(
            DisassociateMemberFromQueueRequest disassociateMemberFromQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member from a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromQueueRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromQueueRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.DisassociateMemberFromQueueRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateMemberFromQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.DisassociateMemberFromQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromQueueResponse> disassociateMemberFromQueue(
            Consumer<DisassociateMemberFromQueueRequest.Builder> disassociateMemberFromQueueRequest) {
        return disassociateMemberFromQueue(DisassociateMemberFromQueueRequest.builder()
                .applyMutation(disassociateMemberFromQueueRequest).build());
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     *
     * @param getBudgetRequest
     * @return A Java Future containing the result of the GetBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBudgetResponse> getBudget(GetBudgetRequest getBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link GetBudgetRequest#builder()}
     * </p>
     *
     * @param getBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetBudgetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBudgetResponse> getBudget(Consumer<GetBudgetRequest.Builder> getBudgetRequest) {
        return getBudget(GetBudgetRequest.builder().applyMutation(getBudgetRequest).build());
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     *
     * @param getFarmRequest
     * @return A Java Future containing the result of the GetFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFarmResponse> getFarm(GetFarmRequest getFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFarmRequest.Builder} avoiding the need to create
     * one manually via {@link GetFarmRequest#builder()}
     * </p>
     *
     * @param getFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetFarmRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFarmResponse> getFarm(Consumer<GetFarmRequest.Builder> getFarmRequest) {
        return getFarm(GetFarmRequest.builder().applyMutation(getFarmRequest).build());
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFleetResponse> getFleet(GetFleetRequest getFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFleetRequest.Builder} avoiding the need to
     * create one manually via {@link GetFleetRequest#builder()}
     * </p>
     *
     * @param getFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFleetResponse> getFleet(Consumer<GetFleetRequest.Builder> getFleetRequest) {
        return getFleet(GetFleetRequest.builder().applyMutation(getFleetRequest).build());
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     *
     * @param getJobRequest
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Deadline Cloud job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(Consumer<GetJobRequest.Builder> getJobRequest) {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     *
     * @param getLicenseEndpointRequest
     * @return A Java Future containing the result of the GetLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLicenseEndpointResponse> getLicenseEndpoint(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a licence endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetLicenseEndpointRequest#builder()}
     * </p>
     *
     * @param getLicenseEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLicenseEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetLicenseEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLicenseEndpointResponse> getLicenseEndpoint(
            Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest) {
        return getLicenseEndpoint(GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     *
     * @param getMonitorRequest
     * @return A Java Future containing the result of the GetMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMonitorResponse> getMonitor(GetMonitorRequest getMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link GetMonitorRequest#builder()}
     * </p>
     *
     * @param getMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetMonitorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMonitorResponse> getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) {
        return getMonitor(GetMonitorRequest.builder().applyMutation(getMonitorRequest).build());
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     *
     * @param getQueueRequest
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueueRequest#builder()}
     * </p>
     *
     * @param getQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return getQueue(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     *
     * @param getQueueEnvironmentRequest
     * @return A Java Future containing the result of the GetQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueueEnvironmentResponse> getQueueEnvironment(
            GetQueueEnvironmentRequest getQueueEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link GetQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param getQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueueEnvironmentResponse> getQueueEnvironment(
            Consumer<GetQueueEnvironmentRequest.Builder> getQueueEnvironmentRequest) {
        return getQueueEnvironment(GetQueueEnvironmentRequest.builder().applyMutation(getQueueEnvironmentRequest).build());
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     * @return A Java Future containing the result of the GetQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueueFleetAssociationResponse> getQueueFleetAssociation(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueFleetAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param getQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueueFleetAssociationResponse> getQueueFleetAssociation(
            Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest) {
        return getQueueFleetAssociation(GetQueueFleetAssociationRequest.builder().applyMutation(getQueueFleetAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     *
     * @param getSessionActionRequest
     * @return A Java Future containing the result of the GetSessionAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionActionResponse> getSessionAction(GetSessionActionRequest getSessionActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a session action for the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionActionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSessionActionRequest#builder()}
     * </p>
     *
     * @param getSessionActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSessionAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionActionResponse> getSessionAction(
            Consumer<GetSessionActionRequest.Builder> getSessionActionRequest) {
        return getSessionAction(GetSessionActionRequest.builder().applyMutation(getSessionActionRequest).build());
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return A Java Future containing the result of the GetSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSessionsStatisticsAggregationResponse> getSessionsStatisticsAggregation(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a set of statistics for queues or farms. Before you can call the
     * <code>GetSessionStatisticsAggregation</code> operation, you must first call the
     * <code>StartSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call the
     * <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link GetSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSessionsStatisticsAggregationResponse> getSessionsStatisticsAggregation(
            Consumer<GetSessionsStatisticsAggregationRequest.Builder> getSessionsStatisticsAggregationRequest) {
        return getSessionsStatisticsAggregation(GetSessionsStatisticsAggregationRequest.builder()
                .applyMutation(getSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationPublisher publisher = client.getSessionsStatisticsAggregationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationPublisher publisher = client.getSessionsStatisticsAggregationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationPublisher getSessionsStatisticsAggregationPaginator(
            GetSessionsStatisticsAggregationRequest getSessionsStatisticsAggregationRequest) {
        return new GetSessionsStatisticsAggregationPublisher(this, getSessionsStatisticsAggregationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationPublisher publisher = client.getSessionsStatisticsAggregationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.GetSessionsStatisticsAggregationPublisher publisher = client.getSessionsStatisticsAggregationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSessionsStatisticsAggregation(software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link GetSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param getSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSessionsStatisticsAggregationPublisher getSessionsStatisticsAggregationPaginator(
            Consumer<GetSessionsStatisticsAggregationRequest.Builder> getSessionsStatisticsAggregationRequest) {
        return getSessionsStatisticsAggregationPaginator(GetSessionsStatisticsAggregationRequest.builder()
                .applyMutation(getSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     *
     * @param getStepRequest
     * @return A Java Future containing the result of the GetStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStepResponse> getStep(GetStepRequest getStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStepRequest.Builder} avoiding the need to create
     * one manually via {@link GetStepRequest#builder()}
     * </p>
     *
     * @param getStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStepRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStepResponse> getStep(Consumer<GetStepRequest.Builder> getStepRequest) {
        return getStep(GetStepRequest.builder().applyMutation(getStepRequest).build());
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     *
     * @param getStorageProfileRequest
     * @return A Java Future containing the result of the GetStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStorageProfileResponse> getStorageProfile(GetStorageProfileRequest getStorageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStorageProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetStorageProfileRequest#builder()}
     * </p>
     *
     * @param getStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStorageProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStorageProfileResponse> getStorageProfile(
            Consumer<GetStorageProfileRequest.Builder> getStorageProfileRequest) {
        return getStorageProfile(GetStorageProfileRequest.builder().applyMutation(getStorageProfileRequest).build());
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     * @return A Java Future containing the result of the GetStorageProfileForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStorageProfileForQueueResponse> getStorageProfileForQueue(
            GetStorageProfileForQueueRequest getStorageProfileForQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a storage profile for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStorageProfileForQueueRequest.Builder} avoiding
     * the need to create one manually via {@link GetStorageProfileForQueueRequest#builder()}
     * </p>
     *
     * @param getStorageProfileForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetStorageProfileForQueueRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetStorageProfileForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetStorageProfileForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStorageProfileForQueueResponse> getStorageProfileForQueue(
            Consumer<GetStorageProfileForQueueRequest.Builder> getStorageProfileForQueueRequest) {
        return getStorageProfileForQueue(GetStorageProfileForQueueRequest.builder()
                .applyMutation(getStorageProfileForQueueRequest).build());
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     *
     * @param getTaskRequest
     * @return A Java Future containing the result of the GetTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskResponse> getTask(GetTaskRequest getTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskRequest.Builder} avoiding the need to create
     * one manually via {@link GetTaskRequest#builder()}
     * </p>
     *
     * @param getTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskResponse> getTask(Consumer<GetTaskRequest.Builder> getTaskRequest) {
        return getTask(GetTaskRequest.builder().applyMutation(getTaskRequest).build());
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     *
     * @param getWorkerRequest
     * @return A Java Future containing the result of the GetWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkerResponse> getWorker(GetWorkerRequest getWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkerRequest#builder()}
     * </p>
     *
     * @param getWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.GetWorkerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkerResponse> getWorker(Consumer<GetWorkerRequest.Builder> getWorkerRequest) {
        return getWorker(GetWorkerRequest.builder().applyMutation(getWorkerRequest).build());
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return A Java Future containing the result of the ListAvailableMeteredProducts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableMeteredProductsResponse> listAvailableMeteredProducts(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of the available metered products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableMeteredProductsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAvailableMeteredProducts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableMeteredProductsResponse> listAvailableMeteredProducts(
            Consumer<ListAvailableMeteredProductsRequest.Builder> listAvailableMeteredProductsRequest) {
        return listAvailableMeteredProducts(ListAvailableMeteredProductsRequest.builder()
                .applyMutation(listAvailableMeteredProductsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsPublisher publisher = client.listAvailableMeteredProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsPublisher publisher = client.listAvailableMeteredProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsPublisher listAvailableMeteredProductsPaginator(
            ListAvailableMeteredProductsRequest listAvailableMeteredProductsRequest) {
        return new ListAvailableMeteredProductsPublisher(this, listAvailableMeteredProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsPublisher publisher = client.listAvailableMeteredProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListAvailableMeteredProductsPublisher publisher = client.listAvailableMeteredProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableMeteredProducts(software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableMeteredProductsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listAvailableMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListAvailableMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableMeteredProductsPublisher listAvailableMeteredProductsPaginator(
            Consumer<ListAvailableMeteredProductsRequest.Builder> listAvailableMeteredProductsRequest) {
        return listAvailableMeteredProductsPaginator(ListAvailableMeteredProductsRequest.builder()
                .applyMutation(listAvailableMeteredProductsRequest).build());
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     *
     * @param listBudgetsRequest
     * @return A Java Future containing the result of the ListBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBudgetsResponse> listBudgets(ListBudgetsRequest listBudgetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of budgets in a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBudgetsRequest#builder()}
     * </p>
     *
     * @param listBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListBudgetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBudgetsResponse> listBudgets(Consumer<ListBudgetsRequest.Builder> listBudgetsRequest) {
        return listBudgets(ListBudgetsRequest.builder().applyMutation(listBudgetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsPublisher publisher = client.listBudgetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsPublisher publisher = client.listBudgetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListBudgetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListBudgetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)} operation.</b>
     * </p>
     *
     * @param listBudgetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsPublisher listBudgetsPaginator(ListBudgetsRequest listBudgetsRequest) {
        return new ListBudgetsPublisher(this, listBudgetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsPublisher publisher = client.listBudgetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListBudgetsPublisher publisher = client.listBudgetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListBudgetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListBudgetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgets(software.amazon.awssdk.services.deadline.model.ListBudgetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBudgetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBudgetsRequest#builder()}
     * </p>
     *
     * @param listBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListBudgetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBudgetsPublisher listBudgetsPaginator(Consumer<ListBudgetsRequest.Builder> listBudgetsRequest) {
        return listBudgetsPaginator(ListBudgetsRequest.builder().applyMutation(listBudgetsRequest).build());
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     *
     * @param listFarmMembersRequest
     * @return A Java Future containing the result of the ListFarmMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFarmMembersResponse> listFarmMembers(ListFarmMembersRequest listFarmMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the members of a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFarmMembersRequest#builder()}
     * </p>
     *
     * @param listFarmMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFarmMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFarmMembersResponse> listFarmMembers(
            Consumer<ListFarmMembersRequest.Builder> listFarmMembersRequest) {
        return listFarmMembers(ListFarmMembersRequest.builder().applyMutation(listFarmMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersPublisher publisher = client.listFarmMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersPublisher publisher = client.listFarmMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation.</b>
     * </p>
     *
     * @param listFarmMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersPublisher listFarmMembersPaginator(ListFarmMembersRequest listFarmMembersRequest) {
        return new ListFarmMembersPublisher(this, listFarmMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersPublisher publisher = client.listFarmMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmMembersPublisher publisher = client.listFarmMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarmMembers(software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFarmMembersRequest#builder()}
     * </p>
     *
     * @param listFarmMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarmMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmMembersPublisher listFarmMembersPaginator(Consumer<ListFarmMembersRequest.Builder> listFarmMembersRequest) {
        return listFarmMembersPaginator(ListFarmMembersRequest.builder().applyMutation(listFarmMembersRequest).build());
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     *
     * @param listFarmsRequest
     * @return A Java Future containing the result of the ListFarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFarmsResponse> listFarms(ListFarmsRequest listFarmsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists farms.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFarmsRequest#builder()}
     * </p>
     *
     * @param listFarmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFarmsResponse> listFarms(Consumer<ListFarmsRequest.Builder> listFarmsRequest) {
        return listFarms(ListFarmsRequest.builder().applyMutation(listFarmsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsPublisher publisher = client.listFarmsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsPublisher publisher = client.listFarmsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFarmsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFarmsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)} operation.</b>
     * </p>
     *
     * @param listFarmsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsPublisher listFarmsPaginator(ListFarmsRequest listFarmsRequest) {
        return new ListFarmsPublisher(this, listFarmsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsPublisher publisher = client.listFarmsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFarmsPublisher publisher = client.listFarmsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFarmsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFarmsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFarms(software.amazon.awssdk.services.deadline.model.ListFarmsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFarmsRequest#builder()}
     * </p>
     *
     * @param listFarmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFarmsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFarmsPublisher listFarmsPaginator(Consumer<ListFarmsRequest.Builder> listFarmsRequest) {
        return listFarmsPaginator(ListFarmsRequest.builder().applyMutation(listFarmsRequest).build());
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     *
     * @param listFleetMembersRequest
     * @return A Java Future containing the result of the ListFleetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetMembersResponse> listFleetMembers(ListFleetMembersRequest listFleetMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists fleet members.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMembersRequest#builder()}
     * </p>
     *
     * @param listFleetMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFleetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetMembersResponse> listFleetMembers(
            Consumer<ListFleetMembersRequest.Builder> listFleetMembersRequest) {
        return listFleetMembers(ListFleetMembersRequest.builder().applyMutation(listFleetMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersPublisher publisher = client.listFleetMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersPublisher publisher = client.listFleetMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation.</b>
     * </p>
     *
     * @param listFleetMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersPublisher listFleetMembersPaginator(ListFleetMembersRequest listFleetMembersRequest) {
        return new ListFleetMembersPublisher(this, listFleetMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersPublisher publisher = client.listFleetMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetMembersPublisher publisher = client.listFleetMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMembers(software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMembersRequest#builder()}
     * </p>
     *
     * @param listFleetMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetMembersPublisher listFleetMembersPaginator(Consumer<ListFleetMembersRequest.Builder> listFleetMembersRequest) {
        return listFleetMembersPaginator(ListFleetMembersRequest.builder().applyMutation(listFleetMembersRequest).build());
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        return new ListFleetsPublisher(this, listFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.deadline.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     *
     * @param listJobMembersRequest
     * @return A Java Future containing the result of the ListJobMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobMembersResponse> listJobMembers(ListJobMembersRequest listJobMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists members on a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobMembersRequest#builder()}
     * </p>
     *
     * @param listJobMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJobMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobMembersResponse> listJobMembers(Consumer<ListJobMembersRequest.Builder> listJobMembersRequest) {
        return listJobMembers(ListJobMembersRequest.builder().applyMutation(listJobMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersPublisher publisher = client.listJobMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersPublisher publisher = client.listJobMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListJobMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListJobMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation.</b>
     * </p>
     *
     * @param listJobMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersPublisher listJobMembersPaginator(ListJobMembersRequest listJobMembersRequest) {
        return new ListJobMembersPublisher(this, listJobMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersPublisher publisher = client.listJobMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobMembersPublisher publisher = client.listJobMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListJobMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListJobMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobMembers(software.amazon.awssdk.services.deadline.model.ListJobMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobMembersRequest#builder()}
     * </p>
     *
     * @param listJobMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobMembersPublisher listJobMembersPaginator(Consumer<ListJobMembersRequest.Builder> listJobMembersRequest) {
        return listJobMembersPaginator(ListJobMembersRequest.builder().applyMutation(listJobMembersRequest).build());
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, listJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.deadline.model.ListJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return A Java Future containing the result of the ListLicenseEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLicenseEndpointsResponse> listLicenseEndpoints(
            ListLicenseEndpointsRequest listLicenseEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists license endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLicenseEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLicenseEndpointsResponse> listLicenseEndpoints(
            Consumer<ListLicenseEndpointsRequest.Builder> listLicenseEndpointsRequest) {
        return listLicenseEndpoints(ListLicenseEndpointsRequest.builder().applyMutation(listLicenseEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsPublisher publisher = client.listLicenseEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsPublisher publisher = client.listLicenseEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLicenseEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsPublisher listLicenseEndpointsPaginator(ListLicenseEndpointsRequest listLicenseEndpointsRequest) {
        return new ListLicenseEndpointsPublisher(this, listLicenseEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsPublisher publisher = client.listLicenseEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListLicenseEndpointsPublisher publisher = client.listLicenseEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseEndpoints(software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListLicenseEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicenseEndpointsPublisher listLicenseEndpointsPaginator(
            Consumer<ListLicenseEndpointsRequest.Builder> listLicenseEndpointsRequest) {
        return listLicenseEndpointsPaginator(ListLicenseEndpointsRequest.builder().applyMutation(listLicenseEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return A Java Future containing the result of the ListMeteredProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMeteredProductsResponse> listMeteredProducts(
            ListMeteredProductsRequest listMeteredProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists metered products.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeteredProductsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMeteredProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMeteredProductsResponse> listMeteredProducts(
            Consumer<ListMeteredProductsRequest.Builder> listMeteredProductsRequest) {
        return listMeteredProducts(ListMeteredProductsRequest.builder().applyMutation(listMeteredProductsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsPublisher publisher = client.listMeteredProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsPublisher publisher = client.listMeteredProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMeteredProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsPublisher listMeteredProductsPaginator(ListMeteredProductsRequest listMeteredProductsRequest) {
        return new ListMeteredProductsPublisher(this, listMeteredProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsPublisher publisher = client.listMeteredProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMeteredProductsPublisher publisher = client.listMeteredProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeteredProducts(software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeteredProductsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMeteredProductsRequest#builder()}
     * </p>
     *
     * @param listMeteredProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMeteredProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMeteredProductsPublisher listMeteredProductsPaginator(
            Consumer<ListMeteredProductsRequest.Builder> listMeteredProductsRequest) {
        return listMeteredProductsPaginator(ListMeteredProductsRequest.builder().applyMutation(listMeteredProductsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     *
     * @param listMonitorsRequest
     * @return A Java Future containing the result of the ListMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMonitorsResponse> listMonitors(ListMonitorsRequest listMonitorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of your monitors in Deadline Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMonitorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMonitorsResponse> listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return listMonitors(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListMonitorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListMonitorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)} operation.</b>
     * </p>
     *
     * @param listMonitorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsPublisher listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) {
        return new ListMonitorsPublisher(this, listMonitorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListMonitorsPublisher publisher = client.listMonitorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListMonitorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListMonitorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.deadline.model.ListMonitorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListMonitorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsPublisher listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return listMonitorsPaginator(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return A Java Future containing the result of the ListQueueEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueueEnvironmentsResponse> listQueueEnvironments(
            ListQueueEnvironmentsRequest listQueueEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queue environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQueueEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueueEnvironmentsResponse> listQueueEnvironments(
            Consumer<ListQueueEnvironmentsRequest.Builder> listQueueEnvironmentsRequest) {
        return listQueueEnvironments(ListQueueEnvironmentsRequest.builder().applyMutation(listQueueEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsPublisher publisher = client.listQueueEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsPublisher publisher = client.listQueueEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsPublisher listQueueEnvironmentsPaginator(
            ListQueueEnvironmentsRequest listQueueEnvironmentsRequest) {
        return new ListQueueEnvironmentsPublisher(this, listQueueEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsPublisher publisher = client.listQueueEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueEnvironmentsPublisher publisher = client.listQueueEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueEnvironments(software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listQueueEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueEnvironmentsPublisher listQueueEnvironmentsPaginator(
            Consumer<ListQueueEnvironmentsRequest.Builder> listQueueEnvironmentsRequest) {
        return listQueueEnvironmentsPaginator(ListQueueEnvironmentsRequest.builder().applyMutation(listQueueEnvironmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return A Java Future containing the result of the ListQueueFleetAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueueFleetAssociationsResponse> listQueueFleetAssociations(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queue-fleet associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueFleetAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueueFleetAssociationsRequest#builder()}
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListQueueFleetAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueueFleetAssociationsResponse> listQueueFleetAssociations(
            Consumer<ListQueueFleetAssociationsRequest.Builder> listQueueFleetAssociationsRequest) {
        return listQueueFleetAssociations(ListQueueFleetAssociationsRequest.builder()
                .applyMutation(listQueueFleetAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsPublisher publisher = client.listQueueFleetAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsPublisher publisher = client.listQueueFleetAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsPublisher listQueueFleetAssociationsPaginator(
            ListQueueFleetAssociationsRequest listQueueFleetAssociationsRequest) {
        return new ListQueueFleetAssociationsPublisher(this, listQueueFleetAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsPublisher publisher = client.listQueueFleetAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueFleetAssociationsPublisher publisher = client.listQueueFleetAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueFleetAssociations(software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueFleetAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueueFleetAssociationsRequest#builder()}
     * </p>
     *
     * @param listQueueFleetAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueFleetAssociationsPublisher listQueueFleetAssociationsPaginator(
            Consumer<ListQueueFleetAssociationsRequest.Builder> listQueueFleetAssociationsRequest) {
        return listQueueFleetAssociationsPaginator(ListQueueFleetAssociationsRequest.builder()
                .applyMutation(listQueueFleetAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     *
     * @param listQueueMembersRequest
     * @return A Java Future containing the result of the ListQueueMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueueMembersResponse> listQueueMembers(ListQueueMembersRequest listQueueMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the members in a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListQueueMembersRequest#builder()}
     * </p>
     *
     * @param listQueueMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQueueMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueueMembersResponse> listQueueMembers(
            Consumer<ListQueueMembersRequest.Builder> listQueueMembersRequest) {
        return listQueueMembers(ListQueueMembersRequest.builder().applyMutation(listQueueMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersPublisher publisher = client.listQueueMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersPublisher publisher = client.listQueueMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation.</b>
     * </p>
     *
     * @param listQueueMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersPublisher listQueueMembersPaginator(ListQueueMembersRequest listQueueMembersRequest) {
        return new ListQueueMembersPublisher(this, listQueueMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersPublisher publisher = client.listQueueMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueueMembersPublisher publisher = client.listQueueMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueMembers(software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListQueueMembersRequest#builder()}
     * </p>
     *
     * @param listQueueMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueueMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueueMembersPublisher listQueueMembersPaginator(Consumer<ListQueueMembersRequest.Builder> listQueueMembersRequest) {
        return listQueueMembersPaginator(ListQueueMembersRequest.builder().applyMutation(listQueueMembersRequest).build());
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     *
     * @param listQueuesRequest
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists queues.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueuesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(ListQueuesRequest listQueuesRequest) {
        return new ListQueuesPublisher(this, listQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.deadline.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListQueuesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     *
     * @param listSessionActionsRequest
     * @return A Java Future containing the result of the ListSessionActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSessionActionsResponse> listSessionActions(ListSessionActionsRequest listSessionActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists session actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionActionsRequest#builder()}
     * </p>
     *
     * @param listSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSessionActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSessionActionsResponse> listSessionActions(
            Consumer<ListSessionActionsRequest.Builder> listSessionActionsRequest) {
        return listSessionActions(ListSessionActionsRequest.builder().applyMutation(listSessionActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsPublisher publisher = client.listSessionActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsPublisher publisher = client.listSessionActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsPublisher listSessionActionsPaginator(ListSessionActionsRequest listSessionActionsRequest) {
        return new ListSessionActionsPublisher(this, listSessionActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsPublisher publisher = client.listSessionActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionActionsPublisher publisher = client.listSessionActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionActions(software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionActionsRequest#builder()}
     * </p>
     *
     * @param listSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionActionsPublisher listSessionActionsPaginator(
            Consumer<ListSessionActionsRequest.Builder> listSessionActionsRequest) {
        return listSessionActionsPaginator(ListSessionActionsRequest.builder().applyMutation(listSessionActionsRequest).build());
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return A Java Future containing the result of the ListSessionsForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsForWorkerResponse> listSessionsForWorker(
            ListSessionsForWorkerRequest listSessionsForWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists sessions for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsForWorkerRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionsForWorkerRequest#builder()}
     * </p>
     *
     * @param listSessionsForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSessionsForWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsForWorkerResponse> listSessionsForWorker(
            Consumer<ListSessionsForWorkerRequest.Builder> listSessionsForWorkerRequest) {
        return listSessionsForWorker(ListSessionsForWorkerRequest.builder().applyMutation(listSessionsForWorkerRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerPublisher publisher = client.listSessionsForWorkerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerPublisher publisher = client.listSessionsForWorkerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionsForWorkerRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerPublisher listSessionsForWorkerPaginator(
            ListSessionsForWorkerRequest listSessionsForWorkerRequest) {
        return new ListSessionsForWorkerPublisher(this, listSessionsForWorkerRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerPublisher publisher = client.listSessionsForWorkerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsForWorkerPublisher publisher = client.listSessionsForWorkerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessionsForWorker(software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsForWorkerRequest.Builder} avoiding the
     * need to create one manually via {@link ListSessionsForWorkerRequest#builder()}
     * </p>
     *
     * @param listSessionsForWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessionsForWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsForWorkerPublisher listSessionsForWorkerPaginator(
            Consumer<ListSessionsForWorkerRequest.Builder> listSessionsForWorkerRequest) {
        return listSessionsForWorkerPaginator(ListSessionsForWorkerRequest.builder().applyMutation(listSessionsForWorkerRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(ListSessionsRequest listSessionsRequest) {
        return new ListSessionsPublisher(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.deadline.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListSessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     *
     * @param listStepConsumersRequest
     * @return A Java Future containing the result of the ListStepConsumers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepConsumersResponse> listStepConsumers(ListStepConsumersRequest listStepConsumersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists step consumers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepConsumersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStepConsumersRequest#builder()}
     * </p>
     *
     * @param listStepConsumersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStepConsumers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepConsumersResponse> listStepConsumers(
            Consumer<ListStepConsumersRequest.Builder> listStepConsumersRequest) {
        return listStepConsumers(ListStepConsumersRequest.builder().applyMutation(listStepConsumersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersPublisher publisher = client.listStepConsumersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersPublisher publisher = client.listStepConsumersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStepConsumersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersPublisher listStepConsumersPaginator(ListStepConsumersRequest listStepConsumersRequest) {
        return new ListStepConsumersPublisher(this, listStepConsumersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersPublisher publisher = client.listStepConsumersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepConsumersPublisher publisher = client.listStepConsumersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepConsumers(software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepConsumersRequest.Builder} avoiding the need
     * to create one manually via {@link ListStepConsumersRequest#builder()}
     * </p>
     *
     * @param listStepConsumersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepConsumersPublisher listStepConsumersPaginator(
            Consumer<ListStepConsumersRequest.Builder> listStepConsumersRequest) {
        return listStepConsumersPaginator(ListStepConsumersRequest.builder().applyMutation(listStepConsumersRequest).build());
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return A Java Future containing the result of the ListStepDependencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepDependenciesResponse> listStepDependencies(
            ListStepDependenciesRequest listStepDependenciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the dependencies for a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepDependenciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStepDependenciesRequest#builder()}
     * </p>
     *
     * @param listStepDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStepDependencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepDependenciesResponse> listStepDependencies(
            Consumer<ListStepDependenciesRequest.Builder> listStepDependenciesRequest) {
        return listStepDependencies(ListStepDependenciesRequest.builder().applyMutation(listStepDependenciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesPublisher publisher = client.listStepDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesPublisher publisher = client.listStepDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStepDependenciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesPublisher listStepDependenciesPaginator(ListStepDependenciesRequest listStepDependenciesRequest) {
        return new ListStepDependenciesPublisher(this, listStepDependenciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesPublisher publisher = client.listStepDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepDependenciesPublisher publisher = client.listStepDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStepDependencies(software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepDependenciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStepDependenciesRequest#builder()}
     * </p>
     *
     * @param listStepDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStepDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepDependenciesPublisher listStepDependenciesPaginator(
            Consumer<ListStepDependenciesRequest.Builder> listStepDependenciesRequest) {
        return listStepDependenciesPaginator(ListStepDependenciesRequest.builder().applyMutation(listStepDependenciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     *
     * @param listStepsRequest
     * @return A Java Future containing the result of the ListSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStepsResponse> listSteps(ListStepsRequest listStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists steps for a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStepsResponse> listSteps(Consumer<ListStepsRequest.Builder> listStepsRequest) {
        return listSteps(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)} operation.</b>
     * </p>
     *
     * @param listStepsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsPublisher listStepsPaginator(ListStepsRequest listStepsRequest) {
        return new ListStepsPublisher(this, listStepsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.deadline.model.ListStepsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStepsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsPublisher listStepsPaginator(Consumer<ListStepsRequest.Builder> listStepsRequest) {
        return listStepsPaginator(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return A Java Future containing the result of the ListStorageProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStorageProfilesResponse> listStorageProfiles(
            ListStorageProfilesRequest listStorageProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists storage profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageProfilesRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStorageProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStorageProfilesResponse> listStorageProfiles(
            Consumer<ListStorageProfilesRequest.Builder> listStorageProfilesRequest) {
        return listStorageProfiles(ListStorageProfilesRequest.builder().applyMutation(listStorageProfilesRequest).build());
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return A Java Future containing the result of the ListStorageProfilesForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStorageProfilesForQueueResponse> listStorageProfilesForQueue(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists storage profiles for a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesForQueueRequest.Builder}
     * avoiding the need to create one manually via {@link ListStorageProfilesForQueueRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListStorageProfilesForQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStorageProfilesForQueueResponse> listStorageProfilesForQueue(
            Consumer<ListStorageProfilesForQueueRequest.Builder> listStorageProfilesForQueueRequest) {
        return listStorageProfilesForQueue(ListStorageProfilesForQueueRequest.builder()
                .applyMutation(listStorageProfilesForQueueRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueuePublisher publisher = client.listStorageProfilesForQueuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueuePublisher publisher = client.listStorageProfilesForQueuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueuePublisher listStorageProfilesForQueuePaginator(
            ListStorageProfilesForQueueRequest listStorageProfilesForQueueRequest) {
        return new ListStorageProfilesForQueuePublisher(this, listStorageProfilesForQueueRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueuePublisher publisher = client.listStorageProfilesForQueuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesForQueuePublisher publisher = client.listStorageProfilesForQueuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfilesForQueue(software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesForQueueRequest.Builder}
     * avoiding the need to create one manually via {@link ListStorageProfilesForQueueRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesForQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfilesForQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageProfilesForQueuePublisher listStorageProfilesForQueuePaginator(
            Consumer<ListStorageProfilesForQueueRequest.Builder> listStorageProfilesForQueueRequest) {
        return listStorageProfilesForQueuePaginator(ListStorageProfilesForQueueRequest.builder()
                .applyMutation(listStorageProfilesForQueueRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesPublisher publisher = client.listStorageProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesPublisher publisher = client.listStorageProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesPublisher listStorageProfilesPaginator(ListStorageProfilesRequest listStorageProfilesRequest) {
        return new ListStorageProfilesPublisher(this, listStorageProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesPublisher publisher = client.listStorageProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListStorageProfilesPublisher publisher = client.listStorageProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListStorageProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageProfiles(software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageProfilesRequest#builder()}
     * </p>
     *
     * @param listStorageProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListStorageProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListStorageProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageProfilesPublisher listStorageProfilesPaginator(
            Consumer<ListStorageProfilesRequest.Builder> listStorageProfilesRequest) {
        return listStorageProfilesPaginator(ListStorageProfilesRequest.builder().applyMutation(listStorageProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     *
     * @param listTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tasks for a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(ListTasksRequest listTasksRequest) {
        return new ListTasksPublisher(this, listTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.deadline.model.ListTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     *
     * @param listWorkersRequest
     * @return A Java Future containing the result of the ListWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkersResponse> listWorkers(ListWorkersRequest listWorkersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists workers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListWorkersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkersResponse> listWorkers(Consumer<ListWorkersRequest.Builder> listWorkersRequest) {
        return listWorkers(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListWorkersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListWorkersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)} operation.</b>
     * </p>
     *
     * @param listWorkersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersPublisher listWorkersPaginator(ListWorkersRequest listWorkersRequest) {
        return new ListWorkersPublisher(this, listWorkersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.deadline.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.deadline.model.ListWorkersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.deadline.model.ListWorkersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.deadline.model.ListWorkersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.ListWorkersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkersPublisher listWorkersPaginator(Consumer<ListWorkersRequest.Builder> listWorkersRequest) {
        return listWorkersPaginator(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     *
     * @param putMeteredProductRequest
     * @return A Java Future containing the result of the PutMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutMeteredProductResponse> putMeteredProduct(PutMeteredProductRequest putMeteredProductRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a metered product.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMeteredProductRequest.Builder} avoiding the need
     * to create one manually via {@link PutMeteredProductRequest#builder()}
     * </p>
     *
     * @param putMeteredProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.PutMeteredProductRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutMeteredProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.PutMeteredProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutMeteredProductResponse> putMeteredProduct(
            Consumer<PutMeteredProductRequest.Builder> putMeteredProductRequest) {
        return putMeteredProduct(PutMeteredProductRequest.builder().applyMutation(putMeteredProductRequest).build());
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     *
     * @param searchJobsRequest
     * @return A Java Future containing the result of the SearchJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchJobsResponse> searchJobs(SearchJobsRequest searchJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchJobsRequest#builder()}
     * </p>
     *
     * @param searchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchJobsResponse> searchJobs(Consumer<SearchJobsRequest.Builder> searchJobsRequest) {
        return searchJobs(SearchJobsRequest.builder().applyMutation(searchJobsRequest).build());
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     *
     * @param searchStepsRequest
     * @return A Java Future containing the result of the SearchSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchStepsResponse> searchSteps(SearchStepsRequest searchStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for steps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchStepsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchStepsRequest#builder()}
     * </p>
     *
     * @param searchStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchStepsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchStepsResponse> searchSteps(Consumer<SearchStepsRequest.Builder> searchStepsRequest) {
        return searchSteps(SearchStepsRequest.builder().applyMutation(searchStepsRequest).build());
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     *
     * @param searchTasksRequest
     * @return A Java Future containing the result of the SearchTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchTasksResponse> searchTasks(SearchTasksRequest searchTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTasksRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTasksRequest#builder()}
     * </p>
     *
     * @param searchTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchTasksResponse> searchTasks(Consumer<SearchTasksRequest.Builder> searchTasksRequest) {
        return searchTasks(SearchTasksRequest.builder().applyMutation(searchTasksRequest).build());
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     *
     * @param searchWorkersRequest
     * @return A Java Future containing the result of the SearchWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchWorkersResponse> searchWorkers(SearchWorkersRequest searchWorkersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for workers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchWorkersRequest#builder()}
     * </p>
     *
     * @param searchWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.SearchWorkersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.SearchWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchWorkersResponse> searchWorkers(Consumer<SearchWorkersRequest.Builder> searchWorkersRequest) {
        return searchWorkers(SearchWorkersRequest.builder().applyMutation(searchWorkersRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     * @return A Java Future containing the result of the StartSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSessionsStatisticsAggregationResponse> startSessionsStatisticsAggregation(
            StartSessionsStatisticsAggregationRequest startSessionsStatisticsAggregationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous request for getting aggregated statistics about queues and farms. Get the statistics using
     * the <code>GetSessionsStatisticsAggregation</code> operation. Statistics are available for 1 hour after you call
     * the <code>StartSessionsStatisticsAggregation</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSessionsStatisticsAggregationRequest.Builder}
     * avoiding the need to create one manually via {@link StartSessionsStatisticsAggregationRequest#builder()}
     * </p>
     *
     * @param startSessionsStatisticsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.StartSessionsStatisticsAggregationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartSessionsStatisticsAggregation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.StartSessionsStatisticsAggregation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSessionsStatisticsAggregationResponse> startSessionsStatisticsAggregation(
            Consumer<StartSessionsStatisticsAggregationRequest.Builder> startSessionsStatisticsAggregationRequest) {
        return startSessionsStatisticsAggregation(StartSessionsStatisticsAggregationRequest.builder()
                .applyMutation(startSessionsStatisticsAggregationRequest).build());
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource using the resource's ARN and desired tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource using the resource's ARN and tag to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     *
     * @param updateBudgetRequest
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a budget that sets spending thresholds for rendering activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBudgetRequest#builder()}
     * </p>
     *
     * @param updateBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateBudget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(Consumer<UpdateBudgetRequest.Builder> updateBudgetRequest) {
        return updateBudget(UpdateBudgetRequest.builder().applyMutation(updateBudgetRequest).build());
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     *
     * @param updateFarmRequest
     * @return A Java Future containing the result of the UpdateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFarmResponse> updateFarm(UpdateFarmRequest updateFarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a farm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFarmRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFarmRequest#builder()}
     * </p>
     *
     * @param updateFarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateFarmRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFarmResponse> updateFarm(Consumer<UpdateFarmRequest.Builder> updateFarmRequest) {
        return updateFarm(UpdateFarmRequest.builder().applyMutation(updateFarmRequest).build());
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest) {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     *
     * @param updateJobRequest
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobRequest#builder()}
     * </p>
     *
     * @param updateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJobResponse> updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) {
        return updateJob(UpdateJobRequest.builder().applyMutation(updateJobRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     *
     * @param updateMonitorRequest
     * @return A Java Future containing the result of the UpdateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest updateMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a Deadline Cloud monitor. You can modify one or all of the settings when you call
     * <code>UpdateMonitor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMonitorRequest#builder()}
     * </p>
     *
     * @param updateMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMonitorResponse> updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest) {
        return updateMonitor(UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest).build());
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     *
     * @param updateQueueRequest
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(UpdateQueueRequest updateQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQueueRequest#builder()}
     * </p>
     *
     * @param updateQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(Consumer<UpdateQueueRequest.Builder> updateQueueRequest) {
        return updateQueue(UpdateQueueRequest.builder().applyMutation(updateQueueRequest).build());
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     * @return A Java Future containing the result of the UpdateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQueueEnvironmentResponse> updateQueueEnvironment(
            UpdateQueueEnvironmentRequest updateQueueEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the queue environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQueueEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateQueueEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateQueueEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQueueEnvironmentResponse> updateQueueEnvironment(
            Consumer<UpdateQueueEnvironmentRequest.Builder> updateQueueEnvironmentRequest) {
        return updateQueueEnvironment(UpdateQueueEnvironmentRequest.builder().applyMutation(updateQueueEnvironmentRequest)
                .build());
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     * @return A Java Future containing the result of the UpdateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQueueFleetAssociationResponse> updateQueueFleetAssociation(
            UpdateQueueFleetAssociationRequest updateQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a queue-fleet association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueFleetAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQueueFleetAssociationRequest#builder()}
     * </p>
     *
     * @param updateQueueFleetAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateQueueFleetAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateQueueFleetAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQueueFleetAssociationResponse> updateQueueFleetAssociation(
            Consumer<UpdateQueueFleetAssociationRequest.Builder> updateQueueFleetAssociationRequest) {
        return updateQueueFleetAssociation(UpdateQueueFleetAssociationRequest.builder()
                .applyMutation(updateQueueFleetAssociationRequest).build());
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     *
     * @param updateSessionRequest
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(UpdateSessionRequest updateSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest) {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     *
     * @param updateStepRequest
     * @return A Java Future containing the result of the UpdateStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStepResponse> updateStep(UpdateStepRequest updateStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStepRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStepRequest#builder()}
     * </p>
     *
     * @param updateStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateStepRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStepResponse> updateStep(Consumer<UpdateStepRequest.Builder> updateStepRequest) {
        return updateStep(UpdateStepRequest.builder().applyMutation(updateStepRequest).build());
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     *
     * @param updateStorageProfileRequest
     * @return A Java Future containing the result of the UpdateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStorageProfileResponse> updateStorageProfile(
            UpdateStorageProfileRequest updateStorageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a storage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStorageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStorageProfileRequest#builder()}
     * </p>
     *
     * @param updateStorageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStorageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateStorageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStorageProfileResponse> updateStorageProfile(
            Consumer<UpdateStorageProfileRequest.Builder> updateStorageProfileRequest) {
        return updateStorageProfile(UpdateStorageProfileRequest.builder().applyMutation(updateStorageProfileRequest).build());
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     *
     * @param updateTaskRequest
     * @return A Java Future containing the result of the UpdateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskResponse> updateTask(UpdateTaskRequest updateTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTaskRequest#builder()}
     * </p>
     *
     * @param updateTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskResponse> updateTask(Consumer<UpdateTaskRequest.Builder> updateTaskRequest) {
        return updateTask(UpdateTaskRequest.builder().applyMutation(updateTaskRequest).build());
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     *
     * @param updateWorkerRequest
     * @return A Java Future containing the result of the UpdateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkerResponse> updateWorker(UpdateWorkerRequest updateWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkerRequest#builder()}
     * </p>
     *
     * @param updateWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkerResponse> updateWorker(Consumer<UpdateWorkerRequest.Builder> updateWorkerRequest) {
        return updateWorker(UpdateWorkerRequest.builder().applyMutation(updateWorkerRequest).build());
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     *
     * @param updateWorkerScheduleRequest
     * @return A Java Future containing the result of the UpdateWorkerSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerScheduleResponse> updateWorkerSchedule(
            UpdateWorkerScheduleRequest updateWorkerScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schedule for a worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkerScheduleRequest#builder()}
     * </p>
     *
     * @param updateWorkerScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkerSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerErrorException Deadline Cloud can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeadlineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeadlineAsyncClient.UpdateWorkerSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerScheduleResponse> updateWorkerSchedule(
            Consumer<UpdateWorkerScheduleRequest.Builder> updateWorkerScheduleRequest) {
        return updateWorkerSchedule(UpdateWorkerScheduleRequest.builder().applyMutation(updateWorkerScheduleRequest).build());
    }

    /**
     * Create an instance of {@link DeadlineAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DeadlineAsyncWaiter}
     */
    default DeadlineAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default DeadlineServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DeadlineAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DeadlineAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DeadlineAsyncClient}.
     */
    static DeadlineAsyncClientBuilder builder() {
        return new DefaultDeadlineAsyncClientBuilder();
    }
}
