/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorageProfileRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateStorageProfileRequest.Builder, CreateStorageProfileRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateStorageProfileRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateStorageProfileRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateStorageProfileRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField
            .<List<FileSystemLocation>> builder(MarshallingType.LIST)
            .memberName("fileSystemLocations")
            .getter(getter(CreateStorageProfileRequest::fileSystemLocations))
            .setter(setter(Builder::fileSystemLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(CreateStorageProfileRequest::osFamilyAsString))
            .setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DISPLAY_NAME_FIELD, FARM_ID_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, OS_FAMILY_FIELD));

    private final String clientToken;

    private final String displayName;

    private final String farmId;

    private final List<FileSystemLocation> fileSystemLocations;

    private final String osFamily;

    private CreateStorageProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.osFamily = builder.osFamily;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The display name of the storage profile.
     * </p>
     * 
     * @return The display name of the storage profile.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The farm ID of the farm to connect to the storage profile.
     * </p>
     * 
     * @return The farm ID of the farm to connect to the storage profile.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemLocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemLocations() {
        return fileSystemLocations != null && !(fileSystemLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * File system paths to include in the storage profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemLocations} method.
     * </p>
     * 
     * @return File system paths to include in the storage profile.
     */
    public final List<FileSystemLocation> fileSystemLocations() {
        return fileSystemLocations;
    }

    /**
     * <p>
     * The type of operating system (OS) for the storage profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The type of operating system (OS) for the storage profile.
     * @see StorageProfileOperatingSystemFamily
     */
    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The type of operating system (OS) for the storage profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The type of operating system (OS) for the storage profile.
     * @see StorageProfileOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemLocations() ? fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageProfileRequest)) {
            return false;
        }
        CreateStorageProfileRequest other = (CreateStorageProfileRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(farmId(), other.farmId()) && hasFileSystemLocations() == other.hasFileSystemLocations()
                && Objects.equals(fileSystemLocations(), other.fileSystemLocations())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorageProfileRequest").add("ClientToken", clientToken())
                .add("DisplayName", displayName()).add("FarmId", farmId())
                .add("FileSystemLocations", fileSystemLocations() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OsFamily", osFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fileSystemLocations":
            return Optional.ofNullable(clazz.cast(fileSystemLocations()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageProfileRequest, T> g) {
        return obj -> g.apply((CreateStorageProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStorageProfileRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The display name of the storage profile.
         * </p>
         * 
         * @param displayName
         *        The display name of the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The farm ID of the farm to connect to the storage profile.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm to connect to the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * File system paths to include in the storage profile.
         * </p>
         * 
         * @param fileSystemLocations
         *        File system paths to include in the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations);

        /**
         * <p>
         * File system paths to include in the storage profile.
         * </p>
         * 
         * @param fileSystemLocations
         *        File system paths to include in the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(FileSystemLocation... fileSystemLocations);

        /**
         * <p>
         * File system paths to include in the storage profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemLocations(List<FileSystemLocation>)}.
         * 
         * @param fileSystemLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemLocations(java.util.Collection<FileSystemLocation>)
         */
        Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations);

        /**
         * <p>
         * The type of operating system (OS) for the storage profile.
         * </p>
         * 
         * @param osFamily
         *        The type of operating system (OS) for the storage profile.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The type of operating system (OS) for the storage profile.
         * </p>
         * 
         * @param osFamily
         *        The type of operating system (OS) for the storage profile.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(StorageProfileOperatingSystemFamily osFamily);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String displayName;

        private String farmId;

        private List<FileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private String osFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageProfileRequest model) {
            super(model);
            clientToken(model.clientToken);
            displayName(model.displayName);
            farmId(model.farmId);
            fileSystemLocations(model.fileSystemLocations);
            osFamily(model.osFamily);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocations() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<FileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(FileSystemLocation... fileSystemLocations) {
            fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations) {
            fileSystemLocations(Stream.of(fileSystemLocations).map(c -> FileSystemLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorageProfileRequest build() {
            return new CreateStorageProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
