/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time stamp in date-time format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeFilterExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimeFilterExpression.Builder, DateTimeFilterExpression> {
    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateTime")
            .getter(getter(DateTimeFilterExpression::dateTime))
            .setter(setter(Builder::dateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DateTimeFilterExpression::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(DateTimeFilterExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_FIELD, NAME_FIELD,
            OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant dateTime;

    private final String name;

    private final String operator;

    private DateTimeFilterExpression(BuilderImpl builder) {
        this.dateTime = builder.dateTime;
        this.name = builder.name;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The date and time.
     * </p>
     * 
     * @return The date and time.
     */
    public final Instant dateTime() {
        return dateTime;
    }

    /**
     * <p>
     * The name of the date-time field to filter on.
     * </p>
     * 
     * @return The name of the date-time field to filter on.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of comparison to use to filter the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The type of comparison to use to filter the results.
     * @see ComparisonOperator
     */
    public final ComparisonOperator operator() {
        return ComparisonOperator.fromValue(operator);
    }

    /**
     * <p>
     * The type of comparison to use to filter the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The type of comparison to use to filter the results.
     * @see ComparisonOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeFilterExpression)) {
            return false;
        }
        DateTimeFilterExpression other = (DateTimeFilterExpression) obj;
        return Objects.equals(dateTime(), other.dateTime()) && Objects.equals(name(), other.name())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeFilterExpression").add("DateTime", dateTime()).add("Name", name())
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateTime":
            return Optional.ofNullable(clazz.cast(dateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeFilterExpression, T> g) {
        return obj -> g.apply((DateTimeFilterExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeFilterExpression> {
        /**
         * <p>
         * The date and time.
         * </p>
         * 
         * @param dateTime
         *        The date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTime(Instant dateTime);

        /**
         * <p>
         * The name of the date-time field to filter on.
         * </p>
         * 
         * @param name
         *        The name of the date-time field to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of comparison to use to filter the results.
         * </p>
         * 
         * @param operator
         *        The type of comparison to use to filter the results.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The type of comparison to use to filter the results.
         * </p>
         * 
         * @param operator
         *        The type of comparison to use to filter the results.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder operator(ComparisonOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private Instant dateTime;

        private String name;

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeFilterExpression model) {
            dateTime(model.dateTime);
            name(model.name);
            operator(model.operator);
        }

        public final Instant getDateTime() {
            return dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ComparisonOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public DateTimeFilterExpression build() {
            return new DateTimeFilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
