/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a specified environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentDetailsEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentDetailsEntity.Builder, EnvironmentDetailsEntity> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(EnvironmentDetailsEntity::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(EnvironmentDetailsEntity::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(EnvironmentDetailsEntity::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<Document> TEMPLATE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("template").getter(getter(EnvironmentDetailsEntity::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            JOB_ID_FIELD, SCHEMA_VERSION_FIELD, TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String environmentId;

    private final String jobId;

    private final String schemaVersion;

    private final Document template;

    private EnvironmentDetailsEntity(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.jobId = builder.jobId;
        this.schemaVersion = builder.schemaVersion;
        this.template = builder.template;
    }

    /**
     * <p>
     * The environment ID.
     * </p>
     * 
     * @return The environment ID.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The schema version in the environment.
     * </p>
     * 
     * @return The schema version in the environment.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The template used for the environment.
     * </p>
     * 
     * @return The template used for the environment.
     */
    public final Document template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentDetailsEntity)) {
            return false;
        }
        EnvironmentDetailsEntity other = (EnvironmentDetailsEntity) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentDetailsEntity").add("EnvironmentId", environmentId()).add("JobId", jobId())
                .add("SchemaVersion", schemaVersion())
                .add("Template", template() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentDetailsEntity, T> g) {
        return obj -> g.apply((EnvironmentDetailsEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentDetailsEntity> {
        /**
         * <p>
         * The environment ID.
         * </p>
         * 
         * @param environmentId
         *        The environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The schema version in the environment.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The template used for the environment.
         * </p>
         * 
         * @param template
         *        The template used for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Document template);
    }

    static final class BuilderImpl implements Builder {
        private String environmentId;

        private String jobId;

        private String schemaVersion;

        private Document template;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentDetailsEntity model) {
            environmentId(model.environmentId);
            jobId(model.jobId);
            schemaVersion(model.schemaVersion);
            template(model.template);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Document getTemplate() {
            return template;
        }

        public final void setTemplate(Document template) {
            this.template = template;
        }

        @Override
        public final Builder template(Document template) {
            this.template = template;
            return this;
        }

        @Override
        public EnvironmentDetailsEntity build() {
            return new EnvironmentDetailsEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
