/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchWorkersResponse extends DeadlineResponse implements
        ToCopyableBuilder<SearchWorkersResponse.Builder, SearchWorkersResponse> {
    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nextItemOffset").getter(getter(SearchWorkersResponse::nextItemOffset))
            .setter(setter(Builder::nextItemOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResults").getter(getter(SearchWorkersResponse::totalResults)).setter(setter(Builder::totalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()).build();

    private static final SdkField<List<WorkerSearchSummary>> WORKERS_FIELD = SdkField
            .<List<WorkerSearchSummary>> builder(MarshallingType.LIST)
            .memberName("workers")
            .getter(getter(SearchWorkersResponse::workers))
            .setter(setter(Builder::workers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerSearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerSearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ITEM_OFFSET_FIELD,
            TOTAL_RESULTS_FIELD, WORKERS_FIELD));

    private final Integer nextItemOffset;

    private final Integer totalResults;

    private final List<WorkerSearchSummary> workers;

    private SearchWorkersResponse(BuilderImpl builder) {
        super(builder);
        this.nextItemOffset = builder.nextItemOffset;
        this.totalResults = builder.totalResults;
        this.workers = builder.workers;
    }

    /**
     * <p>
     * The next incremental starting point after the defined <code>itemOffset</code>.
     * </p>
     * 
     * @return The next incremental starting point after the defined <code>itemOffset</code>.
     */
    public final Integer nextItemOffset() {
        return nextItemOffset;
    }

    /**
     * <p>
     * The total number of results in the search.
     * </p>
     * 
     * @return The total number of results in the search.
     */
    public final Integer totalResults() {
        return totalResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkers() {
        return workers != null && !(workers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The workers for the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkers} method.
     * </p>
     * 
     * @return The workers for the search.
     */
    public final List<WorkerSearchSummary> workers() {
        return workers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(totalResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkers() ? workers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkersResponse)) {
            return false;
        }
        SearchWorkersResponse other = (SearchWorkersResponse) obj;
        return Objects.equals(nextItemOffset(), other.nextItemOffset()) && Objects.equals(totalResults(), other.totalResults())
                && hasWorkers() == other.hasWorkers() && Objects.equals(workers(), other.workers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchWorkersResponse").add("NextItemOffset", nextItemOffset())
                .add("TotalResults", totalResults()).add("Workers", hasWorkers() ? workers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextItemOffset":
            return Optional.ofNullable(clazz.cast(nextItemOffset()));
        case "totalResults":
            return Optional.ofNullable(clazz.cast(totalResults()));
        case "workers":
            return Optional.ofNullable(clazz.cast(workers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkersResponse, T> g) {
        return obj -> g.apply((SearchWorkersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchWorkersResponse> {
        /**
         * <p>
         * The next incremental starting point after the defined <code>itemOffset</code>.
         * </p>
         * 
         * @param nextItemOffset
         *        The next incremental starting point after the defined <code>itemOffset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextItemOffset(Integer nextItemOffset);

        /**
         * <p>
         * The total number of results in the search.
         * </p>
         * 
         * @param totalResults
         *        The total number of results in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResults(Integer totalResults);

        /**
         * <p>
         * The workers for the search.
         * </p>
         * 
         * @param workers
         *        The workers for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workers(Collection<WorkerSearchSummary> workers);

        /**
         * <p>
         * The workers for the search.
         * </p>
         * 
         * @param workers
         *        The workers for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workers(WorkerSearchSummary... workers);

        /**
         * <p>
         * The workers for the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.WorkerSearchSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.WorkerSearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.WorkerSearchSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #workers(List<WorkerSearchSummary>)}.
         * 
         * @param workers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.WorkerSearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workers(java.util.Collection<WorkerSearchSummary>)
         */
        Builder workers(Consumer<WorkerSearchSummary.Builder>... workers);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private Integer nextItemOffset;

        private Integer totalResults;

        private List<WorkerSearchSummary> workers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkersResponse model) {
            super(model);
            nextItemOffset(model.nextItemOffset);
            totalResults(model.totalResults);
            workers(model.workers);
        }

        public final Integer getNextItemOffset() {
            return nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final Integer getTotalResults() {
            return totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public final List<WorkerSearchSummary.Builder> getWorkers() {
            List<WorkerSearchSummary.Builder> result = WorkerSearchSummariesCopier.copyToBuilder(this.workers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkers(Collection<WorkerSearchSummary.BuilderImpl> workers) {
            this.workers = WorkerSearchSummariesCopier.copyFromBuilder(workers);
        }

        @Override
        public final Builder workers(Collection<WorkerSearchSummary> workers) {
            this.workers = WorkerSearchSummariesCopier.copy(workers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(WorkerSearchSummary... workers) {
            workers(Arrays.asList(workers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(Consumer<WorkerSearchSummary.Builder>... workers) {
            workers(Stream.of(workers).map(c -> WorkerSearchSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchWorkersResponse build() {
            return new SearchWorkersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
