/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum, maximum, average, and sum.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stats implements SdkPojo, Serializable, ToCopyableBuilder<Stats.Builder, Stats> {
    private static final SdkField<Double> AVG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("avg")
            .getter(getter(Stats::avg)).setter(setter(Builder::avg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avg").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("max")
            .getter(getter(Stats::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("min")
            .getter(getter(Stats::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("sum")
            .getter(getter(Stats::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVG_FIELD, MAX_FIELD,
            MIN_FIELD, SUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double avg;

    private final Double max;

    private final Double min;

    private final Double sum;

    private Stats(BuilderImpl builder) {
        this.avg = builder.avg;
        this.max = builder.max;
        this.min = builder.min;
        this.sum = builder.sum;
    }

    /**
     * <p>
     * The average of the usage statistics.
     * </p>
     * 
     * @return The average of the usage statistics.
     */
    public final Double avg() {
        return avg;
    }

    /**
     * <p>
     * The maximum among the usage statistics.
     * </p>
     * 
     * @return The maximum among the usage statistics.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * The minimum of the usage statistics.
     * </p>
     * 
     * @return The minimum of the usage statistics.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The sum of the usage statistics.
     * </p>
     * 
     * @return The sum of the usage statistics.
     */
    public final Double sum() {
        return sum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(avg());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stats)) {
            return false;
        }
        Stats other = (Stats) obj;
        return Objects.equals(avg(), other.avg()) && Objects.equals(max(), other.max()) && Objects.equals(min(), other.min())
                && Objects.equals(sum(), other.sum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Stats").add("Avg", avg()).add("Max", max()).add("Min", min()).add("Sum", sum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "avg":
            return Optional.ofNullable(clazz.cast(avg()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "sum":
            return Optional.ofNullable(clazz.cast(sum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stats, T> g) {
        return obj -> g.apply((Stats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stats> {
        /**
         * <p>
         * The average of the usage statistics.
         * </p>
         * 
         * @param avg
         *        The average of the usage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avg(Double avg);

        /**
         * <p>
         * The maximum among the usage statistics.
         * </p>
         * 
         * @param max
         *        The maximum among the usage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * The minimum of the usage statistics.
         * </p>
         * 
         * @param min
         *        The minimum of the usage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The sum of the usage statistics.
         * </p>
         * 
         * @param sum
         *        The sum of the usage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);
    }

    static final class BuilderImpl implements Builder {
        private Double avg;

        private Double max;

        private Double min;

        private Double sum;

        private BuilderImpl() {
        }

        private BuilderImpl(Stats model) {
            avg(model.avg);
            max(model.max);
            min(model.min);
            sum(model.sum);
        }

        public final Double getAvg() {
            return avg;
        }

        public final void setAvg(Double avg) {
            this.avg = avg;
        }

        @Override
        public final Builder avg(Double avg) {
            this.avg = avg;
            return this;
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getSum() {
            return sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        @Override
        public Stats build() {
            return new Stats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
