/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a metered product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeteredProductSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MeteredProductSummary.Builder, MeteredProductSummary> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("family")
            .getter(getter(MeteredProductSummary::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(MeteredProductSummary::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productId").getter(getter(MeteredProductSummary::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productId").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vendor")
            .getter(getter(MeteredProductSummary::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, PORT_FIELD,
            PRODUCT_ID_FIELD, VENDOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final Integer port;

    private final String productId;

    private final String vendor;

    private MeteredProductSummary(BuilderImpl builder) {
        this.family = builder.family;
        this.port = builder.port;
        this.productId = builder.productId;
        this.vendor = builder.vendor;
    }

    /**
     * <p>
     * The family to which the metered product belongs.
     * </p>
     * 
     * @return The family to which the metered product belongs.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The port on which the metered product should run.
     * </p>
     * 
     * @return The port on which the metered product should run.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The product ID.
     * </p>
     * 
     * @return The product ID.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The vendor.
     * </p>
     * 
     * @return The vendor.
     */
    public final String vendor() {
        return vendor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeteredProductSummary)) {
            return false;
        }
        MeteredProductSummary other = (MeteredProductSummary) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(port(), other.port())
                && Objects.equals(productId(), other.productId()) && Objects.equals(vendor(), other.vendor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeteredProductSummary").add("Family", family()).add("Port", port())
                .add("ProductId", productId()).add("Vendor", vendor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "family":
            return Optional.ofNullable(clazz.cast(family()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "productId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeteredProductSummary, T> g) {
        return obj -> g.apply((MeteredProductSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeteredProductSummary> {
        /**
         * <p>
         * The family to which the metered product belongs.
         * </p>
         * 
         * @param family
         *        The family to which the metered product belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The port on which the metered product should run.
         * </p>
         * 
         * @param port
         *        The port on which the metered product should run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The product ID.
         * </p>
         * 
         * @param productId
         *        The product ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The vendor.
         * </p>
         * 
         * @param vendor
         *        The vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private Integer port;

        private String productId;

        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(MeteredProductSummary model) {
            family(model.family);
            port(model.port);
            productId(model.productId);
            vendor(model.vendor);
        }

        public final String getFamily() {
            return family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        @Override
        public MeteredProductSummary build() {
            return new MeteredProductSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
