/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchJobsResponse extends DeadlineResponse implements
        ToCopyableBuilder<SearchJobsResponse.Builder, SearchJobsResponse> {
    private static final SdkField<List<JobSearchSummary>> JOBS_FIELD = SdkField
            .<List<JobSearchSummary>> builder(MarshallingType.LIST)
            .memberName("jobs")
            .getter(getter(SearchJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobSearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobSearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nextItemOffset").getter(getter(SearchJobsResponse::nextItemOffset))
            .setter(setter(Builder::nextItemOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResults").getter(getter(SearchJobsResponse::totalResults)).setter(setter(Builder::totalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            NEXT_ITEM_OFFSET_FIELD, TOTAL_RESULTS_FIELD));

    private final List<JobSearchSummary> jobs;

    private final Integer nextItemOffset;

    private final Integer totalResults;

    private SearchJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextItemOffset = builder.nextItemOffset;
        this.totalResults = builder.totalResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Jobs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The jobs in the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobs} method.
     * </p>
     * 
     * @return The jobs in the search.
     */
    public final List<JobSearchSummary> jobs() {
        return jobs;
    }

    /**
     * <p>
     * The next incremental starting point after the defined <code>itemOffset</code>.
     * </p>
     * 
     * @return The next incremental starting point after the defined <code>itemOffset</code>.
     */
    public final Integer nextItemOffset() {
        return nextItemOffset;
    }

    /**
     * <p>
     * The total number of results in the search.
     * </p>
     * 
     * @return The total number of results in the search.
     */
    public final Integer totalResults() {
        return totalResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(totalResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobsResponse)) {
            return false;
        }
        SearchJobsResponse other = (SearchJobsResponse) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && Objects.equals(nextItemOffset(), other.nextItemOffset())
                && Objects.equals(totalResults(), other.totalResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchJobsResponse").add("Jobs", hasJobs() ? jobs() : null)
                .add("NextItemOffset", nextItemOffset()).add("TotalResults", totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "nextItemOffset":
            return Optional.ofNullable(clazz.cast(nextItemOffset()));
        case "totalResults":
            return Optional.ofNullable(clazz.cast(totalResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchJobsResponse, T> g) {
        return obj -> g.apply((SearchJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchJobsResponse> {
        /**
         * <p>
         * The jobs in the search.
         * </p>
         * 
         * @param jobs
         *        The jobs in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobSearchSummary> jobs);

        /**
         * <p>
         * The jobs in the search.
         * </p>
         * 
         * @param jobs
         *        The jobs in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobSearchSummary... jobs);

        /**
         * <p>
         * The jobs in the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.JobSearchSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.JobSearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.JobSearchSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #jobs(List<JobSearchSummary>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.JobSearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(java.util.Collection<JobSearchSummary>)
         */
        Builder jobs(Consumer<JobSearchSummary.Builder>... jobs);

        /**
         * <p>
         * The next incremental starting point after the defined <code>itemOffset</code>.
         * </p>
         * 
         * @param nextItemOffset
         *        The next incremental starting point after the defined <code>itemOffset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextItemOffset(Integer nextItemOffset);

        /**
         * <p>
         * The total number of results in the search.
         * </p>
         * 
         * @param totalResults
         *        The total number of results in the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResults(Integer totalResults);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<JobSearchSummary> jobs = DefaultSdkAutoConstructList.getInstance();

        private Integer nextItemOffset;

        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobsResponse model) {
            super(model);
            jobs(model.jobs);
            nextItemOffset(model.nextItemOffset);
            totalResults(model.totalResults);
        }

        public final List<JobSearchSummary.Builder> getJobs() {
            List<JobSearchSummary.Builder> result = JobSearchSummariesCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<JobSearchSummary.BuilderImpl> jobs) {
            this.jobs = JobSearchSummariesCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<JobSearchSummary> jobs) {
            this.jobs = JobSearchSummariesCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobSearchSummary... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobSearchSummary.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> JobSearchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNextItemOffset() {
            return nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final Integer getTotalResults() {
            return totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchJobsResponse build() {
            return new SearchJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
