/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows setting a specific user's job to run first.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserJobsFirst implements SdkPojo, Serializable, ToCopyableBuilder<UserJobsFirst.Builder, UserJobsFirst> {
    private static final SdkField<String> USER_IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userIdentityId").getter(getter(UserJobsFirst::userIdentityId)).setter(setter(Builder::userIdentityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentityId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDENTITY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userIdentityId;

    private UserJobsFirst(BuilderImpl builder) {
        this.userIdentityId = builder.userIdentityId;
    }

    /**
     * <p>
     * The user's ID.
     * </p>
     * 
     * @return The user's ID.
     */
    public final String userIdentityId() {
        return userIdentityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userIdentityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserJobsFirst)) {
            return false;
        }
        UserJobsFirst other = (UserJobsFirst) obj;
        return Objects.equals(userIdentityId(), other.userIdentityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserJobsFirst").add("UserIdentityId", userIdentityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userIdentityId":
            return Optional.ofNullable(clazz.cast(userIdentityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserJobsFirst, T> g) {
        return obj -> g.apply((UserJobsFirst) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserJobsFirst> {
        /**
         * <p>
         * The user's ID.
         * </p>
         * 
         * @param userIdentityId
         *        The user's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentityId(String userIdentityId);
    }

    static final class BuilderImpl implements Builder {
        private String userIdentityId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserJobsFirst model) {
            userIdentityId(model.userIdentityId);
        }

        public final String getUserIdentityId() {
            return userIdentityId;
        }

        public final void setUserIdentityId(String userIdentityId) {
            this.userIdentityId = userIdentityId;
        }

        @Override
        public final Builder userIdentityId(String userIdentityId) {
            this.userIdentityId = userIdentityId;
            return this;
        }

        @Override
        public UserJobsFirst build() {
            return new UserJobsFirst(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
