/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.SessionLifecycleTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerSessionSummary> {
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(WorkerSessionSummary.getter(WorkerSessionSummary::endedAt)).setter(WorkerSessionSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(WorkerSessionSummary.getter(WorkerSessionSummary::jobId)).setter(WorkerSessionSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(WorkerSessionSummary.getter(WorkerSessionSummary::lifecycleStatusAsString)).setter(WorkerSessionSummary.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(WorkerSessionSummary.getter(WorkerSessionSummary::queueId)).setter(WorkerSessionSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(WorkerSessionSummary.getter(WorkerSessionSummary::sessionId)).setter(WorkerSessionSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(WorkerSessionSummary.getter(WorkerSessionSummary::startedAt)).setter(WorkerSessionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetLifecycleStatus").getter(WorkerSessionSummary.getter(WorkerSessionSummary::targetLifecycleStatusAsString)).setter(WorkerSessionSummary.setter(Builder::targetLifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDED_AT_FIELD, JOB_ID_FIELD, LIFECYCLE_STATUS_FIELD, QUEUE_ID_FIELD, SESSION_ID_FIELD, STARTED_AT_FIELD, TARGET_LIFECYCLE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant endedAt;
    private final String jobId;
    private final String lifecycleStatus;
    private final String queueId;
    private final String sessionId;
    private final Instant startedAt;
    private final String targetLifecycleStatus;

    private WorkerSessionSummary(BuilderImpl builder) {
        this.endedAt = builder.endedAt;
        this.jobId = builder.jobId;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.queueId = builder.queueId;
        this.sessionId = builder.sessionId;
        this.startedAt = builder.startedAt;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final SessionLifecycleStatus lifecycleStatus() {
        return SessionLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(this.targetLifecycleStatus);
    }

    public final String targetLifecycleStatusAsString() {
        return this.targetLifecycleStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLifecycleStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerSessionSummary)) {
            return false;
        }
        WorkerSessionSummary other = (WorkerSessionSummary)obj;
        return Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerSessionSummary").add("EndedAt", (Object)this.endedAt()).add("JobId", (Object)this.jobId()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("QueueId", (Object)this.queueId()).add("SessionId", (Object)this.sessionId()).add("StartedAt", (Object)this.startedAt()).add("TargetLifecycleStatus", (Object)this.targetLifecycleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "targetLifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.targetLifecycleStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerSessionSummary, T> g) {
        return obj -> g.apply((WorkerSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endedAt;
        private String jobId;
        private String lifecycleStatus;
        private String queueId;
        private String sessionId;
        private Instant startedAt;
        private String targetLifecycleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerSessionSummary model) {
            this.endedAt(model.endedAt);
            this.jobId(model.jobId);
            this.lifecycleStatus(model.lifecycleStatus);
            this.queueId(model.queueId);
            this.sessionId(model.sessionId);
            this.startedAt(model.startedAt);
            this.targetLifecycleStatus(model.targetLifecycleStatus);
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return this.targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        public WorkerSessionSummary build() {
            return new WorkerSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerSessionSummary> {
        public Builder endedAt(Instant var1);

        public Builder jobId(String var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(SessionLifecycleStatus var1);

        public Builder queueId(String var1);

        public Builder sessionId(String var1);

        public Builder startedAt(Instant var1);

        public Builder targetLifecycleStatus(String var1);

        public Builder targetLifecycleStatus(SessionLifecycleTargetStatus var1);
    }
}

