/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.SessionActionDefinitionSummary;
import software.amazon.awssdk.services.deadline.model.SessionActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionActionSummary> {
    private static final SdkField<SessionActionDefinitionSummary> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(SessionActionSummary.getter(SessionActionSummary::definition)).setter(SessionActionSummary.setter(Builder::definition)).constructor(SessionActionDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(SessionActionSummary.getter(SessionActionSummary::endedAt)).setter(SessionActionSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercent").getter(SessionActionSummary.getter(SessionActionSummary::progressPercent)).setter(SessionActionSummary.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()}).build();
    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionActionId").getter(SessionActionSummary.getter(SessionActionSummary::sessionActionId)).setter(SessionActionSummary.setter(Builder::sessionActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(SessionActionSummary.getter(SessionActionSummary::startedAt)).setter(SessionActionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SessionActionSummary.getter(SessionActionSummary::statusAsString)).setter(SessionActionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> WORKER_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("workerUpdatedAt").getter(SessionActionSummary.getter(SessionActionSummary::workerUpdatedAt)).setter(SessionActionSummary.setter(Builder::workerUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, ENDED_AT_FIELD, PROGRESS_PERCENT_FIELD, SESSION_ACTION_ID_FIELD, STARTED_AT_FIELD, STATUS_FIELD, WORKER_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SessionActionDefinitionSummary definition;
    private final Instant endedAt;
    private final Float progressPercent;
    private final String sessionActionId;
    private final Instant startedAt;
    private final String status;
    private final Instant workerUpdatedAt;

    private SessionActionSummary(BuilderImpl builder) {
        this.definition = builder.definition;
        this.endedAt = builder.endedAt;
        this.progressPercent = builder.progressPercent;
        this.sessionActionId = builder.sessionActionId;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.workerUpdatedAt = builder.workerUpdatedAt;
    }

    public final SessionActionDefinitionSummary definition() {
        return this.definition;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Float progressPercent() {
        return this.progressPercent;
    }

    public final String sessionActionId() {
        return this.sessionActionId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final SessionActionStatus status() {
        return SessionActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant workerUpdatedAt() {
        return this.workerUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionSummary)) {
            return false;
        }
        SessionActionSummary other = (SessionActionSummary)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.sessionActionId(), other.sessionActionId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.workerUpdatedAt(), other.workerUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SessionActionSummary").add("Definition", (Object)this.definition()).add("EndedAt", (Object)this.endedAt()).add("ProgressPercent", (Object)this.progressPercent()).add("SessionActionId", (Object)this.sessionActionId()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("WorkerUpdatedAt", (Object)this.workerUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "progressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "sessionActionId": {
                return Optional.ofNullable(clazz.cast(this.sessionActionId()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "workerUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.workerUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionActionSummary, T> g) {
        return obj -> g.apply((SessionActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SessionActionDefinitionSummary definition;
        private Instant endedAt;
        private Float progressPercent;
        private String sessionActionId;
        private Instant startedAt;
        private String status;
        private Instant workerUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionSummary model) {
            this.definition(model.definition);
            this.endedAt(model.endedAt);
            this.progressPercent(model.progressPercent);
            this.sessionActionId(model.sessionActionId);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.workerUpdatedAt(model.workerUpdatedAt);
        }

        public final SessionActionDefinitionSummary.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(SessionActionDefinitionSummary.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SessionActionDefinitionSummary definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Float getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getSessionActionId() {
            return this.sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getWorkerUpdatedAt() {
            return this.workerUpdatedAt;
        }

        public final void setWorkerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
        }

        @Override
        public final Builder workerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
            return this;
        }

        public SessionActionSummary build() {
            return new SessionActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionActionSummary> {
        public Builder definition(SessionActionDefinitionSummary var1);

        default public Builder definition(Consumer<SessionActionDefinitionSummary.Builder> definition) {
            return this.definition((SessionActionDefinitionSummary)((SessionActionDefinitionSummary.Builder)SessionActionDefinitionSummary.builder().applyMutation(definition)).build());
        }

        public Builder endedAt(Instant var1);

        public Builder progressPercent(Float var1);

        public Builder sessionActionId(String var1);

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SessionActionStatus var1);

        public Builder workerUpdatedAt(Instant var1);
    }
}

