/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueueEnvironmentsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListQueueEnvironmentsResponse.Builder, ListQueueEnvironmentsResponse> {
    private static final SdkField<List<QueueEnvironmentSummary>> ENVIRONMENTS_FIELD = SdkField
            .<List<QueueEnvironmentSummary>> builder(MarshallingType.LIST)
            .memberName("environments")
            .getter(getter(ListQueueEnvironmentsResponse::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueEnvironmentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueEnvironmentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListQueueEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<QueueEnvironmentSummary> environments;

    private final String nextToken;

    private ListQueueEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environments to include in the queue environments list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironments} method.
     * </p>
     * 
     * @return The environments to include in the queue environments list.
     */
    public final List<QueueEnvironmentSummary> environments() {
        return environments;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueEnvironmentsResponse)) {
            return false;
        }
        ListQueueEnvironmentsResponse other = (ListQueueEnvironmentsResponse) obj;
        return hasEnvironments() == other.hasEnvironments() && Objects.equals(environments(), other.environments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueueEnvironmentsResponse").add("Environments", hasEnvironments() ? environments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListQueueEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueueEnvironmentsResponse> {
        /**
         * <p>
         * The environments to include in the queue environments list.
         * </p>
         * 
         * @param environments
         *        The environments to include in the queue environments list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<QueueEnvironmentSummary> environments);

        /**
         * <p>
         * The environments to include in the queue environments list.
         * </p>
         * 
         * @param environments
         *        The environments to include in the queue environments list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(QueueEnvironmentSummary... environments);

        /**
         * <p>
         * The environments to include in the queue environments list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #environments(List<QueueEnvironmentSummary>)}.
         * 
         * @param environments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environments(java.util.Collection<QueueEnvironmentSummary>)
         */
        Builder environments(Consumer<QueueEnvironmentSummary.Builder>... environments);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<QueueEnvironmentSummary> environments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueEnvironmentsResponse model) {
            super(model);
            environments(model.environments);
            nextToken(model.nextToken);
        }

        public final List<QueueEnvironmentSummary.Builder> getEnvironments() {
            List<QueueEnvironmentSummary.Builder> result = QueueEnvironmentSummariesCopier.copyToBuilder(this.environments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironments(Collection<QueueEnvironmentSummary.BuilderImpl> environments) {
            this.environments = QueueEnvironmentSummariesCopier.copyFromBuilder(environments);
        }

        @Override
        public final Builder environments(Collection<QueueEnvironmentSummary> environments) {
            this.environments = QueueEnvironmentSummariesCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(QueueEnvironmentSummary... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Consumer<QueueEnvironmentSummary.Builder>... environments) {
            environments(Stream.of(environments).map(c -> QueueEnvironmentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueueEnvironmentsResponse build() {
            return new ListQueueEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
